/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.zze;
import com.google.android.gms.internal.zzbgo;
import java.util.ArrayList;
import java.util.Arrays;

public final class RoomEntity
extends GamesDowngradeableSafeParcel
implements Room {
    public static final Parcelable.Creator<RoomEntity> CREATOR = new zza();
    private final String zza;
    private final String zzb;
    private final long zzc;
    private final int zzd;
    private final String zze;
    private final int zzf;
    private final Bundle zzg;
    private final ArrayList<ParticipantEntity> zzh;
    private final int zzi;

    @Hide
    public RoomEntity(Room room) {
        this.zza = room.getRoomId();
        this.zzb = room.getCreatorId();
        this.zzc = room.getCreationTimestamp();
        this.zzd = room.getStatus();
        this.zze = room.getDescription();
        this.zzf = room.getVariant();
        this.zzg = room.getAutoMatchCriteria();
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        this.zzh = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzh.add((ParticipantEntity)((Participant)arrayList.get(i)).freeze());
        }
        this.zzi = room.getAutoMatchWaitEstimateSeconds();
    }

    RoomEntity(String string, String string2, long l, int n, String string3, int n2, Bundle bundle, ArrayList<ParticipantEntity> arrayList, int n3) {
        this.zza = string;
        this.zzb = string2;
        this.zzc = l;
        this.zzd = n;
        this.zze = string3;
        this.zzf = n2;
        this.zzg = bundle;
        this.zzh = arrayList;
        this.zzi = n3;
    }

    @Override
    public final String getRoomId() {
        return this.zza;
    }

    @Override
    public final String getCreatorId() {
        return this.zzb;
    }

    @Override
    public final long getCreationTimestamp() {
        return this.zzc;
    }

    @Override
    public final int getStatus() {
        return this.zzd;
    }

    @Override
    public final String getDescription() {
        return this.zze;
    }

    @Override
    public final void getDescription(CharArrayBuffer charArrayBuffer) {
        com.google.android.gms.common.util.zzh.zza((String)this.zze, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final int getVariant() {
        return this.zzf;
    }

    @Override
    public final Bundle getAutoMatchCriteria() {
        return this.zzg;
    }

    @Override
    public final ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.zzh);
    }

    @Override
    public final int getAutoMatchWaitEstimateSeconds() {
        return this.zzi;
    }

    @Override
    public final int getParticipantStatus(String string) {
        return RoomEntity.zza((Room)this, string);
    }

    @Override
    public final ArrayList<String> getParticipantIds() {
        return RoomEntity.zzc(this);
    }

    @Override
    public final String getParticipantId(String string) {
        return RoomEntity.zzb(this, string);
    }

    @Override
    public final Participant getParticipant(String string) {
        return RoomEntity.zzc(this, string);
    }

    public final Room freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return RoomEntity.zza(this);
    }

    static int zza(Room room) {
        return Arrays.hashCode(new Object[]{room.getRoomId(), room.getCreatorId(), room.getCreationTimestamp(), room.getStatus(), room.getDescription(), room.getVariant(), room.getAutoMatchCriteria(), room.getParticipants(), room.getAutoMatchWaitEstimateSeconds()});
    }

    public final boolean equals(Object object) {
        return RoomEntity.zza((Room)this, object);
    }

    static boolean zza(Room room, Object object) {
        if (!(object instanceof Room)) {
            return false;
        }
        if (room == object) {
            return true;
        }
        Room room2 = (Room)object;
        return zzbg.zza((Object)room2.getRoomId(), (Object)room.getRoomId()) && zzbg.zza((Object)room2.getCreatorId(), (Object)room.getCreatorId()) && zzbg.zza((Object)room2.getCreationTimestamp(), (Object)room.getCreationTimestamp()) && zzbg.zza((Object)room2.getStatus(), (Object)room.getStatus()) && zzbg.zza((Object)room2.getDescription(), (Object)room.getDescription()) && zzbg.zza((Object)room2.getVariant(), (Object)room.getVariant()) && zzbg.zza((Object)room2.getAutoMatchCriteria(), (Object)room.getAutoMatchCriteria()) && zzbg.zza((Object)room2.getParticipants(), (Object)room.getParticipants()) && zzbg.zza((Object)room2.getAutoMatchWaitEstimateSeconds(), (Object)room.getAutoMatchWaitEstimateSeconds());
    }

    public final String toString() {
        return RoomEntity.zzb(this);
    }

    static String zzb(Room room) {
        return zzbg.zza((Object)room).zza("RoomId", (Object)room.getRoomId()).zza("CreatorId", (Object)room.getCreatorId()).zza("CreationTimestamp", (Object)room.getCreationTimestamp()).zza("RoomStatus", (Object)room.getStatus()).zza("Description", (Object)room.getDescription()).zza("Variant", (Object)room.getVariant()).zza("AutoMatchCriteria", (Object)room.getAutoMatchCriteria()).zza("Participants", (Object)room.getParticipants()).zza("AutoMatchWaitEstimateSeconds", (Object)room.getAutoMatchWaitEstimateSeconds()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        RoomEntity roomEntity = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (String)roomEntity.getRoomId(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)2, (String)roomEntity.getCreatorId(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (long)roomEntity.getCreationTimestamp());
        zzbgo.zza((Parcel)parcel2, (int)4, (int)roomEntity.getStatus());
        zzbgo.zza((Parcel)parcel2, (int)5, (String)roomEntity.getDescription(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)6, (int)roomEntity.getVariant());
        zzbgo.zza((Parcel)parcel2, (int)7, (Bundle)roomEntity.getAutoMatchCriteria(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)8, roomEntity.getParticipants(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)9, (int)roomEntity.getAutoMatchWaitEstimateSeconds());
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    static int zza(Room room, String string) {
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant.getStatus();
        }
        String string2 = room.getRoomId();
        throw new IllegalStateException(new StringBuilder(28 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Participant ").append(string).append(" is not in room ").append(string2).toString());
    }

    static ArrayList<String> zzc(Room room) {
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            arrayList2.add(participant.getParticipantId());
        }
        return arrayList2;
    }

    static String zzb(Room room, String string) {
        String string2 = null;
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(string)) continue;
            string2 = participant.getParticipantId();
            break;
        }
        return string2;
    }

    static Participant zzc(Room room, String string) {
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant;
        }
        String string2 = room.getRoomId();
        throw new IllegalStateException(new StringBuilder(29 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Participant ").append(string).append(" is not in match ").append(string2).toString());
    }

    static final class zza
    extends zze {
        zza() {
        }

        @Override
        public final RoomEntity zza(Parcel parcel) {
            if (RoomEntity.zzb(RoomEntity.o_()) || RoomEntity.zza((String)RoomEntity.class.getCanonicalName())) {
                return super.zza(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            long l = parcel.readLong();
            int n = parcel.readInt();
            String string3 = parcel.readString();
            int n2 = parcel.readInt();
            Bundle bundle = parcel.readBundle();
            int n3 = parcel.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n3);
            for (int i = 0; i < n3; ++i) {
                arrayList.add((ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            return new RoomEntity(string, string2, l, n, string3, n2, bundle, arrayList, -1);
        }

        @Override
        public final /* synthetic */ Object createFromParcel(Parcel parcel) {
            return ((zze)this).zza(parcel);
        }
    }
}

