/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.os.Bundle;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.games.internal.zzf;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;

public final class LoadMatchesResponse {
    private final InvitationBuffer zza;
    private final TurnBasedMatchBuffer zzb;
    private final TurnBasedMatchBuffer zzc;
    private final TurnBasedMatchBuffer zzd;

    @Hide
    public LoadMatchesResponse(Bundle bundle) {
        DataHolder dataHolder = LoadMatchesResponse.zza(bundle, 0);
        this.zza = dataHolder != null ? new InvitationBuffer(dataHolder) : null;
        DataHolder dataHolder2 = LoadMatchesResponse.zza(bundle, 1);
        this.zzb = dataHolder2 != null ? new TurnBasedMatchBuffer(dataHolder2) : null;
        DataHolder dataHolder3 = LoadMatchesResponse.zza(bundle, 2);
        this.zzc = dataHolder3 != null ? new TurnBasedMatchBuffer(dataHolder3) : null;
        DataHolder dataHolder4 = LoadMatchesResponse.zza(bundle, 3);
        if (dataHolder4 != null) {
            this.zzd = new TurnBasedMatchBuffer(dataHolder4);
            return;
        }
        this.zzd = null;
    }

    private static DataHolder zza(Bundle bundle, int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                String string2 = "TURN_STATUS_INVITED";
                break;
            }
            case 1: {
                String string2 = "TURN_STATUS_MY_TURN";
                break;
            }
            case 2: {
                String string2 = "TURN_STATUS_THEIR_TURN";
                break;
            }
            case 3: {
                String string2 = "TURN_STATUS_COMPLETE";
                break;
            }
            default: {
                zzf.zzb("MatchTurnStatus", new StringBuilder(38).append("Unknown match turn status: ").append(n2).toString());
                String string2 = string = "TURN_STATUS_UNKNOWN";
            }
        }
        if (!bundle.containsKey(string)) {
            return null;
        }
        return (DataHolder)bundle.getParcelable(string);
    }

    public final InvitationBuffer getInvitations() {
        return this.zza;
    }

    public final TurnBasedMatchBuffer getMyTurnMatches() {
        return this.zzb;
    }

    public final TurnBasedMatchBuffer getTheirTurnMatches() {
        return this.zzc;
    }

    public final TurnBasedMatchBuffer getCompletedMatches() {
        return this.zzd;
    }

    @Deprecated
    public final void close() {
        this.release();
    }

    public final void release() {
        if (this.zza != null) {
            this.zza.release();
        }
        if (this.zzb != null) {
            this.zzb.release();
        }
        if (this.zzc != null) {
            this.zzc.release();
        }
        if (this.zzd != null) {
            this.zzd.release();
        }
    }

    public final boolean hasData() {
        if (this.zza != null && this.zza.getCount() > 0) {
            return true;
        }
        if (this.zzb != null && this.zzb.getCount() > 0) {
            return true;
        }
        if (this.zzc != null && this.zzc.getCount() > 0) {
            return true;
        }
        return this.zzd != null && this.zzd.getCount() > 0;
    }
}

