/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.zzc;
import com.google.android.gms.internal.zzbgo;
import java.util.ArrayList;
import java.util.Arrays;

public final class TurnBasedMatchEntity
extends com.google.android.gms.games.internal.zzc
implements TurnBasedMatch {
    public static final Parcelable.Creator<TurnBasedMatchEntity> CREATOR = new zzc();
    private final GameEntity zza;
    private final String zzb;
    private final String zzc;
    private final long zzd;
    private final String zze;
    private final long zzf;
    private final String zzg;
    private final int zzh;
    private final int zzi;
    private final int zzj;
    private final byte[] zzk;
    private final ArrayList<ParticipantEntity> zzl;
    private final String zzm;
    private final byte[] zzn;
    private final int zzo;
    private final Bundle zzp;
    private final int zzq;
    private final boolean zzr;
    private final String zzs;
    private final String zzt;

    @Hide
    public TurnBasedMatchEntity(TurnBasedMatch turnBasedMatch) {
        this.zza = new GameEntity(turnBasedMatch.getGame());
        this.zzb = turnBasedMatch.getMatchId();
        this.zzc = turnBasedMatch.getCreatorId();
        this.zzd = turnBasedMatch.getCreationTimestamp();
        this.zze = turnBasedMatch.getLastUpdaterId();
        this.zzf = turnBasedMatch.getLastUpdatedTimestamp();
        this.zzg = turnBasedMatch.getPendingParticipantId();
        this.zzh = turnBasedMatch.getStatus();
        this.zzq = turnBasedMatch.getTurnStatus();
        this.zzi = turnBasedMatch.getVariant();
        this.zzj = turnBasedMatch.getVersion();
        this.zzm = turnBasedMatch.getRematchId();
        this.zzo = turnBasedMatch.getMatchNumber();
        this.zzp = turnBasedMatch.getAutoMatchCriteria();
        this.zzr = turnBasedMatch.isLocallyModified();
        this.zzs = turnBasedMatch.getDescription();
        this.zzt = turnBasedMatch.getDescriptionParticipantId();
        byte[] byArray = turnBasedMatch.getData();
        if (byArray == null) {
            this.zzk = null;
        } else {
            this.zzk = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.zzk, 0, byArray.length);
        }
        byte[] byArray2 = turnBasedMatch.getPreviousMatchData();
        if (byArray2 == null) {
            this.zzn = null;
        } else {
            this.zzn = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, this.zzn, 0, byArray2.length);
        }
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        this.zzl = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzl.add((ParticipantEntity)((Participant)arrayList.get(i)).freeze());
        }
    }

    TurnBasedMatchEntity(GameEntity gameEntity, String string, String string2, long l, String string3, long l2, String string4, int n, int n2, int n3, byte[] byArray, ArrayList<ParticipantEntity> arrayList, String string5, byte[] byArray2, int n4, Bundle bundle, int n5, boolean bl, String string6, String string7) {
        this.zza = gameEntity;
        this.zzb = string;
        this.zzc = string2;
        this.zzd = l;
        this.zze = string3;
        this.zzf = l2;
        this.zzg = string4;
        this.zzh = n;
        this.zzq = n5;
        this.zzi = n2;
        this.zzj = n3;
        this.zzk = byArray;
        this.zzl = arrayList;
        this.zzm = string5;
        this.zzn = byArray2;
        this.zzo = n4;
        this.zzp = bundle;
        this.zzr = bl;
        this.zzs = string6;
        this.zzt = string7;
    }

    @Override
    public final Game getGame() {
        return this.zza;
    }

    @Override
    public final String getMatchId() {
        return this.zzb;
    }

    @Override
    public final String getCreatorId() {
        return this.zzc;
    }

    @Override
    public final long getCreationTimestamp() {
        return this.zzd;
    }

    @Override
    public final String getLastUpdaterId() {
        return this.zze;
    }

    @Override
    public final long getLastUpdatedTimestamp() {
        return this.zzf;
    }

    @Override
    public final String getPendingParticipantId() {
        return this.zzg;
    }

    @Override
    public final int getStatus() {
        return this.zzh;
    }

    @Override
    public final int getTurnStatus() {
        return this.zzq;
    }

    @Override
    public final String getDescription() {
        return this.zzs;
    }

    @Override
    public final String getDescriptionParticipantId() {
        return this.zzt;
    }

    @Override
    public final Participant getDescriptionParticipant() {
        String string = this.getDescriptionParticipantId();
        if (string == null) {
            return null;
        }
        return this.getParticipant(string);
    }

    @Override
    public final void getDescription(CharArrayBuffer charArrayBuffer) {
        com.google.android.gms.common.util.zzh.zza((String)this.zzs, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final int getVariant() {
        return this.zzi;
    }

    @Override
    public final byte[] getData() {
        return this.zzk;
    }

    @Override
    public final int getVersion() {
        return this.zzj;
    }

    @Override
    public final String getRematchId() {
        return this.zzm;
    }

    @Override
    public final byte[] getPreviousMatchData() {
        return this.zzn;
    }

    @Override
    public final int getMatchNumber() {
        return this.zzo;
    }

    @Override
    public final Bundle getAutoMatchCriteria() {
        return this.zzp;
    }

    @Override
    public final int getAvailableAutoMatchSlots() {
        if (this.zzp == null) {
            return 0;
        }
        return this.zzp.getInt("max_automatch_players");
    }

    @Override
    public final boolean canRematch() {
        return this.zzh == 2 && this.zzm == null;
    }

    @Override
    public final boolean isLocallyModified() {
        return this.zzr;
    }

    @Override
    public final int getParticipantStatus(String string) {
        return TurnBasedMatchEntity.zza((TurnBasedMatch)this, string);
    }

    @Override
    public final ArrayList<String> getParticipantIds() {
        return TurnBasedMatchEntity.zzc(this);
    }

    @Override
    public final String getParticipantId(String string) {
        return TurnBasedMatchEntity.zzb(this, string);
    }

    @Override
    public final Participant getParticipant(String string) {
        return TurnBasedMatchEntity.zzc(this, string);
    }

    @Override
    public final ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.zzl);
    }

    public final TurnBasedMatch freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return TurnBasedMatchEntity.zza(this);
    }

    static int zza(TurnBasedMatch turnBasedMatch) {
        return Arrays.hashCode(new Object[]{turnBasedMatch.getGame(), turnBasedMatch.getMatchId(), turnBasedMatch.getCreatorId(), turnBasedMatch.getCreationTimestamp(), turnBasedMatch.getLastUpdaterId(), turnBasedMatch.getLastUpdatedTimestamp(), turnBasedMatch.getPendingParticipantId(), turnBasedMatch.getStatus(), turnBasedMatch.getTurnStatus(), turnBasedMatch.getDescription(), turnBasedMatch.getVariant(), turnBasedMatch.getVersion(), turnBasedMatch.getParticipants(), turnBasedMatch.getRematchId(), turnBasedMatch.getMatchNumber(), turnBasedMatch.getAutoMatchCriteria(), turnBasedMatch.getAvailableAutoMatchSlots(), turnBasedMatch.isLocallyModified()});
    }

    public final boolean equals(Object object) {
        return TurnBasedMatchEntity.zza((TurnBasedMatch)this, object);
    }

    static boolean zza(TurnBasedMatch turnBasedMatch, Object object) {
        if (!(object instanceof TurnBasedMatch)) {
            return false;
        }
        if (turnBasedMatch == object) {
            return true;
        }
        TurnBasedMatch turnBasedMatch2 = (TurnBasedMatch)object;
        return zzbg.zza((Object)turnBasedMatch2.getGame(), (Object)turnBasedMatch.getGame()) && zzbg.zza((Object)turnBasedMatch2.getMatchId(), (Object)turnBasedMatch.getMatchId()) && zzbg.zza((Object)turnBasedMatch2.getCreatorId(), (Object)turnBasedMatch.getCreatorId()) && zzbg.zza((Object)turnBasedMatch2.getCreationTimestamp(), (Object)turnBasedMatch.getCreationTimestamp()) && zzbg.zza((Object)turnBasedMatch2.getLastUpdaterId(), (Object)turnBasedMatch.getLastUpdaterId()) && zzbg.zza((Object)turnBasedMatch2.getLastUpdatedTimestamp(), (Object)turnBasedMatch.getLastUpdatedTimestamp()) && zzbg.zza((Object)turnBasedMatch2.getPendingParticipantId(), (Object)turnBasedMatch.getPendingParticipantId()) && zzbg.zza((Object)turnBasedMatch2.getStatus(), (Object)turnBasedMatch.getStatus()) && zzbg.zza((Object)turnBasedMatch2.getTurnStatus(), (Object)turnBasedMatch.getTurnStatus()) && zzbg.zza((Object)turnBasedMatch2.getDescription(), (Object)turnBasedMatch.getDescription()) && zzbg.zza((Object)turnBasedMatch2.getVariant(), (Object)turnBasedMatch.getVariant()) && zzbg.zza((Object)turnBasedMatch2.getVersion(), (Object)turnBasedMatch.getVersion()) && zzbg.zza((Object)turnBasedMatch2.getParticipants(), (Object)turnBasedMatch.getParticipants()) && zzbg.zza((Object)turnBasedMatch2.getRematchId(), (Object)turnBasedMatch.getRematchId()) && zzbg.zza((Object)turnBasedMatch2.getMatchNumber(), (Object)turnBasedMatch.getMatchNumber()) && zzbg.zza((Object)turnBasedMatch2.getAutoMatchCriteria(), (Object)turnBasedMatch.getAutoMatchCriteria()) && zzbg.zza((Object)turnBasedMatch2.getAvailableAutoMatchSlots(), (Object)turnBasedMatch.getAvailableAutoMatchSlots()) && zzbg.zza((Object)turnBasedMatch2.isLocallyModified(), (Object)turnBasedMatch.isLocallyModified());
    }

    public final String toString() {
        return TurnBasedMatchEntity.zzb(this);
    }

    static String zzb(TurnBasedMatch turnBasedMatch) {
        return zzbg.zza((Object)turnBasedMatch).zza("Game", (Object)turnBasedMatch.getGame()).zza("MatchId", (Object)turnBasedMatch.getMatchId()).zza("CreatorId", (Object)turnBasedMatch.getCreatorId()).zza("CreationTimestamp", (Object)turnBasedMatch.getCreationTimestamp()).zza("LastUpdaterId", (Object)turnBasedMatch.getLastUpdaterId()).zza("LastUpdatedTimestamp", (Object)turnBasedMatch.getLastUpdatedTimestamp()).zza("PendingParticipantId", (Object)turnBasedMatch.getPendingParticipantId()).zza("MatchStatus", (Object)turnBasedMatch.getStatus()).zza("TurnStatus", (Object)turnBasedMatch.getTurnStatus()).zza("Description", (Object)turnBasedMatch.getDescription()).zza("Variant", (Object)turnBasedMatch.getVariant()).zza("Data", (Object)turnBasedMatch.getData()).zza("Version", (Object)turnBasedMatch.getVersion()).zza("Participants", (Object)turnBasedMatch.getParticipants()).zza("RematchId", (Object)turnBasedMatch.getRematchId()).zza("PreviousData", (Object)turnBasedMatch.getPreviousMatchData()).zza("MatchNumber", (Object)turnBasedMatch.getMatchNumber()).zza("AutoMatchCriteria", (Object)turnBasedMatch.getAutoMatchCriteria()).zza("AvailableAutoMatchSlots", (Object)turnBasedMatch.getAvailableAutoMatchSlots()).zza("LocallyModified", (Object)turnBasedMatch.isLocallyModified()).zza("DescriptionParticipantId", (Object)turnBasedMatch.getDescriptionParticipantId()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        TurnBasedMatchEntity turnBasedMatchEntity = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (Parcelable)turnBasedMatchEntity.getGame(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)2, (String)turnBasedMatchEntity.getMatchId(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (String)turnBasedMatchEntity.getCreatorId(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (long)turnBasedMatchEntity.getCreationTimestamp());
        zzbgo.zza((Parcel)parcel2, (int)5, (String)turnBasedMatchEntity.getLastUpdaterId(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)6, (long)turnBasedMatchEntity.getLastUpdatedTimestamp());
        zzbgo.zza((Parcel)parcel2, (int)7, (String)turnBasedMatchEntity.getPendingParticipantId(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)8, (int)turnBasedMatchEntity.getStatus());
        zzbgo.zza((Parcel)parcel2, (int)10, (int)turnBasedMatchEntity.getVariant());
        zzbgo.zza((Parcel)parcel2, (int)11, (int)turnBasedMatchEntity.getVersion());
        zzbgo.zza((Parcel)parcel2, (int)12, (byte[])turnBasedMatchEntity.getData(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)13, turnBasedMatchEntity.getParticipants(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)14, (String)turnBasedMatchEntity.getRematchId(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)15, (byte[])turnBasedMatchEntity.getPreviousMatchData(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)16, (int)turnBasedMatchEntity.getMatchNumber());
        zzbgo.zza((Parcel)parcel2, (int)17, (Bundle)turnBasedMatchEntity.getAutoMatchCriteria(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)18, (int)turnBasedMatchEntity.getTurnStatus());
        zzbgo.zza((Parcel)parcel2, (int)19, (boolean)turnBasedMatchEntity.isLocallyModified());
        zzbgo.zza((Parcel)parcel2, (int)20, (String)turnBasedMatchEntity.getDescription(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)21, (String)turnBasedMatchEntity.getDescriptionParticipantId(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    static int zza(TurnBasedMatch turnBasedMatch, String string) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant.getStatus();
        }
        String string2 = turnBasedMatch.getMatchId();
        throw new IllegalStateException(new StringBuilder(29 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Participant ").append(string).append(" is not in match ").append(string2).toString());
    }

    static ArrayList<String> zzc(TurnBasedMatch turnBasedMatch) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            arrayList2.add(participant.getParticipantId());
        }
        return arrayList2;
    }

    static String zzb(TurnBasedMatch turnBasedMatch, String string) {
        String string2 = null;
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(string)) continue;
            string2 = participant.getParticipantId();
            break;
        }
        return string2;
    }

    static Participant zzc(TurnBasedMatch turnBasedMatch, String string) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant;
        }
        String string2 = turnBasedMatch.getMatchId();
        throw new IllegalStateException(new StringBuilder(29 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Participant ").append(string).append(" is not in match ").append(string2).toString());
    }
}

