/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.video;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.games.internal.zzc;
import com.google.android.gms.games.video.VideoConfiguration;
import com.google.android.gms.games.video.zza;
import com.google.android.gms.internal.zzbgo;
import java.util.Arrays;

public final class VideoCapabilities
extends zzc {
    public static final Parcelable.Creator<VideoCapabilities> CREATOR = new zza();
    private final boolean zza;
    private final boolean zzb;
    private final boolean zzc;
    private final boolean[] zzd;
    private final boolean[] zze;

    @Hide
    public VideoCapabilities(boolean bl, boolean bl2, boolean bl3, boolean[] blArray, boolean[] blArray2) {
        this.zza = bl;
        this.zzb = bl2;
        this.zzc = bl3;
        this.zzd = blArray;
        this.zze = blArray2;
    }

    public final boolean isMicSupported() {
        return this.zzb;
    }

    public final boolean isCameraSupported() {
        return this.zza;
    }

    public final boolean isWriteStorageSupported() {
        return this.zzc;
    }

    public final boolean[] getSupportedCaptureModes() {
        return this.zzd;
    }

    public final boolean[] getSupportedQualityLevels() {
        return this.zze;
    }

    public final boolean supportsCaptureMode(int n) {
        zzbq.zza((boolean)VideoConfiguration.isValidCaptureMode(n, false));
        return this.zzd[n];
    }

    public final boolean supportsQualityLevel(int n) {
        zzbq.zza((boolean)VideoConfiguration.isValidQualityLevel(n, false));
        return this.zze[n];
    }

    public final boolean isFullySupported(int n, int n2) {
        return this.zza && this.zzb && this.zzc && this.supportsCaptureMode(n) && this.supportsQualityLevel(n2);
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.getSupportedCaptureModes(), this.getSupportedQualityLevels(), this.isCameraSupported(), this.isMicSupported(), this.isWriteStorageSupported()});
    }

    public final boolean equals(Object object) {
        if (!(object instanceof VideoCapabilities)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        VideoCapabilities videoCapabilities = (VideoCapabilities)((Object)object);
        return zzbg.zza((Object)videoCapabilities.getSupportedCaptureModes(), (Object)this.getSupportedCaptureModes()) && zzbg.zza((Object)videoCapabilities.getSupportedQualityLevels(), (Object)this.getSupportedQualityLevels()) && zzbg.zza((Object)videoCapabilities.isCameraSupported(), (Object)this.isCameraSupported()) && zzbg.zza((Object)videoCapabilities.isMicSupported(), (Object)this.isMicSupported()) && zzbg.zza((Object)videoCapabilities.isWriteStorageSupported(), (Object)this.isWriteStorageSupported());
    }

    public final String toString() {
        return zzbg.zza((Object)((Object)this)).zza("SupportedCaptureModes", (Object)this.getSupportedCaptureModes()).zza("SupportedQualityLevels", (Object)this.getSupportedQualityLevels()).zza("CameraSupported", (Object)this.isCameraSupported()).zza("MicSupported", (Object)this.isMicSupported()).zza("StorageWriteSupported", (Object)this.isWriteStorageSupported()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        VideoCapabilities videoCapabilities = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (boolean)videoCapabilities.isCameraSupported());
        zzbgo.zza((Parcel)parcel2, (int)2, (boolean)videoCapabilities.isMicSupported());
        zzbgo.zza((Parcel)parcel2, (int)3, (boolean)videoCapabilities.isWriteStorageSupported());
        zzbgo.zza((Parcel)parcel2, (int)4, (boolean[])videoCapabilities.getSupportedCaptureModes(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)5, (boolean[])videoCapabilities.getSupportedQualityLevels(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }
}

