/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.BinderWrapper;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameBuffer;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.GamesClientStatusCodes;
import com.google.android.gms.games.GamesMetadata;
import com.google.android.gms.games.GamesStatusCodes;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerBuffer;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.achievement.AchievementBuffer;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.event.EventBuffer;
import com.google.android.gms.games.event.Events;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.games.leaderboard.LeaderboardScoreBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardScoreEntity;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.leaderboard.ScoreSubmissionData;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.Invitations;
import com.google.android.gms.games.multiplayer.OnInvitationReceivedListener;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessage;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomConfig;
import com.google.android.gms.games.multiplayer.realtime.RoomEntity;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.games.multiplayer.turnbased.LoadMatchesResponse;
import com.google.android.gms.games.multiplayer.turnbased.OnTurnBasedMatchUpdateReceivedListener;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchConfig;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestBuffer;
import com.google.android.gms.games.quest.QuestEntity;
import com.google.android.gms.games.quest.QuestUpdateListener;
import com.google.android.gms.games.quest.Quests;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestBuffer;
import com.google.android.gms.games.request.OnRequestReceivedListener;
import com.google.android.gms.games.request.Requests;
import com.google.android.gms.games.snapshot.Snapshot;
import com.google.android.gms.games.snapshot.SnapshotContents;
import com.google.android.gms.games.snapshot.SnapshotEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataBuffer;
import com.google.android.gms.games.snapshot.SnapshotMetadataChange;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntity;
import com.google.android.gms.games.snapshot.Snapshots;
import com.google.android.gms.games.stats.PlayerStats;
import com.google.android.gms.games.stats.PlayerStatsBuffer;
import com.google.android.gms.games.stats.Stats;
import com.google.android.gms.games.video.CaptureState;
import com.google.android.gms.games.video.VideoCapabilities;
import com.google.android.gms.games.video.Videos;
import com.google.android.gms.internal.zzcct;
import com.google.android.gms.internal.zzccv;
import com.google.android.gms.internal.zzccw;
import com.google.android.gms.internal.zzcyt;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GamesClientImpl
extends com.google.android.gms.common.internal.zzab<com.google.android.gms.games.internal.zzw> {
    private zzccv zzhwr = new com.google.android.gms.games.internal.zzd(this);
    private final String zzhws;
    private PlayerEntity zzhwt;
    private GameEntity zzhwu;
    private final com.google.android.gms.games.internal.zzaa zzhwv;
    private boolean zzhww = false;
    private final Binder zzhwx;
    private final long zzhwy;
    private final Games.GamesOptions zzhwz;
    private boolean zzhxa = false;
    private Bundle zzhxb;

    public GamesClientImpl(Context context, Looper looper, com.google.android.gms.common.internal.zzr zzr2, Games.GamesOptions gamesOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 1, zzr2, connectionCallbacks, onConnectionFailedListener);
        this.zzhws = zzr2.zzami();
        this.zzhwx = new Binder();
        int n = zzr2.zzame();
        GamesClientImpl gamesClientImpl = this;
        this.zzhwv = new com.google.android.gms.games.internal.zzad(gamesClientImpl, n);
        this.zzhwy = ((Object)((Object)this)).hashCode();
        this.zzhwz = gamesOptions;
        if (!this.zzhwz.zzhsh && (zzr2.zzamk() != null || context instanceof Activity)) {
            this.zzz(zzr2.zzamk());
        }
    }

    public final boolean zzacc() {
        return true;
    }

    public final void onConnectionFailed(ConnectionResult connectionResult) {
        super.onConnectionFailed(connectionResult);
        this.zzhww = false;
    }

    public final void zzds(int n) {
        int n2;
        this.zzhwv.zziad.gravity = n2 = n;
    }

    public final void zzz(View view) {
        this.zzhwv.zzaa(view);
    }

    protected final Set<Scope> zzb(Set<Scope> set) {
        HashSet<Scope> hashSet = new HashSet<Scope>(set);
        boolean bl = set.contains(Games.SCOPE_GAMES);
        boolean bl2 = set.contains(Games.SCOPE_GAMES_LITE);
        if (set.contains(Games.zzhrt)) {
            com.google.android.gms.common.internal.zzbq.zza((!bl ? 1 : 0) != 0, (String)"Cannot have both %s and %s!", (Object[])new Object[]{"https://www.googleapis.com/auth/games", "https://www.googleapis.com/auth/games.firstparty"});
        } else {
            com.google.android.gms.common.internal.zzbq.zza((bl || bl2 ? 1 : 0) != 0, (String)"Games APIs requires %s function.", (Object[])new Object[]{"https://www.googleapis.com/auth/games_lite"});
            if (bl2 && bl) {
                hashSet.remove(Games.SCOPE_GAMES_LITE);
            }
        }
        return hashSet;
    }

    public final void zza(com.google.android.gms.common.internal.zzj zzj2) {
        GamesClientImpl gamesClientImpl = this;
        this.zzhwt = null;
        gamesClientImpl.zzhwu = null;
        super.zza(zzj2);
    }

    public final void disconnect() {
        this.zzhww = false;
        if (this.isConnected()) {
            try {
                com.google.android.gms.games.internal.zzw zzw2 = (com.google.android.gms.games.internal.zzw)this.zzalw();
                zzw2.zzaur();
                this.zzhwr.flush();
                zzw2.zzac(this.zzhwy);
            }
            catch (RemoteException remoteException) {
                com.google.android.gms.games.internal.zzf.zzv("GamesClientImpl", "Failed to notify client disconnect.");
            }
        }
        super.disconnect();
    }

    protected final String zzhm() {
        return "com.google.android.gms.games.service.START";
    }

    protected final String zzhn() {
        return "com.google.android.gms.games.internal.IGamesService";
    }

    public final Bundle zzagp() {
        try {
            Bundle bundle = ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzagp();
            if (bundle != null) {
                bundle.setClassLoader(GamesClientImpl.class.getClassLoader());
                this.zzhxb = bundle;
            }
            return bundle;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    @Nullable
    public final Bundle zzatd() {
        Bundle bundle = this.zzagp();
        if (bundle == null) {
            bundle = this.zzhxb;
        }
        this.zzhxb = null;
        return bundle;
    }

    protected final Bundle zzabt() {
        String string = this.getContext().getResources().getConfiguration().locale.toString();
        Bundle bundle = this.zzhwz.zzasu();
        bundle.putString("com.google.android.gms.games.key.gamePackageName", this.zzhws);
        bundle.putString("com.google.android.gms.games.key.desiredLocale", string);
        bundle.putParcelable("com.google.android.gms.games.key.popupWindowToken", (Parcelable)new BinderWrapper(this.zzhwv.zziad.zziae));
        bundle.putInt("com.google.android.gms.games.key.API_VERSION", 6);
        bundle.putBundle("com.google.android.gms.games.key.signInOptions", zzcyt.zza((com.google.android.gms.common.internal.zzr)this.zzamr()));
        return bundle;
    }

    public final String zzate() throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzate();
    }

    public final String zzatf() {
        try {
            return this.zzate();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    @Hide
    public final void zzb(String string, com.google.android.gms.common.api.internal.zzn<Games.GetServerAuthCodeResult> zzn2) throws RemoteException {
        com.google.android.gms.common.internal.zzbq.zzh((String)string, (Object)"Please provide a valid serverClientId");
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zza(string, new zzy(zzn2));
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final String zzbm(boolean bl) throws RemoteException {
        if (this.zzhwt != null) {
            return this.zzhwt.getPlayerId();
        }
        return ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzaut();
    }

    public final String zzbn(boolean bl) {
        try {
            return this.zzbm(true);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Player zzatg() throws RemoteException {
        this.zzalv();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.zzhwt == null) {
                PlayerBuffer playerBuffer = new PlayerBuffer(((com.google.android.gms.games.internal.zzw)this.zzalw()).zzauu());
                try {
                    if (playerBuffer.getCount() > 0) {
                        this.zzhwt = (PlayerEntity)((Player)playerBuffer.get(0)).freeze();
                    }
                }
                finally {
                    playerBuffer.release();
                }
            }
        }
        return this.zzhwt;
    }

    public final Player zzath() {
        try {
            return this.zzatg();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Game zzati() throws RemoteException {
        this.zzalv();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.zzhwu == null) {
                GameBuffer gameBuffer = new GameBuffer(((com.google.android.gms.games.internal.zzw)this.zzalw()).zzauv());
                try {
                    if (gameBuffer.getCount() > 0) {
                        this.zzhwu = (GameEntity)((Game)gameBuffer.get(0)).freeze();
                    }
                }
                finally {
                    gameBuffer.release();
                }
            }
        }
        return this.zzhwu;
    }

    public final Game zzatj() {
        try {
            return this.zzati();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Players.LoadPlayersResult> zzn2, String string, boolean bl) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzb((com.google.android.gms.games.internal.zzs)new zzbn(zzn2), string, bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    @Hide
    public final void zza(com.google.android.gms.common.api.internal.zzn<Players.LoadPlayersResult> zzn2, int n, boolean bl, boolean bl2) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zza((com.google.android.gms.games.internal.zzs)new zzbn(zzn2), n, bl, bl2);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    @Hide
    public final void zza(com.google.android.gms.common.api.internal.zzn<Players.LoadPlayersResult> zzn2, String string, int n, boolean bl, boolean bl2) throws RemoteException {
        switch (string) {
            case "played_with": {
                break;
            }
            default: {
                String string2 = String.valueOf(string);
                throw new IllegalArgumentException(string2.length() != 0 ? "Invalid player collection: ".concat(string2) : new String("Invalid player collection: "));
            }
        }
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zza((com.google.android.gms.games.internal.zzs)new zzbn(zzn2), string, n, bl, bl2);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Players.LoadPlayersResult> zzn2, boolean bl) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzc((com.google.android.gms.games.internal.zzs)new zzbn(zzn2), bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final Intent zzatk() throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzatk();
    }

    public final Intent zzatl() {
        try {
            return this.zzatk();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    public final Intent zzj(String string, int n, int n2) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzk(string, n, n2);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Leaderboards.LeaderboardMetadataResult> zzn2, boolean bl) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzb((com.google.android.gms.games.internal.zzs)new zzai(zzn2), bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Leaderboards.LeaderboardMetadataResult> zzn2, String string, boolean bl) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zza((com.google.android.gms.games.internal.zzs)new zzai(zzn2), string, bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadPlayerScoreResult> zzn2, String string, String string2, int n, int n2) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zza((com.google.android.gms.games.internal.zzs)new zzbl(zzn2), null, string2, n, n2);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadScoresResult> zzn2, String string, int n, int n2, int n3, boolean bl) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zza(new zzah(zzn2), string, n, n2, n3, bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadScoresResult> zzn2, String string, int n, int n2, int n3, boolean bl) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzb(new zzah(zzn2), string, n, n2, n3, bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadScoresResult> zzn2, LeaderboardScoreBuffer leaderboardScoreBuffer, int n, int n2) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zza((com.google.android.gms.games.internal.zzs)new zzah(zzn2), leaderboardScoreBuffer.zzavp().asBundle(), n, n2);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Leaderboards.SubmitScoreResult> zzn2, String string, long l, String string2) throws RemoteException {
        zzcl zzcl2 = zzn2 == null ? null : new zzcl(zzn2);
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zza((com.google.android.gms.games.internal.zzs)zzcl2, string, l, string2);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final Intent zzatm() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzatm();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zzc(com.google.android.gms.common.api.internal.zzn<Achievements.LoadAchievementsResult> zzn2, boolean bl) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zza((com.google.android.gms.games.internal.zzs)new zzf(zzn2), bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Achievements.UpdateAchievementResult> zzn2, String string) throws RemoteException {
        zze zze2 = zzn2 == null ? null : new zze(zzn2);
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zza((com.google.android.gms.games.internal.zzs)zze2, string, this.zzhwv.zziad.zziae, this.zzhwv.zziad.zzauy());
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Achievements.UpdateAchievementResult> zzn2, String string) throws RemoteException {
        zze zze2 = zzn2 == null ? null : new zze(zzn2);
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzb(zze2, string, this.zzhwv.zziad.zziae, this.zzhwv.zziad.zzauy());
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Achievements.UpdateAchievementResult> zzn2, String string, int n) throws RemoteException {
        zze zze2 = zzn2 == null ? null : new zze(zzn2);
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zza((com.google.android.gms.games.internal.zzs)zze2, string, n, this.zzhwv.zziad.zziae, this.zzhwv.zziad.zzauy());
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Achievements.UpdateAchievementResult> zzn2, String string, int n) throws RemoteException {
        zze zze2 = zzn2 == null ? null : new zze(zzn2);
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzb(zze2, string, n, this.zzhwv.zziad.zziae, this.zzhwv.zziad.zzauy());
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzd(com.google.android.gms.common.api.internal.zzn<Events.LoadEventsResult> zzn2, boolean bl) throws RemoteException {
        this.zzhwr.flush();
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zze((com.google.android.gms.games.internal.zzs)new zzu(zzn2), bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Events.LoadEventsResult> zzn2, boolean bl, String ... stringArray) throws RemoteException {
        this.zzhwr.flush();
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zza((com.google.android.gms.games.internal.zzs)new zzu(zzn2), bl, stringArray);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzp(String string, int n) {
        this.zzhwr.zzp(string, n);
    }

    public final Intent zzatn() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzatn();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final Intent zzato() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzato();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zze(com.google.android.gms.common.api.internal.zzci<OnInvitationReceivedListener> zzci2) throws RemoteException {
        zzab zzab2 = new zzab(zzci2);
        ((com.google.android.gms.games.internal.zzw)this.zzalw()).zza((com.google.android.gms.games.internal.zzs)zzab2, this.zzhwy);
    }

    public final void zzf(com.google.android.gms.common.api.internal.zzci<OnInvitationReceivedListener> zzci2) {
        try {
            this.zze(zzci2);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzatp() throws RemoteException {
        ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzad(this.zzhwy);
    }

    public final void zzatq() {
        try {
            this.zzatp();
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzg(com.google.android.gms.common.api.internal.zzci<OnTurnBasedMatchUpdateReceivedListener> zzci2) throws RemoteException {
        zzaz zzaz2 = new zzaz(zzci2);
        ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzb((com.google.android.gms.games.internal.zzs)zzaz2, this.zzhwy);
    }

    public final void zzh(com.google.android.gms.common.api.internal.zzci<OnTurnBasedMatchUpdateReceivedListener> zzci2) {
        try {
            this.zzg(zzci2);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzatr() throws RemoteException {
        ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzae(this.zzhwy);
    }

    public final void zzats() {
        try {
            this.zzatr();
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzi(com.google.android.gms.common.api.internal.zzci<QuestUpdateListener> zzci2) {
        try {
            zzbs zzbs2 = new zzbs(zzci2);
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzd((com.google.android.gms.games.internal.zzs)zzbs2, this.zzhwy);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzatt() {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzag(this.zzhwy);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzj(com.google.android.gms.common.api.internal.zzci<OnRequestReceivedListener> zzci2) {
        try {
            zzbw zzbw2 = new zzbw(zzci2);
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzc((com.google.android.gms.games.internal.zzs)zzbw2, this.zzhwy);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzatu() {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzaf(this.zzhwy);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final Intent zza(PlayerEntity playerEntity) throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzalw()).zza(playerEntity);
    }

    public final Intent zzb(PlayerEntity playerEntity) {
        try {
            return this.zza(playerEntity);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    public final Intent zzatv() throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzatv();
    }

    public final Intent zzatw() {
        try {
            return this.zzatv();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    public final Intent zza(Room room, int n) throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzalw()).zza((RoomEntity)room.freeze(), n);
    }

    public final Intent zzb(Room room, int n) {
        try {
            return this.zza(room, n);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    public final Intent zzatx() throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzatx();
    }

    public final Intent zzaty() {
        try {
            return this.zzatx();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    public final void zzf(com.google.android.gms.common.api.internal.zzn<GamesMetadata.LoadGamesResult> zzn2) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzb(new zzx(zzn2));
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(@NonNull com.google.android.gms.common.internal.zzp zzp2) {
        try {
            this.zzg(new com.google.android.gms.games.internal.zze(this, zzp2));
            return;
        }
        catch (RemoteException remoteException) {
            zzp2.zzako();
            return;
        }
    }

    @Hide
    public final void zzg(com.google.android.gms.common.api.internal.zzn<Status> zzn2) throws RemoteException {
        this.zzhwr.flush();
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zza(new zzcg(zzn2));
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final int zzatz() throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzatz();
    }

    public final int zzaua() {
        try {
            return this.zzatz();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return 4368;
        }
    }

    public final String getAppId() throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzalw()).getAppId();
    }

    public final String zzaub() {
        try {
            return this.getAppId();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Invitations.LoadInvitationsResult> zzn2, int n) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zza((com.google.android.gms.games.internal.zzs)new zzae(zzn2), n);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzq(String string, int n) throws RemoteException {
        ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzq(string, n);
    }

    public final void zzr(String string, int n) {
        try {
            this.zzq(string, n);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzs(String string, int n) throws RemoteException {
        ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzs(string, n);
    }

    public final void zzt(String string, int n) {
        try {
            this.zzs(string, n);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final Intent zzb(int n, int n2, boolean bl) throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzb(n, n2, bl);
    }

    public final Intent zzc(int n, int n2, boolean bl) {
        try {
            return this.zzb(n, n2, bl);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.InitiateMatchResult> zzn2, TurnBasedMatchConfig turnBasedMatchConfig) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zza((com.google.android.gms.games.internal.zzs)new zzco(zzn2), turnBasedMatchConfig.getVariant(), turnBasedMatchConfig.zzavv(), turnBasedMatchConfig.getInvitedPlayerIds(), turnBasedMatchConfig.getAutoMatchCriteria());
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzc(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.InitiateMatchResult> zzn2, String string) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzb((com.google.android.gms.games.internal.zzs)new zzco(zzn2), string);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzd(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.InitiateMatchResult> zzn2, String string) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzc((com.google.android.gms.games.internal.zzs)new zzco(zzn2), string);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final int zzauc() throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzauc();
    }

    public final int zzaud() {
        try {
            return this.zzauc();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return -1;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.UpdateMatchResult> zzn2, String string, byte[] byArray, String string2, ParticipantResult[] participantResultArray) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zza((com.google.android.gms.games.internal.zzs)new zzcs(zzn2), string, byArray, string2, participantResultArray);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.UpdateMatchResult> zzn2, String string, byte[] byArray, ParticipantResult[] participantResultArray) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zza((com.google.android.gms.games.internal.zzs)new zzcs(zzn2), string, byArray, participantResultArray);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zze(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LeaveMatchResult> zzn2, String string) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zze((com.google.android.gms.games.internal.zzs)new zzcp(zzn2), string);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LeaveMatchResult> zzn2, String string, String string2) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zza((com.google.android.gms.games.internal.zzs)new zzcp(zzn2), string, string2);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzf(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.CancelMatchResult> zzn2, String string) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzd((com.google.android.gms.games.internal.zzs)new zzcn(zzn2), string);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzhy(String string) throws RemoteException {
        ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzic(string);
    }

    public final void zzhz(String string) {
        try {
            this.zzhy(string);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LoadMatchesResult> zzn2, int n, int[] nArray) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zza((com.google.android.gms.games.internal.zzs)new zzct(zzn2), n, nArray);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzg(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LoadMatchResult> zzn2, String string) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzf((com.google.android.gms.games.internal.zzs)new zzcq(zzn2), string);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final Intent zzd(int n, int n2, boolean bl) throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzd(n, n2, bl);
    }

    public final Intent zze(int n, int n2, boolean bl) {
        try {
            return this.zzd(n, n2, bl);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzci<? extends RoomUpdateListener> zzci2, com.google.android.gms.common.api.internal.zzci<? extends RoomStatusUpdateListener> zzci3, com.google.android.gms.common.api.internal.zzci<? extends RealTimeMessageReceivedListener> zzci4, RoomConfig roomConfig) throws RemoteException {
        zzcc zzcc2 = new zzcc(zzci2, zzci3, zzci4);
        ((com.google.android.gms.games.internal.zzw)this.zzalw()).zza(zzcc2, (IBinder)this.zzhwx, roomConfig.getVariant(), roomConfig.getInvitedPlayerIds(), roomConfig.getAutoMatchCriteria(), false, this.zzhwy);
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzci<? extends RoomUpdateListener> zzci2, com.google.android.gms.common.api.internal.zzci<? extends RoomStatusUpdateListener> zzci3, com.google.android.gms.common.api.internal.zzci<? extends RealTimeMessageReceivedListener> zzci4, RoomConfig roomConfig) {
        try {
            this.zza(zzci2, zzci3, zzci4, roomConfig);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzc(com.google.android.gms.common.api.internal.zzci<? extends RoomUpdateListener> zzci2, com.google.android.gms.common.api.internal.zzci<? extends RoomStatusUpdateListener> zzci3, com.google.android.gms.common.api.internal.zzci<? extends RealTimeMessageReceivedListener> zzci4, RoomConfig roomConfig) throws RemoteException {
        zzcc zzcc2 = new zzcc(zzci2, zzci3, zzci4);
        ((com.google.android.gms.games.internal.zzw)this.zzalw()).zza((com.google.android.gms.games.internal.zzs)zzcc2, (IBinder)this.zzhwx, roomConfig.getInvitationId(), false, this.zzhwy);
    }

    public final void zzd(com.google.android.gms.common.api.internal.zzci<? extends RoomUpdateListener> zzci2, com.google.android.gms.common.api.internal.zzci<? extends RoomStatusUpdateListener> zzci3, com.google.android.gms.common.api.internal.zzci<? extends RealTimeMessageReceivedListener> zzci4, RoomConfig roomConfig) {
        try {
            this.zzc(zzci2, zzci3, zzci4, roomConfig);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzci<? extends RoomUpdateListener> zzci2, String string) {
        try {
            String string2 = string;
            com.google.android.gms.common.api.internal.zzci<? extends RoomUpdateListener> zzci3 = zzci2;
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zza((com.google.android.gms.games.internal.zzs)new zzcc(zzci3), string2);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final int zza(com.google.android.gms.common.api.internal.zzci<RealTimeMultiplayer.ReliableMessageSentCallback> zzci2, byte[] byArray, String string, String string2) throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzalw()).zza((com.google.android.gms.games.internal.zzs)new zzbv(zzci2), byArray, string, string2);
    }

    public final int zzb(com.google.android.gms.common.api.internal.zzci<RealTimeMultiplayer.ReliableMessageSentCallback> zzci2, byte[] byArray, String string, String string2) {
        try {
            return this.zza(zzci2, byArray, string, string2);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return -1;
        }
    }

    public final int zza(byte[] byArray, String string, String[] stringArray) {
        com.google.android.gms.common.internal.zzbq.checkNotNull((Object)stringArray, (Object)"Participant IDs must not be null");
        try {
            String[] stringArray2 = stringArray;
            String string2 = string;
            byte[] byArray2 = byArray;
            GamesClientImpl gamesClientImpl = this;
            com.google.android.gms.common.internal.zzbq.checkNotNull((Object)stringArray2, (Object)"Participant IDs must not be null");
            return ((com.google.android.gms.games.internal.zzw)gamesClientImpl.zzalw()).zzb(byArray2, string2, stringArray2);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return -1;
        }
    }

    public final int zzd(byte[] byArray, String string) throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzb(byArray, string, null);
    }

    public final int zze(byte[] byArray, String string) {
        try {
            return this.zzd(byArray, string);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return -1;
        }
    }

    public final void zzdt(int n) throws RemoteException {
        ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzdt(n);
    }

    public final void zzdu(int n) {
        try {
            this.zzdt(n);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final Intent zzaue() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzaue();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final Intent zza(int n, byte[] byArray, int n2, Bitmap bitmap, String string) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzw)this.zzalw()).zza(n, byArray, n2, string);
            com.google.android.gms.common.internal.zzbq.checkNotNull((Object)bitmap, (Object)"Must provide a non null icon");
            intent.putExtra("com.google.android.gms.games.REQUEST_ITEM_ICON", (Parcelable)bitmap);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final int zzauf() {
        int n = -1;
        try {
            n = ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzauf();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
        }
        return n;
    }

    public final int zzaug() {
        int n = -1;
        try {
            n = ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzaug();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
        }
        return n;
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Requests.UpdateRequestsResult> zzn2, String[] stringArray) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zza((com.google.android.gms.games.internal.zzs)new zzca(zzn2), stringArray);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Requests.UpdateRequestsResult> zzn2, String[] stringArray) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzb((com.google.android.gms.games.internal.zzs)new zzca(zzn2), stringArray);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Requests.LoadRequestsResult> zzn2, int n, int n2, int n3) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zza((com.google.android.gms.games.internal.zzs)new zzbz(zzn2), n, n2, n3);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zze(com.google.android.gms.common.api.internal.zzn<Stats.LoadPlayerStatsResult> zzn2, boolean bl) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzf((com.google.android.gms.games.internal.zzs)new zzbm(zzn2), bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final Intent zzc(int[] nArray) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzc(nArray);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final Intent zzia(String string) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzia(string);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zzh(com.google.android.gms.common.api.internal.zzn<Quests.AcceptQuestResult> zzn2, String string) throws RemoteException {
        this.zzhwr.flush();
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzh(new zzbp(zzn2), string);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Quests.ClaimMilestoneResult> zzn2, String string, String string2) throws RemoteException {
        this.zzhwr.flush();
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzb((com.google.android.gms.games.internal.zzs)new zzbr(zzn2, string2), string, string2);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Quests.LoadQuestsResult> zzn2, int[] nArray, int n, boolean bl) throws RemoteException {
        this.zzhwr.flush();
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zza((com.google.android.gms.games.internal.zzs)new zzbt(zzn2), nArray, n, bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Quests.LoadQuestsResult> zzn2, boolean bl, String[] stringArray) throws RemoteException {
        this.zzhwr.flush();
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zza((com.google.android.gms.games.internal.zzs)new zzbt(zzn2), stringArray, bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzib(String string) {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zza(string, this.zzhwv.zziad.zziae, this.zzhwv.zziad.zzauy());
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final int zzauh() throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzauh();
    }

    public final int zzaui() {
        try {
            return this.zzauh();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return -1;
        }
    }

    public final int zzauj() throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzauj();
    }

    public final int zzauk() {
        try {
            return this.zzauj();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return -1;
        }
    }

    public final Intent zza(String string, boolean bl, boolean bl2, int n) throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzalw()).zza(string, bl, bl2, n);
    }

    public final Intent zzb(String string, boolean bl, boolean bl2, int n) {
        try {
            return this.zza(string, bl, bl2, n);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    public final void zzf(com.google.android.gms.common.api.internal.zzn<Snapshots.LoadSnapshotsResult> zzn2, boolean bl) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzd((com.google.android.gms.games.internal.zzs)new zzck(zzn2), bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Snapshots.OpenSnapshotResult> zzn2, String string, boolean bl, int n) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zza((com.google.android.gms.games.internal.zzs)new zzcj(zzn2), string, bl, n);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Snapshots.CommitSnapshotResult> zzn2, Snapshot snapshot, SnapshotMetadataChange snapshotMetadataChange) throws RemoteException {
        SnapshotContents snapshotContents = snapshot.getSnapshotContents();
        com.google.android.gms.common.internal.zzbq.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"Snapshot already closed");
        BitmapTeleporter bitmapTeleporter = snapshotMetadataChange.zzavy();
        if (bitmapTeleporter != null) {
            bitmapTeleporter.setTempDir(this.getContext().getCacheDir());
        }
        com.google.android.gms.drive.zzc zzc2 = snapshotContents.zzapl();
        snapshotContents.close();
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zza((com.google.android.gms.games.internal.zzs)new zzch(zzn2), snapshot.getMetadata().getSnapshotId(), (com.google.android.gms.games.snapshot.zze)snapshotMetadataChange, zzc2);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(Snapshot snapshot) throws RemoteException {
        SnapshotContents snapshotContents = snapshot.getSnapshotContents();
        com.google.android.gms.common.internal.zzbq.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"Snapshot already closed");
        com.google.android.gms.drive.zzc zzc2 = snapshotContents.zzapl();
        snapshotContents.close();
        ((com.google.android.gms.games.internal.zzw)this.zzalw()).zza(zzc2);
    }

    public final void zzb(Snapshot snapshot) {
        try {
            this.zza(snapshot);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzi(com.google.android.gms.common.api.internal.zzn<Snapshots.DeleteSnapshotResult> zzn2, String string) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzg(new zzci(zzn2), string);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Snapshots.OpenSnapshotResult> zzn2, String string, String string2, SnapshotMetadataChange snapshotMetadataChange, SnapshotContents snapshotContents) throws RemoteException {
        com.google.android.gms.common.internal.zzbq.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"SnapshotContents already closed");
        BitmapTeleporter bitmapTeleporter = snapshotMetadataChange.zzavy();
        if (bitmapTeleporter != null) {
            bitmapTeleporter.setTempDir(this.getContext().getCacheDir());
        }
        com.google.android.gms.drive.zzc zzc2 = snapshotContents.zzapl();
        snapshotContents.close();
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zza((com.google.android.gms.games.internal.zzs)new zzcj(zzn2), string, string2, (com.google.android.gms.games.snapshot.zze)snapshotMetadataChange, zzc2);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzh(com.google.android.gms.common.api.internal.zzn<Videos.CaptureCapabilitiesResult> zzn2) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzc(new zzj(zzn2));
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final Intent zzaul() throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzauw();
    }

    public final Intent zzaum() {
        try {
            return this.zzaul();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    public final void zzi(com.google.android.gms.common.api.internal.zzn<Videos.CaptureStateResult> zzn2) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzd(new zzn(zzn2));
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Videos.CaptureAvailableResult> zzn2, int n) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzb((com.google.android.gms.games.internal.zzs)new zzh(zzn2), n);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final boolean zzaun() throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzaun();
    }

    public final boolean zzauo() {
        try {
            return this.zzaun();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return false;
        }
    }

    public final void zzk(com.google.android.gms.common.api.internal.zzci<Videos.CaptureOverlayStateListener> zzci2) throws RemoteException {
        zzl zzl2 = new zzl(zzci2);
        ((com.google.android.gms.games.internal.zzw)this.zzalw()).zze((com.google.android.gms.games.internal.zzs)zzl2, this.zzhwy);
    }

    public final void zzl(com.google.android.gms.common.api.internal.zzci<Videos.CaptureOverlayStateListener> zzci2) {
        try {
            this.zzk(zzci2);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzaup() throws RemoteException {
        ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzah(this.zzhwy);
    }

    public final void zzauq() {
        try {
            this.zzaup();
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    @Hide
    public final void zza(IBinder iBinder, Bundle bundle) {
        if (this.isConnected()) {
            try {
                ((com.google.android.gms.games.internal.zzw)this.zzalw()).zza(iBinder, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                GamesClientImpl.zzd(remoteException);
            }
        }
    }

    @Hide
    public final void zzaur() {
        if (this.isConnected()) {
            try {
                ((com.google.android.gms.games.internal.zzw)this.zzalw()).zzaur();
                return;
            }
            catch (RemoteException remoteException) {
                GamesClientImpl.zzd(remoteException);
            }
        }
    }

    private static void zzd(RemoteException remoteException) {
        com.google.android.gms.games.internal.zzf.zzc("GamesClientImpl", "service died", remoteException);
    }

    private static void zza(SecurityException securityException) {
        com.google.android.gms.games.internal.zzf.zzd("GamesClientImpl", "Is player signed out?", securityException);
    }

    private static <R> void zza(com.google.android.gms.common.api.internal.zzn<R> zzn2, SecurityException securityException) {
        if (zzn2 != null) {
            zzn2.zzu(GamesClientStatusCodes.zzdg(4));
        }
    }

    private static Room zzbg(DataHolder dataHolder) {
        com.google.android.gms.games.multiplayer.realtime.zzb zzb2 = new com.google.android.gms.games.multiplayer.realtime.zzb(dataHolder);
        Room room = null;
        try {
            if (zzb2.getCount() > 0) {
                room = (Room)((Room)zzb2.get(0)).freeze();
            }
        }
        finally {
            zzb2.release();
        }
        return room;
    }

    protected final void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (n == 0 && bundle != null) {
            bundle.setClassLoader(GamesClientImpl.class.getClassLoader());
            this.zzhxa = this.zzhww = bundle.getBoolean("show_welcome_popup");
            this.zzhwt = (PlayerEntity)bundle.getParcelable("com.google.android.gms.games.current_player");
            this.zzhwu = (GameEntity)bundle.getParcelable("com.google.android.gms.games.current_game");
        }
        super.zza(n, iBinder, bundle, n2);
    }

    public final /* synthetic */ void zza(@NonNull IInterface iInterface) {
        com.google.android.gms.games.internal.zzw zzw2 = (com.google.android.gms.games.internal.zzw)iInterface;
        GamesClientImpl gamesClientImpl = this;
        super.zza((IInterface)zzw2);
        if (gamesClientImpl.zzhww) {
            gamesClientImpl.zzhwv.zzaux();
            gamesClientImpl.zzhww = false;
        }
        if (!gamesClientImpl.zzhwz.zzhrz && !gamesClientImpl.zzhwz.zzhsh) {
            com.google.android.gms.games.internal.zzw zzw3 = zzw2;
            GamesClientImpl gamesClientImpl2 = gamesClientImpl;
            try {
                zzbo zzbo2 = new zzbo(gamesClientImpl2.zzhwv);
                zzw3.zza(zzbo2, gamesClientImpl2.zzhwy);
                return;
            }
            catch (RemoteException remoteException) {
                GamesClientImpl.zzd(remoteException);
            }
        }
    }

    protected final /* synthetic */ IInterface zzd(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.games.internal.IGamesService");
        if (iInterface instanceof com.google.android.gms.games.internal.zzw) {
            return (com.google.android.gms.games.internal.zzw)iInterface;
        }
        return new com.google.android.gms.games.internal.zzx(iBinder2);
    }

    static final class CaptureStreamingUrlResultImpl
    implements Videos.CaptureStreamingUrlResult {
        private final String zzag;

        public final Status getStatus() {
            throw new NoSuchMethodError();
        }

        @Override
        public final String getUrl() {
            return this.zzag;
        }
    }

    static final class zzo
    implements Videos.CaptureStateResult {
        private final Status mStatus;
        private final CaptureState zzhxk;

        zzo(Status status, CaptureState captureState) {
            this.mStatus = status;
            this.zzhxk = captureState;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final CaptureState getCaptureState() {
            return this.zzhxk;
        }
    }

    static final class zzk
    implements Videos.CaptureCapabilitiesResult {
        private final Status mStatus;
        private final VideoCapabilities zzhxi;

        zzk(Status status, VideoCapabilities videoCapabilities) {
            this.mStatus = status;
            this.zzhxi = videoCapabilities;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final VideoCapabilities getCapabilities() {
            return this.zzhxi;
        }
    }

    static final class zzi
    implements Videos.CaptureAvailableResult {
        private final Status mStatus;
        private final boolean zzhxh;

        zzi(Status status, boolean bl) {
            this.mStatus = status;
            this.zzhxh = bl;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final boolean isAvailable() {
            return this.zzhxh;
        }
    }

    static final class zzs
    implements Snapshots.DeleteSnapshotResult {
        private final Status mStatus;
        private final String zzhxn;

        zzs(int n, String string) {
            this.mStatus = GamesStatusCodes.zzdg(n);
            this.zzhxn = string;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final String getSnapshotId() {
            return this.zzhxn;
        }
    }

    static final class zzq
    extends zzw
    implements Snapshots.CommitSnapshotResult {
        private final SnapshotMetadata zzhxm;

        zzq(DataHolder dataHolder) {
            super(dataHolder);
            SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(dataHolder);
            try {
                this.zzhxm = snapshotMetadataBuffer.getCount() > 0 ? new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(0)) : null;
                return;
            }
            finally {
                snapshotMetadataBuffer.release();
            }
        }

        @Override
        public final SnapshotMetadata getSnapshotMetadata() {
            return this.zzhxm;
        }
    }

    static final class zzbc
    extends zzw
    implements Snapshots.OpenSnapshotResult {
        private final Snapshot zzhyg;
        private final String zzhyh;
        private final Snapshot zzhyi;
        private final com.google.android.gms.drive.zzc zzhyj;
        private final SnapshotContents zzhyk;

        zzbc(DataHolder dataHolder, com.google.android.gms.drive.zzc zzc2) {
            this(dataHolder, null, zzc2, null, null);
        }

        zzbc(DataHolder dataHolder, String string, com.google.android.gms.drive.zzc zzc2, com.google.android.gms.drive.zzc zzc3, com.google.android.gms.drive.zzc zzc4) {
            super(dataHolder);
            SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(dataHolder);
            try {
                if (snapshotMetadataBuffer.getCount() == 0) {
                    this.zzhyg = null;
                    this.zzhyi = null;
                } else if (snapshotMetadataBuffer.getCount() == 1) {
                    com.google.android.gms.common.internal.zzc.checkState((dataHolder.getStatusCode() != 4004 ? 1 : 0) != 0);
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(0));
                    this.zzhyg = new SnapshotEntity(snapshotMetadataEntity, new com.google.android.gms.games.snapshot.zza(zzc2));
                    this.zzhyi = null;
                } else {
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(0));
                    this.zzhyg = new SnapshotEntity(snapshotMetadataEntity, new com.google.android.gms.games.snapshot.zza(zzc2));
                    SnapshotMetadataEntity snapshotMetadataEntity2 = new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(1));
                    this.zzhyi = new SnapshotEntity(snapshotMetadataEntity2, new com.google.android.gms.games.snapshot.zza(zzc3));
                }
            }
            finally {
                snapshotMetadataBuffer.release();
            }
            this.zzhyh = string;
            this.zzhyj = zzc4;
            this.zzhyk = new com.google.android.gms.games.snapshot.zza(zzc4);
        }

        @Override
        public final Snapshot getSnapshot() {
            return this.zzhyg;
        }

        @Override
        public final String getConflictId() {
            return this.zzhyh;
        }

        @Override
        public final Snapshot getConflictingSnapshot() {
            return this.zzhyi;
        }

        @Override
        public final SnapshotContents getResolutionSnapshotContents() {
            return this.zzhyk;
        }
    }

    static final class zzax
    extends zzw
    implements Snapshots.LoadSnapshotsResult {
        zzax(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final SnapshotMetadataBuffer getSnapshots() {
            return new SnapshotMetadataBuffer(this.zzfxb);
        }
    }

    static final class zzas
    extends zzw
    implements Stats.LoadPlayerStatsResult {
        private final PlayerStats zzhxy;

        zzas(DataHolder dataHolder) {
            super(dataHolder);
            PlayerStatsBuffer playerStatsBuffer = new PlayerStatsBuffer(dataHolder);
            try {
                this.zzhxy = playerStatsBuffer.getCount() > 0 ? new com.google.android.gms.games.stats.zza((PlayerStats)playerStatsBuffer.get(0)) : null;
                return;
            }
            finally {
                playerStatsBuffer.release();
            }
        }

        @Override
        public final PlayerStats getPlayerStats() {
            return this.zzhxy;
        }
    }

    static final class zzp
    extends zzw
    implements Quests.ClaimMilestoneResult {
        private final Milestone zzhxl;
        private final Quest zzhxf;

        zzp(DataHolder dataHolder, String string) {
            super(dataHolder);
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            try {
                if (questBuffer.getCount() > 0) {
                    this.zzhxf = new QuestEntity((Quest)questBuffer.get(0));
                    List<Milestone> list = this.zzhxf.zzavw();
                    int n = list.size();
                    for (int i = 0; i < n; ++i) {
                        if (!list.get(i).getMilestoneId().equals(string)) continue;
                        this.zzhxl = list.get(i);
                        return;
                    }
                    this.zzhxl = null;
                } else {
                    this.zzhxl = null;
                    this.zzhxf = null;
                }
                return;
            }
            finally {
                questBuffer.release();
            }
        }

        @Override
        public final Milestone getMilestone() {
            return this.zzhxl;
        }

        @Override
        public final Quest getQuest() {
            return this.zzhxf;
        }
    }

    static final class zzd
    extends zzw
    implements Quests.AcceptQuestResult {
        private final Quest zzhxf;

        zzd(DataHolder dataHolder) {
            super(dataHolder);
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            try {
                this.zzhxf = questBuffer.getCount() > 0 ? new QuestEntity((Quest)questBuffer.get(0)) : null;
                return;
            }
            finally {
                questBuffer.release();
            }
        }

        @Override
        public final Quest getQuest() {
            return this.zzhxf;
        }
    }

    static final class zzau
    extends zzw
    implements Quests.LoadQuestsResult {
        private final DataHolder zzfxb;

        zzau(DataHolder dataHolder) {
            super(dataHolder);
            this.zzfxb = dataHolder;
        }

        @Override
        public final QuestBuffer getQuests() {
            return new QuestBuffer(this.zzfxb);
        }
    }

    static final class zzav
    implements Requests.LoadRequestsResult {
        private final Status mStatus;
        private final Bundle zzhya;

        zzav(Status status, Bundle bundle) {
            this.mStatus = status;
            this.zzhya = bundle;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final GameRequestBuffer getRequests(int n) {
            String string;
            switch (n) {
                case 1: {
                    String string2 = "GIFT";
                    break;
                }
                case 2: {
                    String string2 = "WISH";
                    break;
                }
                default: {
                    com.google.android.gms.games.internal.zzf.zzw("RequestType", new StringBuilder(33).append("Unknown request type: ").append(n).toString());
                    String string2 = string = "UNKNOWN_TYPE";
                }
            }
            if (!this.zzhya.containsKey(string)) {
                return null;
            }
            DataHolder dataHolder = (DataHolder)this.zzhya.get(string);
            return new GameRequestBuffer(dataHolder);
        }

        public final void release() {
            for (String string : this.zzhya.keySet()) {
                DataHolder dataHolder = (DataHolder)this.zzhya.getParcelable(string);
                if (dataHolder == null) continue;
                dataHolder.close();
            }
        }
    }

    static final class zzcw
    extends zzw
    implements Requests.UpdateRequestsResult {
        private final zzccw zzhzj;

        zzcw(DataHolder dataHolder) {
            super(dataHolder);
            this.zzhzj = zzccw.zzbj(dataHolder);
        }

        @Override
        public final int getRequestOutcome(String string) {
            return this.zzhzj.getRequestOutcome(string);
        }

        @Override
        public final Set<String> getRequestIds() {
            return this.zzhzj.getRequestIds();
        }
    }

    static final class zzz
    implements Games.GetServerAuthCodeResult {
        private final Status mStatus;
        private final String zzhxo;

        zzz(Status status, String string) {
            this.mStatus = status;
            this.zzhxo = string;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final String getCode() {
            return this.zzhxo;
        }
    }

    static final class zzg
    implements TurnBasedMultiplayer.CancelMatchResult {
        private final Status mStatus;
        private final String zzhxg;

        zzg(Status status, String string) {
            this.mStatus = status;
            this.zzhxg = string;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final String getMatchId() {
            return this.zzhxg;
        }
    }

    static final class zzaj
    extends zzcr
    implements TurnBasedMultiplayer.LeaveMatchResult {
        zzaj(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    static final class zzcv
    extends zzcr
    implements TurnBasedMultiplayer.UpdateMatchResult {
        zzcv(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    static final class zzaa
    extends zzcr
    implements TurnBasedMultiplayer.InitiateMatchResult {
        zzaa(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    static final class zzap
    extends zzcr
    implements TurnBasedMultiplayer.LoadMatchResult {
        zzap(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    static abstract class zzcr
    extends zzw {
        private TurnBasedMatch zzhye;

        zzcr(DataHolder dataHolder) {
            super(dataHolder);
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            try {
                this.zzhye = turnBasedMatchBuffer.getCount() > 0 ? (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze() : null;
                return;
            }
            finally {
                turnBasedMatchBuffer.release();
            }
        }

        public TurnBasedMatch getMatch() {
            return this.zzhye;
        }
    }

    static final class zzcm
    extends zzw
    implements Leaderboards.SubmitScoreResult {
        private final ScoreSubmissionData zzhzc;

        public zzcm(DataHolder dataHolder) {
            super(dataHolder);
            try {
                this.zzhzc = new ScoreSubmissionData(dataHolder);
                return;
            }
            finally {
                dataHolder.close();
            }
        }

        @Override
        public final ScoreSubmissionData getScoreData() {
            return this.zzhzc;
        }
    }

    static final class zzat
    extends zzw
    implements Players.LoadPlayersResult {
        private final PlayerBuffer zzhxz;

        zzat(DataHolder dataHolder) {
            super(dataHolder);
            this.zzhxz = new PlayerBuffer(dataHolder);
        }

        @Override
        public final PlayerBuffer getPlayers() {
            return this.zzhxz;
        }
    }

    static final class zzaq
    implements TurnBasedMultiplayer.LoadMatchesResult {
        private final Status mStatus;
        private final LoadMatchesResponse zzhxw;

        zzaq(Status status, Bundle bundle) {
            this.mStatus = status;
            this.zzhxw = new LoadMatchesResponse(bundle);
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final LoadMatchesResponse getMatches() {
            return this.zzhxw;
        }

        public final void release() {
            this.zzhxw.release();
        }
    }

    static final class zzao
    extends zzw
    implements Invitations.LoadInvitationsResult {
        private final InvitationBuffer zzhxv;

        zzao(DataHolder dataHolder) {
            super(dataHolder);
            this.zzhxv = new InvitationBuffer(dataHolder);
        }

        @Override
        public final InvitationBuffer getInvitations() {
            return this.zzhxv;
        }
    }

    static final class zzar
    extends zzw
    implements Leaderboards.LoadPlayerScoreResult {
        private final LeaderboardScoreEntity zzhxx;

        zzar(DataHolder dataHolder) {
            super(dataHolder);
            LeaderboardScoreBuffer leaderboardScoreBuffer = new LeaderboardScoreBuffer(dataHolder);
            try {
                this.zzhxx = leaderboardScoreBuffer.getCount() > 0 ? (LeaderboardScoreEntity)((LeaderboardScore)leaderboardScoreBuffer.get(0)).freeze() : null;
                return;
            }
            finally {
                leaderboardScoreBuffer.release();
            }
        }

        @Override
        public final LeaderboardScore getScore() {
            return this.zzhxx;
        }
    }

    static final class zzaw
    extends zzw
    implements Leaderboards.LoadScoresResult {
        private final LeaderboardEntity zzhyb;
        private final LeaderboardScoreBuffer zzhyc;

        zzaw(DataHolder dataHolder, DataHolder dataHolder2) {
            super(dataHolder2);
            LeaderboardBuffer leaderboardBuffer = new LeaderboardBuffer(dataHolder);
            try {
                this.zzhyb = leaderboardBuffer.getCount() > 0 ? (LeaderboardEntity)((Leaderboard)leaderboardBuffer.get(0)).freeze() : null;
            }
            finally {
                leaderboardBuffer.release();
            }
            this.zzhyc = new LeaderboardScoreBuffer(dataHolder2);
        }

        @Override
        public final Leaderboard getLeaderboard() {
            return this.zzhyb;
        }

        @Override
        public final LeaderboardScoreBuffer getScores() {
            return this.zzhyc;
        }
    }

    static final class zzag
    extends zzw
    implements Leaderboards.LeaderboardMetadataResult {
        private final LeaderboardBuffer zzhxq;

        zzag(DataHolder dataHolder) {
            super(dataHolder);
            this.zzhxq = new LeaderboardBuffer(dataHolder);
        }

        @Override
        public final LeaderboardBuffer getLeaderboards() {
            return this.zzhxq;
        }
    }

    static final class zzan
    extends zzw
    implements GamesMetadata.LoadGamesResult {
        private final GameBuffer zzhxu;

        zzan(DataHolder dataHolder) {
            super(dataHolder);
            this.zzhxu = new GameBuffer(dataHolder);
        }

        @Override
        public final GameBuffer getGames() {
            return this.zzhxu;
        }
    }

    static final class zzam
    extends zzw
    implements Events.LoadEventsResult {
        private final EventBuffer zzhxt;

        zzam(DataHolder dataHolder) {
            super(dataHolder);
            this.zzhxt = new EventBuffer(dataHolder);
        }

        @Override
        public final EventBuffer getEvents() {
            return this.zzhxt;
        }
    }

    static final class zzcu
    implements Achievements.UpdateAchievementResult {
        private final Status mStatus;
        private final String zzhwd;

        zzcu(int n, String string) {
            this.mStatus = GamesStatusCodes.zzdg(n);
            this.zzhwd = string;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final String getAchievementId() {
            return this.zzhwd;
        }
    }

    static final class zzal
    extends zzw
    implements Achievements.LoadAchievementsResult {
        private final AchievementBuffer zzhxs;

        zzal(DataHolder dataHolder) {
            super(dataHolder);
            this.zzhxs = new AchievementBuffer(dataHolder);
        }

        @Override
        public final AchievementBuffer getAchievements() {
            return this.zzhxs;
        }
    }

    static abstract class zzw
    extends com.google.android.gms.common.api.internal.zzaj {
        protected zzw(DataHolder dataHolder) {
            super(dataHolder, GamesStatusCodes.zzdg(dataHolder.getStatusCode()));
        }
    }

    static final class zzbu
    implements com.google.android.gms.common.api.internal.zzcl<RealTimeMultiplayer.ReliableMessageSentCallback> {
        private final int zzcc;
        private final String zzhyq;
        private final int zzhyr;

        zzbu(int n, int n2, String string) {
            this.zzcc = n;
            this.zzhyr = n2;
            this.zzhyq = string;
        }

        public final void zzajh() {
        }

        public final /* synthetic */ void zzu(Object object) {
            RealTimeMultiplayer.ReliableMessageSentCallback reliableMessageSentCallback = (RealTimeMultiplayer.ReliableMessageSentCallback)object;
            zzbu zzbu2 = this;
            if (reliableMessageSentCallback != null) {
                reliableMessageSentCallback.onRealTimeMessageSent(zzbu2.zzcc, zzbu2.zzhyr, zzbu2.zzhyq);
            }
        }
    }

    static final class zzbb
    implements com.google.android.gms.common.api.internal.zzcl<RealTimeMessageReceivedListener> {
        private final RealTimeMessage zzhyf;

        zzbb(RealTimeMessage realTimeMessage) {
            this.zzhyf = realTimeMessage;
        }

        public final void zzajh() {
        }

        public final /* synthetic */ void zzu(Object object) {
            RealTimeMessageReceivedListener realTimeMessageReceivedListener = (RealTimeMessageReceivedListener)object;
            zzbb zzbb2 = this;
            realTimeMessageReceivedListener.onRealTimeMessageReceived(zzbb2.zzhyf);
        }
    }

    static final class zzbe
    implements com.google.android.gms.common.api.internal.zzcl<RoomStatusUpdateListener> {
        private final String zzhyl;

        zzbe(String string) {
            this.zzhyl = string;
        }

        public final void zzajh() {
        }

        public final /* synthetic */ void zzu(Object object) {
            RoomStatusUpdateListener roomStatusUpdateListener = (RoomStatusUpdateListener)object;
            zzbe zzbe2 = this;
            roomStatusUpdateListener.onP2PDisconnected(zzbe2.zzhyl);
        }
    }

    static final class zzbd
    implements com.google.android.gms.common.api.internal.zzcl<RoomStatusUpdateListener> {
        private final String zzhyl;

        zzbd(String string) {
            this.zzhyl = string;
        }

        public final void zzajh() {
        }

        public final /* synthetic */ void zzu(Object object) {
            RoomStatusUpdateListener roomStatusUpdateListener = (RoomStatusUpdateListener)object;
            zzbd zzbd2 = this;
            roomStatusUpdateListener.onP2PConnected(zzbd2.zzhyl);
        }
    }

    static final class zzbh
    extends zza {
        zzbh(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersDisconnected(room, arrayList);
        }
    }

    static final class zzbf
    extends zza {
        zzbf(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersConnected(room, arrayList);
        }
    }

    static final class zzbg
    extends zza {
        zzbg(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerDeclined(room, arrayList);
        }
    }

    static final class zzbk
    extends zza {
        zzbk(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerLeft(room, arrayList);
        }
    }

    static final class zzbj
    extends zza {
        zzbj(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerJoined(room, arrayList);
        }
    }

    static final class zzbi
    extends zza {
        zzbi(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerInvitedToRoom(room, arrayList);
        }
    }

    static final class zzt
    extends zzc {
        zzt(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onDisconnectedFromRoom(room);
        }
    }

    static final class zzr
    extends zzc {
        zzr(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onConnectedToRoom(room);
        }
    }

    static final class zzcb
    extends zzc {
        zzcb(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomAutoMatching(room);
        }
    }

    static final class zzce
    extends zzc {
        zzce(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomConnecting(room);
        }
    }

    static final class zzcd
    extends zzb {
        zzcd(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onRoomConnected(n, room);
        }
    }

    static final class zzak
    implements com.google.android.gms.common.api.internal.zzcl<RoomUpdateListener> {
        private final int zzcc;
        private final String zzhxr;

        zzak(int n, String string) {
            this.zzcc = n;
            this.zzhxr = string;
        }

        public final void zzajh() {
        }

        public final /* synthetic */ void zzu(Object object) {
            RoomUpdateListener roomUpdateListener = (RoomUpdateListener)object;
            zzak zzak2 = this;
            roomUpdateListener.onLeftRoom(zzak2.zzcc, zzak2.zzhxr);
        }
    }

    static final class zzaf
    extends zzb {
        public zzaf(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onJoinedRoom(n, room);
        }
    }

    static final class zzcf
    extends zzb {
        public zzcf(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onRoomCreated(n, room);
        }
    }

    static abstract class zza
    extends zzc {
        private final ArrayList<String> zzhxe = new ArrayList();

        zza(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                this.zzhxe.add(stringArray[i]);
            }
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            this.zza(roomStatusUpdateListener, room, this.zzhxe);
        }

        protected abstract void zza(RoomStatusUpdateListener var1, Room var2, ArrayList<String> var3);
    }

    static abstract class zzc
    extends com.google.android.gms.common.api.internal.zzai<RoomStatusUpdateListener> {
        zzc(DataHolder dataHolder) {
            super(dataHolder);
        }

        protected abstract void zza(RoomStatusUpdateListener var1, Room var2);

        protected final /* synthetic */ void zza(Object object, DataHolder dataHolder) {
            DataHolder dataHolder2 = dataHolder;
            RoomStatusUpdateListener roomStatusUpdateListener = (RoomStatusUpdateListener)object;
            this.zza(roomStatusUpdateListener, GamesClientImpl.zzbg(dataHolder2));
        }
    }

    static abstract class zzb
    extends com.google.android.gms.common.api.internal.zzai<RoomUpdateListener> {
        zzb(DataHolder dataHolder) {
            super(dataHolder);
        }

        protected abstract void zza(RoomUpdateListener var1, Room var2, int var3);

        protected final /* synthetic */ void zza(Object object, DataHolder dataHolder) {
            DataHolder dataHolder2 = dataHolder;
            RoomUpdateListener roomUpdateListener = (RoomUpdateListener)object;
            this.zza(roomUpdateListener, GamesClientImpl.zzbg(dataHolder2), dataHolder2.getStatusCode());
        }
    }

    static final class zzby
    implements com.google.android.gms.common.api.internal.zzcl<OnRequestReceivedListener> {
        private final String zzcwj;

        zzby(String string) {
            this.zzcwj = string;
        }

        public final void zzajh() {
        }

        public final /* synthetic */ void zzu(Object object) {
            OnRequestReceivedListener onRequestReceivedListener = (OnRequestReceivedListener)object;
            zzby zzby2 = this;
            onRequestReceivedListener.onRequestRemoved(zzby2.zzcwj);
        }
    }

    static final class zzbx
    implements com.google.android.gms.common.api.internal.zzcl<OnRequestReceivedListener> {
        private final GameRequest zzhyt;

        zzbx(GameRequest gameRequest) {
            this.zzhyt = gameRequest;
        }

        public final void zzajh() {
        }

        public final /* synthetic */ void zzu(Object object) {
            OnRequestReceivedListener onRequestReceivedListener = (OnRequestReceivedListener)object;
            zzbx zzbx2 = this;
            onRequestReceivedListener.onRequestReceived(zzbx2.zzhyt);
        }
    }

    static final class zzbq
    implements com.google.android.gms.common.api.internal.zzcl<QuestUpdateListener> {
        private final Quest zzhxf;

        zzbq(Quest quest) {
            this.zzhxf = quest;
        }

        public final void zzajh() {
        }

        public final /* synthetic */ void zzu(Object object) {
            QuestUpdateListener questUpdateListener = (QuestUpdateListener)object;
            zzbq zzbq2 = this;
            questUpdateListener.onQuestCompleted(zzbq2.zzhxf);
        }
    }

    static final class zzay
    implements com.google.android.gms.common.api.internal.zzcl<OnTurnBasedMatchUpdateReceivedListener> {
        private final String zzhyd;

        zzay(String string) {
            this.zzhyd = string;
        }

        public final void zzajh() {
        }

        public final /* synthetic */ void zzu(Object object) {
            OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener = (OnTurnBasedMatchUpdateReceivedListener)object;
            zzay zzay2 = this;
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchRemoved(zzay2.zzhyd);
        }
    }

    static final class zzba
    implements com.google.android.gms.common.api.internal.zzcl<OnTurnBasedMatchUpdateReceivedListener> {
        private final TurnBasedMatch zzhye;

        zzba(TurnBasedMatch turnBasedMatch) {
            this.zzhye = turnBasedMatch;
        }

        public final void zzajh() {
        }

        public final /* synthetic */ void zzu(Object object) {
            OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener = (OnTurnBasedMatchUpdateReceivedListener)object;
            zzba zzba2 = this;
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchReceived(zzba2.zzhye);
        }
    }

    static final class zzad
    implements com.google.android.gms.common.api.internal.zzcl<OnInvitationReceivedListener> {
        private final String zzeha;

        zzad(String string) {
            this.zzeha = string;
        }

        public final void zzajh() {
        }

        public final /* synthetic */ void zzu(Object object) {
            OnInvitationReceivedListener onInvitationReceivedListener = (OnInvitationReceivedListener)object;
            zzad zzad2 = this;
            onInvitationReceivedListener.onInvitationRemoved(zzad2.zzeha);
        }
    }

    static final class zzac
    implements com.google.android.gms.common.api.internal.zzcl<OnInvitationReceivedListener> {
        private final Invitation zzhxp;

        zzac(Invitation invitation) {
            this.zzhxp = invitation;
        }

        public final void zzajh() {
        }

        public final /* synthetic */ void zzu(Object object) {
            OnInvitationReceivedListener onInvitationReceivedListener = (OnInvitationReceivedListener)object;
            zzac zzac2 = this;
            onInvitationReceivedListener.onInvitationReceived(zzac2.zzhxp);
        }
    }

    static final class zzm
    implements com.google.android.gms.common.api.internal.zzcl<Videos.CaptureOverlayStateListener> {
        private final int zzhxj;

        zzm(int n) {
            this.zzhxj = n;
        }

        public final void zzajh() {
        }

        public final /* synthetic */ void zzu(Object object) {
            Videos.CaptureOverlayStateListener captureOverlayStateListener = (Videos.CaptureOverlayStateListener)object;
            zzm zzm2 = this;
            captureOverlayStateListener.onCaptureOverlayStateChanged(zzm2.zzhxj);
        }
    }

    static final class zzn
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Videos.CaptureStateResult> zzgbf;

        public zzn(com.google.android.gms.common.api.internal.zzn<Videos.CaptureStateResult> zzn2) {
            this.zzgbf = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzh(int n, Bundle bundle) {
            this.zzgbf.setResult((Object)new zzo(new Status(n), CaptureState.zzq(bundle)));
        }
    }

    static final class zzl
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzci<Videos.CaptureOverlayStateListener> zzgut;

        zzl(com.google.android.gms.common.api.internal.zzci<Videos.CaptureOverlayStateListener> zzci2) {
            this.zzgut = (com.google.android.gms.common.api.internal.zzci)com.google.android.gms.common.internal.zzbq.checkNotNull(zzci2, (Object)"Callback must not be null");
        }

        @Override
        public final void onCaptureOverlayStateChanged(int n) {
            this.zzgut.zza((com.google.android.gms.common.api.internal.zzcl)new zzm(n));
        }
    }

    static final class zzj
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Videos.CaptureCapabilitiesResult> zzgbf;

        zzj(com.google.android.gms.common.api.internal.zzn<Videos.CaptureCapabilitiesResult> zzn2) {
            this.zzgbf = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zza(int n, VideoCapabilities videoCapabilities) {
            this.zzgbf.setResult((Object)new zzk(new Status(n), videoCapabilities));
        }
    }

    static final class zzh
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Videos.CaptureAvailableResult> zzgbf;

        zzh(com.google.android.gms.common.api.internal.zzn<Videos.CaptureAvailableResult> zzn2) {
            this.zzgbf = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzi(int n, boolean bl) {
            this.zzgbf.setResult((Object)new zzi(new Status(n), bl));
        }
    }

    static final class zzci
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Snapshots.DeleteSnapshotResult> zzgbf;

        public zzci(com.google.android.gms.common.api.internal.zzn<Snapshots.DeleteSnapshotResult> zzn2) {
            this.zzgbf = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzj(int n, String string) {
            this.zzgbf.setResult((Object)new zzs(n, string));
        }
    }

    static final class zzch
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Snapshots.CommitSnapshotResult> zzhyz;

        public zzch(com.google.android.gms.common.api.internal.zzn<Snapshots.CommitSnapshotResult> zzn2) {
            this.zzhyz = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzam(DataHolder dataHolder) {
            this.zzhyz.setResult((Object)new zzq(dataHolder));
        }
    }

    static final class zzcj
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Snapshots.OpenSnapshotResult> zzhza;

        public zzcj(com.google.android.gms.common.api.internal.zzn<Snapshots.OpenSnapshotResult> zzn2) {
            this.zzhza = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zza(DataHolder dataHolder, com.google.android.gms.drive.zzc zzc2) {
            this.zzhza.setResult((Object)new zzbc(dataHolder, zzc2));
        }

        @Override
        public final void zza(DataHolder dataHolder, String string, com.google.android.gms.drive.zzc zzc2, com.google.android.gms.drive.zzc zzc3, com.google.android.gms.drive.zzc zzc4) {
            this.zzhza.setResult((Object)new zzbc(dataHolder, string, zzc2, zzc3, zzc4));
        }
    }

    static final class zzck
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Snapshots.LoadSnapshotsResult> zzhzb;

        public zzck(com.google.android.gms.common.api.internal.zzn<Snapshots.LoadSnapshotsResult> zzn2) {
            this.zzhzb = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzal(DataHolder dataHolder) {
            this.zzhzb.setResult((Object)new zzax(dataHolder));
        }
    }

    static final class zzbm
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Stats.LoadPlayerStatsResult> zzgbf;

        public zzbm(com.google.android.gms.common.api.internal.zzn<Stats.LoadPlayerStatsResult> zzn2) {
            this.zzgbf = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzau(DataHolder dataHolder) {
            this.zzgbf.setResult((Object)new zzas(dataHolder));
        }
    }

    static final class zzbt
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Quests.LoadQuestsResult> zzhyp;

        public zzbt(com.google.android.gms.common.api.internal.zzn<Quests.LoadQuestsResult> zzn2) {
            this.zzhyp = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzar(DataHolder dataHolder) {
            this.zzhyp.setResult((Object)new zzau(dataHolder));
        }
    }

    static final class zzbr
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Quests.ClaimMilestoneResult> zzhyn;
        private final String zzhyo;

        public zzbr(com.google.android.gms.common.api.internal.zzn<Quests.ClaimMilestoneResult> zzn2, String string) {
            this.zzhyn = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
            this.zzhyo = (String)com.google.android.gms.common.internal.zzbq.checkNotNull((Object)string, (Object)"MilestoneId must not be null");
        }

        @Override
        public final void zzan(DataHolder dataHolder) {
            this.zzhyn.setResult((Object)new zzp(dataHolder, this.zzhyo));
        }
    }

    static final class zzbp
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Quests.AcceptQuestResult> zzhym;

        public zzbp(com.google.android.gms.common.api.internal.zzn<Quests.AcceptQuestResult> zzn2) {
            this.zzhym = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzao(DataHolder dataHolder) {
            this.zzhym.setResult((Object)new zzd(dataHolder));
        }
    }

    static final class zzbz
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Requests.LoadRequestsResult> zzhyu;

        public zzbz(com.google.android.gms.common.api.internal.zzn<Requests.LoadRequestsResult> zzn2) {
            this.zzhyu = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzc(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzdg(n);
            this.zzhyu.setResult((Object)new zzav(status, bundle));
        }
    }

    static final class zzca
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Requests.UpdateRequestsResult> zzhyv;

        public zzca(com.google.android.gms.common.api.internal.zzn<Requests.UpdateRequestsResult> zzn2) {
            this.zzhyv = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzai(DataHolder dataHolder) {
            this.zzhyv.setResult((Object)new zzcw(dataHolder));
        }
    }

    static final class zzbo
    extends com.google.android.gms.games.internal.zzb {
        private final com.google.android.gms.games.internal.zzaa zzhwv;

        public zzbo(com.google.android.gms.games.internal.zzaa zzaa2) {
            this.zzhwv = zzaa2;
        }

        @Override
        public final com.google.android.gms.games.internal.zzy zzatc() {
            return new com.google.android.gms.games.internal.zzy(this.zzhwv.zziad);
        }
    }

    static final class zzy
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Games.GetServerAuthCodeResult> zzgbf;

        public zzy(com.google.android.gms.common.api.internal.zzn<Games.GetServerAuthCodeResult> zzn2) {
            this.zzgbf = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzg(int n, String string) {
            Status status = GamesStatusCodes.zzdg(n);
            this.zzgbf.setResult((Object)new zzz(status, string));
        }
    }

    static final class zzcg
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Status> zzgbf;

        public zzcg(com.google.android.gms.common.api.internal.zzn<Status> zzn2) {
            this.zzgbf = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzako() {
            Status status = GamesStatusCodes.zzdg(0);
            this.zzgbf.setResult((Object)status);
        }
    }

    static final class zzbv
    extends com.google.android.gms.games.internal.zza {
        private com.google.android.gms.common.api.internal.zzci<RealTimeMultiplayer.ReliableMessageSentCallback> zzhys;

        public zzbv(com.google.android.gms.common.api.internal.zzci<RealTimeMultiplayer.ReliableMessageSentCallback> zzci2) {
            this.zzhys = zzci2;
        }

        @Override
        public final void zzb(int n, int n2, String string) {
            if (this.zzhys != null) {
                this.zzhys.zza((com.google.android.gms.common.api.internal.zzcl)new zzbu(n, n2, string));
            }
        }
    }

    static final class zzcc
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzci<? extends RoomUpdateListener> zzhyw;
        private final com.google.android.gms.common.api.internal.zzci<? extends RoomStatusUpdateListener> zzhyx;
        private final com.google.android.gms.common.api.internal.zzci<? extends RealTimeMessageReceivedListener> zzhyy;

        public zzcc(com.google.android.gms.common.api.internal.zzci<? extends RoomUpdateListener> zzci2) {
            this.zzhyw = (com.google.android.gms.common.api.internal.zzci)com.google.android.gms.common.internal.zzbq.checkNotNull(zzci2, (Object)"Callbacks must not be null");
            this.zzhyx = null;
            this.zzhyy = null;
        }

        public zzcc(com.google.android.gms.common.api.internal.zzci<? extends RoomUpdateListener> zzci2, com.google.android.gms.common.api.internal.zzci<? extends RoomStatusUpdateListener> zzci3, com.google.android.gms.common.api.internal.zzci<? extends RealTimeMessageReceivedListener> zzci4) {
            this.zzhyw = (com.google.android.gms.common.api.internal.zzci)com.google.android.gms.common.internal.zzbq.checkNotNull(zzci2, (Object)"Callbacks must not be null");
            this.zzhyx = zzci3;
            this.zzhyy = zzci4;
        }

        @Override
        public final void zzx(DataHolder dataHolder) {
            this.zzhyw.zza((com.google.android.gms.common.api.internal.zzcl)new zzcf(dataHolder));
        }

        @Override
        public final void zzy(DataHolder dataHolder) {
            this.zzhyw.zza((com.google.android.gms.common.api.internal.zzcl)new zzaf(dataHolder));
        }

        @Override
        public final void onLeftRoom(int n, String string) {
            this.zzhyw.zza((com.google.android.gms.common.api.internal.zzcl)new zzak(n, string));
        }

        @Override
        public final void zzab(DataHolder dataHolder) {
            this.zzhyw.zza((com.google.android.gms.common.api.internal.zzcl)new zzcd(dataHolder));
        }

        @Override
        public final void zzz(DataHolder dataHolder) {
            if (this.zzhyx != null) {
                this.zzhyx.zza((com.google.android.gms.common.api.internal.zzcl)new zzce(dataHolder));
            }
        }

        @Override
        public final void zzaa(DataHolder dataHolder) {
            if (this.zzhyx != null) {
                this.zzhyx.zza((com.google.android.gms.common.api.internal.zzcl)new zzcb(dataHolder));
            }
        }

        @Override
        public final void zzac(DataHolder dataHolder) {
            if (this.zzhyx != null) {
                this.zzhyx.zza((com.google.android.gms.common.api.internal.zzcl)new zzr(dataHolder));
            }
        }

        @Override
        public final void zzad(DataHolder dataHolder) {
            if (this.zzhyx != null) {
                this.zzhyx.zza((com.google.android.gms.common.api.internal.zzcl)new zzt(dataHolder));
            }
        }

        @Override
        public final void zze(DataHolder dataHolder, String[] stringArray) {
            if (this.zzhyx != null) {
                this.zzhyx.zza((com.google.android.gms.common.api.internal.zzcl)new zzbf(dataHolder, stringArray));
            }
        }

        @Override
        public final void zzf(DataHolder dataHolder, String[] stringArray) {
            if (this.zzhyx != null) {
                this.zzhyx.zza((com.google.android.gms.common.api.internal.zzcl)new zzbh(dataHolder, stringArray));
            }
        }

        @Override
        public final void zza(DataHolder dataHolder, String[] stringArray) {
            if (this.zzhyx != null) {
                this.zzhyx.zza((com.google.android.gms.common.api.internal.zzcl)new zzbi(dataHolder, stringArray));
            }
        }

        @Override
        public final void zzb(DataHolder dataHolder, String[] stringArray) {
            if (this.zzhyx != null) {
                this.zzhyx.zza((com.google.android.gms.common.api.internal.zzcl)new zzbj(dataHolder, stringArray));
            }
        }

        @Override
        public final void zzc(DataHolder dataHolder, String[] stringArray) {
            if (this.zzhyx != null) {
                this.zzhyx.zza((com.google.android.gms.common.api.internal.zzcl)new zzbk(dataHolder, stringArray));
            }
        }

        @Override
        public final void zzd(DataHolder dataHolder, String[] stringArray) {
            if (this.zzhyx != null) {
                this.zzhyx.zza((com.google.android.gms.common.api.internal.zzcl)new zzbg(dataHolder, stringArray));
            }
        }

        @Override
        public final void onP2PConnected(String string) {
            if (this.zzhyx != null) {
                this.zzhyx.zza((com.google.android.gms.common.api.internal.zzcl)new zzbd(string));
            }
        }

        @Override
        public final void onP2PDisconnected(String string) {
            if (this.zzhyx != null) {
                this.zzhyx.zza((com.google.android.gms.common.api.internal.zzcl)new zzbe(string));
            }
        }

        @Override
        public final void onRealTimeMessageReceived(RealTimeMessage realTimeMessage) {
            if (this.zzhyy != null) {
                this.zzhyy.zza((com.google.android.gms.common.api.internal.zzcl)new zzbb(realTimeMessage));
            }
        }
    }

    static final class zzcn
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.CancelMatchResult> zzhzd;

        public zzcn(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.CancelMatchResult> zzn2) {
            this.zzhzd = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzi(int n, String string) {
            Status status = GamesStatusCodes.zzdg(n);
            this.zzhzd.setResult((Object)new zzg(status, string));
        }
    }

    static final class zzcp
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LeaveMatchResult> zzhzf;

        public zzcp(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LeaveMatchResult> zzn2) {
            this.zzhzf = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzv(DataHolder dataHolder) {
            this.zzhzf.setResult((Object)new zzaj(dataHolder));
        }
    }

    static final class zzcs
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.UpdateMatchResult> zzhzh;

        public zzcs(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.UpdateMatchResult> zzn2) {
            this.zzhzh = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzu(DataHolder dataHolder) {
            this.zzhzh.setResult((Object)new zzcv(dataHolder));
        }
    }

    static final class zzco
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.InitiateMatchResult> zzhze;

        public zzco(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.InitiateMatchResult> zzn2) {
            this.zzhze = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzt(DataHolder dataHolder) {
            this.zzhze.setResult((Object)new zzaa(dataHolder));
        }
    }

    static final class zzcq
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LoadMatchResult> zzhzg;

        public zzcq(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LoadMatchResult> zzn2) {
            this.zzhzg = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzs(DataHolder dataHolder) {
            this.zzhzg.setResult((Object)new zzap(dataHolder));
        }
    }

    static final class zzct
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LoadMatchesResult> zzhzi;

        public zzct(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LoadMatchesResult> zzn2) {
            this.zzhzi = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzb(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzdg(n);
            this.zzhzi.setResult((Object)new zzaq(status, bundle));
        }
    }

    static final class zzcl
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Leaderboards.SubmitScoreResult> zzgbf;

        public zzcl(com.google.android.gms.common.api.internal.zzn<Leaderboards.SubmitScoreResult> zzn2) {
            this.zzgbf = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzi(DataHolder dataHolder) {
            this.zzgbf.setResult((Object)new zzcm(dataHolder));
        }
    }

    static final class zzbn
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Players.LoadPlayersResult> zzgbf;

        zzbn(com.google.android.gms.common.api.internal.zzn<Players.LoadPlayersResult> zzn2) {
            this.zzgbf = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzj(DataHolder dataHolder) {
            this.zzgbf.setResult((Object)new zzat(dataHolder));
        }

        @Override
        public final void zzk(DataHolder dataHolder) {
            this.zzgbf.setResult((Object)new zzat(dataHolder));
        }
    }

    static final class zzbw
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzci<OnRequestReceivedListener> zzgut;

        zzbw(com.google.android.gms.common.api.internal.zzci<OnRequestReceivedListener> zzci2) {
            this.zzgut = zzci2;
        }

        @Override
        public final void zzr(DataHolder dataHolder) {
            GameRequestBuffer gameRequestBuffer = new GameRequestBuffer(dataHolder);
            GameRequest gameRequest = null;
            try {
                if (gameRequestBuffer.getCount() > 0) {
                    gameRequest = (GameRequest)((GameRequest)gameRequestBuffer.get(0)).freeze();
                }
            }
            finally {
                gameRequestBuffer.release();
            }
            if (gameRequest != null) {
                this.zzgut.zza((com.google.android.gms.common.api.internal.zzcl)new zzbx(gameRequest));
            }
        }

        @Override
        public final void onRequestRemoved(String string) {
            this.zzgut.zza((com.google.android.gms.common.api.internal.zzcl)new zzby(string));
        }
    }

    static final class zzbs
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzci<QuestUpdateListener> zzgut;

        zzbs(com.google.android.gms.common.api.internal.zzci<QuestUpdateListener> zzci2) {
            this.zzgut = zzci2;
        }

        @Override
        public final void zzap(DataHolder dataHolder) {
            Quest quest = zzbs.zzbi(dataHolder);
            if (quest != null) {
                this.zzgut.zza((com.google.android.gms.common.api.internal.zzcl)new zzbq(quest));
            }
        }

        private static Quest zzbi(DataHolder dataHolder) {
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            Quest quest = null;
            try {
                if (questBuffer.getCount() > 0) {
                    quest = (Quest)((Quest)questBuffer.get(0)).freeze();
                }
            }
            finally {
                questBuffer.release();
            }
            return quest;
        }
    }

    static final class zzaz
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzci<OnTurnBasedMatchUpdateReceivedListener> zzgut;

        zzaz(com.google.android.gms.common.api.internal.zzci<OnTurnBasedMatchUpdateReceivedListener> zzci2) {
            this.zzgut = zzci2;
        }

        @Override
        public final void zzw(DataHolder dataHolder) {
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            TurnBasedMatch turnBasedMatch = null;
            try {
                if (turnBasedMatchBuffer.getCount() > 0) {
                    turnBasedMatch = (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze();
                }
            }
            finally {
                turnBasedMatchBuffer.release();
            }
            if (turnBasedMatch != null) {
                this.zzgut.zza((com.google.android.gms.common.api.internal.zzcl)new zzba(turnBasedMatch));
            }
        }

        @Override
        public final void onTurnBasedMatchRemoved(String string) {
            this.zzgut.zza((com.google.android.gms.common.api.internal.zzcl)new zzay(string));
        }
    }

    static final class zzab
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzci<OnInvitationReceivedListener> zzgut;

        zzab(com.google.android.gms.common.api.internal.zzci<OnInvitationReceivedListener> zzci2) {
            this.zzgut = zzci2;
        }

        @Override
        public final void zzq(DataHolder dataHolder) {
            InvitationBuffer invitationBuffer = new InvitationBuffer(dataHolder);
            Invitation invitation = null;
            try {
                if (invitationBuffer.getCount() > 0) {
                    invitation = (Invitation)((Invitation)invitationBuffer.get(0)).freeze();
                }
            }
            finally {
                invitationBuffer.release();
            }
            if (invitation != null) {
                this.zzgut.zza((com.google.android.gms.common.api.internal.zzcl)new zzac(invitation));
            }
        }

        @Override
        public final void onInvitationRemoved(String string) {
            this.zzgut.zza((com.google.android.gms.common.api.internal.zzcl)new zzad(string));
        }
    }

    static final class zzae
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Invitations.LoadInvitationsResult> zzgbf;

        zzae(com.google.android.gms.common.api.internal.zzn<Invitations.LoadInvitationsResult> zzn2) {
            this.zzgbf = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzp(DataHolder dataHolder) {
            this.zzgbf.setResult((Object)new zzao(dataHolder));
        }
    }

    static final class zzbl
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadPlayerScoreResult> zzgbf;

        zzbl(com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadPlayerScoreResult> zzn2) {
            this.zzgbf = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzah(DataHolder dataHolder) {
            this.zzgbf.setResult((Object)new zzar(dataHolder));
        }
    }

    static final class zzah
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadScoresResult> zzgbf;

        zzah(com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadScoresResult> zzn2) {
            this.zzgbf = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zza(DataHolder dataHolder, DataHolder dataHolder2) {
            this.zzgbf.setResult((Object)new zzaw(dataHolder, dataHolder2));
        }
    }

    static final class zzai
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Leaderboards.LeaderboardMetadataResult> zzgbf;

        zzai(com.google.android.gms.common.api.internal.zzn<Leaderboards.LeaderboardMetadataResult> zzn2) {
            this.zzgbf = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzh(DataHolder dataHolder) {
            this.zzgbf.setResult((Object)new zzag(dataHolder));
        }
    }

    static final class zzu
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Events.LoadEventsResult> zzgbf;

        zzu(com.google.android.gms.common.api.internal.zzn<Events.LoadEventsResult> zzn2) {
            this.zzgbf = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzg(DataHolder dataHolder) {
            this.zzgbf.setResult((Object)new zzam(dataHolder));
        }
    }

    static final class zzx
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<GamesMetadata.LoadGamesResult> zzgbf;

        zzx(com.google.android.gms.common.api.internal.zzn<GamesMetadata.LoadGamesResult> zzn2) {
            this.zzgbf = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzl(DataHolder dataHolder) {
            this.zzgbf.setResult((Object)new zzan(dataHolder));
        }
    }

    static final class zze
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Achievements.UpdateAchievementResult> zzgbf;

        zze(com.google.android.gms.common.api.internal.zzn<Achievements.UpdateAchievementResult> zzn2) {
            this.zzgbf = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzh(int n, String string) {
            this.zzgbf.setResult((Object)new zzcu(n, string));
        }
    }

    static final class zzf
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Achievements.LoadAchievementsResult> zzgbf;

        zzf(com.google.android.gms.common.api.internal.zzn<Achievements.LoadAchievementsResult> zzn2) {
            this.zzgbf = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzf(DataHolder dataHolder) {
            this.zzgbf.setResult((Object)new zzal(dataHolder));
        }
    }

    final class zzv
    extends zzcct {
        private /* synthetic */ GamesClientImpl zzhxc;

        public zzv(GamesClientImpl gamesClientImpl) {
            this.zzhxc = gamesClientImpl;
            super(gamesClientImpl.getContext().getMainLooper(), 1000);
        }

        @Override
        protected final void zzu(String string, int n) {
            try {
                if (this.zzhxc.isConnected()) {
                    ((com.google.android.gms.games.internal.zzw)this.zzhxc.zzalw()).zzp(string, n);
                    return;
                }
                com.google.android.gms.games.internal.zzf.zzw("GamesClientImpl", new StringBuilder(89 + String.valueOf(string).length()).append("Unable to increment event ").append(string).append(" by ").append(n).append(" because the games client is no longer connected").toString());
                return;
            }
            catch (RemoteException remoteException) {
                GamesClientImpl.zzd(remoteException);
                return;
            }
            catch (SecurityException securityException) {
                GamesClientImpl.zza(securityException);
                return;
            }
        }
    }
}

