/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.zzc;
import com.google.android.gms.internal.zzbgo;
import java.util.Arrays;

public final class ParticipantEntity
extends GamesDowngradeableSafeParcel
implements Participant {
    public static final Parcelable.Creator<ParticipantEntity> CREATOR = new zza();
    private final String zzhyl;
    private final String zzemi;
    private final Uri zzhra;
    private final Uri zzhrb;
    private final int zzcfl;
    private final String zzifg;
    private final boolean zzifh;
    private final PlayerEntity zzhwk;
    private final int zzety;
    private final ParticipantResult zzifi;
    private final String zzhrl;
    private final String zzhrm;

    @Hide
    public ParticipantEntity(Participant participant) {
        this.zzhyl = participant.getParticipantId();
        this.zzemi = participant.getDisplayName();
        this.zzhra = participant.getIconImageUri();
        this.zzhrb = participant.getHiResImageUri();
        this.zzcfl = participant.getStatus();
        this.zzifg = participant.zzavt();
        this.zzifh = participant.isConnectedToRoom();
        Player player = participant.getPlayer();
        this.zzhwk = player == null ? null : new PlayerEntity(player);
        this.zzety = participant.getCapabilities();
        this.zzifi = participant.getResult();
        this.zzhrl = participant.getIconImageUrl();
        this.zzhrm = participant.getHiResImageUrl();
    }

    ParticipantEntity(String string, String string2, Uri uri, Uri uri2, int n, String string3, boolean bl, PlayerEntity playerEntity, int n2, ParticipantResult participantResult, String string4, String string5) {
        this.zzhyl = string;
        this.zzemi = string2;
        this.zzhra = uri;
        this.zzhrb = uri2;
        this.zzcfl = n;
        this.zzifg = string3;
        this.zzifh = bl;
        this.zzhwk = playerEntity;
        this.zzety = n2;
        this.zzifi = participantResult;
        this.zzhrl = string4;
        this.zzhrm = string5;
    }

    @Override
    public final int getStatus() {
        return this.zzcfl;
    }

    @Override
    @Hide
    public final String zzavt() {
        return this.zzifg;
    }

    @Override
    public final boolean isConnectedToRoom() {
        return this.zzifh;
    }

    @Override
    public final String getDisplayName() {
        if (this.zzhwk == null) {
            return this.zzemi;
        }
        return this.zzhwk.getDisplayName();
    }

    @Override
    public final void getDisplayName(CharArrayBuffer charArrayBuffer) {
        if (this.zzhwk == null) {
            zzh.zzb((String)this.zzemi, (CharArrayBuffer)charArrayBuffer);
            return;
        }
        this.zzhwk.getDisplayName(charArrayBuffer);
    }

    @Override
    public final Uri getIconImageUri() {
        if (this.zzhwk == null) {
            return this.zzhra;
        }
        return this.zzhwk.getIconImageUri();
    }

    @Override
    @Hide
    public final String getIconImageUrl() {
        if (this.zzhwk == null) {
            return this.zzhrl;
        }
        return this.zzhwk.getIconImageUrl();
    }

    @Override
    public final Uri getHiResImageUri() {
        if (this.zzhwk == null) {
            return this.zzhrb;
        }
        return this.zzhwk.getHiResImageUri();
    }

    @Override
    @Hide
    public final String getHiResImageUrl() {
        if (this.zzhwk == null) {
            return this.zzhrm;
        }
        return this.zzhwk.getHiResImageUrl();
    }

    @Override
    public final String getParticipantId() {
        return this.zzhyl;
    }

    @Override
    public final Player getPlayer() {
        return this.zzhwk;
    }

    @Override
    public final ParticipantResult getResult() {
        return this.zzifi;
    }

    @Override
    @Hide
    public final int getCapabilities() {
        return this.zzety;
    }

    public final Participant freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return ParticipantEntity.zza(this);
    }

    static int zza(Participant participant) {
        return Arrays.hashCode(new Object[]{participant.getPlayer(), participant.getStatus(), participant.zzavt(), participant.isConnectedToRoom(), participant.getDisplayName(), participant.getIconImageUri(), participant.getHiResImageUri(), participant.getCapabilities(), participant.getResult(), participant.getParticipantId()});
    }

    public final boolean equals(Object object) {
        return ParticipantEntity.zza(this, object);
    }

    static boolean zza(Participant participant, Object object) {
        if (!(object instanceof Participant)) {
            return false;
        }
        if (participant == object) {
            return true;
        }
        Participant participant2 = (Participant)object;
        return zzbg.equal((Object)participant2.getPlayer(), (Object)participant.getPlayer()) && zzbg.equal((Object)participant2.getStatus(), (Object)participant.getStatus()) && zzbg.equal((Object)participant2.zzavt(), (Object)participant.zzavt()) && zzbg.equal((Object)participant2.isConnectedToRoom(), (Object)participant.isConnectedToRoom()) && zzbg.equal((Object)participant2.getDisplayName(), (Object)participant.getDisplayName()) && zzbg.equal((Object)participant2.getIconImageUri(), (Object)participant.getIconImageUri()) && zzbg.equal((Object)participant2.getHiResImageUri(), (Object)participant.getHiResImageUri()) && zzbg.equal((Object)participant2.getCapabilities(), (Object)participant.getCapabilities()) && zzbg.equal((Object)((Object)participant2.getResult()), (Object)((Object)participant.getResult())) && zzbg.equal((Object)participant2.getParticipantId(), (Object)participant.getParticipantId());
    }

    public final String toString() {
        return ParticipantEntity.zzb(this);
    }

    static String zzb(Participant participant) {
        return zzbg.zzx((Object)participant).zzg("ParticipantId", (Object)participant.getParticipantId()).zzg("Player", (Object)participant.getPlayer()).zzg("Status", (Object)participant.getStatus()).zzg("ClientAddress", (Object)participant.zzavt()).zzg("ConnectedToRoom", (Object)participant.isConnectedToRoom()).zzg("DisplayName", (Object)participant.getDisplayName()).zzg("IconImage", (Object)participant.getIconImageUri()).zzg("IconImageUrl", (Object)participant.getIconImageUrl()).zzg("HiResImage", (Object)participant.getHiResImageUri()).zzg("HiResImageUrl", (Object)participant.getHiResImageUrl()).zzg("Capabilities", (Object)participant.getCapabilities()).zzg("Result", (Object)participant.getResult()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        ParticipantEntity participantEntity = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (String)participantEntity.getParticipantId(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)2, (String)participantEntity.getDisplayName(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (Parcelable)participantEntity.getIconImageUri(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (Parcelable)participantEntity.getHiResImageUri(), (int)n, (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)5, (int)participantEntity.getStatus());
        zzbgo.zza((Parcel)parcel2, (int)6, (String)participantEntity.zzifg, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)7, (boolean)participantEntity.isConnectedToRoom());
        zzbgo.zza((Parcel)parcel2, (int)8, (Parcelable)participantEntity.getPlayer(), (int)n, (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)9, (int)participantEntity.zzety);
        zzbgo.zza((Parcel)parcel2, (int)10, (Parcelable)participantEntity.getResult(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)11, (String)participantEntity.getIconImageUrl(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)12, (String)participantEntity.getHiResImageUrl(), (boolean)false);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    static final class zza
    extends zzc {
        zza() {
        }

        @Override
        public final ParticipantEntity zzr(Parcel parcel) {
            if (ParticipantEntity.zze(ParticipantEntity.zzamq()) || ParticipantEntity.zzgq((String)ParticipantEntity.class.getCanonicalName())) {
                return super.zzr(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            String string4 = parcel.readString();
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            int n = parcel.readInt();
            String string5 = parcel.readString();
            boolean bl = parcel.readInt() > 0;
            PlayerEntity playerEntity = parcel.readInt() > 0 ? (PlayerEntity)PlayerEntity.CREATOR.createFromParcel(parcel) : null;
            return new ParticipantEntity(string, string2, uri, uri2, n, string5, bl, playerEntity, 7, null, null, null);
        }

        @Override
        public final /* synthetic */ Object createFromParcel(Parcel parcel) {
            return ((zzc)this).zzr(parcel);
        }
    }
}

