/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.zze;
import com.google.android.gms.internal.zzbgo;
import java.util.ArrayList;
import java.util.Arrays;

public final class RoomEntity
extends GamesDowngradeableSafeParcel
implements Room {
    public static final Parcelable.Creator<RoomEntity> CREATOR = new zza();
    private final String zzhxr;
    private final String zzifz;
    private final long mCreationTimestamp;
    private final int zziga;
    private final String zzdxh;
    private final int zzifd;
    private final Bundle zzifw;
    private final ArrayList<ParticipantEntity> zzifc;
    private final int zzigb;

    @Hide
    public RoomEntity(Room room) {
        this.zzhxr = room.getRoomId();
        this.zzifz = room.getCreatorId();
        this.mCreationTimestamp = room.getCreationTimestamp();
        this.zziga = room.getStatus();
        this.zzdxh = room.getDescription();
        this.zzifd = room.getVariant();
        this.zzifw = room.getAutoMatchCriteria();
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        this.zzifc = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzifc.add((ParticipantEntity)((Participant)arrayList.get(i)).freeze());
        }
        this.zzigb = room.getAutoMatchWaitEstimateSeconds();
    }

    RoomEntity(String string, String string2, long l, int n, String string3, int n2, Bundle bundle, ArrayList<ParticipantEntity> arrayList, int n3) {
        this.zzhxr = string;
        this.zzifz = string2;
        this.mCreationTimestamp = l;
        this.zziga = n;
        this.zzdxh = string3;
        this.zzifd = n2;
        this.zzifw = bundle;
        this.zzifc = arrayList;
        this.zzigb = n3;
    }

    @Override
    public final String getRoomId() {
        return this.zzhxr;
    }

    @Override
    public final String getCreatorId() {
        return this.zzifz;
    }

    @Override
    public final long getCreationTimestamp() {
        return this.mCreationTimestamp;
    }

    @Override
    public final int getStatus() {
        return this.zziga;
    }

    @Override
    public final String getDescription() {
        return this.zzdxh;
    }

    @Override
    public final void getDescription(CharArrayBuffer charArrayBuffer) {
        zzh.zzb((String)this.zzdxh, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final int getVariant() {
        return this.zzifd;
    }

    @Override
    public final Bundle getAutoMatchCriteria() {
        return this.zzifw;
    }

    @Override
    public final ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.zzifc);
    }

    @Override
    public final int getAutoMatchWaitEstimateSeconds() {
        return this.zzigb;
    }

    @Override
    public final int getParticipantStatus(String string) {
        return RoomEntity.zza((Room)this, string);
    }

    @Override
    public final ArrayList<String> getParticipantIds() {
        return RoomEntity.zzc(this);
    }

    @Override
    public final String getParticipantId(String string) {
        return RoomEntity.zzb(this, string);
    }

    @Override
    public final Participant getParticipant(String string) {
        return RoomEntity.zzc(this, string);
    }

    public final Room freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return RoomEntity.zza(this);
    }

    static int zza(Room room) {
        return Arrays.hashCode(new Object[]{room.getRoomId(), room.getCreatorId(), room.getCreationTimestamp(), room.getStatus(), room.getDescription(), room.getVariant(), room.getAutoMatchCriteria(), room.getParticipants(), room.getAutoMatchWaitEstimateSeconds()});
    }

    public final boolean equals(Object object) {
        return RoomEntity.zza((Room)this, object);
    }

    static boolean zza(Room room, Object object) {
        if (!(object instanceof Room)) {
            return false;
        }
        if (room == object) {
            return true;
        }
        Room room2 = (Room)object;
        return zzbg.equal((Object)room2.getRoomId(), (Object)room.getRoomId()) && zzbg.equal((Object)room2.getCreatorId(), (Object)room.getCreatorId()) && zzbg.equal((Object)room2.getCreationTimestamp(), (Object)room.getCreationTimestamp()) && zzbg.equal((Object)room2.getStatus(), (Object)room.getStatus()) && zzbg.equal((Object)room2.getDescription(), (Object)room.getDescription()) && zzbg.equal((Object)room2.getVariant(), (Object)room.getVariant()) && zzbg.equal((Object)room2.getAutoMatchCriteria(), (Object)room.getAutoMatchCriteria()) && zzbg.equal((Object)room2.getParticipants(), (Object)room.getParticipants()) && zzbg.equal((Object)room2.getAutoMatchWaitEstimateSeconds(), (Object)room.getAutoMatchWaitEstimateSeconds());
    }

    public final String toString() {
        return RoomEntity.zzb(this);
    }

    static String zzb(Room room) {
        return zzbg.zzx((Object)room).zzg("RoomId", (Object)room.getRoomId()).zzg("CreatorId", (Object)room.getCreatorId()).zzg("CreationTimestamp", (Object)room.getCreationTimestamp()).zzg("RoomStatus", (Object)room.getStatus()).zzg("Description", (Object)room.getDescription()).zzg("Variant", (Object)room.getVariant()).zzg("AutoMatchCriteria", (Object)room.getAutoMatchCriteria()).zzg("Participants", (Object)room.getParticipants()).zzg("AutoMatchWaitEstimateSeconds", (Object)room.getAutoMatchWaitEstimateSeconds()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        RoomEntity roomEntity = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (String)roomEntity.getRoomId(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)2, (String)roomEntity.getCreatorId(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (long)roomEntity.getCreationTimestamp());
        zzbgo.zzc((Parcel)parcel2, (int)4, (int)roomEntity.getStatus());
        zzbgo.zza((Parcel)parcel2, (int)5, (String)roomEntity.getDescription(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)6, (int)roomEntity.getVariant());
        zzbgo.zza((Parcel)parcel2, (int)7, (Bundle)roomEntity.getAutoMatchCriteria(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)8, roomEntity.getParticipants(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)9, (int)roomEntity.getAutoMatchWaitEstimateSeconds());
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    static int zza(Room room, String string) {
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant.getStatus();
        }
        String string2 = room.getRoomId();
        throw new IllegalStateException(new StringBuilder(28 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Participant ").append(string).append(" is not in room ").append(string2).toString());
    }

    static ArrayList<String> zzc(Room room) {
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            arrayList2.add(participant.getParticipantId());
        }
        return arrayList2;
    }

    static String zzb(Room room, String string) {
        String string2 = null;
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(string)) continue;
            string2 = participant.getParticipantId();
            break;
        }
        return string2;
    }

    static Participant zzc(Room room, String string) {
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant;
        }
        String string2 = room.getRoomId();
        throw new IllegalStateException(new StringBuilder(29 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Participant ").append(string).append(" is not in match ").append(string2).toString());
    }

    static final class zza
    extends zze {
        zza() {
        }

        @Override
        public final RoomEntity zzs(Parcel parcel) {
            if (RoomEntity.zze(RoomEntity.zzamq()) || RoomEntity.zzgq((String)RoomEntity.class.getCanonicalName())) {
                return super.zzs(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            long l = parcel.readLong();
            int n = parcel.readInt();
            String string3 = parcel.readString();
            int n2 = parcel.readInt();
            Bundle bundle = parcel.readBundle();
            int n3 = parcel.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n3);
            for (int i = 0; i < n3; ++i) {
                arrayList.add((ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            return new RoomEntity(string, string2, l, n, string3, n2, bundle, arrayList, -1);
        }

        @Override
        public final /* synthetic */ Object createFromParcel(Parcel parcel) {
            return ((zze)this).zzs(parcel);
        }
    }
}

