/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.os.Bundle;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.games.internal.zzf;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;

public final class LoadMatchesResponse {
    private final InvitationBuffer zzigd;
    private final TurnBasedMatchBuffer zzige;
    private final TurnBasedMatchBuffer zzigf;
    private final TurnBasedMatchBuffer zzigg;

    @Hide
    public LoadMatchesResponse(Bundle bundle) {
        DataHolder dataHolder = LoadMatchesResponse.zzc(bundle, 0);
        this.zzigd = dataHolder != null ? new InvitationBuffer(dataHolder) : null;
        DataHolder dataHolder2 = LoadMatchesResponse.zzc(bundle, 1);
        this.zzige = dataHolder2 != null ? new TurnBasedMatchBuffer(dataHolder2) : null;
        DataHolder dataHolder3 = LoadMatchesResponse.zzc(bundle, 2);
        this.zzigf = dataHolder3 != null ? new TurnBasedMatchBuffer(dataHolder3) : null;
        DataHolder dataHolder4 = LoadMatchesResponse.zzc(bundle, 3);
        if (dataHolder4 != null) {
            this.zzigg = new TurnBasedMatchBuffer(dataHolder4);
            return;
        }
        this.zzigg = null;
    }

    private static DataHolder zzc(Bundle bundle, int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                String string2 = "TURN_STATUS_INVITED";
                break;
            }
            case 1: {
                String string2 = "TURN_STATUS_MY_TURN";
                break;
            }
            case 2: {
                String string2 = "TURN_STATUS_THEIR_TURN";
                break;
            }
            case 3: {
                String string2 = "TURN_STATUS_COMPLETE";
                break;
            }
            default: {
                zzf.zzw("MatchTurnStatus", new StringBuilder(38).append("Unknown match turn status: ").append(n2).toString());
                String string2 = string = "TURN_STATUS_UNKNOWN";
            }
        }
        if (!bundle.containsKey(string)) {
            return null;
        }
        return (DataHolder)bundle.getParcelable(string);
    }

    public final InvitationBuffer getInvitations() {
        return this.zzigd;
    }

    public final TurnBasedMatchBuffer getMyTurnMatches() {
        return this.zzige;
    }

    public final TurnBasedMatchBuffer getTheirTurnMatches() {
        return this.zzigf;
    }

    public final TurnBasedMatchBuffer getCompletedMatches() {
        return this.zzigg;
    }

    @Deprecated
    public final void close() {
        this.release();
    }

    public final void release() {
        if (this.zzigd != null) {
            this.zzigd.release();
        }
        if (this.zzige != null) {
            this.zzige.release();
        }
        if (this.zzigf != null) {
            this.zzigf.release();
        }
        if (this.zzigg != null) {
            this.zzigg.release();
        }
    }

    public final boolean hasData() {
        if (this.zzigd != null && this.zzigd.getCount() > 0) {
            return true;
        }
        if (this.zzige != null && this.zzige.getCount() > 0) {
            return true;
        }
        if (this.zzigf != null && this.zzigf.getCount() > 0) {
            return true;
        }
        return this.zzigg != null && this.zzigg.getCount() > 0;
    }
}

