/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.zzc;
import com.google.android.gms.internal.zzbgo;
import java.util.ArrayList;
import java.util.Arrays;

public final class TurnBasedMatchEntity
extends com.google.android.gms.games.internal.zzc
implements TurnBasedMatch {
    public static final Parcelable.Creator<TurnBasedMatchEntity> CREATOR = new zzc();
    private final GameEntity zzibx;
    private final String zzhyd;
    private final String zzifz;
    private final long mCreationTimestamp;
    private final String zzigi;
    private final long zzhwn;
    private final String zzigj;
    private final int zzigk;
    private final int zzifd;
    private final int mVersion;
    private final byte[] zzigl;
    private final ArrayList<ParticipantEntity> zzifc;
    private final String zzigm;
    private final byte[] zzign;
    private final int zzigo;
    private final Bundle zzifw;
    private final int zzigp;
    private final boolean zzigq;
    private final String zzdxh;
    private final String zzigr;

    @Hide
    public TurnBasedMatchEntity(TurnBasedMatch turnBasedMatch) {
        this.zzibx = new GameEntity(turnBasedMatch.getGame());
        this.zzhyd = turnBasedMatch.getMatchId();
        this.zzifz = turnBasedMatch.getCreatorId();
        this.mCreationTimestamp = turnBasedMatch.getCreationTimestamp();
        this.zzigi = turnBasedMatch.getLastUpdaterId();
        this.zzhwn = turnBasedMatch.getLastUpdatedTimestamp();
        this.zzigj = turnBasedMatch.getPendingParticipantId();
        this.zzigk = turnBasedMatch.getStatus();
        this.zzigp = turnBasedMatch.getTurnStatus();
        this.zzifd = turnBasedMatch.getVariant();
        this.mVersion = turnBasedMatch.getVersion();
        this.zzigm = turnBasedMatch.getRematchId();
        this.zzigo = turnBasedMatch.getMatchNumber();
        this.zzifw = turnBasedMatch.getAutoMatchCriteria();
        this.zzigq = turnBasedMatch.isLocallyModified();
        this.zzdxh = turnBasedMatch.getDescription();
        this.zzigr = turnBasedMatch.getDescriptionParticipantId();
        byte[] byArray = turnBasedMatch.getData();
        if (byArray == null) {
            this.zzigl = null;
        } else {
            this.zzigl = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.zzigl, 0, byArray.length);
        }
        byte[] byArray2 = turnBasedMatch.getPreviousMatchData();
        if (byArray2 == null) {
            this.zzign = null;
        } else {
            this.zzign = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, this.zzign, 0, byArray2.length);
        }
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        this.zzifc = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzifc.add((ParticipantEntity)((Participant)arrayList.get(i)).freeze());
        }
    }

    TurnBasedMatchEntity(GameEntity gameEntity, String string, String string2, long l, String string3, long l2, String string4, int n, int n2, int n3, byte[] byArray, ArrayList<ParticipantEntity> arrayList, String string5, byte[] byArray2, int n4, Bundle bundle, int n5, boolean bl, String string6, String string7) {
        this.zzibx = gameEntity;
        this.zzhyd = string;
        this.zzifz = string2;
        this.mCreationTimestamp = l;
        this.zzigi = string3;
        this.zzhwn = l2;
        this.zzigj = string4;
        this.zzigk = n;
        this.zzigp = n5;
        this.zzifd = n2;
        this.mVersion = n3;
        this.zzigl = byArray;
        this.zzifc = arrayList;
        this.zzigm = string5;
        this.zzign = byArray2;
        this.zzigo = n4;
        this.zzifw = bundle;
        this.zzigq = bl;
        this.zzdxh = string6;
        this.zzigr = string7;
    }

    @Override
    public final Game getGame() {
        return this.zzibx;
    }

    @Override
    public final String getMatchId() {
        return this.zzhyd;
    }

    @Override
    public final String getCreatorId() {
        return this.zzifz;
    }

    @Override
    public final long getCreationTimestamp() {
        return this.mCreationTimestamp;
    }

    @Override
    public final String getLastUpdaterId() {
        return this.zzigi;
    }

    @Override
    public final long getLastUpdatedTimestamp() {
        return this.zzhwn;
    }

    @Override
    public final String getPendingParticipantId() {
        return this.zzigj;
    }

    @Override
    public final int getStatus() {
        return this.zzigk;
    }

    @Override
    public final int getTurnStatus() {
        return this.zzigp;
    }

    @Override
    public final String getDescription() {
        return this.zzdxh;
    }

    @Override
    public final String getDescriptionParticipantId() {
        return this.zzigr;
    }

    @Override
    public final Participant getDescriptionParticipant() {
        String string = this.getDescriptionParticipantId();
        if (string == null) {
            return null;
        }
        return this.getParticipant(string);
    }

    @Override
    public final void getDescription(CharArrayBuffer charArrayBuffer) {
        zzh.zzb((String)this.zzdxh, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final int getVariant() {
        return this.zzifd;
    }

    @Override
    public final byte[] getData() {
        return this.zzigl;
    }

    @Override
    public final int getVersion() {
        return this.mVersion;
    }

    @Override
    public final String getRematchId() {
        return this.zzigm;
    }

    @Override
    public final byte[] getPreviousMatchData() {
        return this.zzign;
    }

    @Override
    public final int getMatchNumber() {
        return this.zzigo;
    }

    @Override
    public final Bundle getAutoMatchCriteria() {
        return this.zzifw;
    }

    @Override
    public final int getAvailableAutoMatchSlots() {
        if (this.zzifw == null) {
            return 0;
        }
        return this.zzifw.getInt("max_automatch_players");
    }

    @Override
    public final boolean canRematch() {
        return this.zzigk == 2 && this.zzigm == null;
    }

    @Override
    public final boolean isLocallyModified() {
        return this.zzigq;
    }

    @Override
    public final int getParticipantStatus(String string) {
        return TurnBasedMatchEntity.zza((TurnBasedMatch)this, string);
    }

    @Override
    public final ArrayList<String> getParticipantIds() {
        return TurnBasedMatchEntity.zzc(this);
    }

    @Override
    public final String getParticipantId(String string) {
        return TurnBasedMatchEntity.zzb(this, string);
    }

    @Override
    public final Participant getParticipant(String string) {
        return TurnBasedMatchEntity.zzc(this, string);
    }

    @Override
    public final ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.zzifc);
    }

    public final TurnBasedMatch freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return TurnBasedMatchEntity.zza(this);
    }

    static int zza(TurnBasedMatch turnBasedMatch) {
        return Arrays.hashCode(new Object[]{turnBasedMatch.getGame(), turnBasedMatch.getMatchId(), turnBasedMatch.getCreatorId(), turnBasedMatch.getCreationTimestamp(), turnBasedMatch.getLastUpdaterId(), turnBasedMatch.getLastUpdatedTimestamp(), turnBasedMatch.getPendingParticipantId(), turnBasedMatch.getStatus(), turnBasedMatch.getTurnStatus(), turnBasedMatch.getDescription(), turnBasedMatch.getVariant(), turnBasedMatch.getVersion(), turnBasedMatch.getParticipants(), turnBasedMatch.getRematchId(), turnBasedMatch.getMatchNumber(), turnBasedMatch.getAutoMatchCriteria(), turnBasedMatch.getAvailableAutoMatchSlots(), turnBasedMatch.isLocallyModified()});
    }

    public final boolean equals(Object object) {
        return TurnBasedMatchEntity.zza((TurnBasedMatch)this, object);
    }

    static boolean zza(TurnBasedMatch turnBasedMatch, Object object) {
        if (!(object instanceof TurnBasedMatch)) {
            return false;
        }
        if (turnBasedMatch == object) {
            return true;
        }
        TurnBasedMatch turnBasedMatch2 = (TurnBasedMatch)object;
        return zzbg.equal((Object)turnBasedMatch2.getGame(), (Object)turnBasedMatch.getGame()) && zzbg.equal((Object)turnBasedMatch2.getMatchId(), (Object)turnBasedMatch.getMatchId()) && zzbg.equal((Object)turnBasedMatch2.getCreatorId(), (Object)turnBasedMatch.getCreatorId()) && zzbg.equal((Object)turnBasedMatch2.getCreationTimestamp(), (Object)turnBasedMatch.getCreationTimestamp()) && zzbg.equal((Object)turnBasedMatch2.getLastUpdaterId(), (Object)turnBasedMatch.getLastUpdaterId()) && zzbg.equal((Object)turnBasedMatch2.getLastUpdatedTimestamp(), (Object)turnBasedMatch.getLastUpdatedTimestamp()) && zzbg.equal((Object)turnBasedMatch2.getPendingParticipantId(), (Object)turnBasedMatch.getPendingParticipantId()) && zzbg.equal((Object)turnBasedMatch2.getStatus(), (Object)turnBasedMatch.getStatus()) && zzbg.equal((Object)turnBasedMatch2.getTurnStatus(), (Object)turnBasedMatch.getTurnStatus()) && zzbg.equal((Object)turnBasedMatch2.getDescription(), (Object)turnBasedMatch.getDescription()) && zzbg.equal((Object)turnBasedMatch2.getVariant(), (Object)turnBasedMatch.getVariant()) && zzbg.equal((Object)turnBasedMatch2.getVersion(), (Object)turnBasedMatch.getVersion()) && zzbg.equal((Object)turnBasedMatch2.getParticipants(), (Object)turnBasedMatch.getParticipants()) && zzbg.equal((Object)turnBasedMatch2.getRematchId(), (Object)turnBasedMatch.getRematchId()) && zzbg.equal((Object)turnBasedMatch2.getMatchNumber(), (Object)turnBasedMatch.getMatchNumber()) && zzbg.equal((Object)turnBasedMatch2.getAutoMatchCriteria(), (Object)turnBasedMatch.getAutoMatchCriteria()) && zzbg.equal((Object)turnBasedMatch2.getAvailableAutoMatchSlots(), (Object)turnBasedMatch.getAvailableAutoMatchSlots()) && zzbg.equal((Object)turnBasedMatch2.isLocallyModified(), (Object)turnBasedMatch.isLocallyModified());
    }

    public final String toString() {
        return TurnBasedMatchEntity.zzb(this);
    }

    static String zzb(TurnBasedMatch turnBasedMatch) {
        return zzbg.zzx((Object)turnBasedMatch).zzg("Game", (Object)turnBasedMatch.getGame()).zzg("MatchId", (Object)turnBasedMatch.getMatchId()).zzg("CreatorId", (Object)turnBasedMatch.getCreatorId()).zzg("CreationTimestamp", (Object)turnBasedMatch.getCreationTimestamp()).zzg("LastUpdaterId", (Object)turnBasedMatch.getLastUpdaterId()).zzg("LastUpdatedTimestamp", (Object)turnBasedMatch.getLastUpdatedTimestamp()).zzg("PendingParticipantId", (Object)turnBasedMatch.getPendingParticipantId()).zzg("MatchStatus", (Object)turnBasedMatch.getStatus()).zzg("TurnStatus", (Object)turnBasedMatch.getTurnStatus()).zzg("Description", (Object)turnBasedMatch.getDescription()).zzg("Variant", (Object)turnBasedMatch.getVariant()).zzg("Data", (Object)turnBasedMatch.getData()).zzg("Version", (Object)turnBasedMatch.getVersion()).zzg("Participants", (Object)turnBasedMatch.getParticipants()).zzg("RematchId", (Object)turnBasedMatch.getRematchId()).zzg("PreviousData", (Object)turnBasedMatch.getPreviousMatchData()).zzg("MatchNumber", (Object)turnBasedMatch.getMatchNumber()).zzg("AutoMatchCriteria", (Object)turnBasedMatch.getAutoMatchCriteria()).zzg("AvailableAutoMatchSlots", (Object)turnBasedMatch.getAvailableAutoMatchSlots()).zzg("LocallyModified", (Object)turnBasedMatch.isLocallyModified()).zzg("DescriptionParticipantId", (Object)turnBasedMatch.getDescriptionParticipantId()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        TurnBasedMatchEntity turnBasedMatchEntity = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (Parcelable)turnBasedMatchEntity.getGame(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)2, (String)turnBasedMatchEntity.getMatchId(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (String)turnBasedMatchEntity.getCreatorId(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (long)turnBasedMatchEntity.getCreationTimestamp());
        zzbgo.zza((Parcel)parcel2, (int)5, (String)turnBasedMatchEntity.getLastUpdaterId(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)6, (long)turnBasedMatchEntity.getLastUpdatedTimestamp());
        zzbgo.zza((Parcel)parcel2, (int)7, (String)turnBasedMatchEntity.getPendingParticipantId(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)8, (int)turnBasedMatchEntity.getStatus());
        zzbgo.zzc((Parcel)parcel2, (int)10, (int)turnBasedMatchEntity.getVariant());
        zzbgo.zzc((Parcel)parcel2, (int)11, (int)turnBasedMatchEntity.getVersion());
        zzbgo.zza((Parcel)parcel2, (int)12, (byte[])turnBasedMatchEntity.getData(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)13, turnBasedMatchEntity.getParticipants(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)14, (String)turnBasedMatchEntity.getRematchId(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)15, (byte[])turnBasedMatchEntity.getPreviousMatchData(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)16, (int)turnBasedMatchEntity.getMatchNumber());
        zzbgo.zza((Parcel)parcel2, (int)17, (Bundle)turnBasedMatchEntity.getAutoMatchCriteria(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)18, (int)turnBasedMatchEntity.getTurnStatus());
        zzbgo.zza((Parcel)parcel2, (int)19, (boolean)turnBasedMatchEntity.isLocallyModified());
        zzbgo.zza((Parcel)parcel2, (int)20, (String)turnBasedMatchEntity.getDescription(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)21, (String)turnBasedMatchEntity.getDescriptionParticipantId(), (boolean)false);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    static int zza(TurnBasedMatch turnBasedMatch, String string) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant.getStatus();
        }
        String string2 = turnBasedMatch.getMatchId();
        throw new IllegalStateException(new StringBuilder(29 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Participant ").append(string).append(" is not in match ").append(string2).toString());
    }

    static ArrayList<String> zzc(TurnBasedMatch turnBasedMatch) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            arrayList2.add(participant.getParticipantId());
        }
        return arrayList2;
    }

    static String zzb(TurnBasedMatch turnBasedMatch, String string) {
        String string2 = null;
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(string)) continue;
            string2 = participant.getParticipantId();
            break;
        }
        return string2;
    }

    static Participant zzc(TurnBasedMatch turnBasedMatch, String string) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant;
        }
        String string2 = turnBasedMatch.getMatchId();
        throw new IllegalStateException(new StringBuilder(29 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Participant ").append(string).append(" is not in match ").append(string2).toString());
    }
}

