/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameRef;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestEntity;
import com.google.android.gms.games.quest.zzb;
import java.util.ArrayList;
import java.util.List;

@Hide
public final class QuestRef
extends zzc
implements Quest {
    private final Game zzidx;
    private final int zzidy;

    QuestRef(DataHolder dataHolder, int n, int n2) {
        super(dataHolder, n);
        this.zzidx = new GameRef(dataHolder, n);
        this.zzidy = n2;
    }

    @Override
    public final String getQuestId() {
        return this.getString("external_quest_id");
    }

    @Override
    public final String getName() {
        return this.getString("quest_name");
    }

    @Override
    public final void getName(CharArrayBuffer charArrayBuffer) {
        this.zza("quest_name", charArrayBuffer);
    }

    @Override
    public final String getDescription() {
        return this.getString("quest_description");
    }

    @Override
    public final void getDescription(CharArrayBuffer charArrayBuffer) {
        this.zza("quest_description", charArrayBuffer);
    }

    @Override
    public final Uri getIconImageUri() {
        return this.zzgk("quest_icon_image_uri");
    }

    @Override
    @Hide
    public final String getIconImageUrl() {
        return this.getString("quest_icon_image_url");
    }

    @Override
    public final Uri getBannerImageUri() {
        return this.zzgk("quest_banner_image_uri");
    }

    @Override
    @Hide
    public final String getBannerImageUrl() {
        return this.getString("quest_banner_image_url");
    }

    @Override
    public final Milestone getCurrentMilestone() {
        return this.zzavw().get(0);
    }

    @Override
    @Hide
    public final List<Milestone> zzavw() {
        ArrayList<Milestone> arrayList = new ArrayList<Milestone>(this.zzidy);
        for (int i = 0; i < this.zzidy; ++i) {
            arrayList.add(new zzb(this.zzfxb, this.zzgch + i));
        }
        return arrayList;
    }

    @Override
    public final Game getGame() {
        return this.zzidx;
    }

    @Override
    public final int getState() {
        return this.getInteger("quest_state");
    }

    @Override
    @Hide
    public final int getType() {
        return this.getInteger("quest_type");
    }

    @Override
    public final long getAcceptedTimestamp() {
        return this.getLong("accepted_ts");
    }

    @Override
    public final long getEndTimestamp() {
        return this.getLong("quest_end_ts");
    }

    @Override
    public final long getLastUpdatedTimestamp() {
        return this.getLong("quest_last_updated_ts");
    }

    @Override
    @Hide
    public final long zzavx() {
        return this.getLong("notification_ts");
    }

    @Override
    public final long getStartTimestamp() {
        return this.getLong("quest_start_ts");
    }

    @Override
    public final boolean isEndingSoon() {
        return this.getLong("notification_ts") <= System.currentTimeMillis() + 1800000L;
    }

    public final int hashCode() {
        return QuestEntity.zza(this);
    }

    public final boolean equals(Object object) {
        return QuestEntity.zza(this, object);
    }

    public final String toString() {
        return QuestEntity.zzb(this);
    }

    public final int describeContents() {
        return 0;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        ((QuestEntity)((Quest)this.freeze())).writeToParcel(parcel, n);
    }

    public final /* synthetic */ Object freeze() {
        QuestRef questRef = this;
        return new QuestEntity(questRef);
    }
}

