/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntityCreator;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.internal.zzlw;

public final class GameEntity
extends GamesDowngradeableSafeParcel
implements Game {
    public static final Parcelable.Creator<GameEntity> CREATOR = new GameEntityCreatorCompat();
    private final int zzFG;
    private final String zzIm;
    private final String zzSJ;
    private final String zzabZ;
    private final String zzaca;
    private final String zzZO;
    private final String zzacb;
    private final Uri zzacc;
    private final Uri zzacd;
    private final Uri zzace;
    private final boolean zzacf;
    private final boolean zzacg;
    private final String zzach;
    private final int zzaci;
    private final int zzacj;
    private final int zzack;
    private final boolean zzacl;
    private final boolean zzacm;
    private final String zzacn;
    private final String zzaco;
    private final String zzacp;
    private final boolean zzacq;
    private final boolean zzacr;
    private final boolean zzacs;
    private final String zzact;
    private final boolean zzacu;

    public GameEntity(Game game) {
        this.zzFG = 6;
        this.zzIm = game.getApplicationId();
        this.zzabZ = game.getPrimaryCategory();
        this.zzaca = game.getSecondaryCategory();
        this.zzZO = game.getDescription();
        this.zzacb = game.getDeveloperName();
        this.zzSJ = game.getDisplayName();
        this.zzacc = game.getIconImageUri();
        this.zzacn = game.getIconImageUrl();
        this.zzacd = game.getHiResImageUri();
        this.zzaco = game.getHiResImageUrl();
        this.zzace = game.getFeaturedImageUri();
        this.zzacp = game.getFeaturedImageUrl();
        this.zzacf = game.zzmx();
        this.zzacg = game.zzmz();
        this.zzach = game.zzmA();
        this.zzaci = game.zzmB();
        this.zzacj = game.getAchievementTotalCount();
        this.zzack = game.getLeaderboardCount();
        this.zzacl = game.isRealTimeMultiplayerEnabled();
        this.zzacm = game.isTurnBasedMultiplayerEnabled();
        this.zzacq = game.isMuted();
        this.zzacr = game.zzmy();
        this.zzacs = game.areSnapshotsEnabled();
        this.zzact = game.getThemeColor();
        this.zzacu = game.hasGamepadSupport();
    }

    GameEntity(int versionCode, String applicationId, String displayName, String primaryCategory, String secondaryCategory, String description, String developerName, Uri iconImageUri, Uri hiResImageUri, Uri featuredImageUri, boolean playEnabledGame, boolean instanceInstalled, String instancePackageName, int gameplayAclStatus, int achievementTotalCount, int leaderboardCount, boolean realTimeEnabled, boolean turnBasedEnabled, String iconImageUrl, String hiResImageUrl, String featuredImageUrl, boolean muted, boolean identitySharingConfirmed, boolean snapshotsEnabled, String themeColor, boolean hasGamepadSupport) {
        this.zzFG = versionCode;
        this.zzIm = applicationId;
        this.zzSJ = displayName;
        this.zzabZ = primaryCategory;
        this.zzaca = secondaryCategory;
        this.zzZO = description;
        this.zzacb = developerName;
        this.zzacc = iconImageUri;
        this.zzacn = iconImageUrl;
        this.zzacd = hiResImageUri;
        this.zzaco = hiResImageUrl;
        this.zzace = featuredImageUri;
        this.zzacp = featuredImageUrl;
        this.zzacf = playEnabledGame;
        this.zzacg = instanceInstalled;
        this.zzach = instancePackageName;
        this.zzaci = gameplayAclStatus;
        this.zzacj = achievementTotalCount;
        this.zzack = leaderboardCount;
        this.zzacl = realTimeEnabled;
        this.zzacm = turnBasedEnabled;
        this.zzacq = muted;
        this.zzacr = identitySharingConfirmed;
        this.zzacs = snapshotsEnabled;
        this.zzact = themeColor;
        this.zzacu = hasGamepadSupport;
    }

    public int getVersionCode() {
        return this.zzFG;
    }

    @Override
    public String getApplicationId() {
        return this.zzIm;
    }

    @Override
    public String getDisplayName() {
        return this.zzSJ;
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        zzlw.zzb((String)this.zzSJ, (CharArrayBuffer)dataOut);
    }

    @Override
    public String getPrimaryCategory() {
        return this.zzabZ;
    }

    @Override
    public String getSecondaryCategory() {
        return this.zzaca;
    }

    @Override
    public String getDescription() {
        return this.zzZO;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zzlw.zzb((String)this.zzZO, (CharArrayBuffer)dataOut);
    }

    @Override
    public String getDeveloperName() {
        return this.zzacb;
    }

    @Override
    public void getDeveloperName(CharArrayBuffer dataOut) {
        zzlw.zzb((String)this.zzacb, (CharArrayBuffer)dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzacc;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzacn;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.zzacd;
    }

    @Override
    public String getHiResImageUrl() {
        return this.zzaco;
    }

    @Override
    public Uri getFeaturedImageUri() {
        return this.zzace;
    }

    @Override
    public String getFeaturedImageUrl() {
        return this.zzacp;
    }

    @Override
    public boolean isMuted() {
        return this.zzacq;
    }

    @Override
    public boolean zzmy() {
        return this.zzacr;
    }

    @Override
    public boolean zzmx() {
        return this.zzacf;
    }

    @Override
    public boolean zzmz() {
        return this.zzacg;
    }

    @Override
    public String zzmA() {
        return this.zzach;
    }

    @Override
    public int zzmB() {
        return this.zzaci;
    }

    @Override
    public int getAchievementTotalCount() {
        return this.zzacj;
    }

    @Override
    public int getLeaderboardCount() {
        return this.zzack;
    }

    @Override
    public boolean isRealTimeMultiplayerEnabled() {
        return this.zzacl;
    }

    @Override
    public boolean isTurnBasedMultiplayerEnabled() {
        return this.zzacm;
    }

    @Override
    public boolean areSnapshotsEnabled() {
        return this.zzacs;
    }

    @Override
    public String getThemeColor() {
        return this.zzact;
    }

    @Override
    public boolean hasGamepadSupport() {
        return this.zzacu;
    }

    public Game freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameEntity.zza(this);
    }

    static int zza(Game game) {
        return zzw.hashCode((Object[])new Object[]{game.getApplicationId(), game.getDisplayName(), game.getPrimaryCategory(), game.getSecondaryCategory(), game.getDescription(), game.getDeveloperName(), game.getIconImageUri(), game.getHiResImageUri(), game.getFeaturedImageUri(), game.zzmx(), game.zzmz(), game.zzmA(), game.zzmB(), game.getAchievementTotalCount(), game.getLeaderboardCount(), game.isRealTimeMultiplayerEnabled(), game.isTurnBasedMultiplayerEnabled(), game.isMuted(), game.zzmy(), game.areSnapshotsEnabled(), game.getThemeColor(), game.hasGamepadSupport()});
    }

    public boolean equals(Object obj) {
        return GameEntity.zza(this, obj);
    }

    static boolean zza(Game game, Object object) {
        if (!(object instanceof Game)) {
            return false;
        }
        if (game == object) {
            return true;
        }
        Game game2 = (Game)object;
        return zzw.equal((Object)game2.getApplicationId(), (Object)game.getApplicationId()) && zzw.equal((Object)game2.getDisplayName(), (Object)game.getDisplayName()) && zzw.equal((Object)game2.getPrimaryCategory(), (Object)game.getPrimaryCategory()) && zzw.equal((Object)game2.getSecondaryCategory(), (Object)game.getSecondaryCategory()) && zzw.equal((Object)game2.getDescription(), (Object)game.getDescription()) && zzw.equal((Object)game2.getDeveloperName(), (Object)game.getDeveloperName()) && zzw.equal((Object)game2.getIconImageUri(), (Object)game.getIconImageUri()) && zzw.equal((Object)game2.getHiResImageUri(), (Object)game.getHiResImageUri()) && zzw.equal((Object)game2.getFeaturedImageUri(), (Object)game.getFeaturedImageUri()) && zzw.equal((Object)game2.zzmx(), (Object)game.zzmx()) && zzw.equal((Object)game2.zzmz(), (Object)game.zzmz()) && zzw.equal((Object)game2.zzmA(), (Object)game.zzmA()) && zzw.equal((Object)game2.zzmB(), (Object)game.zzmB()) && zzw.equal((Object)game2.getAchievementTotalCount(), (Object)game.getAchievementTotalCount()) && zzw.equal((Object)game2.getLeaderboardCount(), (Object)game.getLeaderboardCount()) && zzw.equal((Object)game2.isRealTimeMultiplayerEnabled(), (Object)game.isRealTimeMultiplayerEnabled()) && zzw.equal((Object)game2.isTurnBasedMultiplayerEnabled(), (Object)(game.isTurnBasedMultiplayerEnabled() && zzw.equal((Object)game2.isMuted(), (Object)game.isMuted()) && zzw.equal((Object)game2.zzmy(), (Object)game.zzmy()) ? 1 : 0)) && zzw.equal((Object)game2.areSnapshotsEnabled(), (Object)game.areSnapshotsEnabled()) && zzw.equal((Object)game2.getThemeColor(), (Object)game.getThemeColor()) && zzw.equal((Object)game2.hasGamepadSupport(), (Object)game.hasGamepadSupport());
    }

    public String toString() {
        return GameEntity.zzb(this);
    }

    static String zzb(Game game) {
        return zzw.zzk((Object)game).zza("ApplicationId", (Object)game.getApplicationId()).zza("DisplayName", (Object)game.getDisplayName()).zza("PrimaryCategory", (Object)game.getPrimaryCategory()).zza("SecondaryCategory", (Object)game.getSecondaryCategory()).zza("Description", (Object)game.getDescription()).zza("DeveloperName", (Object)game.getDeveloperName()).zza("IconImageUri", (Object)game.getIconImageUri()).zza("IconImageUrl", (Object)game.getIconImageUrl()).zza("HiResImageUri", (Object)game.getHiResImageUri()).zza("HiResImageUrl", (Object)game.getHiResImageUrl()).zza("FeaturedImageUri", (Object)game.getFeaturedImageUri()).zza("FeaturedImageUrl", (Object)game.getFeaturedImageUrl()).zza("PlayEnabledGame", (Object)game.zzmx()).zza("InstanceInstalled", (Object)game.zzmz()).zza("InstancePackageName", (Object)game.zzmA()).zza("AchievementTotalCount", (Object)game.getAchievementTotalCount()).zza("LeaderboardCount", (Object)game.getLeaderboardCount()).zza("RealTimeMultiplayerEnabled", (Object)game.isRealTimeMultiplayerEnabled()).zza("TurnBasedMultiplayerEnabled", (Object)game.isTurnBasedMultiplayerEnabled()).zza("AreSnapshotsEnabled", (Object)game.areSnapshotsEnabled()).zza("ThemeColor", (Object)game.getThemeColor()).zza("HasGamepadSupport", (Object)game.hasGamepadSupport()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.zziY()) {
            GameEntityCreator.zza(this, dest, flags);
        } else {
            dest.writeString(this.zzIm);
            dest.writeString(this.zzSJ);
            dest.writeString(this.zzabZ);
            dest.writeString(this.zzaca);
            dest.writeString(this.zzZO);
            dest.writeString(this.zzacb);
            dest.writeString(this.zzacc == null ? null : this.zzacc.toString());
            dest.writeString(this.zzacd == null ? null : this.zzacd.toString());
            dest.writeString(this.zzace == null ? null : this.zzace.toString());
            dest.writeInt(this.zzacf ? 1 : 0);
            dest.writeInt(this.zzacg ? 1 : 0);
            dest.writeString(this.zzach);
            dest.writeInt(this.zzaci);
            dest.writeInt(this.zzacj);
            dest.writeInt(this.zzack);
        }
    }

    static final class GameEntityCreatorCompat
    extends GameEntityCreator {
        GameEntityCreatorCompat() {
        }

        @Override
        public GameEntity zzcP(Parcel parcel) {
            boolean bl = GameEntity.zzd(GameEntity.zziX());
            if (bl || GameEntity.zzbf((String)GameEntity.class.getCanonicalName())) {
                return super.zzcP(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            String string7 = parcel.readString();
            Uri uri = string7 == null ? null : Uri.parse((String)string7);
            String string8 = parcel.readString();
            Uri uri2 = string8 == null ? null : Uri.parse((String)string8);
            String string9 = parcel.readString();
            Uri uri3 = string9 == null ? null : Uri.parse((String)string9);
            boolean bl2 = parcel.readInt() > 0;
            boolean bl3 = parcel.readInt() > 0;
            String string10 = parcel.readString();
            int n = parcel.readInt();
            int n2 = parcel.readInt();
            int n3 = parcel.readInt();
            boolean bl4 = false;
            boolean bl5 = false;
            String string11 = null;
            String string12 = null;
            String string13 = null;
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = false;
            String string14 = null;
            boolean bl9 = false;
            return new GameEntity(6, string, string2, string3, string4, string5, string6, uri, uri2, uri3, bl2, bl3, string10, n, n2, n3, bl4, bl5, string11, string12, string13, bl6, bl7, bl8, string14, bl9);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.zzcP(x0);
        }
    }
}

