/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.event;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.event.Event;
import com.google.android.gms.games.event.EventEntityCreator;
import com.google.android.gms.internal.zzlw;

public final class EventEntity
implements SafeParcelable,
Event {
    public static final EventEntityCreator CREATOR = new EventEntityCreator();
    private final int zzFG;
    private final String zzadJ;
    private final String mName;
    private final String zzZO;
    private final Uri zzacc;
    private final String zzacn;
    private final PlayerEntity zzadf;
    private final long zzadK;
    private final String zzadL;
    private final boolean zzadM;

    public EventEntity(Event event) {
        this.zzFG = 1;
        this.zzadJ = event.getEventId();
        this.mName = event.getName();
        this.zzZO = event.getDescription();
        this.zzacc = event.getIconImageUri();
        this.zzacn = event.getIconImageUrl();
        this.zzadf = (PlayerEntity)event.getPlayer().freeze();
        this.zzadK = event.getValue();
        this.zzadL = event.getFormattedValue();
        this.zzadM = event.isVisible();
    }

    EventEntity(int versionCode, String eventId, String name, String description, Uri iconImageUri, String iconImageUrl, Player player, long value, String formattedValue, boolean isVisible) {
        this.zzFG = versionCode;
        this.zzadJ = eventId;
        this.mName = name;
        this.zzZO = description;
        this.zzacc = iconImageUri;
        this.zzacn = iconImageUrl;
        this.zzadf = new PlayerEntity(player);
        this.zzadK = value;
        this.zzadL = formattedValue;
        this.zzadM = isVisible;
    }

    public int getVersionCode() {
        return this.zzFG;
    }

    @Override
    public String getEventId() {
        return this.zzadJ;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer dataOut) {
        zzlw.zzb((String)this.mName, (CharArrayBuffer)dataOut);
    }

    @Override
    public String getDescription() {
        return this.zzZO;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zzlw.zzb((String)this.zzZO, (CharArrayBuffer)dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzacc;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzacn;
    }

    @Override
    public Player getPlayer() {
        return this.zzadf;
    }

    @Override
    public long getValue() {
        return this.zzadK;
    }

    @Override
    public String getFormattedValue() {
        return this.zzadL;
    }

    @Override
    public void getFormattedValue(CharArrayBuffer dataOut) {
        zzlw.zzb((String)this.zzadL, (CharArrayBuffer)dataOut);
    }

    @Override
    public boolean isVisible() {
        return this.zzadM;
    }

    public Event freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return EventEntity.zza(this);
    }

    static int zza(Event event) {
        return zzw.hashCode((Object[])new Object[]{event.getEventId(), event.getName(), event.getDescription(), event.getIconImageUri(), event.getIconImageUrl(), event.getPlayer(), event.getValue(), event.getFormattedValue(), event.isVisible()});
    }

    public boolean equals(Object obj) {
        return EventEntity.zza(this, obj);
    }

    static boolean zza(Event event, Object object) {
        if (!(object instanceof Event)) {
            return false;
        }
        if (event == object) {
            return true;
        }
        Event event2 = (Event)object;
        return zzw.equal((Object)event2.getEventId(), (Object)event.getEventId()) && zzw.equal((Object)event2.getName(), (Object)event.getName()) && zzw.equal((Object)event2.getDescription(), (Object)event.getDescription()) && zzw.equal((Object)event2.getIconImageUri(), (Object)event.getIconImageUri()) && zzw.equal((Object)event2.getIconImageUrl(), (Object)event.getIconImageUrl()) && zzw.equal((Object)event2.getPlayer(), (Object)event.getPlayer()) && zzw.equal((Object)event2.getValue(), (Object)event.getValue()) && zzw.equal((Object)event2.getFormattedValue(), (Object)event.getFormattedValue()) && zzw.equal((Object)event2.isVisible(), (Object)event.isVisible());
    }

    public String toString() {
        return EventEntity.zzb(this);
    }

    static String zzb(Event event) {
        return zzw.zzk((Object)event).zza("Id", (Object)event.getEventId()).zza("Name", (Object)event.getName()).zza("Description", (Object)event.getDescription()).zza("IconImageUri", (Object)event.getIconImageUri()).zza("IconImageUrl", (Object)event.getIconImageUrl()).zza("Player", (Object)event.getPlayer()).zza("Value", (Object)event.getValue()).zza("FormattedValue", (Object)event.getFormattedValue()).zza("isVisible", (Object)event.isVisible()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        EventEntityCreator.zza(this, out, flags);
    }
}

