/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.api.zzb;
import com.google.android.gms.common.api.zzc;
import com.google.android.gms.common.api.zze;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zza;
import com.google.android.gms.common.internal.BinderWrapper;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzk;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.drive.Contents;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameBuffer;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.GamesMetadata;
import com.google.android.gms.games.GamesStatusCodes;
import com.google.android.gms.games.Notifications;
import com.google.android.gms.games.OnNearbyPlayerDetectedListener;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerBuffer;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.achievement.AchievementBuffer;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.appcontent.AppContents;
import com.google.android.gms.games.event.EventBuffer;
import com.google.android.gms.games.event.Events;
import com.google.android.gms.games.internal.AbstractGamesCallbacks;
import com.google.android.gms.games.internal.AbstractGamesClient;
import com.google.android.gms.games.internal.GamesLog;
import com.google.android.gms.games.internal.IGamesCallbacks;
import com.google.android.gms.games.internal.IGamesService;
import com.google.android.gms.games.internal.PopupLocationInfoParcelable;
import com.google.android.gms.games.internal.PopupManager;
import com.google.android.gms.games.internal.constants.RequestType;
import com.google.android.gms.games.internal.events.EventIncrementCache;
import com.google.android.gms.games.internal.events.EventIncrementManager;
import com.google.android.gms.games.internal.experience.ExperienceEventBuffer;
import com.google.android.gms.games.internal.game.Acls;
import com.google.android.gms.games.internal.game.ExtendedGameBuffer;
import com.google.android.gms.games.internal.game.GameInstanceBuffer;
import com.google.android.gms.games.internal.game.GameSearchSuggestionBuffer;
import com.google.android.gms.games.internal.request.RequestUpdateOutcomes;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.games.leaderboard.LeaderboardScoreBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardScoreEntity;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.leaderboard.ScoreSubmissionData;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.Invitations;
import com.google.android.gms.games.multiplayer.OnInvitationReceivedListener;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessage;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomBuffer;
import com.google.android.gms.games.multiplayer.realtime.RoomConfig;
import com.google.android.gms.games.multiplayer.realtime.RoomEntity;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.games.multiplayer.turnbased.LoadMatchesResponse;
import com.google.android.gms.games.multiplayer.turnbased.OnTurnBasedMatchUpdateReceivedListener;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchConfig;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestBuffer;
import com.google.android.gms.games.quest.QuestEntity;
import com.google.android.gms.games.quest.QuestUpdateListener;
import com.google.android.gms.games.quest.Quests;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestBuffer;
import com.google.android.gms.games.request.OnRequestReceivedListener;
import com.google.android.gms.games.request.Requests;
import com.google.android.gms.games.snapshot.Snapshot;
import com.google.android.gms.games.snapshot.SnapshotContents;
import com.google.android.gms.games.snapshot.SnapshotContentsEntity;
import com.google.android.gms.games.snapshot.SnapshotEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataBuffer;
import com.google.android.gms.games.snapshot.SnapshotMetadataChange;
import com.google.android.gms.games.snapshot.SnapshotMetadataChangeEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntity;
import com.google.android.gms.games.snapshot.Snapshots;
import com.google.android.gms.internal.zzus;
import com.google.android.gms.internal.zzvc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class GamesClientImpl
extends zzk<IGamesService>
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener {
    EventIncrementManager zzadP = new EventIncrementManager(){

        @Override
        public EventIncrementCache zznM() {
            return new GameClientEventIncrementCache();
        }
    };
    private final String zzadQ;
    private PlayerEntity zzadR;
    private GameEntity zzadS;
    private final PopupManager zzadT;
    private boolean zzadU = false;
    private final Binder zzadV;
    private final long zzadW;
    private final Games.GamesOptions zzadX;

    public GamesClientImpl(Context context, Looper looper, zzf clientSettings, Games.GamesOptions options, GoogleApiClient.ConnectionCallbacks connectedListener, GoogleApiClient.OnConnectionFailedListener connectionFailedListener) {
        super(context, looper, 1, connectedListener, connectionFailedListener, clientSettings);
        this.zzadQ = clientSettings.zziR();
        this.zzadV = new Binder();
        this.zzadT = PopupManager.zza(this, clientSettings.zziO());
        this.zzl(clientSettings.zziT());
        this.zzadW = ((Object)((Object)this)).hashCode();
        this.zzadX = options;
        this.registerConnectionCallbacks(this);
        this.registerConnectionFailedListener(this);
    }

    public boolean zzhc() {
        return true;
    }

    public void onConnected(Bundle connectionHint) {
        if (this.zzadU) {
            this.zzadT.zzoc();
            this.zzadU = false;
        }
        if (!this.zzadX.zzacA) {
            this.zzno();
        }
    }

    public void onConnectionSuspended(int cause) {
    }

    public void onConnectionFailed(ConnectionResult result) {
        this.zzadU = false;
    }

    public void zzeB(int n) {
        this.zzadT.setGravity(n);
    }

    public void zzl(View view) {
        this.zzadT.zzm(view);
    }

    protected List<String> zzf(List<String> list) {
        boolean bl = false;
        boolean bl2 = false;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String string = list.get(i);
            if (string.equals("https://www.googleapis.com/auth/games")) {
                bl = true;
                continue;
            }
            if (!string.equals("https://www.googleapis.com/auth/games.firstparty")) continue;
            bl2 = true;
        }
        if (bl2) {
            zzx.zza((!bl ? 1 : 0) != 0, (String)"Cannot have both %s and %s!", (Object[])new Object[]{"https://www.googleapis.com/auth/games", "https://www.googleapis.com/auth/games.firstparty"});
        } else {
            zzx.zza((boolean)bl, (String)"Games APIs requires %s to function.", (Object[])new Object[]{"https://www.googleapis.com/auth/games"});
        }
        return list;
    }

    public void connect() {
        this.zznn();
        super.connect();
    }

    public void disconnect() {
        this.zzadU = false;
        if (this.isConnected()) {
            try {
                IGamesService iGamesService = (IGamesService)this.zzjb();
                iGamesService.zznL();
                this.zzadP.flush();
                iGamesService.zzu(this.zzadW);
            }
            catch (RemoteException remoteException) {
                GamesLog.zzr("GamesClientImpl", "Failed to notify client disconnect.");
            }
        }
        super.disconnect();
    }

    protected String zzcF() {
        return "com.google.android.gms.games.service.START";
    }

    protected String zzcG() {
        return "com.google.android.gms.games.internal.IGamesService";
    }

    protected IGamesService zzaW(IBinder iBinder) {
        return IGamesService.Stub.zzaZ(iBinder);
    }

    public Bundle zzhp() {
        try {
            Bundle bundle = ((IGamesService)this.zzjb()).zzhp();
            if (bundle != null) {
                bundle.setClassLoader(GamesClientImpl.class.getClassLoader());
            }
            return bundle;
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
            return null;
        }
    }

    private void zznn() {
        this.zzadR = null;
        this.zzadS = null;
    }

    protected Bundle zzhq() {
        String string = this.getContext().getResources().getConfiguration().locale.toString();
        Bundle bundle = new Bundle();
        bundle.putString("com.google.android.gms.games.key.gamePackageName", this.zzadQ);
        bundle.putBoolean("com.google.android.gms.games.key.isHeadless", this.zzadX.zzacA);
        bundle.putBoolean("com.google.android.gms.games.key.showConnectingPopup", this.zzadX.zzacB);
        bundle.putInt("com.google.android.gms.games.key.connectingPopupGravity", this.zzadX.zzacC);
        bundle.putBoolean("com.google.android.gms.games.key.retryingSignIn", this.zzadX.zzacD);
        bundle.putInt("com.google.android.gms.games.key.sdkVariant", this.zzadX.zzacE);
        bundle.putString("com.google.android.gms.games.key.forceResolveAccountKey", this.zzadX.zzacF);
        bundle.putStringArrayList("com.google.android.gms.games.key.proxyApis", this.zzadX.zzacG);
        bundle.putString("com.google.android.gms.games.key.desiredLocale", string);
        bundle.putParcelable("com.google.android.gms.games.key.popupWindowToken", (Parcelable)new BinderWrapper(this.zzadT.zzoe()));
        zzf zzf2 = this.zzja();
        if (zzf2.zziU() != null) {
            bundle.putBundle("com.google.android.gms.games.key.signInOptions", zzvc.zza((zzus)zzf2.zziU(), (Integer)zzf2.zziV(), (ExecutorService)Executors.newSingleThreadExecutor()));
        }
        return bundle;
    }

    public void zzno() {
        try {
            PopupLocationInfoBinderCallbacks popupLocationInfoBinderCallbacks = new PopupLocationInfoBinderCallbacks(this.zzadT);
            ((IGamesService)this.zzjb()).zza(popupLocationInfoBinderCallbacks, this.zzadW);
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
        }
    }

    public String zznp() {
        try {
            return ((IGamesService)this.zzjb()).zznp();
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
            return null;
        }
    }

    public String zznq() {
        if (this.zzadR != null) {
            return this.zzadR.getPlayerId();
        }
        try {
            return ((IGamesService)this.zzjb()).zznq();
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Player zznr() {
        this.zzfc();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.zzadR == null) {
                try {
                    PlayerBuffer playerBuffer = new PlayerBuffer(((IGamesService)this.zzjb()).zznN());
                    try {
                        if (playerBuffer.getCount() > 0) {
                            this.zzadR = (PlayerEntity)playerBuffer.get(0).freeze();
                        }
                    }
                    finally {
                        playerBuffer.release();
                    }
                }
                catch (RemoteException remoteException) {
                    GamesLog.zzr("GamesClientImpl", "service died");
                }
            }
        }
        return this.zzadR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Game zzns() {
        this.zzfc();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.zzadS == null) {
                try {
                    GameBuffer gameBuffer = new GameBuffer(((IGamesService)this.zzjb()).zznP());
                    try {
                        if (gameBuffer.getCount() > 0) {
                            this.zzadS = (GameEntity)gameBuffer.get(0).freeze();
                        }
                    }
                    finally {
                        gameBuffer.release();
                    }
                }
                catch (RemoteException remoteException) {
                    GamesLog.zzr("GamesClientImpl", "service died");
                }
            }
        }
        return this.zzadS;
    }

    public void zza(zza.zzb<Players.LoadPlayersResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzjb()).zzf((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, bl);
    }

    public void zza(zza.zzb<Players.LoadPlayersResult> zzb2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zzjb()).zzc((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), stringArray);
    }

    public void zza(zza.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzjb()).zza((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zza(zza.zzb<Players.LoadPlayersResult> zzb2, String string, int n, boolean bl, boolean bl2) throws RemoteException {
        switch (string) {
            case "played_with": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid player collection: " + string);
            }
        }
        ((IGamesService)this.zzjb()).zzd(new PlayersLoadedBinderCallback(zzb2), string, n, bl, bl2);
    }

    public void zza(zza.zzb<Players.LoadPlayersResult> zzb2, String string, String string2, int n, boolean bl, boolean bl2) throws RemoteException {
        switch (string) {
            case "circled": 
            case "played_with": 
            case "nearby": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid player collection: " + string);
            }
        }
        ((IGamesService)this.zzjb()).zza((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, string2, n, bl, bl2);
    }

    public void zza(zza.zzb<Players.LoadPlayersResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzjb()).zzc((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), bl);
    }

    public Intent zznt() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzjb()).zznt();
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent zzo(String string, int n) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzjb()).zzv(string, n);
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void zzb(zza.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzjb()).zzb((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), bl);
    }

    public void zzb(zza.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzjb()).zzc((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), string, bl);
    }

    public void zza(zza.zzb<Leaderboards.LoadPlayerScoreResult> zzb2, String string, String string2, int n, int n2) throws RemoteException {
        ((IGamesService)this.zzjb()).zza((IGamesCallbacks)new PlayerLeaderboardScoreLoadedBinderCallback(zzb2), string, string2, n, n2);
    }

    public void zza(zza.zzb<Leaderboards.LoadScoresResult> zzb2, String string, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zzjb()).zza((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), string, n, n2, n3, bl);
    }

    public void zzb(zza.zzb<Leaderboards.LoadScoresResult> zzb2, String string, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zzjb()).zzb((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), string, n, n2, n3, bl);
    }

    public void zza(zza.zzb<Leaderboards.LoadScoresResult> zzb2, LeaderboardScoreBuffer leaderboardScoreBuffer, int n, int n2) throws RemoteException {
        ((IGamesService)this.zzjb()).zza((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), leaderboardScoreBuffer.zzoQ().zzoR(), n, n2);
    }

    public void zza(zza.zzb<Leaderboards.SubmitScoreResult> zzb2, String string, long l, String string2) throws RemoteException {
        SubmitScoreBinderCallbacks submitScoreBinderCallbacks = zzb2 == null ? null : new SubmitScoreBinderCallbacks(zzb2);
        ((IGamesService)this.zzjb()).zza((IGamesCallbacks)submitScoreBinderCallbacks, string, l, string2);
    }

    public Intent zznu() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzjb()).zznu();
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void zzc(zza.zzb<Achievements.LoadAchievementsResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzjb()).zza((IGamesCallbacks)new AchievementsLoadedBinderCallback(zzb2), bl);
    }

    public void zza(zza.zzb<Achievements.UpdateAchievementResult> zzb2, String string) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zzjb()).zza((IGamesCallbacks)achievementUpdatedBinderCallback, string, this.zzadT.zzoe(), this.zzadT.zzod());
    }

    public void zzb(zza.zzb<Achievements.UpdateAchievementResult> zzb2, String string) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zzjb()).zzb((IGamesCallbacks)achievementUpdatedBinderCallback, string, this.zzadT.zzoe(), this.zzadT.zzod());
    }

    public void zza(zza.zzb<Achievements.UpdateAchievementResult> zzb2, String string, int n) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zzjb()).zza((IGamesCallbacks)achievementUpdatedBinderCallback, string, n, this.zzadT.zzoe(), this.zzadT.zzod());
    }

    public void zzb(zza.zzb<Achievements.UpdateAchievementResult> zzb2, String string, int n) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zzjb()).zzb((IGamesCallbacks)achievementUpdatedBinderCallback, string, n, this.zzadT.zzoe(), this.zzadT.zzod());
    }

    public void zzd(zza.zzb<Events.LoadEventsResult> zzb2, boolean bl) throws RemoteException {
        this.zzadP.flush();
        ((IGamesService)this.zzjb()).zzf((IGamesCallbacks)new EventsLoadedBinderCallback(zzb2), bl);
    }

    public void zza(zza.zzb<Events.LoadEventsResult> zzb2, boolean bl, String ... stringArray) throws RemoteException {
        this.zzadP.flush();
        ((IGamesService)this.zzjb()).zza((IGamesCallbacks)new EventsLoadedBinderCallback(zzb2), bl, stringArray);
    }

    public void zzp(String string, int n) {
        this.zzadP.zzp(string, n);
    }

    public Intent zznv() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzjb()).zznv();
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent zznw() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzjb()).zznw();
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void zza(zze<OnInvitationReceivedListener> zze2) {
        try {
            InvitationReceivedBinderCallback invitationReceivedBinderCallback = new InvitationReceivedBinderCallback(zze2);
            ((IGamesService)this.zzjb()).zza((IGamesCallbacks)invitationReceivedBinderCallback, this.zzadW);
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
        }
    }

    public void zznx() {
        try {
            ((IGamesService)this.zzjb()).zzv(this.zzadW);
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
        }
    }

    public void zzb(zze<OnTurnBasedMatchUpdateReceivedListener> zze2) {
        try {
            MatchUpdateReceivedBinderCallback matchUpdateReceivedBinderCallback = new MatchUpdateReceivedBinderCallback(zze2);
            ((IGamesService)this.zzjb()).zzb((IGamesCallbacks)matchUpdateReceivedBinderCallback, this.zzadW);
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
        }
    }

    public void zzny() {
        try {
            ((IGamesService)this.zzjb()).zzw(this.zzadW);
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
        }
    }

    public void zzc(zze<QuestUpdateListener> zze2) {
        try {
            QuestUpdateBinderCallback questUpdateBinderCallback = new QuestUpdateBinderCallback(zze2);
            ((IGamesService)this.zzjb()).zzd((IGamesCallbacks)questUpdateBinderCallback, this.zzadW);
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
        }
    }

    public void zznz() {
        try {
            ((IGamesService)this.zzjb()).zzy(this.zzadW);
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
        }
    }

    public void zzd(zze<OnRequestReceivedListener> zze2) {
        try {
            RequestReceivedBinderCallback requestReceivedBinderCallback = new RequestReceivedBinderCallback(zze2);
            ((IGamesService)this.zzjb()).zzc((IGamesCallbacks)requestReceivedBinderCallback, this.zzadW);
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
        }
    }

    public void zznA() {
        try {
            ((IGamesService)this.zzjb()).zzx(this.zzadW);
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
        }
    }

    public Intent zza(PlayerEntity playerEntity) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzjb()).zza(playerEntity);
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent zznB() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzjb()).zznB();
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent zza(Room room, int n) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzjb()).zza((RoomEntity)room.freeze(), n);
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent zznC() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzjb()).zznC();
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void zzf(zza.zzb<GamesMetadata.LoadGamesResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzjb()).zzd(new GamesLoadedBinderCallback(zzb2));
    }

    public void zzb(zza.zzb<Status> zzb2) throws RemoteException {
        this.zzadP.flush();
        ((IGamesService)this.zzjb()).zza(new SignOutCompleteBinderCallbacks(zzb2));
    }

    public int zznD() {
        int n = 4368;
        try {
            n = ((IGamesService)this.zzjb()).zznD();
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
        }
        return n;
    }

    public String zznE() {
        try {
            return ((IGamesService)this.zzjb()).zznE();
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
            return null;
        }
    }

    public void zzc(zza.zzb<Invitations.LoadInvitationsResult> zzb2, int n) throws RemoteException {
        ((IGamesService)this.zzjb()).zza((IGamesCallbacks)new InvitationsLoadedBinderCallback(zzb2), n);
    }

    public void zzq(String string, int n) {
        try {
            ((IGamesService)this.zzjb()).zzq(string, n);
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
        }
    }

    public void zzr(String string, int n) {
        try {
            ((IGamesService)this.zzjb()).zzr(string, n);
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
        }
    }

    public Intent zza(int n, int n2, boolean bl) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzjb()).zza(n, n2, bl);
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void zza(zza.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, TurnBasedMatchConfig turnBasedMatchConfig) throws RemoteException {
        ((IGamesService)this.zzjb()).zza((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), turnBasedMatchConfig.getVariant(), turnBasedMatchConfig.zzoX(), turnBasedMatchConfig.getInvitedPlayerIds(), turnBasedMatchConfig.getAutoMatchCriteria());
    }

    public void zzc(zza.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzjb()).zzl(new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string);
    }

    public void zzd(zza.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzjb()).zzm(new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string);
    }

    public int zznF() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzjb()).zznF();
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
        }
        return n;
    }

    public void zza(zza.zzb<TurnBasedMultiplayer.UpdateMatchResult> zzb2, String string, byte[] byArray, String string2, ParticipantResult[] participantResultArray) throws RemoteException {
        ((IGamesService)this.zzjb()).zza((IGamesCallbacks)new TurnBasedMatchUpdatedBinderCallbacks(zzb2), string, byArray, string2, participantResultArray);
    }

    public void zza(zza.zzb<TurnBasedMultiplayer.UpdateMatchResult> zzb2, String string, byte[] byArray, ParticipantResult[] participantResultArray) throws RemoteException {
        ((IGamesService)this.zzjb()).zza((IGamesCallbacks)new TurnBasedMatchUpdatedBinderCallbacks(zzb2), string, byArray, participantResultArray);
    }

    public void zze(zza.zzb<TurnBasedMultiplayer.LeaveMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzjb()).zzo(new TurnBasedMatchLeftBinderCallbacks(zzb2), string);
    }

    public void zza(zza.zzb<TurnBasedMultiplayer.LeaveMatchResult> zzb2, String string, String string2) throws RemoteException {
        ((IGamesService)this.zzjb()).zzc((IGamesCallbacks)new TurnBasedMatchLeftBinderCallbacks(zzb2), string, string2);
    }

    public void zzf(zza.zzb<TurnBasedMultiplayer.CancelMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzjb()).zzn(new TurnBasedMatchCanceledBinderCallbacks(zzb2), string);
    }

    public void zzbO(String string) {
        try {
            ((IGamesService)this.zzjb()).zzbW(string);
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
        }
    }

    public void zza(zza.zzb<TurnBasedMultiplayer.LoadMatchesResult> zzb2, int n, int[] nArray) throws RemoteException {
        ((IGamesService)this.zzjb()).zza((IGamesCallbacks)new TurnBasedMatchesLoadedBinderCallbacks(zzb2), n, nArray);
    }

    public void zzg(zza.zzb<TurnBasedMultiplayer.LoadMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzjb()).zzp(new TurnBasedMatchLoadedBinderCallbacks(zzb2), string);
    }

    public Intent zzb(int n, int n2, boolean bl) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzjb()).zzb(n, n2, bl);
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void zza(zze<RoomUpdateListener> zze2, zze<RoomStatusUpdateListener> zze3, zze<RealTimeMessageReceivedListener> zze4, RoomConfig roomConfig) {
        try {
            RoomBinderCallbacks roomBinderCallbacks = new RoomBinderCallbacks(zze2, zze3, zze4);
            ((IGamesService)this.zzjb()).zza((IGamesCallbacks)roomBinderCallbacks, (IBinder)this.zzadV, roomConfig.getVariant(), roomConfig.getInvitedPlayerIds(), roomConfig.getAutoMatchCriteria(), false, this.zzadW);
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
        }
    }

    public void zzb(zze<RoomUpdateListener> zze2, zze<RoomStatusUpdateListener> zze3, zze<RealTimeMessageReceivedListener> zze4, RoomConfig roomConfig) {
        try {
            RoomBinderCallbacks roomBinderCallbacks = new RoomBinderCallbacks(zze2, zze3, zze4);
            ((IGamesService)this.zzjb()).zza((IGamesCallbacks)roomBinderCallbacks, (IBinder)this.zzadV, roomConfig.getInvitationId(), false, this.zzadW);
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
        }
    }

    public void zza(zze<RoomUpdateListener> zze2, String string) {
        try {
            ((IGamesService)this.zzjb()).zzc((IGamesCallbacks)new RoomBinderCallbacks(zze2), string);
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
        }
    }

    public int zza(zze<RealTimeMultiplayer.ReliableMessageSentCallback> zze2, byte[] byArray, String string, String string2) {
        try {
            return ((IGamesService)this.zzjb()).zza((IGamesCallbacks)new RealTimeReliableMessageBinderCallbacks(zze2), byArray, string, string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
            return -1;
        }
    }

    public int zza(byte[] byArray, String string, String[] stringArray) {
        zzx.zzb((Object)stringArray, (Object)"Participant IDs must not be null");
        try {
            return ((IGamesService)this.zzjb()).zzb(byArray, string, stringArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
            return -1;
        }
    }

    public int zzd(byte[] byArray, String string) {
        try {
            return ((IGamesService)this.zzjb()).zzb(byArray, string, null);
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
            return -1;
        }
    }

    public void zzeC(int n) {
        try {
            ((IGamesService)this.zzjb()).zzeC(n);
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
        }
    }

    public Intent zznG() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzjb()).zznG();
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent zza(int n, byte[] byArray, int n2, Bitmap bitmap, String string) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzjb()).zza(n, byArray, n2, string);
            zzx.zzb((Object)bitmap, (Object)"Must provide a non null icon");
            intent.putExtra("com.google.android.gms.games.REQUEST_ITEM_ICON", (Parcelable)bitmap);
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public int zznH() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzjb()).zznH();
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
        }
        return n;
    }

    public int zznI() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzjb()).zznI();
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
        }
        return n;
    }

    public void zzb(zza.zzb<Requests.UpdateRequestsResult> zzb2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zzjb()).zza((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(zzb2), stringArray);
    }

    public void zzc(zza.zzb<Requests.UpdateRequestsResult> zzb2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zzjb()).zzb((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(zzb2), stringArray);
    }

    public void zza(zza.zzb<Requests.LoadRequestsResult> zzb2, int n, int n2, int n3) throws RemoteException {
        ((IGamesService)this.zzjb()).zza((IGamesCallbacks)new RequestsLoadedBinderCallbacks(zzb2), n, n2, n3);
    }

    public void zza(zza.zzb<AppContents.LoadAppContentResult> zzb2, int n, String string, String[] stringArray, boolean bl) throws RemoteException {
        ((IGamesService)this.zzjb()).zza((IGamesCallbacks)new AppContentLoadedBinderCallbacks(zzb2), n, string, stringArray, bl);
    }

    public Intent zzb(int[] nArray) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzjb()).zzb(nArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent zzbP(String string) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzjb()).zzbP(string);
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void zzh(zza.zzb<Quests.AcceptQuestResult> zzb2, String string) throws RemoteException {
        this.zzadP.flush();
        ((IGamesService)this.zzjb()).zzu(new QuestAcceptedBinderCallbacks(zzb2), string);
    }

    public void zzb(zza.zzb<Quests.ClaimMilestoneResult> zzb2, String string, String string2) throws RemoteException {
        this.zzadP.flush();
        ((IGamesService)this.zzjb()).zzf((IGamesCallbacks)new QuestMilestoneClaimBinderCallbacks(zzb2, string2), string, string2);
    }

    public void zza(zza.zzb<Quests.LoadQuestsResult> zzb2, int[] nArray, int n, boolean bl) throws RemoteException {
        this.zzadP.flush();
        ((IGamesService)this.zzjb()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), nArray, n, bl);
    }

    public void zzb(zza.zzb<Quests.LoadQuestsResult> zzb2, boolean bl, String[] stringArray) throws RemoteException {
        this.zzadP.flush();
        ((IGamesService)this.zzjb()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), stringArray, bl);
    }

    public void zzbQ(String string) {
        try {
            ((IGamesService)this.zzjb()).zza(string, this.zzadT.zzoe(), this.zzadT.zzod());
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
        }
    }

    public void zza(zza.zzb<Quests.LoadQuestsResult> zzb2, String string, String string2, int[] nArray, int n, boolean bl) throws RemoteException {
        this.zzadP.flush();
        ((IGamesService)this.zzjb()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), string, string2, nArray, n, bl);
    }

    public void zza(zza.zzb<Quests.LoadQuestsResult> zzb2, String string, String string2, boolean bl, String[] stringArray) throws RemoteException {
        this.zzadP.flush();
        ((IGamesService)this.zzjb()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), string, string2, stringArray, bl);
    }

    public int zznJ() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzjb()).zznJ();
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
        }
        return n;
    }

    public int zznK() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzjb()).zznK();
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
        }
        return n;
    }

    public Intent zza(String string, boolean bl, boolean bl2, int n) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzjb()).zza(string, bl, bl2, n);
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void zze(zza.zzb<Snapshots.LoadSnapshotsResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzjb()).zzd((IGamesCallbacks)new SnapshotsLoadedBinderCallbacks(zzb2), bl);
    }

    public void zza(zza.zzb<Snapshots.OpenSnapshotResult> zzb2, String string, boolean bl, int n) throws RemoteException {
        ((IGamesService)this.zzjb()).zza((IGamesCallbacks)new SnapshotOpenedBinderCallbacks(zzb2), string, bl, n);
    }

    public void zza(zza.zzb<Snapshots.CommitSnapshotResult> zzb2, Snapshot snapshot, SnapshotMetadataChange snapshotMetadataChange) throws RemoteException {
        SnapshotContents snapshotContents = snapshot.getSnapshotContents();
        zzx.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"Snapshot already closed");
        zza zza2 = snapshotMetadataChange.zzpc();
        if (zza2 != null) {
            zza2.zza(this.getContext().getCacheDir());
        }
        Contents contents = snapshotContents.zzkq();
        snapshotContents.close();
        ((IGamesService)this.zzjb()).zza((IGamesCallbacks)new SnapshotCommittedBinderCallbacks(zzb2), snapshot.getMetadata().getSnapshotId(), (SnapshotMetadataChangeEntity)snapshotMetadataChange, contents);
    }

    public void zza(Snapshot snapshot) {
        SnapshotContents snapshotContents = snapshot.getSnapshotContents();
        zzx.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"Snapshot already closed");
        Contents contents = snapshotContents.zzkq();
        snapshotContents.close();
        try {
            ((IGamesService)this.zzjb()).zza(contents);
        }
        catch (RemoteException remoteException) {
            GamesLog.zzr("GamesClientImpl", "service died");
        }
    }

    public void zzi(zza.zzb<Snapshots.DeleteSnapshotResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzjb()).zzr(new SnapshotDeletedBinderCallbacks(zzb2), string);
    }

    public void zza(zza.zzb<Snapshots.OpenSnapshotResult> zzb2, String string, String string2, SnapshotMetadataChange snapshotMetadataChange, SnapshotContents snapshotContents) throws RemoteException {
        zzx.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"SnapshotContents already closed");
        zza zza2 = snapshotMetadataChange.zzpc();
        if (zza2 != null) {
            zza2.zza(this.getContext().getCacheDir());
        }
        Contents contents = snapshotContents.zzkq();
        snapshotContents.close();
        ((IGamesService)this.zzjb()).zza((IGamesCallbacks)new SnapshotOpenedBinderCallbacks(zzb2), string, string2, (SnapshotMetadataChangeEntity)snapshotMetadataChange, contents);
    }

    public void zzb(zza.zzb<GamesMetadata.LoadExtendedGamesResult> zzb2, String string, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzjb()).zza((IGamesCallbacks)new ExtendedGamesLoadedBinderCallback(zzb2), string, n, bl, bl2);
    }

    public void zzj(zza.zzb<GamesMetadata.LoadExtendedGamesResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzjb()).zze((IGamesCallbacks)new ExtendedGamesLoadedBinderCallback(zzb2), string);
    }

    public void zzk(zza.zzb<GamesMetadata.LoadGameInstancesResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzjb()).zzf((IGamesCallbacks)new GameInstancesLoadedBinderCallback(zzb2), string);
    }

    public void zza(zza.zzb<GamesMetadata.LoadExtendedGamesResult> zzb2, int n, int n2, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzjb()).zza((IGamesCallbacks)new ExtendedGamesLoadedBinderCallback(zzb2), n, n2, bl, bl2);
    }

    public void zza(zza.zzb<GamesMetadata.LoadExtendedGamesResult> zzb2, String string, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws RemoteException {
        ((IGamesService)this.zzjb()).zza((IGamesCallbacks)new ExtendedGamesLoadedBinderCallback(zzb2), string, n, bl, bl2, bl3, bl4);
    }

    public void zzc(zza.zzb<GamesMetadata.LoadExtendedGamesResult> zzb2, String string, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzjb()).zze(new ExtendedGamesLoadedBinderCallback(zzb2), string, n, bl, bl2);
    }

    public void zzd(zza.zzb<GamesMetadata.LoadExtendedGamesResult> zzb2, String string, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzjb()).zzf(new ExtendedGamesLoadedBinderCallback(zzb2), string, n, bl, bl2);
    }

    public void zze(zza.zzb<GamesMetadata.LoadExtendedGamesResult> zzb2, String string, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzjb()).zzc(new ExtendedGamesLoadedBinderCallback(zzb2), string, n, bl, bl2);
    }

    public void zzl(zza.zzb<GamesMetadata.LoadGameSearchSuggestionsResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzjb()).zzq(new GameSearchSuggestionsLoadedBinderCallback(zzb2), string);
    }

    public void zzc(zza.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzjb()).zzd((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), string, bl);
    }

    public void zza(zza.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, String string, String string2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzjb()).zzb((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), string, string2, bl);
    }

    public void zza(zza.zzb<Leaderboards.LoadScoresResult> zzb2, String string, String string2, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zzjb()).zza((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), string, string2, n, n2, n3, bl);
    }

    public void zzb(zza.zzb<Leaderboards.LoadScoresResult> zzb2, String string, String string2, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zzjb()).zzb(new LeaderboardScoresLoadedBinderCallback(zzb2), string, string2, n, n2, n3, bl);
    }

    public void zzb(zza.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzjb()).zzb((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zzc(zza.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzjb()).zzc((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zzd(zza.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzjb()).zze(new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zzf(zza.zzb<Players.LoadPlayersResult> zzb2, String string, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzjb()).zzb((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, n, bl, bl2);
    }

    public void zzb(zza.zzb<Players.LoadPlayersResult> zzb2, String string, String string2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzjb()).zzb((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, string2, n, bl, bl2);
    }

    public void zzg(zza.zzb<Players.LoadOwnerCoverPhotoUrisResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzjb()).zzj(new OwnerCoverPhotoUrisLoadedBinderCallback(zzb2));
    }

    public void zzm(zza.zzb<Players.LoadXpForGameCategoriesResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzjb()).zzs(new PlayerXpForGameCategoriesLoadedBinderCallback(zzb2), string);
    }

    public void zzc(zza.zzb<Players.LoadXpStreamResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zzjb()).zzb((IGamesCallbacks)new PlayerXpStreamLoadedBinderCallback(zzb2), string, n);
    }

    public void zzd(zza.zzb<Players.LoadXpStreamResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zzjb()).zzc((IGamesCallbacks)new PlayerXpStreamLoadedBinderCallback(zzb2), string, n);
    }

    public void zzf(zza.zzb<Players.LoadProfileSettingsResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzjb()).zzg((IGamesCallbacks)new ProfileSettingsLoadedBinderCallback(zzb2), bl);
    }

    public void zzg(zza.zzb<Status> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzjb()).zzh((IGamesCallbacks)new ProfileSettingsUpdatedBinderCallback(zzb2), bl);
    }

    public void zzb(zza.zzb<Achievements.LoadAchievementsResult> zzb2, String string, String string2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzjb()).zza((IGamesCallbacks)new AchievementsLoadedBinderCallback(zzb2), string, string2, bl);
    }

    public void zzc(zza.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string, String string2) throws RemoteException {
        ((IGamesService)this.zzjb()).zzd((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string, string2);
    }

    public void zzd(zza.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string, String string2) throws RemoteException {
        ((IGamesService)this.zzjb()).zze((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string, string2);
    }

    public void zze(zza.zzb<Invitations.LoadInvitationsResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zzjb()).zzb((IGamesCallbacks)new InvitationsLoadedBinderCallback(zzb2), string, n, false);
    }

    public void zzn(zza.zzb<Invitations.LoadInvitationsResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzjb()).zzk(new InvitationsLoadedBinderCallback(zzb2), string);
    }

    public void zza(zza.zzb<TurnBasedMultiplayer.LoadMatchesResult> zzb2, String string, int n, int[] nArray) throws RemoteException {
        ((IGamesService)this.zzjb()).zza((IGamesCallbacks)new TurnBasedMatchesLoadedBinderCallbacks(zzb2), string, n, nArray);
    }

    public void zzh(zza.zzb<Acls.LoadAclResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzjb()).zzh(new NotifyAclLoadedBinderCallback(zzb2));
    }

    public void zzo(zza.zzb<Status> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzjb()).zzj(new NotifyAclUpdatedBinderCallback(zzb2), string);
    }

    public void zzd(zza.zzb<Notifications.GameMuteStatusChangeResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzjb()).zza((IGamesCallbacks)new GameMuteStatusChangedBinderCallback(zzb2), string, bl);
    }

    public void zzp(zza.zzb<Notifications.GameMuteStatusLoadResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzjb()).zzi(new GameMuteStatusLoadedBinderCallback(zzb2), string);
    }

    public void zzh(zza.zzb<Notifications.ContactSettingLoadResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzjb()).zze((IGamesCallbacks)new ContactSettingsLoadedBinderCallback(zzb2), bl);
    }

    public void zza(zza.zzb<Status> zzb2, boolean bl, Bundle bundle) throws RemoteException {
        ((IGamesService)this.zzjb()).zza((IGamesCallbacks)new ContactSettingsUpdatedBinderCallback(zzb2), bl, bundle);
    }

    public void zzi(zza.zzb<Notifications.InboxCountResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzjb()).zzt(new InboxCountsLoadedBinderCallback(zzb2), null);
    }

    public void zza(zza.zzb<Requests.SendRequestResult> zzb2, String string, String[] stringArray, int n, byte[] byArray, int n2) throws RemoteException {
        ((IGamesService)this.zzjb()).zza((IGamesCallbacks)new RequestSentBinderCallbacks(zzb2), string, stringArray, n, byArray, n2);
    }

    public void zza(zza.zzb<Requests.UpdateRequestsResult> zzb2, String string, String string2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zzjb()).zza((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(zzb2), string, string2, stringArray);
    }

    public void zza(zza.zzb<Requests.LoadRequestsResult> zzb2, String string, String string2, int n, int n2, int n3) throws RemoteException {
        ((IGamesService)this.zzjb()).zza((IGamesCallbacks)new RequestsLoadedBinderCallbacks(zzb2), string, string2, n, n2, n3);
    }

    public void zzf(zza.zzb<Requests.LoadRequestSummariesResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zzjb()).zza((IGamesCallbacks)new RequestSummariesLoadedBinderCallbacks(zzb2), string, n);
    }

    public void zzc(zza.zzb<Snapshots.LoadSnapshotsResult> zzb2, String string, String string2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzjb()).zzc((IGamesCallbacks)new SnapshotsLoadedBinderCallbacks(zzb2), string, string2, bl);
    }

    public void zza(IBinder iBinder, Bundle bundle) {
        if (this.isConnected()) {
            try {
                ((IGamesService)this.zzjb()).zza(iBinder, bundle);
            }
            catch (RemoteException remoteException) {
                GamesLog.zzr("GamesClientImpl", "service died");
            }
        }
    }

    public void zznL() {
        if (this.isConnected()) {
            try {
                ((IGamesService)this.zzjb()).zznL();
            }
            catch (RemoteException remoteException) {
                GamesLog.zzr("GamesClientImpl", "service died");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Room zzR(DataHolder dataHolder) {
        RoomBuffer roomBuffer = new RoomBuffer(dataHolder);
        Room room = null;
        try {
            if (roomBuffer.getCount() > 0) {
                room = (Room)((Room)roomBuffer.get(0)).freeze();
            }
        }
        finally {
            roomBuffer.release();
        }
        return room;
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle) {
        if (n == 0 && bundle != null) {
            bundle.setClassLoader(GamesClientImpl.class.getClassLoader());
            this.zzadU = bundle.getBoolean("show_welcome_popup");
            this.zzadR = (PlayerEntity)bundle.getParcelable("com.google.android.gms.games.current_player");
            this.zzadS = (GameEntity)bundle.getParcelable("com.google.android.gms.games.current_game");
        }
        super.zza(n, iBinder, bundle);
    }

    protected /* synthetic */ IInterface zzp(IBinder iBinder) {
        return this.zzaW(iBinder);
    }

    private static final class DeleteSnapshotResultImpl
    implements Snapshots.DeleteSnapshotResult {
        private final Status zzHb;
        private final String zzaef;

        DeleteSnapshotResultImpl(int statusCode, String snapshotId) {
            this.zzHb = GamesStatusCodes.zzep(statusCode);
            this.zzaef = snapshotId;
        }

        public Status getStatus() {
            return this.zzHb;
        }

        @Override
        public String getSnapshotId() {
            return this.zzaef;
        }
    }

    private static final class CommitSnapshotResultImpl
    extends GamesDataHolderResult
    implements Snapshots.CommitSnapshotResult {
        private final SnapshotMetadata zzaee;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        CommitSnapshotResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(dataHolder);
            try {
                this.zzaee = snapshotMetadataBuffer.getCount() > 0 ? new SnapshotMetadataEntity(snapshotMetadataBuffer.get(0)) : null;
            }
            finally {
                snapshotMetadataBuffer.release();
            }
        }

        @Override
        public SnapshotMetadata getSnapshotMetadata() {
            return this.zzaee;
        }
    }

    private static final class OpenSnapshotResultImpl
    extends GamesDataHolderResult
    implements Snapshots.OpenSnapshotResult {
        private final Snapshot zzaeJ;
        private final String zzaeK;
        private final Snapshot zzaeL;
        private final Contents zzaeM;
        private final SnapshotContents zzaeN;

        OpenSnapshotResultImpl(DataHolder dataHolder, Contents currentContents) {
            this(dataHolder, null, currentContents, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        OpenSnapshotResultImpl(DataHolder metadataHolder, String conflictId, Contents currentContents, Contents conflictContents, Contents resolutionContents) {
            super(metadataHolder);
            SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(metadataHolder);
            try {
                if (snapshotMetadataBuffer.getCount() == 0) {
                    this.zzaeJ = null;
                    this.zzaeL = null;
                } else if (snapshotMetadataBuffer.getCount() == 1) {
                    com.google.android.gms.common.internal.zzb.zzN((metadataHolder.getStatusCode() != 4004 ? 1 : 0) != 0);
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity(snapshotMetadataBuffer.get(0));
                    this.zzaeJ = new SnapshotEntity(snapshotMetadataEntity, new SnapshotContentsEntity(currentContents));
                    this.zzaeL = null;
                } else {
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity(snapshotMetadataBuffer.get(0));
                    this.zzaeJ = new SnapshotEntity(snapshotMetadataEntity, new SnapshotContentsEntity(currentContents));
                    SnapshotMetadataEntity snapshotMetadataEntity2 = new SnapshotMetadataEntity(snapshotMetadataBuffer.get(1));
                    this.zzaeL = new SnapshotEntity(snapshotMetadataEntity2, new SnapshotContentsEntity(conflictContents));
                }
            }
            finally {
                snapshotMetadataBuffer.release();
            }
            this.zzaeK = conflictId;
            this.zzaeM = resolutionContents;
            this.zzaeN = new SnapshotContentsEntity(resolutionContents);
        }

        @Override
        public Snapshot getSnapshot() {
            return this.zzaeJ;
        }

        @Override
        public String getConflictId() {
            return this.zzaeK;
        }

        @Override
        public Snapshot getConflictingSnapshot() {
            return this.zzaeL;
        }

        @Override
        public SnapshotContents getResolutionSnapshotContents() {
            return this.zzaeN;
        }
    }

    private static final class LoadSnapshotsResultImpl
    extends GamesDataHolderResult
    implements Snapshots.LoadSnapshotsResult {
        LoadSnapshotsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public SnapshotMetadataBuffer getSnapshots() {
            return new SnapshotMetadataBuffer(this.zzMd);
        }
    }

    private static final class LoadAppContentsResultImpl
    extends GamesDataHolderResult
    implements AppContents.LoadAppContentResult {
        private final ArrayList<DataHolder> zzaeo;

        LoadAppContentsResultImpl(DataHolder[] appContentData) {
            super(appContentData[0]);
            this.zzaeo = new ArrayList<DataHolder>(Arrays.asList(appContentData));
        }
    }

    private static final class ClaimMilestoneResultImpl
    extends GamesDataHolderResult
    implements Quests.ClaimMilestoneResult {
        private final Milestone zzaed;
        private final Quest zzaea;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ClaimMilestoneResultImpl(DataHolder dataHolder, String milestoneId) {
            super(dataHolder);
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            try {
                if (questBuffer.getCount() > 0) {
                    this.zzaea = new QuestEntity((Quest)questBuffer.get(0));
                    List<Milestone> list = this.zzaea.zzoZ();
                    int n = list.size();
                    for (int i = 0; i < n; ++i) {
                        if (!list.get(i).getMilestoneId().equals(milestoneId)) continue;
                        this.zzaed = list.get(i);
                        return;
                    }
                    this.zzaed = null;
                } else {
                    this.zzaed = null;
                    this.zzaea = null;
                }
            }
            finally {
                questBuffer.release();
            }
        }

        @Override
        public Milestone getMilestone() {
            return this.zzaed;
        }

        @Override
        public Quest getQuest() {
            return this.zzaea;
        }
    }

    private static final class AcceptQuestResultImpl
    extends GamesDataHolderResult
    implements Quests.AcceptQuestResult {
        private final Quest zzaea;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        AcceptQuestResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            try {
                this.zzaea = questBuffer.getCount() > 0 ? new QuestEntity((Quest)questBuffer.get(0)) : null;
            }
            finally {
                questBuffer.release();
            }
        }

        @Override
        public Quest getQuest() {
            return this.zzaea;
        }
    }

    private static final class LoadQuestsResultImpl
    extends GamesDataHolderResult
    implements Quests.LoadQuestsResult {
        private final DataHolder zzMd;

        LoadQuestsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzMd = dataHolder;
        }

        @Override
        public QuestBuffer getQuests() {
            return new QuestBuffer(this.zzMd);
        }
    }

    private static final class LoadRequestSummariesResultImpl
    extends GamesDataHolderResult
    implements Requests.LoadRequestSummariesResult {
        LoadRequestSummariesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class LoadRequestsResultImpl
    implements Requests.LoadRequestsResult {
        private final Status zzHb;
        private final Bundle zzaez;

        LoadRequestsResultImpl(Status status, Bundle requestData) {
            this.zzHb = status;
            this.zzaez = requestData;
        }

        public Status getStatus() {
            return this.zzHb;
        }

        @Override
        public GameRequestBuffer getRequests(int requestType) {
            String string = RequestType.zzeJ(requestType);
            if (!this.zzaez.containsKey(string)) {
                return null;
            }
            DataHolder dataHolder = (DataHolder)this.zzaez.get(string);
            return new GameRequestBuffer(dataHolder);
        }

        public void release() {
            for (String string : this.zzaez.keySet()) {
                DataHolder dataHolder = (DataHolder)this.zzaez.getParcelable(string);
                if (dataHolder == null) continue;
                dataHolder.close();
            }
        }
    }

    private static final class UpdateRequestsResultImpl
    extends GamesDataHolderResult
    implements Requests.UpdateRequestsResult {
        private final RequestUpdateOutcomes zzafo;

        UpdateRequestsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzafo = RequestUpdateOutcomes.zzW(dataHolder);
        }

        @Override
        public int getRequestOutcome(String requestId) {
            return this.zzafo.getRequestOutcome(requestId);
        }

        @Override
        public Set<String> getRequestIds() {
            return this.zzafo.getRequestIds();
        }
    }

    private static final class SendRequestResultImpl
    extends GamesDataHolderResult
    implements Requests.SendRequestResult {
        private final GameRequest zzaeW;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SendRequestResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            GameRequestBuffer gameRequestBuffer = new GameRequestBuffer(dataHolder);
            try {
                this.zzaeW = gameRequestBuffer.getCount() > 0 ? (GameRequest)((GameRequest)gameRequestBuffer.get(0)).freeze() : null;
            }
            finally {
                gameRequestBuffer.release();
            }
        }
    }

    private static final class InboxCountResultImpl
    implements Notifications.InboxCountResult {
        private final Status zzHb;
        private final Bundle zzaei;

        InboxCountResultImpl(Status status, Bundle inboxCounts) {
            this.zzHb = status;
            this.zzaei = inboxCounts;
        }

        public Status getStatus() {
            return this.zzHb;
        }
    }

    private static final class ContactSettingLoadResultImpl
    extends GamesDataHolderResult
    implements Notifications.ContactSettingLoadResult {
        ContactSettingLoadResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class GameMuteStatusLoadResultImpl
    implements Notifications.GameMuteStatusLoadResult {
        private final Status zzHb;
        private final String zzaeg;
        private final boolean zzaeh;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GameMuteStatusLoadResultImpl(DataHolder dataHolder) {
            try {
                this.zzHb = GamesStatusCodes.zzep(dataHolder.getStatusCode());
                if (dataHolder.getCount() > 0) {
                    this.zzaeg = dataHolder.zzc("external_game_id", 0, 0);
                    this.zzaeh = dataHolder.zzd("muted", 0, 0);
                } else {
                    this.zzaeg = null;
                    this.zzaeh = false;
                }
            }
            finally {
                dataHolder.close();
            }
        }

        public Status getStatus() {
            return this.zzHb;
        }
    }

    private static final class GameMuteStatusChangeResultImpl
    implements Notifications.GameMuteStatusChangeResult {
        private final Status zzHb;
        private final String zzaeg;
        private final boolean zzaeh;

        public GameMuteStatusChangeResultImpl(int statusCode, String externalGameId, boolean isMuted) {
            this.zzHb = GamesStatusCodes.zzep(statusCode);
            this.zzaeg = externalGameId;
            this.zzaeh = isMuted;
        }

        public Status getStatus() {
            return this.zzHb;
        }
    }

    private static final class LoadAclResultImpl
    extends GamesDataHolderResult
    implements Acls.LoadAclResult {
        LoadAclResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class CancelMatchResultImpl
    implements TurnBasedMultiplayer.CancelMatchResult {
        private final Status zzHb;
        private final String zzaec;

        CancelMatchResultImpl(Status status, String externalMatchId) {
            this.zzHb = status;
            this.zzaec = externalMatchId;
        }

        public Status getStatus() {
            return this.zzHb;
        }

        @Override
        public String getMatchId() {
            return this.zzaec;
        }
    }

    private static final class LeaveMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.LeaveMatchResult {
        LeaveMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class UpdateMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.UpdateMatchResult {
        UpdateMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class InitiateMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.InitiateMatchResult {
        InitiateMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class LoadMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.LoadMatchResult {
        LoadMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static abstract class TurnBasedMatchResult
    extends GamesDataHolderResult {
        final TurnBasedMatch zzaeG;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TurnBasedMatchResult(DataHolder dataHolder) {
            super(dataHolder);
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            try {
                this.zzaeG = turnBasedMatchBuffer.getCount() > 0 ? (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze() : null;
            }
            finally {
                turnBasedMatchBuffer.release();
            }
        }

        public TurnBasedMatch getMatch() {
            return this.zzaeG;
        }
    }

    private static final class SubmitScoreResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.SubmitScoreResult {
        private final ScoreSubmissionData zzafh;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SubmitScoreResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            try {
                this.zzafh = new ScoreSubmissionData(dataHolder);
            }
            finally {
                dataHolder.close();
            }
        }

        @Override
        public ScoreSubmissionData getScoreData() {
            return this.zzafh;
        }
    }

    private static final class LoadOwnerCoverPhotoUrisResultImpl
    implements Players.LoadOwnerCoverPhotoUrisResult {
        private final Status zzHb;
        private final Bundle zzGK;

        LoadOwnerCoverPhotoUrisResultImpl(int statusCode, Bundle bundle) {
            this.zzHb = GamesStatusCodes.zzep(statusCode);
            this.zzGK = bundle;
        }

        public Status getStatus() {
            return this.zzHb;
        }
    }

    private static final class LoadProfileSettingsResultImpl
    extends GamesDataHolderResult
    implements Players.LoadProfileSettingsResult {
        private final boolean zzadM;
        private final boolean zzaey;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LoadProfileSettingsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            try {
                if (dataHolder.getCount() > 0) {
                    int n = dataHolder.zzax(0);
                    this.zzadM = dataHolder.zzd("profile_visible", 0, n);
                    this.zzaey = dataHolder.zzd("profile_visibility_explicitly_set", 0, n);
                } else {
                    this.zzadM = true;
                    this.zzaey = false;
                }
            }
            finally {
                dataHolder.close();
            }
        }

        public Status getStatus() {
            return this.zzHb;
        }

        @Override
        public boolean isProfileVisible() {
            return this.zzadM;
        }

        @Override
        public boolean isVisibilityExplicitlySet() {
            return this.zzaey;
        }
    }

    private static final class LoadXpStreamResultImpl
    extends GamesDataHolderResult
    implements Players.LoadXpStreamResult {
        private final ExperienceEventBuffer zzaeE;

        LoadXpStreamResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaeE = new ExperienceEventBuffer(dataHolder);
        }
    }

    private static final class LoadXpForGameCategoriesResultImpl
    implements Players.LoadXpForGameCategoriesResult {
        private final Status zzHb;
        private final List<String> zzaeC;
        private final Bundle zzaeD;

        LoadXpForGameCategoriesResultImpl(Status status, Bundle xpData) {
            this.zzHb = status;
            this.zzaeC = xpData.getStringArrayList("game_category_list");
            this.zzaeD = xpData;
        }

        public Status getStatus() {
            return this.zzHb;
        }
    }

    private static final class LoadPlayersResultImpl
    extends GamesDataHolderResult
    implements Players.LoadPlayersResult {
        private final PlayerBuffer zzaex;

        LoadPlayersResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaex = new PlayerBuffer(dataHolder);
        }

        @Override
        public PlayerBuffer getPlayers() {
            return this.zzaex;
        }
    }

    private static final class LoadMatchesResultImpl
    implements TurnBasedMultiplayer.LoadMatchesResult {
        private final Status zzHb;
        private final LoadMatchesResponse zzaev;

        LoadMatchesResultImpl(Status status, Bundle matchData) {
            this.zzHb = status;
            this.zzaev = new LoadMatchesResponse(matchData);
        }

        public Status getStatus() {
            return this.zzHb;
        }

        @Override
        public LoadMatchesResponse getMatches() {
            return this.zzaev;
        }

        public void release() {
            this.zzaev.release();
        }
    }

    private static final class LoadInvitationsResultImpl
    extends GamesDataHolderResult
    implements Invitations.LoadInvitationsResult {
        private final InvitationBuffer zzaeu;

        LoadInvitationsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaeu = new InvitationBuffer(dataHolder);
        }

        @Override
        public InvitationBuffer getInvitations() {
            return this.zzaeu;
        }
    }

    private static final class LoadPlayerScoreResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.LoadPlayerScoreResult {
        private final LeaderboardScoreEntity zzaew;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LoadPlayerScoreResultImpl(DataHolder scoreHolder) {
            super(scoreHolder);
            LeaderboardScoreBuffer leaderboardScoreBuffer = new LeaderboardScoreBuffer(scoreHolder);
            try {
                this.zzaew = leaderboardScoreBuffer.getCount() > 0 ? (LeaderboardScoreEntity)leaderboardScoreBuffer.get(0).freeze() : null;
            }
            finally {
                leaderboardScoreBuffer.release();
            }
        }

        @Override
        public LeaderboardScore getScore() {
            return this.zzaew;
        }
    }

    private static final class LoadScoresResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.LoadScoresResult {
        private final LeaderboardEntity zzaeA;
        private final LeaderboardScoreBuffer zzaeB;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LoadScoresResultImpl(DataHolder leaderboard, DataHolder scores) {
            super(scores);
            LeaderboardBuffer leaderboardBuffer = new LeaderboardBuffer(leaderboard);
            try {
                this.zzaeA = leaderboardBuffer.getCount() > 0 ? (LeaderboardEntity)((Leaderboard)leaderboardBuffer.get(0)).freeze() : null;
            }
            finally {
                leaderboardBuffer.release();
            }
            this.zzaeB = new LeaderboardScoreBuffer(scores);
        }

        @Override
        public Leaderboard getLeaderboard() {
            return this.zzaeA;
        }

        @Override
        public LeaderboardScoreBuffer getScores() {
            return this.zzaeB;
        }
    }

    private static final class LeaderboardMetadataResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.LeaderboardMetadataResult {
        private final LeaderboardBuffer zzael;

        LeaderboardMetadataResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzael = new LeaderboardBuffer(dataHolder);
        }

        @Override
        public LeaderboardBuffer getLeaderboards() {
            return this.zzael;
        }
    }

    private static final class LoadGameSearchSuggestionsResultImpl
    extends GamesDataHolderResult
    implements GamesMetadata.LoadGameSearchSuggestionsResult {
        private final GameSearchSuggestionBuffer zzaes;

        LoadGameSearchSuggestionsResultImpl(DataHolder data) {
            super(data);
            this.zzaes = new GameSearchSuggestionBuffer(data);
        }
    }

    private static final class LoadGameInstancesResultImpl
    extends GamesDataHolderResult
    implements GamesMetadata.LoadGameInstancesResult {
        private final GameInstanceBuffer zzaer;

        LoadGameInstancesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaer = new GameInstanceBuffer(dataHolder);
        }
    }

    private static final class LoadExtendedGamesResultImpl
    extends GamesDataHolderResult
    implements GamesMetadata.LoadExtendedGamesResult {
        private final ExtendedGameBuffer zzaeq;

        LoadExtendedGamesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaeq = new ExtendedGameBuffer(dataHolder);
        }
    }

    private static final class LoadGamesResultImpl
    extends GamesDataHolderResult
    implements GamesMetadata.LoadGamesResult {
        private final GameBuffer zzaet;

        LoadGamesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaet = new GameBuffer(dataHolder);
        }

        @Override
        public GameBuffer getGames() {
            return this.zzaet;
        }
    }

    private static final class LoadEventResultImpl
    extends GamesDataHolderResult
    implements Events.LoadEventsResult {
        private final EventBuffer zzaep;

        LoadEventResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaep = new EventBuffer(dataHolder);
        }

        @Override
        public EventBuffer getEvents() {
            return this.zzaep;
        }
    }

    private static final class UpdateAchievementResultImpl
    implements Achievements.UpdateAchievementResult {
        private final Status zzHb;
        private final String zzacY;

        UpdateAchievementResultImpl(int statusCode, String achievementId) {
            this.zzHb = GamesStatusCodes.zzep(statusCode);
            this.zzacY = achievementId;
        }

        public Status getStatus() {
            return this.zzHb;
        }

        @Override
        public String getAchievementId() {
            return this.zzacY;
        }
    }

    private static final class LoadAchievementsResultImpl
    extends GamesDataHolderResult
    implements Achievements.LoadAchievementsResult {
        private final AchievementBuffer zzaen;

        LoadAchievementsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaen = new AchievementBuffer(dataHolder);
        }

        @Override
        public AchievementBuffer getAchievements() {
            return this.zzaen;
        }
    }

    private static abstract class GamesDataHolderResult
    extends zzc {
        protected GamesDataHolderResult(DataHolder dataHolder) {
            super(dataHolder, GamesStatusCodes.zzep(dataHolder.getStatusCode()));
        }
    }

    private static final class RealTimeMessageSentNotifier
    implements zze.zzb<RealTimeMultiplayer.ReliableMessageSentCallback> {
        private final int zzLs;
        private final String zzaeT;
        private final int zzaeU;

        RealTimeMessageSentNotifier(int statusCode, int token, String recipientParticipantId) {
            this.zzLs = statusCode;
            this.zzaeU = token;
            this.zzaeT = recipientParticipantId;
        }

        public void zza(RealTimeMultiplayer.ReliableMessageSentCallback reliableMessageSentCallback) {
            if (reliableMessageSentCallback != null) {
                reliableMessageSentCallback.onRealTimeMessageSent(this.zzLs, this.zzaeU, this.zzaeT);
            }
        }

        public void zzhX() {
        }

        public /* synthetic */ void zze(Object object) {
            this.zza((RealTimeMultiplayer.ReliableMessageSentCallback)object);
        }
    }

    private static final class MessageReceivedNotifier
    implements zze.zzb<RealTimeMessageReceivedListener> {
        private final RealTimeMessage zzaeH;

        MessageReceivedNotifier(RealTimeMessage message) {
            this.zzaeH = message;
        }

        public void zza(RealTimeMessageReceivedListener realTimeMessageReceivedListener) {
            realTimeMessageReceivedListener.onRealTimeMessageReceived(this.zzaeH);
        }

        public void zzhX() {
        }

        public /* synthetic */ void zze(Object object) {
            this.zza((RealTimeMessageReceivedListener)object);
        }
    }

    private static final class P2PDisconnectedNotifier
    implements zze.zzb<RoomStatusUpdateListener> {
        private final String zzaeO;

        P2PDisconnectedNotifier(String participantId) {
            this.zzaeO = participantId;
        }

        public void zza(RoomStatusUpdateListener roomStatusUpdateListener) {
            roomStatusUpdateListener.onP2PDisconnected(this.zzaeO);
        }

        public void zzhX() {
        }

        public /* synthetic */ void zze(Object object) {
            this.zza((RoomStatusUpdateListener)object);
        }
    }

    private static final class P2PConnectedNotifier
    implements zze.zzb<RoomStatusUpdateListener> {
        private final String zzaeO;

        P2PConnectedNotifier(String participantId) {
            this.zzaeO = participantId;
        }

        public void zza(RoomStatusUpdateListener roomStatusUpdateListener) {
            roomStatusUpdateListener.onP2PConnected(this.zzaeO);
        }

        public void zzhX() {
        }

        public /* synthetic */ void zze(Object object) {
            this.zza((RoomStatusUpdateListener)object);
        }
    }

    private static final class PeerDisconnectedNotifier
    extends AbstractPeerStatusNotifier {
        PeerDisconnectedNotifier(DataHolder dataHolder, String[] participantIds) {
            super(dataHolder, participantIds);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersDisconnected(room, arrayList);
        }
    }

    private static final class PeerConnectedNotifier
    extends AbstractPeerStatusNotifier {
        PeerConnectedNotifier(DataHolder dataHolder, String[] participantIds) {
            super(dataHolder, participantIds);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersConnected(room, arrayList);
        }
    }

    private static final class PeerDeclinedNotifier
    extends AbstractPeerStatusNotifier {
        PeerDeclinedNotifier(DataHolder dataHolder, String[] participantIds) {
            super(dataHolder, participantIds);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerDeclined(room, arrayList);
        }
    }

    private static final class PeerLeftRoomNotifier
    extends AbstractPeerStatusNotifier {
        PeerLeftRoomNotifier(DataHolder dataHolder, String[] participantIds) {
            super(dataHolder, participantIds);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerLeft(room, arrayList);
        }
    }

    private static final class PeerJoinedRoomNotifier
    extends AbstractPeerStatusNotifier {
        PeerJoinedRoomNotifier(DataHolder dataHolder, String[] participantIds) {
            super(dataHolder, participantIds);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerJoined(room, arrayList);
        }
    }

    private static final class PeerInvitedToRoomNotifier
    extends AbstractPeerStatusNotifier {
        PeerInvitedToRoomNotifier(DataHolder dataHolder, String[] participantIds) {
            super(dataHolder, participantIds);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerInvitedToRoom(room, arrayList);
        }
    }

    private static final class DisconnectedFromRoomNotifier
    extends AbstractRoomStatusNotifier {
        DisconnectedFromRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onDisconnectedFromRoom(room);
        }
    }

    private static final class ConnectedToRoomNotifier
    extends AbstractRoomStatusNotifier {
        ConnectedToRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onConnectedToRoom(room);
        }
    }

    private static final class RoomAutoMatchingNotifier
    extends AbstractRoomStatusNotifier {
        RoomAutoMatchingNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomAutoMatching(room);
        }
    }

    private static final class RoomConnectingNotifier
    extends AbstractRoomStatusNotifier {
        RoomConnectingNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomConnecting(room);
        }
    }

    private static final class RoomConnectedNotifier
    extends AbstractRoomNotifier {
        RoomConnectedNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onRoomConnected(n, room);
        }
    }

    private static final class LeftRoomNotifier
    implements zze.zzb<RoomUpdateListener> {
        private final int zzLs;
        private final String zzaem;

        LeftRoomNotifier(int statusCode, String roomId) {
            this.zzLs = statusCode;
            this.zzaem = roomId;
        }

        public void zza(RoomUpdateListener roomUpdateListener) {
            roomUpdateListener.onLeftRoom(this.zzLs, this.zzaem);
        }

        public void zzhX() {
        }

        public /* synthetic */ void zze(Object object) {
            this.zza((RoomUpdateListener)object);
        }
    }

    private static final class JoinedRoomNotifier
    extends AbstractRoomNotifier {
        public JoinedRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onJoinedRoom(n, room);
        }
    }

    private static final class RoomCreatedNotifier
    extends AbstractRoomNotifier {
        public RoomCreatedNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onRoomCreated(n, room);
        }
    }

    private static abstract class AbstractPeerStatusNotifier
    extends AbstractRoomStatusNotifier {
        private final ArrayList<String> zzadZ = new ArrayList();

        AbstractPeerStatusNotifier(DataHolder dataHolder, String[] participantIds) {
            super(dataHolder);
            int n = participantIds.length;
            for (int i = 0; i < n; ++i) {
                this.zzadZ.add(participantIds[i]);
            }
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            this.zza(roomStatusUpdateListener, room, this.zzadZ);
        }

        protected abstract void zza(RoomStatusUpdateListener var1, Room var2, ArrayList<String> var3);
    }

    private static abstract class AbstractRoomStatusNotifier
    extends zzb<RoomStatusUpdateListener> {
        AbstractRoomStatusNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder) {
            this.zza(roomStatusUpdateListener, GamesClientImpl.zzR(dataHolder));
        }

        protected abstract void zza(RoomStatusUpdateListener var1, Room var2);
    }

    private static abstract class AbstractRoomNotifier
    extends zzb<RoomUpdateListener> {
        AbstractRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        protected void zza(RoomUpdateListener roomUpdateListener, DataHolder dataHolder) {
            this.zza(roomUpdateListener, GamesClientImpl.zzR(dataHolder), dataHolder.getStatusCode());
        }

        protected abstract void zza(RoomUpdateListener var1, Room var2, int var3);
    }

    private static final class NearbyPlayerDetectedNotifier
    implements zze.zzb<OnNearbyPlayerDetectedListener> {
        private final Player zzaeI;

        public void zza(OnNearbyPlayerDetectedListener onNearbyPlayerDetectedListener) {
            onNearbyPlayerDetectedListener.zza(this.zzaeI);
        }

        public void zzhX() {
        }

        public /* synthetic */ void zze(Object object) {
            this.zza((OnNearbyPlayerDetectedListener)object);
        }
    }

    private static final class RequestRemovedNotifier
    implements zze.zzb<OnRequestReceivedListener> {
        private final String zzxv;

        RequestRemovedNotifier(String requestId) {
            this.zzxv = requestId;
        }

        public void zza(OnRequestReceivedListener onRequestReceivedListener) {
            onRequestReceivedListener.onRequestRemoved(this.zzxv);
        }

        public void zzhX() {
        }

        public /* synthetic */ void zze(Object object) {
            this.zza((OnRequestReceivedListener)object);
        }
    }

    private static final class RequestReceivedNotifier
    implements zze.zzb<OnRequestReceivedListener> {
        private final GameRequest zzaeW;

        RequestReceivedNotifier(GameRequest request) {
            this.zzaeW = request;
        }

        public void zza(OnRequestReceivedListener onRequestReceivedListener) {
            onRequestReceivedListener.onRequestReceived(this.zzaeW);
        }

        public void zzhX() {
        }

        public /* synthetic */ void zze(Object object) {
            this.zza((OnRequestReceivedListener)object);
        }
    }

    private static final class QuestCompletedNotifier
    implements zze.zzb<QuestUpdateListener> {
        private final Quest zzaea;

        QuestCompletedNotifier(Quest quest) {
            this.zzaea = quest;
        }

        public void zza(QuestUpdateListener questUpdateListener) {
            questUpdateListener.onQuestCompleted(this.zzaea);
        }

        public void zzhX() {
        }

        public /* synthetic */ void zze(Object object) {
            this.zza((QuestUpdateListener)object);
        }
    }

    private static final class MatchRemovedNotifier
    implements zze.zzb<OnTurnBasedMatchUpdateReceivedListener> {
        private final String zzaeF;

        MatchRemovedNotifier(String matchId) {
            this.zzaeF = matchId;
        }

        public void zza(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchRemoved(this.zzaeF);
        }

        public void zzhX() {
        }

        public /* synthetic */ void zze(Object object) {
            this.zza((OnTurnBasedMatchUpdateReceivedListener)object);
        }
    }

    private static final class MatchUpdateReceivedNotifier
    implements zze.zzb<OnTurnBasedMatchUpdateReceivedListener> {
        private final TurnBasedMatch zzaeG;

        MatchUpdateReceivedNotifier(TurnBasedMatch match) {
            this.zzaeG = match;
        }

        public void zza(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchReceived(this.zzaeG);
        }

        public void zzhX() {
        }

        public /* synthetic */ void zze(Object object) {
            this.zza((OnTurnBasedMatchUpdateReceivedListener)object);
        }
    }

    private static final class InvitationRemovedNotifier
    implements zze.zzb<OnInvitationReceivedListener> {
        private final String zzaek;

        InvitationRemovedNotifier(String invitationId) {
            this.zzaek = invitationId;
        }

        public void zza(OnInvitationReceivedListener onInvitationReceivedListener) {
            onInvitationReceivedListener.onInvitationRemoved(this.zzaek);
        }

        public void zzhX() {
        }

        public /* synthetic */ void zze(Object object) {
            this.zza((OnInvitationReceivedListener)object);
        }
    }

    private static final class InvitationReceivedNotifier
    implements zze.zzb<OnInvitationReceivedListener> {
        private final Invitation zzaej;

        InvitationReceivedNotifier(Invitation invitation) {
            this.zzaej = invitation;
        }

        public void zza(OnInvitationReceivedListener onInvitationReceivedListener) {
            onInvitationReceivedListener.onInvitationReceived(this.zzaej);
        }

        public void zzhX() {
        }

        public /* synthetic */ void zze(Object object) {
            this.zza((OnInvitationReceivedListener)object);
        }
    }

    static final class SnapshotDeletedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<Snapshots.DeleteSnapshotResult> zzHa;

        public SnapshotDeletedBinderCallbacks(zza.zzb<Snapshots.DeleteSnapshotResult> resultHolder) {
            this.zzHa = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzh(int n, String string) {
            this.zzHa.zzd((Object)new DeleteSnapshotResultImpl(n, string));
        }
    }

    private static final class SnapshotCommittedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<Snapshots.CommitSnapshotResult> zzafe;

        public SnapshotCommittedBinderCallbacks(zza.zzb<Snapshots.CommitSnapshotResult> resultHolder) {
            this.zzafe = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzJ(DataHolder dataHolder) {
            this.zzafe.zzd((Object)new CommitSnapshotResultImpl(dataHolder));
        }
    }

    private static final class SnapshotOpenedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<Snapshots.OpenSnapshotResult> zzaff;

        public SnapshotOpenedBinderCallbacks(zza.zzb<Snapshots.OpenSnapshotResult> resultHolder) {
            this.zzaff = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zza(DataHolder dataHolder, Contents contents) {
            this.zzaff.zzd((Object)new OpenSnapshotResultImpl(dataHolder, contents));
        }

        @Override
        public void zza(DataHolder dataHolder, String string, Contents contents, Contents contents2, Contents contents3) {
            this.zzaff.zzd((Object)new OpenSnapshotResultImpl(dataHolder, string, contents, contents2, contents3));
        }
    }

    private static final class SnapshotsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<Snapshots.LoadSnapshotsResult> zzafg;

        public SnapshotsLoadedBinderCallbacks(zza.zzb<Snapshots.LoadSnapshotsResult> resultHolder) {
            this.zzafg = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzI(DataHolder dataHolder) {
            this.zzafg.zzd((Object)new LoadSnapshotsResultImpl(dataHolder));
        }
    }

    private static final class AppContentLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<AppContents.LoadAppContentResult> zzaeb;

        public AppContentLoadedBinderCallbacks(zza.zzb<AppContents.LoadAppContentResult> resultHolder) {
            this.zzaeb = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zza(DataHolder[] dataHolderArray) {
            this.zzaeb.zzd((Object)new LoadAppContentsResultImpl(dataHolderArray));
        }
    }

    private static final class QuestsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<Quests.LoadQuestsResult> zzaeS;

        public QuestsLoadedBinderCallbacks(zza.zzb<Quests.LoadQuestsResult> resultHolder) {
            this.zzaeS = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzO(DataHolder dataHolder) {
            this.zzaeS.zzd((Object)new LoadQuestsResultImpl(dataHolder));
        }
    }

    private static final class QuestMilestoneClaimBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<Quests.ClaimMilestoneResult> zzaeQ;
        private final String zzaeR;

        public QuestMilestoneClaimBinderCallbacks(zza.zzb<Quests.ClaimMilestoneResult> resultHolder, String milestoneId) {
            this.zzaeQ = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
            this.zzaeR = (String)zzx.zzb((Object)milestoneId, (Object)"MilestoneId must not be null");
        }

        @Override
        public void zzK(DataHolder dataHolder) {
            this.zzaeQ.zzd((Object)new ClaimMilestoneResultImpl(dataHolder, this.zzaeR));
        }
    }

    private static final class QuestAcceptedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<Quests.AcceptQuestResult> zzaeP;

        public QuestAcceptedBinderCallbacks(zza.zzb<Quests.AcceptQuestResult> resultHolder) {
            this.zzaeP = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzL(DataHolder dataHolder) {
            this.zzaeP.zzd((Object)new AcceptQuestResultImpl(dataHolder));
        }
    }

    private static final class RequestSummariesLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<Requests.LoadRequestSummariesResult> zzaeY;

        public RequestSummariesLoadedBinderCallbacks(zza.zzb<Requests.LoadRequestSummariesResult> resultHolder) {
            this.zzaeY = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzH(DataHolder dataHolder) {
            this.zzaeY.zzd((Object)new LoadRequestSummariesResultImpl(dataHolder));
        }
    }

    private static final class RequestsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<Requests.LoadRequestsResult> zzaeZ;

        public RequestsLoadedBinderCallbacks(zza.zzb<Requests.LoadRequestsResult> resultHolder) {
            this.zzaeZ = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zze(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzep(n);
            this.zzaeZ.zzd((Object)new LoadRequestsResultImpl(status, bundle));
        }
    }

    private static final class RequestSentBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<Requests.SendRequestResult> zzaeX;

        public RequestSentBinderCallbacks(zza.zzb<Requests.SendRequestResult> resultHolder) {
            this.zzaeX = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzG(DataHolder dataHolder) {
            this.zzaeX.zzd((Object)new SendRequestResultImpl(dataHolder));
        }
    }

    private static final class RequestsUpdatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<Requests.UpdateRequestsResult> zzafa;

        public RequestsUpdatedBinderCallbacks(zza.zzb<Requests.UpdateRequestsResult> resultHolder) {
            this.zzafa = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzF(DataHolder dataHolder) {
            this.zzafa.zzd((Object)new UpdateRequestsResultImpl(dataHolder));
        }
    }

    private static final class PopupLocationInfoBinderCallbacks
    extends AbstractGamesClient {
        private final PopupManager zzadT;

        public PopupLocationInfoBinderCallbacks(PopupManager popupManager) {
            this.zzadT = popupManager;
        }

        @Override
        public PopupLocationInfoParcelable zznk() {
            return new PopupLocationInfoParcelable(this.zzadT.zzof());
        }
    }

    private static final class SignOutCompleteBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<Status> zzHa;

        public SignOutCompleteBinderCallbacks(zza.zzb<Status> resultHolder) {
            this.zzHa = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzhb() {
            Status status = GamesStatusCodes.zzep(0);
            this.zzHa.zzd((Object)status);
        }
    }

    private static final class InboxCountsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Notifications.InboxCountResult> zzHa;

        InboxCountsLoadedBinderCallback(zza.zzb<Notifications.InboxCountResult> holder) {
            this.zzHa = (zza.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzh(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzep(n);
            this.zzHa.zzd((Object)new InboxCountResultImpl(status, bundle));
        }
    }

    private static final class ContactSettingsUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Status> zzHa;

        ContactSettingsUpdatedBinderCallback(zza.zzb<Status> holder) {
            this.zzHa = (zza.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzey(int n) {
            this.zzHa.zzd((Object)GamesStatusCodes.zzep(n));
        }
    }

    private static final class ContactSettingsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Notifications.ContactSettingLoadResult> zzHa;

        ContactSettingsLoadedBinderCallback(zza.zzb<Notifications.ContactSettingLoadResult> holder) {
            this.zzHa = (zza.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzD(DataHolder dataHolder) {
            this.zzHa.zzd((Object)new ContactSettingLoadResultImpl(dataHolder));
        }
    }

    private static final class GameMuteStatusLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Notifications.GameMuteStatusLoadResult> zzHa;

        GameMuteStatusLoadedBinderCallback(zza.zzb<Notifications.GameMuteStatusLoadResult> holder) {
            this.zzHa = (zza.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzB(DataHolder dataHolder) {
            this.zzHa.zzd((Object)new GameMuteStatusLoadResultImpl(dataHolder));
        }
    }

    private static final class GameMuteStatusChangedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Notifications.GameMuteStatusChangeResult> zzHa;

        GameMuteStatusChangedBinderCallback(zza.zzb<Notifications.GameMuteStatusChangeResult> holder) {
            this.zzHa = (zza.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zza(int n, String string, boolean bl) {
            this.zzHa.zzd((Object)new GameMuteStatusChangeResultImpl(n, string, bl));
        }
    }

    private static final class NotifyAclUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Status> zzHa;

        NotifyAclUpdatedBinderCallback(zza.zzb<Status> resultHolder) {
            this.zzHa = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzex(int n) {
            this.zzHa.zzd((Object)GamesStatusCodes.zzep(n));
        }
    }

    private static final class NotifyAclLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Acls.LoadAclResult> zzHa;

        NotifyAclLoadedBinderCallback(zza.zzb<Acls.LoadAclResult> resultHolder) {
            this.zzHa = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzC(DataHolder dataHolder) {
            this.zzHa.zzd((Object)new LoadAclResultImpl(dataHolder));
        }
    }

    private static final class RealTimeReliableMessageBinderCallbacks
    extends AbstractGamesCallbacks {
        final zze<RealTimeMultiplayer.ReliableMessageSentCallback> zzaeV;

        public RealTimeReliableMessageBinderCallbacks(zze<RealTimeMultiplayer.ReliableMessageSentCallback> messageSentCallbacks) {
            this.zzaeV = messageSentCallbacks;
        }

        @Override
        public void zzb(int n, int n2, String string) {
            if (this.zzaeV != null) {
                this.zzaeV.zza((zze.zzb)new RealTimeMessageSentNotifier(n, n2, string));
            }
        }
    }

    private static final class RoomBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zze<? extends RoomUpdateListener> zzafb;
        private final zze<? extends RoomStatusUpdateListener> zzafc;
        private final zze<RealTimeMessageReceivedListener> zzafd;

        public RoomBinderCallbacks(zze<RoomUpdateListener> roomCallbacks) {
            this.zzafb = (zze)zzx.zzb(roomCallbacks, (Object)"Callbacks must not be null");
            this.zzafc = null;
            this.zzafd = null;
        }

        public RoomBinderCallbacks(zze<? extends RoomUpdateListener> roomCallbacks, zze<? extends RoomStatusUpdateListener> roomStatusCallbacks, zze<RealTimeMessageReceivedListener> realTimeMessageReceivedCallbacks) {
            this.zzafb = (zze)zzx.zzb(roomCallbacks, (Object)"Callbacks must not be null");
            this.zzafc = roomStatusCallbacks;
            this.zzafd = realTimeMessageReceivedCallbacks;
        }

        @Override
        public void zzu(DataHolder dataHolder) {
            this.zzafb.zza((zze.zzb)new RoomCreatedNotifier(dataHolder));
        }

        @Override
        public void zzv(DataHolder dataHolder) {
            this.zzafb.zza((zze.zzb)new JoinedRoomNotifier(dataHolder));
        }

        @Override
        public void onLeftRoom(int statusCode, String externalRoomId) {
            this.zzafb.zza((zze.zzb)new LeftRoomNotifier(statusCode, externalRoomId));
        }

        @Override
        public void zzy(DataHolder dataHolder) {
            this.zzafb.zza((zze.zzb)new RoomConnectedNotifier(dataHolder));
        }

        @Override
        public void zzw(DataHolder dataHolder) {
            if (this.zzafc != null) {
                this.zzafc.zza((zze.zzb)new RoomConnectingNotifier(dataHolder));
            }
        }

        @Override
        public void zzx(DataHolder dataHolder) {
            if (this.zzafc != null) {
                this.zzafc.zza((zze.zzb)new RoomAutoMatchingNotifier(dataHolder));
            }
        }

        @Override
        public void zzz(DataHolder dataHolder) {
            if (this.zzafc != null) {
                this.zzafc.zza((zze.zzb)new ConnectedToRoomNotifier(dataHolder));
            }
        }

        @Override
        public void zzA(DataHolder dataHolder) {
            if (this.zzafc != null) {
                this.zzafc.zza((zze.zzb)new DisconnectedFromRoomNotifier(dataHolder));
            }
        }

        @Override
        public void zze(DataHolder dataHolder, String[] stringArray) {
            if (this.zzafc != null) {
                this.zzafc.zza((zze.zzb)new PeerConnectedNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzf(DataHolder dataHolder, String[] stringArray) {
            if (this.zzafc != null) {
                this.zzafc.zza((zze.zzb)new PeerDisconnectedNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zza(DataHolder dataHolder, String[] stringArray) {
            if (this.zzafc != null) {
                this.zzafc.zza((zze.zzb)new PeerInvitedToRoomNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzb(DataHolder dataHolder, String[] stringArray) {
            if (this.zzafc != null) {
                this.zzafc.zza((zze.zzb)new PeerJoinedRoomNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzc(DataHolder dataHolder, String[] stringArray) {
            if (this.zzafc != null) {
                this.zzafc.zza((zze.zzb)new PeerLeftRoomNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzd(DataHolder dataHolder, String[] stringArray) {
            if (this.zzafc != null) {
                this.zzafc.zza((zze.zzb)new PeerDeclinedNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void onP2PConnected(String participantId) {
            if (this.zzafc != null) {
                this.zzafc.zza((zze.zzb)new P2PConnectedNotifier(participantId));
            }
        }

        @Override
        public void onP2PDisconnected(String participantId) {
            if (this.zzafc != null) {
                this.zzafc.zza((zze.zzb)new P2PDisconnectedNotifier(participantId));
            }
        }

        @Override
        public void onRealTimeMessageReceived(RealTimeMessage message) {
            if (this.zzafd != null) {
                this.zzafd.zza((zze.zzb)new MessageReceivedNotifier(message));
            }
        }
    }

    private static final class TurnBasedMatchCanceledBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<TurnBasedMultiplayer.CancelMatchResult> zzafi;

        public TurnBasedMatchCanceledBinderCallbacks(zza.zzb<TurnBasedMultiplayer.CancelMatchResult> resultHolder) {
            this.zzafi = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzg(int n, String string) {
            Status status = GamesStatusCodes.zzep(n);
            this.zzafi.zzd((Object)new CancelMatchResultImpl(status, string));
        }
    }

    private static final class TurnBasedMatchLeftBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<TurnBasedMultiplayer.LeaveMatchResult> zzafk;

        public TurnBasedMatchLeftBinderCallbacks(zza.zzb<TurnBasedMultiplayer.LeaveMatchResult> resultHolder) {
            this.zzafk = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzs(DataHolder dataHolder) {
            this.zzafk.zzd((Object)new LeaveMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchUpdatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<TurnBasedMultiplayer.UpdateMatchResult> zzafm;

        public TurnBasedMatchUpdatedBinderCallbacks(zza.zzb<TurnBasedMultiplayer.UpdateMatchResult> resultHolder) {
            this.zzafm = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzr(DataHolder dataHolder) {
            this.zzafm.zzd((Object)new UpdateMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchInitiatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzafj;

        public TurnBasedMatchInitiatedBinderCallbacks(zza.zzb<TurnBasedMultiplayer.InitiateMatchResult> resultHolder) {
            this.zzafj = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzq(DataHolder dataHolder) {
            this.zzafj.zzd((Object)new InitiateMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<TurnBasedMultiplayer.LoadMatchResult> zzafl;

        public TurnBasedMatchLoadedBinderCallbacks(zza.zzb<TurnBasedMultiplayer.LoadMatchResult> resultHolder) {
            this.zzafl = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzp(DataHolder dataHolder) {
            this.zzafl.zzd((Object)new LoadMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchesLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<TurnBasedMultiplayer.LoadMatchesResult> zzafn;

        public TurnBasedMatchesLoadedBinderCallbacks(zza.zzb<TurnBasedMultiplayer.LoadMatchesResult> resultHolder) {
            this.zzafn = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzd(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzep(n);
            this.zzafn.zzd((Object)new LoadMatchesResultImpl(status, bundle));
        }
    }

    private static final class SubmitScoreBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<Leaderboards.SubmitScoreResult> zzHa;

        public SubmitScoreBinderCallbacks(zza.zzb<Leaderboards.SubmitScoreResult> resultHolder) {
            this.zzHa = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzf(DataHolder dataHolder) {
            this.zzHa.zzd((Object)new SubmitScoreResultImpl(dataHolder));
        }
    }

    private static final class OwnerCoverPhotoUrisLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Players.LoadOwnerCoverPhotoUrisResult> zzHa;

        OwnerCoverPhotoUrisLoadedBinderCallback(zza.zzb<Players.LoadOwnerCoverPhotoUrisResult> holder) {
            this.zzHa = (zza.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzf(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            this.zzHa.zzd((Object)new LoadOwnerCoverPhotoUrisResultImpl(n, bundle));
        }
    }

    private static final class ProfileSettingsUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Status> zzHa;

        ProfileSettingsUpdatedBinderCallback(zza.zzb<Status> holder) {
            this.zzHa = (zza.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzez(int n) {
            this.zzHa.zzd((Object)GamesStatusCodes.zzep(n));
        }
    }

    static final class ProfileSettingsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Players.LoadProfileSettingsResult> zzHa;

        ProfileSettingsLoadedBinderCallback(zza.zzb<Players.LoadProfileSettingsResult> holder) {
            this.zzHa = (zza.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzQ(DataHolder dataHolder) {
            this.zzHa.zzd((Object)new LoadProfileSettingsResultImpl(dataHolder));
        }
    }

    static final class PlayerXpStreamLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Players.LoadXpStreamResult> zzHa;

        PlayerXpStreamLoadedBinderCallback(zza.zzb<Players.LoadXpStreamResult> holder) {
            this.zzHa = (zza.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzP(DataHolder dataHolder) {
            this.zzHa.zzd((Object)new LoadXpStreamResultImpl(dataHolder));
        }
    }

    private static final class PlayerXpForGameCategoriesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Players.LoadXpForGameCategoriesResult> zzHa;

        PlayerXpForGameCategoriesLoadedBinderCallback(zza.zzb<Players.LoadXpForGameCategoriesResult> holder) {
            this.zzHa = (zza.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzg(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzep(n);
            this.zzHa.zzd((Object)new LoadXpForGameCategoriesResultImpl(status, bundle));
        }
    }

    private static final class PlayersLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Players.LoadPlayersResult> zzHa;

        PlayersLoadedBinderCallback(zza.zzb<Players.LoadPlayersResult> holder) {
            this.zzHa = (zza.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzg(DataHolder dataHolder) {
            this.zzHa.zzd((Object)new LoadPlayersResultImpl(dataHolder));
        }

        @Override
        public void zzh(DataHolder dataHolder) {
            this.zzHa.zzd((Object)new LoadPlayersResultImpl(dataHolder));
        }
    }

    private static final class RequestReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final zze<OnRequestReceivedListener> zzTW;

        RequestReceivedBinderCallback(zze<OnRequestReceivedListener> listener) {
            this.zzTW = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzo(DataHolder dataHolder) {
            GameRequestBuffer gameRequestBuffer = new GameRequestBuffer(dataHolder);
            GameRequest gameRequest = null;
            try {
                if (gameRequestBuffer.getCount() > 0) {
                    gameRequest = (GameRequest)((GameRequest)gameRequestBuffer.get(0)).freeze();
                }
            }
            finally {
                gameRequestBuffer.release();
            }
            if (gameRequest != null) {
                this.zzTW.zza((zze.zzb)new RequestReceivedNotifier(gameRequest));
            }
        }

        @Override
        public void onRequestRemoved(String requestId) {
            this.zzTW.zza((zze.zzb)new RequestRemovedNotifier(requestId));
        }
    }

    private static final class QuestUpdateBinderCallback
    extends AbstractGamesCallbacks {
        private final zze<QuestUpdateListener> zzTW;

        QuestUpdateBinderCallback(zze<QuestUpdateListener> listener) {
            this.zzTW = listener;
        }

        @Override
        public void zzM(DataHolder dataHolder) {
            Quest quest = this.zzT(dataHolder);
            if (quest != null) {
                this.zzTW.zza((zze.zzb)new QuestCompletedNotifier(quest));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Quest zzT(DataHolder dataHolder) {
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            Quest quest = null;
            try {
                if (questBuffer.getCount() > 0) {
                    quest = (Quest)((Quest)questBuffer.get(0)).freeze();
                }
            }
            finally {
                questBuffer.release();
            }
            return quest;
        }
    }

    private static final class MatchUpdateReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final zze<OnTurnBasedMatchUpdateReceivedListener> zzTW;

        MatchUpdateReceivedBinderCallback(zze<OnTurnBasedMatchUpdateReceivedListener> listener) {
            this.zzTW = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzt(DataHolder dataHolder) {
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            TurnBasedMatch turnBasedMatch = null;
            try {
                if (turnBasedMatchBuffer.getCount() > 0) {
                    turnBasedMatch = (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze();
                }
            }
            finally {
                turnBasedMatchBuffer.release();
            }
            if (turnBasedMatch != null) {
                this.zzTW.zza((zze.zzb)new MatchUpdateReceivedNotifier(turnBasedMatch));
            }
        }

        @Override
        public void onTurnBasedMatchRemoved(String matchId) {
            this.zzTW.zza((zze.zzb)new MatchRemovedNotifier(matchId));
        }
    }

    private static final class InvitationReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final zze<OnInvitationReceivedListener> zzTW;

        InvitationReceivedBinderCallback(zze<OnInvitationReceivedListener> listener) {
            this.zzTW = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzn(DataHolder dataHolder) {
            InvitationBuffer invitationBuffer = new InvitationBuffer(dataHolder);
            Invitation invitation = null;
            try {
                if (invitationBuffer.getCount() > 0) {
                    invitation = (Invitation)((Invitation)invitationBuffer.get(0)).freeze();
                }
            }
            finally {
                invitationBuffer.release();
            }
            if (invitation != null) {
                this.zzTW.zza((zze.zzb)new InvitationReceivedNotifier(invitation));
            }
        }

        @Override
        public void onInvitationRemoved(String invitationId) {
            this.zzTW.zza((zze.zzb)new InvitationRemovedNotifier(invitationId));
        }
    }

    private static final class InvitationsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Invitations.LoadInvitationsResult> zzHa;

        InvitationsLoadedBinderCallback(zza.zzb<Invitations.LoadInvitationsResult> resultHolder) {
            this.zzHa = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzm(DataHolder dataHolder) {
            this.zzHa.zzd((Object)new LoadInvitationsResultImpl(dataHolder));
        }
    }

    private static final class PlayerLeaderboardScoreLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Leaderboards.LoadPlayerScoreResult> zzHa;

        PlayerLeaderboardScoreLoadedBinderCallback(zza.zzb<Leaderboards.LoadPlayerScoreResult> resultHolder) {
            this.zzHa = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzE(DataHolder dataHolder) {
            this.zzHa.zzd((Object)new LoadPlayerScoreResultImpl(dataHolder));
        }
    }

    private static final class LeaderboardScoresLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Leaderboards.LoadScoresResult> zzHa;

        LeaderboardScoresLoadedBinderCallback(zza.zzb<Leaderboards.LoadScoresResult> resultHolder) {
            this.zzHa = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zza(DataHolder dataHolder, DataHolder dataHolder2) {
            this.zzHa.zzd((Object)new LoadScoresResultImpl(dataHolder, dataHolder2));
        }
    }

    private static final class LeaderboardsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Leaderboards.LeaderboardMetadataResult> zzHa;

        LeaderboardsLoadedBinderCallback(zza.zzb<Leaderboards.LeaderboardMetadataResult> resultHolder) {
            this.zzHa = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zze(DataHolder dataHolder) {
            this.zzHa.zzd((Object)new LeaderboardMetadataResultImpl(dataHolder));
        }
    }

    private static final class GameSearchSuggestionsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<GamesMetadata.LoadGameSearchSuggestionsResult> zzHa;

        GameSearchSuggestionsLoadedBinderCallback(zza.zzb<GamesMetadata.LoadGameSearchSuggestionsResult> holder) {
            this.zzHa = (zza.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzl(DataHolder dataHolder) {
            this.zzHa.zzd((Object)new LoadGameSearchSuggestionsResultImpl(dataHolder));
        }
    }

    private static final class GameInstancesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<GamesMetadata.LoadGameInstancesResult> zzHa;

        GameInstancesLoadedBinderCallback(zza.zzb<GamesMetadata.LoadGameInstancesResult> holder) {
            this.zzHa = (zza.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzk(DataHolder dataHolder) {
            this.zzHa.zzd((Object)new LoadGameInstancesResultImpl(dataHolder));
        }
    }

    private static final class ExtendedGamesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<GamesMetadata.LoadExtendedGamesResult> zzHa;

        ExtendedGamesLoadedBinderCallback(zza.zzb<GamesMetadata.LoadExtendedGamesResult> holder) {
            this.zzHa = (zza.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzj(DataHolder dataHolder) {
            this.zzHa.zzd((Object)new LoadExtendedGamesResultImpl(dataHolder));
        }
    }

    private static final class EventsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Events.LoadEventsResult> zzHa;

        EventsLoadedBinderCallback(zza.zzb<Events.LoadEventsResult> resultHolder) {
            this.zzHa = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzd(DataHolder dataHolder) {
            this.zzHa.zzd((Object)new LoadEventResultImpl(dataHolder));
        }
    }

    private static final class GamesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<GamesMetadata.LoadGamesResult> zzHa;

        GamesLoadedBinderCallback(zza.zzb<GamesMetadata.LoadGamesResult> holder) {
            this.zzHa = (zza.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzi(DataHolder dataHolder) {
            this.zzHa.zzd((Object)new LoadGamesResultImpl(dataHolder));
        }
    }

    private static final class AchievementUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Achievements.UpdateAchievementResult> zzHa;

        AchievementUpdatedBinderCallback(zza.zzb<Achievements.UpdateAchievementResult> resultHolder) {
            this.zzHa = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzf(int n, String string) {
            this.zzHa.zzd((Object)new UpdateAchievementResultImpl(n, string));
        }
    }

    private static final class AchievementsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Achievements.LoadAchievementsResult> zzHa;

        AchievementsLoadedBinderCallback(zza.zzb<Achievements.LoadAchievementsResult> resultHolder) {
            this.zzHa = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzc(DataHolder dataHolder) {
            this.zzHa.zzd((Object)new LoadAchievementsResultImpl(dataHolder));
        }
    }

    private class GameClientEventIncrementCache
    extends EventIncrementCache {
        public GameClientEventIncrementCache() {
            super(GamesClientImpl.this.getContext().getMainLooper(), 1000);
        }

        @Override
        protected void zzs(String string, int n) {
            try {
                if (GamesClientImpl.this.isConnected()) {
                    ((IGamesService)GamesClientImpl.this.zzjb()).zzp(string, n);
                } else {
                    GamesLog.zzs("GamesClientImpl", "Unable to increment event " + string + " by " + n + " because the games client is no longer connected");
                }
            }
            catch (RemoteException remoteException) {
                GamesLog.zzr("GamesClientImpl", "service died");
            }
        }
    }
}

