/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.game;

import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.game.GameBadge;
import com.google.android.gms.games.internal.game.GameBadgeEntityCreator;

public final class GameBadgeEntity
extends GamesDowngradeableSafeParcel
implements GameBadge {
    public static final GameBadgeEntityCreator CREATOR = new GameBadgeEntityCreatorCompat();
    private final int zzFG;
    private int zzJp;
    private String zzSy;
    private String zzZO;
    private Uri zzacc;

    public GameBadgeEntity(GameBadge gameBadge) {
        this.zzFG = 1;
        this.zzJp = gameBadge.getType();
        this.zzSy = gameBadge.getTitle();
        this.zzZO = gameBadge.getDescription();
        this.zzacc = gameBadge.getIconImageUri();
    }

    GameBadgeEntity(int versionCode, int type, String title, String description, Uri iconImageUri) {
        this.zzFG = versionCode;
        this.zzJp = type;
        this.zzSy = title;
        this.zzZO = description;
        this.zzacc = iconImageUri;
    }

    public int getVersionCode() {
        return this.zzFG;
    }

    @Override
    public int getType() {
        return this.zzJp;
    }

    @Override
    public String getTitle() {
        return this.zzSy;
    }

    @Override
    public String getDescription() {
        return this.zzZO;
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzacc;
    }

    public GameBadge zzot() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameBadgeEntity.zza(this);
    }

    static int zza(GameBadge gameBadge) {
        return zzw.hashCode((Object[])new Object[]{gameBadge.getType(), gameBadge.getTitle(), gameBadge.getDescription(), gameBadge.getIconImageUri()});
    }

    public boolean equals(Object obj) {
        return GameBadgeEntity.zza(this, obj);
    }

    static boolean zza(GameBadge gameBadge, Object object) {
        if (!(object instanceof GameBadge)) {
            return false;
        }
        if (gameBadge == object) {
            return true;
        }
        GameBadge gameBadge2 = (GameBadge)object;
        return zzw.equal((Object)gameBadge2.getType(), (Object)gameBadge.getTitle()) && zzw.equal((Object)gameBadge2.getDescription(), (Object)gameBadge.getIconImageUri());
    }

    public String toString() {
        return GameBadgeEntity.zzb(this);
    }

    static String zzb(GameBadge gameBadge) {
        return zzw.zzk((Object)gameBadge).zza("Type", (Object)gameBadge.getType()).zza("Title", (Object)gameBadge.getTitle()).zza("Description", (Object)gameBadge.getDescription()).zza("IconImageUri", (Object)gameBadge.getIconImageUri()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.zziY()) {
            GameBadgeEntityCreator.zza(this, dest, flags);
        } else {
            dest.writeInt(this.zzJp);
            dest.writeString(this.zzSy);
            dest.writeString(this.zzZO);
            dest.writeString(this.zzacc == null ? null : this.zzacc.toString());
        }
    }

    public /* synthetic */ Object freeze() {
        return this.zzot();
    }

    static final class GameBadgeEntityCreatorCompat
    extends GameBadgeEntityCreator {
        GameBadgeEntityCreatorCompat() {
        }

        @Override
        public GameBadgeEntity zzda(Parcel parcel) {
            boolean bl = GameBadgeEntity.zzd(GameBadgeEntity.zziX());
            if (bl || GameBadgeEntity.zzbf((String)GameBadgeEntity.class.getCanonicalName())) {
                return super.zzda(parcel);
            }
            int n = parcel.readInt();
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            return new GameBadgeEntity(1, n, string, string2, uri);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.zzda(x0);
        }
    }
}

