/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntityCreator;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.internal.zzlw;

public final class ParticipantEntity
extends GamesDowngradeableSafeParcel
implements Participant {
    public static final Parcelable.Creator<ParticipantEntity> CREATOR = new ParticipantEntityCreatorCompat();
    private final int zzFG;
    private final String zzaeO;
    private final String zzSJ;
    private final Uri zzacc;
    private final Uri zzacd;
    private final int zzrX;
    private final String zzadN;
    private final boolean zzajD;
    private final PlayerEntity zzadf;
    private final int zzIM;
    private final ParticipantResult zzajE;
    private final String zzacn;
    private final String zzaco;

    public ParticipantEntity(Participant participant) {
        this.zzFG = 3;
        this.zzaeO = participant.getParticipantId();
        this.zzSJ = participant.getDisplayName();
        this.zzacc = participant.getIconImageUri();
        this.zzacd = participant.getHiResImageUri();
        this.zzrX = participant.getStatus();
        this.zzadN = participant.zznl();
        this.zzajD = participant.isConnectedToRoom();
        Player player = participant.getPlayer();
        this.zzadf = player == null ? null : new PlayerEntity(player);
        this.zzIM = participant.getCapabilities();
        this.zzajE = participant.getResult();
        this.zzacn = participant.getIconImageUrl();
        this.zzaco = participant.getHiResImageUrl();
    }

    ParticipantEntity(int versionCode, String participantId, String displayName, Uri iconImageUri, Uri hiResImageUri, int status, String clientAddress, boolean connectedToRoom, PlayerEntity player, int capabilities, ParticipantResult result, String iconImageUrl, String hiResImageUrl) {
        this.zzFG = versionCode;
        this.zzaeO = participantId;
        this.zzSJ = displayName;
        this.zzacc = iconImageUri;
        this.zzacd = hiResImageUri;
        this.zzrX = status;
        this.zzadN = clientAddress;
        this.zzajD = connectedToRoom;
        this.zzadf = player;
        this.zzIM = capabilities;
        this.zzajE = result;
        this.zzacn = iconImageUrl;
        this.zzaco = hiResImageUrl;
    }

    public int getVersionCode() {
        return this.zzFG;
    }

    @Override
    public int getStatus() {
        return this.zzrX;
    }

    @Override
    public String zznl() {
        return this.zzadN;
    }

    @Override
    public boolean isConnectedToRoom() {
        return this.zzajD;
    }

    @Override
    public String getDisplayName() {
        if (this.zzadf == null) {
            return this.zzSJ;
        }
        return this.zzadf.getDisplayName();
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        if (this.zzadf == null) {
            zzlw.zzb((String)this.zzSJ, (CharArrayBuffer)dataOut);
            return;
        }
        this.zzadf.getDisplayName(dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        if (this.zzadf == null) {
            return this.zzacc;
        }
        return this.zzadf.getIconImageUri();
    }

    @Override
    public String getIconImageUrl() {
        if (this.zzadf == null) {
            return this.zzacn;
        }
        return this.zzadf.getIconImageUrl();
    }

    @Override
    public Uri getHiResImageUri() {
        if (this.zzadf == null) {
            return this.zzacd;
        }
        return this.zzadf.getHiResImageUri();
    }

    @Override
    public String getHiResImageUrl() {
        if (this.zzadf == null) {
            return this.zzaco;
        }
        return this.zzadf.getHiResImageUrl();
    }

    @Override
    public String getParticipantId() {
        return this.zzaeO;
    }

    @Override
    public Player getPlayer() {
        return this.zzadf;
    }

    @Override
    public ParticipantResult getResult() {
        return this.zzajE;
    }

    @Override
    public int getCapabilities() {
        return this.zzIM;
    }

    public Participant freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return ParticipantEntity.zza(this);
    }

    static int zza(Participant participant) {
        return zzw.hashCode((Object[])new Object[]{participant.getPlayer(), participant.getStatus(), participant.zznl(), participant.isConnectedToRoom(), participant.getDisplayName(), participant.getIconImageUri(), participant.getHiResImageUri(), participant.getCapabilities(), participant.getResult(), participant.getParticipantId()});
    }

    public boolean equals(Object obj) {
        return ParticipantEntity.zza(this, obj);
    }

    static boolean zza(Participant participant, Object object) {
        if (!(object instanceof Participant)) {
            return false;
        }
        if (participant == object) {
            return true;
        }
        Participant participant2 = (Participant)object;
        return zzw.equal((Object)participant2.getPlayer(), (Object)participant.getPlayer()) && zzw.equal((Object)participant2.getStatus(), (Object)participant.getStatus()) && zzw.equal((Object)participant2.zznl(), (Object)participant.zznl()) && zzw.equal((Object)participant2.isConnectedToRoom(), (Object)participant.isConnectedToRoom()) && zzw.equal((Object)participant2.getDisplayName(), (Object)participant.getDisplayName()) && zzw.equal((Object)participant2.getIconImageUri(), (Object)participant.getIconImageUri()) && zzw.equal((Object)participant2.getHiResImageUri(), (Object)participant.getHiResImageUri()) && zzw.equal((Object)participant2.getCapabilities(), (Object)participant.getCapabilities()) && zzw.equal((Object)participant2.getResult(), (Object)participant.getResult()) && zzw.equal((Object)participant2.getParticipantId(), (Object)participant.getParticipantId());
    }

    public String toString() {
        return ParticipantEntity.zzb(this);
    }

    static String zzb(Participant participant) {
        return zzw.zzk((Object)participant).zza("ParticipantId", (Object)participant.getParticipantId()).zza("Player", (Object)participant.getPlayer()).zza("Status", (Object)participant.getStatus()).zza("ClientAddress", (Object)participant.zznl()).zza("ConnectedToRoom", (Object)participant.isConnectedToRoom()).zza("DisplayName", (Object)participant.getDisplayName()).zza("IconImage", (Object)participant.getIconImageUri()).zza("IconImageUrl", (Object)participant.getIconImageUrl()).zza("HiResImage", (Object)participant.getHiResImageUri()).zza("HiResImageUrl", (Object)participant.getHiResImageUrl()).zza("Capabilities", (Object)participant.getCapabilities()).zza("Result", (Object)participant.getResult()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.zziY()) {
            ParticipantEntityCreator.zza(this, dest, flags);
        } else {
            dest.writeString(this.zzaeO);
            dest.writeString(this.zzSJ);
            dest.writeString(this.zzacc == null ? null : this.zzacc.toString());
            dest.writeString(this.zzacd == null ? null : this.zzacd.toString());
            dest.writeInt(this.zzrX);
            dest.writeString(this.zzadN);
            dest.writeInt(this.zzajD ? 1 : 0);
            dest.writeInt(this.zzadf == null ? 0 : 1);
            if (this.zzadf != null) {
                this.zzadf.writeToParcel(dest, flags);
            }
        }
    }

    static final class ParticipantEntityCreatorCompat
    extends ParticipantEntityCreator {
        ParticipantEntityCreatorCompat() {
        }

        @Override
        public ParticipantEntity zzdf(Parcel parcel) {
            boolean bl = ParticipantEntity.zzd(ParticipantEntity.zziX());
            if (bl || ParticipantEntity.zzbf((String)ParticipantEntity.class.getCanonicalName())) {
                return super.zzdf(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            String string4 = parcel.readString();
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            int n = parcel.readInt();
            String string5 = parcel.readString();
            boolean bl2 = parcel.readInt() > 0;
            boolean bl3 = parcel.readInt() > 0;
            int n2 = 7;
            ParticipantResult participantResult = null;
            String string6 = null;
            String string7 = null;
            PlayerEntity playerEntity = bl3 ? (PlayerEntity)PlayerEntity.CREATOR.createFromParcel(parcel) : null;
            return new ParticipantEntity(3, string, string2, uri, uri2, n, string5, bl2, playerEntity, n2, participantResult, string6, string7);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.zzdf(x0);
        }
    }
}

