/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.os.Bundle;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.internal.constants.TurnBasedMatchTurnStatus;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;

public final class LoadMatchesResponse {
    private final InvitationBuffer zzajV;
    private final TurnBasedMatchBuffer zzajW;
    private final TurnBasedMatchBuffer zzajX;
    private final TurnBasedMatchBuffer zzajY;

    public LoadMatchesResponse(Bundle matchData) {
        DataHolder dataHolder = LoadMatchesResponse.zza(matchData, 0);
        this.zzajV = dataHolder != null ? new InvitationBuffer(dataHolder) : null;
        DataHolder dataHolder2 = LoadMatchesResponse.zza(matchData, 1);
        this.zzajW = dataHolder2 != null ? new TurnBasedMatchBuffer(dataHolder2) : null;
        DataHolder dataHolder3 = LoadMatchesResponse.zza(matchData, 2);
        this.zzajX = dataHolder3 != null ? new TurnBasedMatchBuffer(dataHolder3) : null;
        DataHolder dataHolder4 = LoadMatchesResponse.zza(matchData, 3);
        this.zzajY = dataHolder4 != null ? new TurnBasedMatchBuffer(dataHolder4) : null;
    }

    private static DataHolder zza(Bundle bundle, int n) {
        String string = TurnBasedMatchTurnStatus.zzeJ(n);
        if (!bundle.containsKey(string)) {
            return null;
        }
        return (DataHolder)bundle.getParcelable(string);
    }

    public InvitationBuffer getInvitations() {
        return this.zzajV;
    }

    public TurnBasedMatchBuffer getMyTurnMatches() {
        return this.zzajW;
    }

    public TurnBasedMatchBuffer getTheirTurnMatches() {
        return this.zzajX;
    }

    public TurnBasedMatchBuffer getCompletedMatches() {
        return this.zzajY;
    }

    @Deprecated
    public void close() {
        this.release();
    }

    public void release() {
        if (this.zzajV != null) {
            this.zzajV.release();
        }
        if (this.zzajW != null) {
            this.zzajW.release();
        }
        if (this.zzajX != null) {
            this.zzajX.release();
        }
        if (this.zzajY != null) {
            this.zzajY.release();
        }
    }

    public boolean hasData() {
        if (this.zzajV != null && this.zzajV.getCount() > 0) {
            return true;
        }
        if (this.zzajW != null && this.zzajW.getCount() > 0) {
            return true;
        }
        if (this.zzajX != null && this.zzajX.getCount() > 0) {
            return true;
        }
        return this.zzajY != null && this.zzajY.getCount() > 0;
    }
}

