/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.MilestoneEntityCreator;

public final class MilestoneEntity
implements SafeParcelable,
Milestone {
    public static final MilestoneEntityCreator CREATOR = new MilestoneEntityCreator();
    private final int zzFG;
    private final String zzaeR;
    private final long zzakk;
    private final long zzakl;
    private final byte[] zzakm;
    private final int mState;
    private final String zzadJ;

    public MilestoneEntity(Milestone milestone) {
        this.zzFG = 4;
        this.zzaeR = milestone.getMilestoneId();
        this.zzakk = milestone.getCurrentProgress();
        this.zzakl = milestone.getTargetProgress();
        this.mState = milestone.getState();
        this.zzadJ = milestone.getEventId();
        byte[] byArray = milestone.getCompletionRewardData();
        if (byArray == null) {
            this.zzakm = null;
        } else {
            this.zzakm = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.zzakm, 0, byArray.length);
        }
    }

    MilestoneEntity(int versionCode, String milestoneId, long currentProgress, long targetProgress, byte[] completionBlob, int state, String eventId) {
        this.zzFG = versionCode;
        this.zzaeR = milestoneId;
        this.zzakk = currentProgress;
        this.zzakl = targetProgress;
        this.zzakm = completionBlob;
        this.mState = state;
        this.zzadJ = eventId;
    }

    public int getVersionCode() {
        return this.zzFG;
    }

    @Override
    public String getEventId() {
        return this.zzadJ;
    }

    @Override
    public String getMilestoneId() {
        return this.zzaeR;
    }

    @Override
    public long getCurrentProgress() {
        return this.zzakk;
    }

    @Override
    public long getTargetProgress() {
        return this.zzakl;
    }

    @Override
    public byte[] getCompletionRewardData() {
        return this.zzakm;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    public Milestone freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return MilestoneEntity.zza(this);
    }

    static int zza(Milestone milestone) {
        return zzw.hashCode((Object[])new Object[]{milestone.getMilestoneId(), milestone.getCurrentProgress(), milestone.getTargetProgress(), milestone.getState(), milestone.getEventId()});
    }

    public boolean equals(Object obj) {
        return MilestoneEntity.zza(this, obj);
    }

    static boolean zza(Milestone milestone, Object object) {
        if (!(object instanceof Milestone)) {
            return false;
        }
        if (milestone == object) {
            return true;
        }
        Milestone milestone2 = (Milestone)object;
        return zzw.equal((Object)milestone2.getMilestoneId(), (Object)milestone.getMilestoneId()) && zzw.equal((Object)milestone2.getCurrentProgress(), (Object)milestone.getCurrentProgress()) && zzw.equal((Object)milestone2.getTargetProgress(), (Object)milestone.getTargetProgress()) && zzw.equal((Object)milestone2.getState(), (Object)milestone.getState()) && zzw.equal((Object)milestone2.getEventId(), (Object)milestone.getEventId());
    }

    public String toString() {
        return MilestoneEntity.zzb(this);
    }

    static String zzb(Milestone milestone) {
        return zzw.zzk((Object)milestone).zza("MilestoneId", (Object)milestone.getMilestoneId()).zza("CurrentProgress", (Object)milestone.getCurrentProgress()).zza("TargetProgress", (Object)milestone.getTargetProgress()).zza("State", (Object)milestone.getState()).zza("CompletionRewardData", (Object)milestone.getCompletionRewardData()).zza("EventId", (Object)milestone.getEventId()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        MilestoneEntityCreator.zza(this, out, flags);
    }
}

