/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.snapshot.Snapshot;
import com.google.android.gms.games.snapshot.SnapshotContents;
import com.google.android.gms.games.snapshot.SnapshotContentsEntity;
import com.google.android.gms.games.snapshot.SnapshotEntityCreator;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntity;

public final class SnapshotEntity
implements SafeParcelable,
Snapshot {
    public static final SnapshotEntityCreator CREATOR = new SnapshotEntityCreator();
    private final int zzFG;
    private final SnapshotMetadataEntity zzakC;
    private final SnapshotContentsEntity zzakD;

    public SnapshotEntity(SnapshotMetadata metadata, SnapshotContentsEntity contents) {
        this(2, metadata, contents);
    }

    SnapshotEntity(int versionCode, SnapshotMetadata metadata, SnapshotContentsEntity contents) {
        this.zzFG = versionCode;
        this.zzakC = new SnapshotMetadataEntity(metadata);
        this.zzakD = contents;
    }

    public int getVersionCode() {
        return this.zzFG;
    }

    @Override
    public SnapshotMetadata getMetadata() {
        return this.zzakC;
    }

    @Override
    public SnapshotContents getSnapshotContents() {
        return this.isClosed() ? null : this.zzakD;
    }

    private boolean isClosed() {
        return this.zzakD.isClosed();
    }

    public Snapshot freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return SnapshotEntity.zzb(this);
    }

    static int zzb(Snapshot snapshot) {
        return zzw.hashCode((Object[])new Object[]{snapshot.getMetadata(), snapshot.getSnapshotContents()});
    }

    public boolean equals(Object obj) {
        return SnapshotEntity.zza(this, obj);
    }

    static boolean zza(Snapshot snapshot, Object object) {
        if (!(object instanceof Snapshot)) {
            return false;
        }
        if (snapshot == object) {
            return true;
        }
        Snapshot snapshot2 = (Snapshot)object;
        return zzw.equal((Object)snapshot2.getMetadata(), (Object)snapshot.getMetadata()) && zzw.equal((Object)snapshot2.getSnapshotContents(), (Object)snapshot.getSnapshotContents());
    }

    public String toString() {
        return SnapshotEntity.zzc(this);
    }

    static String zzc(Snapshot snapshot) {
        return zzw.zzk((Object)snapshot).zza("Metadata", (Object)snapshot.getMetadata()).zza("HasContents", (Object)(snapshot.getSnapshotContents() != null ? 1 : 0)).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        SnapshotEntityCreator.zza(this, out, flags);
    }
}

