/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.game;

import android.os.Parcel;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.game.ExtendedGame;
import com.google.android.gms.games.internal.game.ExtendedGameEntityCreator;
import com.google.android.gms.games.internal.game.GameBadge;
import com.google.android.gms.games.internal.game.GameBadgeEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntity;
import java.util.ArrayList;

public final class ExtendedGameEntity
extends GamesDowngradeableSafeParcel
implements ExtendedGame {
    public static final ExtendedGameEntityCreator CREATOR = new ExtendedGameEntityCreatorCompat();
    private final int zzzH;
    private final GameEntity zzalP;
    private final int zzalQ;
    private final boolean zzalR;
    private final int zzalS;
    private final long zzalT;
    private final long zzalU;
    private final String zzalV;
    private final long zzalW;
    private final String zzalX;
    private final ArrayList<GameBadgeEntity> zzalY;
    private final SnapshotMetadataEntity zzalZ;

    public ExtendedGameEntity(ExtendedGame extendedGame) {
        this.zzzH = 2;
        Game game = extendedGame.getGame();
        this.zzalP = game == null ? null : new GameEntity(game);
        this.zzalQ = extendedGame.zzrs();
        this.zzalR = extendedGame.zzrt();
        this.zzalS = extendedGame.zzru();
        this.zzalT = extendedGame.zzrv();
        this.zzalU = extendedGame.zzrw();
        this.zzalV = extendedGame.zzrx();
        this.zzalW = extendedGame.zzry();
        this.zzalX = extendedGame.zzrz();
        SnapshotMetadata snapshotMetadata = extendedGame.zzrA();
        this.zzalZ = snapshotMetadata == null ? null : new SnapshotMetadataEntity(snapshotMetadata);
        ArrayList<GameBadge> arrayList = extendedGame.zzrr();
        int n = arrayList.size();
        this.zzalY = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzalY.add((GameBadgeEntity)arrayList.get(i).freeze());
        }
    }

    ExtendedGameEntity(int versionCode, GameEntity game, int availability, boolean owned, int achievementUnlockedCount, long lastPlayedServerTimestamp, long priceMicros, String formattedPrice, long fullPriceMicros, String formattedFullPrice, ArrayList<GameBadgeEntity> badges, SnapshotMetadataEntity snapshot) {
        this.zzzH = versionCode;
        this.zzalP = game;
        this.zzalQ = availability;
        this.zzalR = owned;
        this.zzalS = achievementUnlockedCount;
        this.zzalT = lastPlayedServerTimestamp;
        this.zzalU = priceMicros;
        this.zzalV = formattedPrice;
        this.zzalW = fullPriceMicros;
        this.zzalX = formattedFullPrice;
        this.zzalY = badges;
        this.zzalZ = snapshot;
    }

    public int getVersionCode() {
        return this.zzzH;
    }

    public GameEntity zzrB() {
        return this.zzalP;
    }

    @Override
    public ArrayList<GameBadge> zzrr() {
        return new ArrayList<GameBadge>(this.zzalY);
    }

    @Override
    public int zzrs() {
        return this.zzalQ;
    }

    @Override
    public boolean zzrt() {
        return this.zzalR;
    }

    @Override
    public int zzru() {
        return this.zzalS;
    }

    @Override
    public long zzrv() {
        return this.zzalT;
    }

    @Override
    public long zzrw() {
        return this.zzalU;
    }

    @Override
    public String zzrx() {
        return this.zzalV;
    }

    @Override
    public long zzry() {
        return this.zzalW;
    }

    @Override
    public String zzrz() {
        return this.zzalX;
    }

    @Override
    public SnapshotMetadata zzrA() {
        return this.zzalZ;
    }

    public ExtendedGame zzrC() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return ExtendedGameEntity.zza(this);
    }

    static int zza(ExtendedGame extendedGame) {
        return zzu.hashCode((Object[])new Object[]{extendedGame.getGame(), extendedGame.zzrs(), extendedGame.zzrt(), extendedGame.zzru(), extendedGame.zzrv(), extendedGame.zzrw(), extendedGame.zzrx(), extendedGame.zzry(), extendedGame.zzrz()});
    }

    public boolean equals(Object obj) {
        return ExtendedGameEntity.zza(this, obj);
    }

    static boolean zza(ExtendedGame extendedGame, Object object) {
        if (!(object instanceof ExtendedGame)) {
            return false;
        }
        if (extendedGame == object) {
            return true;
        }
        ExtendedGame extendedGame2 = (ExtendedGame)object;
        return zzu.equal((Object)extendedGame2.getGame(), (Object)extendedGame.getGame()) && zzu.equal((Object)extendedGame2.zzrs(), (Object)extendedGame.zzrs()) && zzu.equal((Object)extendedGame2.zzrt(), (Object)extendedGame.zzrt()) && zzu.equal((Object)extendedGame2.zzru(), (Object)extendedGame.zzru()) && zzu.equal((Object)extendedGame2.zzrv(), (Object)extendedGame.zzrv()) && zzu.equal((Object)extendedGame2.zzrw(), (Object)extendedGame.zzrw()) && zzu.equal((Object)extendedGame2.zzrx(), (Object)extendedGame.zzrx()) && zzu.equal((Object)extendedGame2.zzry(), (Object)extendedGame.zzry()) && zzu.equal((Object)extendedGame2.zzrz(), (Object)extendedGame.zzrz());
    }

    public String toString() {
        return ExtendedGameEntity.zzb(this);
    }

    static String zzb(ExtendedGame extendedGame) {
        return zzu.zzq((Object)extendedGame).zzg("Game", (Object)extendedGame.getGame()).zzg("Availability", (Object)extendedGame.zzrs()).zzg("Owned", (Object)extendedGame.zzrt()).zzg("AchievementUnlockedCount", (Object)extendedGame.zzru()).zzg("LastPlayedServerTimestamp", (Object)extendedGame.zzrv()).zzg("PriceMicros", (Object)extendedGame.zzrw()).zzg("FormattedPrice", (Object)extendedGame.zzrx()).zzg("FullPriceMicros", (Object)extendedGame.zzry()).zzg("FormattedFullPrice", (Object)extendedGame.zzrz()).zzg("Snapshot", (Object)extendedGame.zzrA()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.zzlQ()) {
            ExtendedGameEntityCreator.zza(this, dest, flags);
        } else {
            this.zzalP.writeToParcel(dest, flags);
            dest.writeInt(this.zzalQ);
            dest.writeInt(this.zzalR ? 1 : 0);
            dest.writeInt(this.zzalS);
            dest.writeLong(this.zzalT);
            dest.writeLong(this.zzalU);
            dest.writeString(this.zzalV);
            dest.writeLong(this.zzalW);
            dest.writeString(this.zzalX);
            int n = this.zzalY.size();
            dest.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.zzalY.get(i).writeToParcel(dest, flags);
            }
        }
    }

    @Override
    public /* synthetic */ Game getGame() {
        return this.zzrB();
    }

    public /* synthetic */ Object freeze() {
        return this.zzrC();
    }

    static final class ExtendedGameEntityCreatorCompat
    extends ExtendedGameEntityCreator {
        ExtendedGameEntityCreatorCompat() {
        }

        @Override
        public ExtendedGameEntity zzdn(Parcel parcel) {
            boolean bl = ExtendedGameEntity.zzd(ExtendedGameEntity.zzlP());
            if (bl || ExtendedGameEntity.zzbK((String)ExtendedGameEntity.class.getCanonicalName())) {
                return super.zzdn(parcel);
            }
            GameEntity gameEntity = (GameEntity)GameEntity.CREATOR.createFromParcel(parcel);
            int n = parcel.readInt();
            boolean bl2 = parcel.readInt() == 1;
            int n2 = parcel.readInt();
            long l = parcel.readLong();
            long l2 = parcel.readLong();
            String string = parcel.readString();
            long l3 = parcel.readLong();
            String string2 = parcel.readString();
            int n3 = parcel.readInt();
            ArrayList<GameBadgeEntity> arrayList = new ArrayList<GameBadgeEntity>(n3);
            for (int i = 0; i < n3; ++i) {
                arrayList.add(GameBadgeEntity.CREATOR.zzdo(parcel));
            }
            SnapshotMetadataEntity snapshotMetadataEntity = null;
            return new ExtendedGameEntity(2, gameEntity, n, bl2, n2, l, l2, string, l3, string2, arrayList, snapshotMetadataEntity);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.zzdn(x0);
        }
    }
}

