/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardVariant;
import com.google.android.gms.games.leaderboard.LeaderboardVariantEntity;
import com.google.android.gms.internal.zzhu;
import java.util.ArrayList;

public final class LeaderboardEntity
implements Leaderboard {
    private final String zzamL;
    private final String zzWF;
    private final Uri zzafY;
    private final int zzamM;
    private final ArrayList<LeaderboardVariantEntity> zzamN;
    private final Game zzamO;
    private final String zzagj;

    public LeaderboardEntity(Leaderboard leaderboard) {
        this.zzamL = leaderboard.getLeaderboardId();
        this.zzWF = leaderboard.getDisplayName();
        this.zzafY = leaderboard.getIconImageUri();
        this.zzagj = leaderboard.getIconImageUrl();
        this.zzamM = leaderboard.getScoreOrder();
        Game game = leaderboard.getGame();
        this.zzamO = game == null ? null : new GameEntity(game);
        ArrayList<LeaderboardVariant> arrayList = leaderboard.getVariants();
        int n = arrayList.size();
        this.zzamN = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzamN.add((LeaderboardVariantEntity)arrayList.get(i).freeze());
        }
    }

    @Override
    public String getLeaderboardId() {
        return this.zzamL;
    }

    @Override
    public String getDisplayName() {
        return this.zzWF;
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        zzhu.zzb((String)this.zzWF, (CharArrayBuffer)dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzafY;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzagj;
    }

    @Override
    public int getScoreOrder() {
        return this.zzamM;
    }

    @Override
    public ArrayList<LeaderboardVariant> getVariants() {
        return new ArrayList<LeaderboardVariant>(this.zzamN);
    }

    @Override
    public Game getGame() {
        return this.zzamO;
    }

    public Leaderboard zzrZ() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return LeaderboardEntity.zza(this);
    }

    static int zza(Leaderboard leaderboard) {
        return zzu.hashCode((Object[])new Object[]{leaderboard.getLeaderboardId(), leaderboard.getDisplayName(), leaderboard.getIconImageUri(), leaderboard.getScoreOrder(), leaderboard.getVariants()});
    }

    public boolean equals(Object obj) {
        return LeaderboardEntity.zza(this, obj);
    }

    static boolean zza(Leaderboard leaderboard, Object object) {
        if (!(object instanceof Leaderboard)) {
            return false;
        }
        if (leaderboard == object) {
            return true;
        }
        Leaderboard leaderboard2 = (Leaderboard)object;
        return zzu.equal((Object)leaderboard2.getLeaderboardId(), (Object)leaderboard.getLeaderboardId()) && zzu.equal((Object)leaderboard2.getDisplayName(), (Object)leaderboard.getDisplayName()) && zzu.equal((Object)leaderboard2.getIconImageUri(), (Object)leaderboard.getIconImageUri()) && zzu.equal((Object)leaderboard2.getScoreOrder(), (Object)leaderboard.getScoreOrder()) && zzu.equal(leaderboard2.getVariants(), leaderboard.getVariants());
    }

    public String toString() {
        return LeaderboardEntity.zzb(this);
    }

    static String zzb(Leaderboard leaderboard) {
        return zzu.zzq((Object)leaderboard).zzg("LeaderboardId", (Object)leaderboard.getLeaderboardId()).zzg("DisplayName", (Object)leaderboard.getDisplayName()).zzg("IconImageUri", (Object)leaderboard.getIconImageUri()).zzg("IconImageUrl", (Object)leaderboard.getIconImageUrl()).zzg("ScoreOrder", (Object)leaderboard.getScoreOrder()).zzg("Variants", leaderboard.getVariants()).toString();
    }

    public /* synthetic */ Object freeze() {
        return this.zzrZ();
    }
}

