/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.internal.zzhu;

public final class LeaderboardScoreEntity
implements LeaderboardScore {
    private final long zzamQ;
    private final String zzamR;
    private final String zzamS;
    private final long zzamT;
    private final long zzamU;
    private final String zzamV;
    private final Uri zzamW;
    private final Uri zzamX;
    private final PlayerEntity zzamY;
    private final String zzamZ;
    private final String zzana;
    private final String zzanb;

    public LeaderboardScoreEntity(LeaderboardScore score) {
        this.zzamQ = score.getRank();
        this.zzamR = (String)zzv.zzr((Object)score.getDisplayRank());
        this.zzamS = (String)zzv.zzr((Object)score.getDisplayScore());
        this.zzamT = score.getRawScore();
        this.zzamU = score.getTimestampMillis();
        this.zzamV = score.getScoreHolderDisplayName();
        this.zzamW = score.getScoreHolderIconImageUri();
        this.zzamX = score.getScoreHolderHiResImageUri();
        Player player = score.getScoreHolder();
        this.zzamY = player == null ? null : (PlayerEntity)player.freeze();
        this.zzamZ = score.getScoreTag();
        this.zzana = score.getScoreHolderIconImageUrl();
        this.zzanb = score.getScoreHolderHiResImageUrl();
    }

    @Override
    public long getRank() {
        return this.zzamQ;
    }

    @Override
    public String getDisplayRank() {
        return this.zzamR;
    }

    @Override
    public void getDisplayRank(CharArrayBuffer dataOut) {
        zzhu.zzb((String)this.zzamR, (CharArrayBuffer)dataOut);
    }

    @Override
    public String getDisplayScore() {
        return this.zzamS;
    }

    @Override
    public void getDisplayScore(CharArrayBuffer dataOut) {
        zzhu.zzb((String)this.zzamS, (CharArrayBuffer)dataOut);
    }

    @Override
    public long getRawScore() {
        return this.zzamT;
    }

    @Override
    public long getTimestampMillis() {
        return this.zzamU;
    }

    @Override
    public String getScoreHolderDisplayName() {
        if (this.zzamY == null) {
            return this.zzamV;
        }
        return this.zzamY.getDisplayName();
    }

    @Override
    public void getScoreHolderDisplayName(CharArrayBuffer dataOut) {
        if (this.zzamY == null) {
            zzhu.zzb((String)this.zzamV, (CharArrayBuffer)dataOut);
            return;
        }
        this.zzamY.getDisplayName(dataOut);
    }

    @Override
    public Uri getScoreHolderIconImageUri() {
        if (this.zzamY == null) {
            return this.zzamW;
        }
        return this.zzamY.getIconImageUri();
    }

    @Override
    public String getScoreHolderIconImageUrl() {
        if (this.zzamY == null) {
            return this.zzana;
        }
        return this.zzamY.getIconImageUrl();
    }

    @Override
    public Uri getScoreHolderHiResImageUri() {
        if (this.zzamY == null) {
            return this.zzamX;
        }
        return this.zzamY.getHiResImageUri();
    }

    @Override
    public String getScoreHolderHiResImageUrl() {
        if (this.zzamY == null) {
            return this.zzanb;
        }
        return this.zzamY.getHiResImageUrl();
    }

    @Override
    public Player getScoreHolder() {
        return this.zzamY;
    }

    @Override
    public String getScoreTag() {
        return this.zzamZ;
    }

    public LeaderboardScore zzsc() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return LeaderboardScoreEntity.zza(this);
    }

    static int zza(LeaderboardScore leaderboardScore) {
        return zzu.hashCode((Object[])new Object[]{leaderboardScore.getRank(), leaderboardScore.getDisplayRank(), leaderboardScore.getRawScore(), leaderboardScore.getDisplayScore(), leaderboardScore.getTimestampMillis(), leaderboardScore.getScoreHolderDisplayName(), leaderboardScore.getScoreHolderIconImageUri(), leaderboardScore.getScoreHolderHiResImageUri(), leaderboardScore.getScoreHolder()});
    }

    public boolean equals(Object obj) {
        return LeaderboardScoreEntity.zza(this, obj);
    }

    static boolean zza(LeaderboardScore leaderboardScore, Object object) {
        if (!(object instanceof LeaderboardScore)) {
            return false;
        }
        if (leaderboardScore == object) {
            return true;
        }
        LeaderboardScore leaderboardScore2 = (LeaderboardScore)object;
        return zzu.equal((Object)leaderboardScore2.getRank(), (Object)leaderboardScore.getRank()) && zzu.equal((Object)leaderboardScore2.getDisplayRank(), (Object)leaderboardScore.getDisplayRank()) && zzu.equal((Object)leaderboardScore2.getRawScore(), (Object)leaderboardScore.getRawScore()) && zzu.equal((Object)leaderboardScore2.getDisplayScore(), (Object)leaderboardScore.getDisplayScore()) && zzu.equal((Object)leaderboardScore2.getTimestampMillis(), (Object)leaderboardScore.getTimestampMillis()) && zzu.equal((Object)leaderboardScore2.getScoreHolderDisplayName(), (Object)leaderboardScore.getScoreHolderDisplayName()) && zzu.equal((Object)leaderboardScore2.getScoreHolderIconImageUri(), (Object)leaderboardScore.getScoreHolderIconImageUri()) && zzu.equal((Object)leaderboardScore2.getScoreHolderHiResImageUri(), (Object)leaderboardScore.getScoreHolderHiResImageUri()) && zzu.equal((Object)leaderboardScore2.getScoreHolder(), (Object)leaderboardScore.getScoreHolder()) && zzu.equal((Object)leaderboardScore2.getScoreTag(), (Object)leaderboardScore.getScoreTag());
    }

    public String toString() {
        return LeaderboardScoreEntity.zzb(this);
    }

    static String zzb(LeaderboardScore leaderboardScore) {
        return zzu.zzq((Object)leaderboardScore).zzg("Rank", (Object)leaderboardScore.getRank()).zzg("DisplayRank", (Object)leaderboardScore.getDisplayRank()).zzg("Score", (Object)leaderboardScore.getRawScore()).zzg("DisplayScore", (Object)leaderboardScore.getDisplayScore()).zzg("Timestamp", (Object)leaderboardScore.getTimestampMillis()).zzg("DisplayName", (Object)leaderboardScore.getScoreHolderDisplayName()).zzg("IconImageUri", (Object)leaderboardScore.getScoreHolderIconImageUri()).zzg("IconImageUrl", (Object)leaderboardScore.getScoreHolderIconImageUrl()).zzg("HiResImageUri", (Object)leaderboardScore.getScoreHolderHiResImageUri()).zzg("HiResImageUrl", (Object)leaderboardScore.getScoreHolderHiResImageUrl()).zzg("Player", (Object)(leaderboardScore.getScoreHolder() == null ? null : leaderboardScore.getScoreHolder())).zzg("ScoreTag", (Object)leaderboardScore.getScoreTag()).toString();
    }

    public /* synthetic */ Object freeze() {
        return this.zzsc();
    }
}

