/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerRef;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.games.leaderboard.LeaderboardScoreEntity;

public final class LeaderboardScoreRef
extends zzc
implements LeaderboardScore {
    private final PlayerRef zzanc;

    LeaderboardScoreRef(DataHolder holder, int dataRow) {
        super(holder, dataRow);
        this.zzanc = new PlayerRef(holder, dataRow);
    }

    @Override
    public long getRank() {
        return this.getLong("rank");
    }

    @Override
    public String getDisplayRank() {
        return this.getString("display_rank");
    }

    @Override
    public void getDisplayRank(CharArrayBuffer dataOut) {
        this.zza("display_rank", dataOut);
    }

    @Override
    public String getDisplayScore() {
        return this.getString("display_score");
    }

    @Override
    public void getDisplayScore(CharArrayBuffer dataOut) {
        this.zza("display_score", dataOut);
    }

    @Override
    public long getRawScore() {
        return this.getLong("raw_score");
    }

    @Override
    public long getTimestampMillis() {
        return this.getLong("achieved_timestamp");
    }

    @Override
    public String getScoreHolderDisplayName() {
        if (this.zzbH("external_player_id")) {
            return this.getString("default_display_name");
        }
        return this.zzanc.getDisplayName();
    }

    @Override
    public void getScoreHolderDisplayName(CharArrayBuffer dataOut) {
        if (this.zzbH("external_player_id")) {
            this.zza("default_display_name", dataOut);
            return;
        }
        this.zzanc.getDisplayName(dataOut);
    }

    @Override
    public Uri getScoreHolderIconImageUri() {
        if (this.zzbH("external_player_id")) {
            return this.zzbG("default_display_image_uri");
        }
        return this.zzanc.getIconImageUri();
    }

    @Override
    public String getScoreHolderIconImageUrl() {
        if (this.zzbH("external_player_id")) {
            return this.getString("default_display_image_url");
        }
        return this.zzanc.getIconImageUrl();
    }

    @Override
    public Uri getScoreHolderHiResImageUri() {
        if (this.zzbH("external_player_id")) {
            return null;
        }
        return this.zzanc.getHiResImageUri();
    }

    @Override
    public String getScoreHolderHiResImageUrl() {
        if (this.zzbH("external_player_id")) {
            return null;
        }
        return this.zzanc.getHiResImageUrl();
    }

    @Override
    public Player getScoreHolder() {
        if (this.zzbH("external_player_id")) {
            return null;
        }
        return this.zzanc;
    }

    @Override
    public String getScoreTag() {
        return this.getString("score_tag");
    }

    public LeaderboardScore zzsc() {
        return new LeaderboardScoreEntity(this);
    }

    public int hashCode() {
        return LeaderboardScoreEntity.zza(this);
    }

    public boolean equals(Object obj) {
        return LeaderboardScoreEntity.zza(this, obj);
    }

    public String toString() {
        return LeaderboardScoreEntity.zzb(this);
    }

    public /* synthetic */ Object freeze() {
        return this.zzsc();
    }
}

