/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.games.internal.constants.TimeSpan;
import java.util.HashMap;

public final class ScoreSubmissionData {
    private static final String[] zzamJ = new String[]{"leaderboardId", "playerId", "timeSpan", "hasResult", "rawScore", "formattedScore", "newBest", "scoreTag"};
    private String zzamL;
    private String zzagC;
    private int zzOJ;
    private HashMap<Integer, Result> zzanp;

    public ScoreSubmissionData(DataHolder dataHolder) {
        this.zzOJ = dataHolder.getStatusCode();
        this.zzanp = new HashMap();
        int n = dataHolder.getCount();
        zzv.zzQ((n == 3 ? 1 : 0) != 0);
        for (int i = 0; i < n; ++i) {
            boolean bl;
            int n2 = dataHolder.zzaD(i);
            if (i == 0) {
                this.zzamL = dataHolder.zzd("leaderboardId", i, n2);
                this.zzagC = dataHolder.zzd("playerId", i, n2);
            }
            if (!(bl = dataHolder.zze("hasResult", i, n2))) continue;
            Result result = new Result(dataHolder.zzb("rawScore", i, n2), dataHolder.zzd("formattedScore", i, n2), dataHolder.zzd("scoreTag", i, n2), dataHolder.zze("newBest", i, n2));
            this.zza(result, dataHolder.zzc("timeSpan", i, n2));
        }
    }

    public String getLeaderboardId() {
        return this.zzamL;
    }

    public String getPlayerId() {
        return this.zzagC;
    }

    public Result getScoreResult(int timeSpan) {
        return this.zzanp.get(timeSpan);
    }

    private void zza(Result result, int n) {
        this.zzanp.put(n, result);
    }

    public String toString() {
        zzu.zza zza2 = zzu.zzq((Object)this).zzg("PlayerId", (Object)this.zzagC).zzg("StatusCode", (Object)this.zzOJ);
        for (int i = 0; i < 3; ++i) {
            Result result = this.zzanp.get(i);
            zza2.zzg("TimesSpan", (Object)TimeSpan.zzeZ(i));
            zza2.zzg("Result", (Object)(result == null ? "null" : result.toString()));
        }
        return zza2.toString();
    }

    public static final class Result {
        public final long rawScore;
        public final String formattedScore;
        public final String scoreTag;
        public final boolean newBest;

        public Result(long rawScore, String formattedScore, String scoreTag, boolean newBest) {
            this.rawScore = rawScore;
            this.formattedScore = formattedScore;
            this.scoreTag = scoreTag;
            this.newBest = newBest;
        }

        public String toString() {
            return zzu.zzq((Object)this).zzg("RawScore", (Object)this.rawScore).zzg("FormattedScore", (Object)this.formattedScore).zzg("ScoreTag", (Object)this.scoreTag).zzg("NewBest", (Object)this.newBest).toString();
        }
    }
}

