/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationEntityCreator;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import java.util.ArrayList;

public final class InvitationEntity
extends GamesDowngradeableSafeParcel
implements Invitation {
    public static final Parcelable.Creator<InvitationEntity> CREATOR = new InvitationEntityCreatorCompat();
    private final int zzzH;
    private final GameEntity zzalP;
    private final String zzaif;
    private final long zzanq;
    private final int zzanr;
    private final ParticipantEntity zzans;
    private final ArrayList<ParticipantEntity> zzant;
    private final int zzanu;
    private final int zzanv;

    InvitationEntity(Invitation invitation) {
        this.zzzH = 2;
        this.zzalP = new GameEntity(invitation.getGame());
        this.zzaif = invitation.getInvitationId();
        this.zzanq = invitation.getCreationTimestamp();
        this.zzanr = invitation.getInvitationType();
        this.zzanu = invitation.getVariant();
        this.zzanv = invitation.getAvailableAutoMatchSlots();
        String string = invitation.getInviter().getParticipantId();
        Participant participant = null;
        ArrayList arrayList = invitation.getParticipants();
        int n = arrayList.size();
        this.zzant = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            Participant participant2 = (Participant)arrayList.get(i);
            if (participant2.getParticipantId().equals(string)) {
                participant = participant2;
            }
            this.zzant.add((ParticipantEntity)participant2.freeze());
        }
        zzv.zzb(participant, (Object)"Must have a valid inviter!");
        this.zzans = (ParticipantEntity)participant.freeze();
    }

    InvitationEntity(int versionCode, GameEntity game, String invitationId, long creationTimestamp, int invitationType, ParticipantEntity inviter, ArrayList<ParticipantEntity> participants, int variant, int availableAutoMatchSlots) {
        this.zzzH = versionCode;
        this.zzalP = game;
        this.zzaif = invitationId;
        this.zzanq = creationTimestamp;
        this.zzanr = invitationType;
        this.zzans = inviter;
        this.zzant = participants;
        this.zzanu = variant;
        this.zzanv = availableAutoMatchSlots;
    }

    public int getVersionCode() {
        return this.zzzH;
    }

    @Override
    public Game getGame() {
        return this.zzalP;
    }

    @Override
    public String getInvitationId() {
        return this.zzaif;
    }

    @Override
    public Participant getInviter() {
        return this.zzans;
    }

    @Override
    public long getCreationTimestamp() {
        return this.zzanq;
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.zzant);
    }

    @Override
    public int getInvitationType() {
        return this.zzanr;
    }

    @Override
    public int getVariant() {
        return this.zzanu;
    }

    @Override
    public int getAvailableAutoMatchSlots() {
        return this.zzanv;
    }

    public Invitation freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return InvitationEntity.zza(this);
    }

    static int zza(Invitation invitation) {
        return zzu.hashCode((Object[])new Object[]{invitation.getGame(), invitation.getInvitationId(), invitation.getCreationTimestamp(), invitation.getInvitationType(), invitation.getInviter(), invitation.getParticipants(), invitation.getVariant(), invitation.getAvailableAutoMatchSlots()});
    }

    public boolean equals(Object obj) {
        return InvitationEntity.zza(this, obj);
    }

    static boolean zza(Invitation invitation, Object object) {
        if (!(object instanceof Invitation)) {
            return false;
        }
        if (invitation == object) {
            return true;
        }
        Invitation invitation2 = (Invitation)object;
        return zzu.equal((Object)invitation2.getGame(), (Object)invitation.getGame()) && zzu.equal((Object)invitation2.getInvitationId(), (Object)invitation.getInvitationId()) && zzu.equal((Object)invitation2.getCreationTimestamp(), (Object)invitation.getCreationTimestamp()) && zzu.equal((Object)invitation2.getInvitationType(), (Object)invitation.getInvitationType()) && zzu.equal((Object)invitation2.getInviter(), (Object)invitation.getInviter()) && zzu.equal((Object)invitation2.getParticipants(), (Object)invitation.getParticipants()) && zzu.equal((Object)invitation2.getVariant(), (Object)invitation.getVariant()) && zzu.equal((Object)invitation2.getAvailableAutoMatchSlots(), (Object)invitation.getAvailableAutoMatchSlots());
    }

    public String toString() {
        return InvitationEntity.zzb(this);
    }

    static String zzb(Invitation invitation) {
        return zzu.zzq((Object)invitation).zzg("Game", (Object)invitation.getGame()).zzg("InvitationId", (Object)invitation.getInvitationId()).zzg("CreationTimestamp", (Object)invitation.getCreationTimestamp()).zzg("InvitationType", (Object)invitation.getInvitationType()).zzg("Inviter", (Object)invitation.getInviter()).zzg("Participants", (Object)invitation.getParticipants()).zzg("Variant", (Object)invitation.getVariant()).zzg("AvailableAutoMatchSlots", (Object)invitation.getAvailableAutoMatchSlots()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.zzlQ()) {
            InvitationEntityCreator.zza(this, dest, flags);
        } else {
            this.zzalP.writeToParcel(dest, flags);
            dest.writeString(this.zzaif);
            dest.writeLong(this.zzanq);
            dest.writeInt(this.zzanr);
            this.zzans.writeToParcel(dest, flags);
            int n = this.zzant.size();
            dest.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.zzant.get(i).writeToParcel(dest, flags);
            }
        }
    }

    static final class InvitationEntityCreatorCompat
    extends InvitationEntityCreator {
        InvitationEntityCreatorCompat() {
        }

        @Override
        public InvitationEntity zzds(Parcel parcel) {
            int n;
            boolean bl = InvitationEntity.zzd(InvitationEntity.zzlP());
            if (bl || InvitationEntity.zzbK((String)InvitationEntity.class.getCanonicalName())) {
                return super.zzds(parcel);
            }
            GameEntity gameEntity = (GameEntity)GameEntity.CREATOR.createFromParcel(parcel);
            String string = parcel.readString();
            long l = parcel.readLong();
            int n2 = parcel.readInt();
            ParticipantEntity participantEntity = (ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel);
            int n3 = parcel.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n3);
            for (n = 0; n < n3; ++n) {
                arrayList.add((ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            n = -1;
            int n4 = 0;
            return new InvitationEntity(2, gameEntity, string, l, n2, participantEntity, arrayList, n, n4);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.zzds(x0);
        }
    }
}

