/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntityCreator;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.internal.zzhu;

public final class ParticipantEntity
extends GamesDowngradeableSafeParcel
implements Participant {
    public static final Parcelable.Creator<ParticipantEntity> CREATOR = new ParticipantEntityCreatorCompat();
    private final int zzzH;
    private final String zzaiJ;
    private final String zzWF;
    private final Uri zzafY;
    private final Uri zzafZ;
    private final int zzue;
    private final String zzahI;
    private final boolean zzanx;
    private final PlayerEntity zzaha;
    private final int zzMd;
    private final ParticipantResult zzany;
    private final String zzagj;
    private final String zzagk;

    public ParticipantEntity(Participant participant) {
        this.zzzH = 3;
        this.zzaiJ = participant.getParticipantId();
        this.zzWF = participant.getDisplayName();
        this.zzafY = participant.getIconImageUri();
        this.zzafZ = participant.getHiResImageUri();
        this.zzue = participant.getStatus();
        this.zzahI = participant.zzqA();
        this.zzanx = participant.isConnectedToRoom();
        Player player = participant.getPlayer();
        this.zzaha = player == null ? null : new PlayerEntity(player);
        this.zzMd = participant.getCapabilities();
        this.zzany = participant.getResult();
        this.zzagj = participant.getIconImageUrl();
        this.zzagk = participant.getHiResImageUrl();
    }

    ParticipantEntity(int versionCode, String participantId, String displayName, Uri iconImageUri, Uri hiResImageUri, int status, String clientAddress, boolean connectedToRoom, PlayerEntity player, int capabilities, ParticipantResult result, String iconImageUrl, String hiResImageUrl) {
        this.zzzH = versionCode;
        this.zzaiJ = participantId;
        this.zzWF = displayName;
        this.zzafY = iconImageUri;
        this.zzafZ = hiResImageUri;
        this.zzue = status;
        this.zzahI = clientAddress;
        this.zzanx = connectedToRoom;
        this.zzaha = player;
        this.zzMd = capabilities;
        this.zzany = result;
        this.zzagj = iconImageUrl;
        this.zzagk = hiResImageUrl;
    }

    public int getVersionCode() {
        return this.zzzH;
    }

    @Override
    public int getStatus() {
        return this.zzue;
    }

    @Override
    public String zzqA() {
        return this.zzahI;
    }

    @Override
    public boolean isConnectedToRoom() {
        return this.zzanx;
    }

    @Override
    public String getDisplayName() {
        if (this.zzaha == null) {
            return this.zzWF;
        }
        return this.zzaha.getDisplayName();
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        if (this.zzaha == null) {
            zzhu.zzb((String)this.zzWF, (CharArrayBuffer)dataOut);
            return;
        }
        this.zzaha.getDisplayName(dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        if (this.zzaha == null) {
            return this.zzafY;
        }
        return this.zzaha.getIconImageUri();
    }

    @Override
    public String getIconImageUrl() {
        if (this.zzaha == null) {
            return this.zzagj;
        }
        return this.zzaha.getIconImageUrl();
    }

    @Override
    public Uri getHiResImageUri() {
        if (this.zzaha == null) {
            return this.zzafZ;
        }
        return this.zzaha.getHiResImageUri();
    }

    @Override
    public String getHiResImageUrl() {
        if (this.zzaha == null) {
            return this.zzagk;
        }
        return this.zzaha.getHiResImageUrl();
    }

    @Override
    public String getParticipantId() {
        return this.zzaiJ;
    }

    @Override
    public Player getPlayer() {
        return this.zzaha;
    }

    @Override
    public ParticipantResult getResult() {
        return this.zzany;
    }

    @Override
    public int getCapabilities() {
        return this.zzMd;
    }

    public Participant freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return ParticipantEntity.zza(this);
    }

    static int zza(Participant participant) {
        return zzu.hashCode((Object[])new Object[]{participant.getPlayer(), participant.getStatus(), participant.zzqA(), participant.isConnectedToRoom(), participant.getDisplayName(), participant.getIconImageUri(), participant.getHiResImageUri(), participant.getCapabilities(), participant.getResult(), participant.getParticipantId()});
    }

    public boolean equals(Object obj) {
        return ParticipantEntity.zza(this, obj);
    }

    static boolean zza(Participant participant, Object object) {
        if (!(object instanceof Participant)) {
            return false;
        }
        if (participant == object) {
            return true;
        }
        Participant participant2 = (Participant)object;
        return zzu.equal((Object)participant2.getPlayer(), (Object)participant.getPlayer()) && zzu.equal((Object)participant2.getStatus(), (Object)participant.getStatus()) && zzu.equal((Object)participant2.zzqA(), (Object)participant.zzqA()) && zzu.equal((Object)participant2.isConnectedToRoom(), (Object)participant.isConnectedToRoom()) && zzu.equal((Object)participant2.getDisplayName(), (Object)participant.getDisplayName()) && zzu.equal((Object)participant2.getIconImageUri(), (Object)participant.getIconImageUri()) && zzu.equal((Object)participant2.getHiResImageUri(), (Object)participant.getHiResImageUri()) && zzu.equal((Object)participant2.getCapabilities(), (Object)participant.getCapabilities()) && zzu.equal((Object)participant2.getResult(), (Object)participant.getResult()) && zzu.equal((Object)participant2.getParticipantId(), (Object)participant.getParticipantId());
    }

    public String toString() {
        return ParticipantEntity.zzb(this);
    }

    static String zzb(Participant participant) {
        return zzu.zzq((Object)participant).zzg("ParticipantId", (Object)participant.getParticipantId()).zzg("Player", (Object)participant.getPlayer()).zzg("Status", (Object)participant.getStatus()).zzg("ClientAddress", (Object)participant.zzqA()).zzg("ConnectedToRoom", (Object)participant.isConnectedToRoom()).zzg("DisplayName", (Object)participant.getDisplayName()).zzg("IconImage", (Object)participant.getIconImageUri()).zzg("IconImageUrl", (Object)participant.getIconImageUrl()).zzg("HiResImage", (Object)participant.getHiResImageUri()).zzg("HiResImageUrl", (Object)participant.getHiResImageUrl()).zzg("Capabilities", (Object)participant.getCapabilities()).zzg("Result", (Object)participant.getResult()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.zzlQ()) {
            ParticipantEntityCreator.zza(this, dest, flags);
        } else {
            dest.writeString(this.zzaiJ);
            dest.writeString(this.zzWF);
            dest.writeString(this.zzafY == null ? null : this.zzafY.toString());
            dest.writeString(this.zzafZ == null ? null : this.zzafZ.toString());
            dest.writeInt(this.zzue);
            dest.writeString(this.zzahI);
            dest.writeInt(this.zzanx ? 1 : 0);
            dest.writeInt(this.zzaha == null ? 0 : 1);
            if (this.zzaha != null) {
                this.zzaha.writeToParcel(dest, flags);
            }
        }
    }

    static final class ParticipantEntityCreatorCompat
    extends ParticipantEntityCreator {
        ParticipantEntityCreatorCompat() {
        }

        @Override
        public ParticipantEntity zzdt(Parcel parcel) {
            boolean bl = ParticipantEntity.zzd(ParticipantEntity.zzlP());
            if (bl || ParticipantEntity.zzbK((String)ParticipantEntity.class.getCanonicalName())) {
                return super.zzdt(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            String string4 = parcel.readString();
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            int n = parcel.readInt();
            String string5 = parcel.readString();
            boolean bl2 = parcel.readInt() > 0;
            boolean bl3 = parcel.readInt() > 0;
            int n2 = 7;
            ParticipantResult participantResult = null;
            String string6 = null;
            String string7 = null;
            PlayerEntity playerEntity = bl3 ? (PlayerEntity)PlayerEntity.CREATOR.createFromParcel(parcel) : null;
            return new ParticipantEntity(3, string, string2, uri, uri2, n, string5, bl2, playerEntity, n2, participantResult, string6, string7);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.zzdt(x0);
        }
    }
}

