/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.MilestoneEntityCreator;

public final class MilestoneEntity
implements SafeParcelable,
Milestone {
    public static final MilestoneEntityCreator CREATOR = new MilestoneEntityCreator();
    private final int zzzH;
    private final String zzaiM;
    private final long zzaoe;
    private final long zzaof;
    private final byte[] zzaog;
    private final int mState;
    private final String zzahE;

    public MilestoneEntity(Milestone milestone) {
        this.zzzH = 4;
        this.zzaiM = milestone.getMilestoneId();
        this.zzaoe = milestone.getCurrentProgress();
        this.zzaof = milestone.getTargetProgress();
        this.mState = milestone.getState();
        this.zzahE = milestone.getEventId();
        byte[] byArray = milestone.getCompletionRewardData();
        if (byArray == null) {
            this.zzaog = null;
        } else {
            this.zzaog = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.zzaog, 0, byArray.length);
        }
    }

    MilestoneEntity(int versionCode, String milestoneId, long currentProgress, long targetProgress, byte[] completionBlob, int state, String eventId) {
        this.zzzH = versionCode;
        this.zzaiM = milestoneId;
        this.zzaoe = currentProgress;
        this.zzaof = targetProgress;
        this.zzaog = completionBlob;
        this.mState = state;
        this.zzahE = eventId;
    }

    public int getVersionCode() {
        return this.zzzH;
    }

    @Override
    public String getEventId() {
        return this.zzahE;
    }

    @Override
    public String getMilestoneId() {
        return this.zzaiM;
    }

    @Override
    public long getCurrentProgress() {
        return this.zzaoe;
    }

    @Override
    public long getTargetProgress() {
        return this.zzaof;
    }

    @Override
    public byte[] getCompletionRewardData() {
        return this.zzaog;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    public Milestone freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return MilestoneEntity.zza(this);
    }

    static int zza(Milestone milestone) {
        return zzu.hashCode((Object[])new Object[]{milestone.getMilestoneId(), milestone.getCurrentProgress(), milestone.getTargetProgress(), milestone.getState(), milestone.getEventId()});
    }

    public boolean equals(Object obj) {
        return MilestoneEntity.zza(this, obj);
    }

    static boolean zza(Milestone milestone, Object object) {
        if (!(object instanceof Milestone)) {
            return false;
        }
        if (milestone == object) {
            return true;
        }
        Milestone milestone2 = (Milestone)object;
        return zzu.equal((Object)milestone2.getMilestoneId(), (Object)milestone.getMilestoneId()) && zzu.equal((Object)milestone2.getCurrentProgress(), (Object)milestone.getCurrentProgress()) && zzu.equal((Object)milestone2.getTargetProgress(), (Object)milestone.getTargetProgress()) && zzu.equal((Object)milestone2.getState(), (Object)milestone.getState()) && zzu.equal((Object)milestone2.getEventId(), (Object)milestone.getEventId());
    }

    public String toString() {
        return MilestoneEntity.zzb(this);
    }

    static String zzb(Milestone milestone) {
        return zzu.zzq((Object)milestone).zzg("MilestoneId", (Object)milestone.getMilestoneId()).zzg("CurrentProgress", (Object)milestone.getCurrentProgress()).zzg("TargetProgress", (Object)milestone.getTargetProgress()).zzg("State", (Object)milestone.getState()).zzg("CompletionRewardData", (Object)milestone.getCompletionRewardData()).zzg("EventId", (Object)milestone.getEventId()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        MilestoneEntityCreator.zza(this, out, flags);
    }
}

