/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.api.zzb;
import com.google.android.gms.common.api.zzc;
import com.google.android.gms.common.api.zzi;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.BinderWrapper;
import com.google.android.gms.common.internal.zze;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.drive.Contents;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameBuffer;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.GamesMetadata;
import com.google.android.gms.games.GamesStatusCodes;
import com.google.android.gms.games.Notifications;
import com.google.android.gms.games.OnNearbyPlayerDetectedListener;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerBuffer;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.achievement.AchievementBuffer;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.appcontent.AppContents;
import com.google.android.gms.games.event.EventBuffer;
import com.google.android.gms.games.event.Events;
import com.google.android.gms.games.internal.AbstractGamesCallbacks;
import com.google.android.gms.games.internal.AbstractGamesClient;
import com.google.android.gms.games.internal.GamesLog;
import com.google.android.gms.games.internal.IGamesCallbacks;
import com.google.android.gms.games.internal.IGamesService;
import com.google.android.gms.games.internal.PopupLocationInfoParcelable;
import com.google.android.gms.games.internal.PopupManager;
import com.google.android.gms.games.internal.constants.RequestType;
import com.google.android.gms.games.internal.events.EventIncrementCache;
import com.google.android.gms.games.internal.events.EventIncrementManager;
import com.google.android.gms.games.internal.experience.ExperienceEventBuffer;
import com.google.android.gms.games.internal.game.Acls;
import com.google.android.gms.games.internal.game.GameInstanceBuffer;
import com.google.android.gms.games.internal.game.GameSearchSuggestionBuffer;
import com.google.android.gms.games.internal.request.RequestUpdateOutcomes;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.games.leaderboard.LeaderboardScoreBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardScoreEntity;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.leaderboard.ScoreSubmissionData;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.Invitations;
import com.google.android.gms.games.multiplayer.OnInvitationReceivedListener;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessage;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomBuffer;
import com.google.android.gms.games.multiplayer.realtime.RoomConfig;
import com.google.android.gms.games.multiplayer.realtime.RoomEntity;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.games.multiplayer.turnbased.LoadMatchesResponse;
import com.google.android.gms.games.multiplayer.turnbased.OnTurnBasedMatchUpdateReceivedListener;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchConfig;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestBuffer;
import com.google.android.gms.games.quest.QuestEntity;
import com.google.android.gms.games.quest.QuestUpdateListener;
import com.google.android.gms.games.quest.Quests;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestBuffer;
import com.google.android.gms.games.request.OnRequestReceivedListener;
import com.google.android.gms.games.request.Requests;
import com.google.android.gms.games.snapshot.Snapshot;
import com.google.android.gms.games.snapshot.SnapshotContents;
import com.google.android.gms.games.snapshot.SnapshotContentsEntity;
import com.google.android.gms.games.snapshot.SnapshotEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataBuffer;
import com.google.android.gms.games.snapshot.SnapshotMetadataChange;
import com.google.android.gms.games.snapshot.SnapshotMetadataChangeEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntity;
import com.google.android.gms.games.snapshot.Snapshots;
import com.google.android.gms.internal.zzpt;
import com.google.android.gms.signin.internal.zzh;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class GamesClientImpl
extends com.google.android.gms.common.internal.zzi<IGamesService> {
    EventIncrementManager zzaoQ = new EventIncrementManager(){

        @Override
        public EventIncrementCache zzsS() {
            return new GameClientEventIncrementCache();
        }
    };
    private final String zzaoR;
    private PlayerEntity zzaoS;
    private GameEntity zzaoT;
    private final PopupManager zzaoU;
    private boolean zzaoV = false;
    private final Binder zzaoW;
    private final long zzaoX;
    private final Games.GamesOptions zzaoY;

    public GamesClientImpl(Context context, Looper looper, zze clientSettings, Games.GamesOptions options, GoogleApiClient.ConnectionCallbacks connectedListener, GoogleApiClient.OnConnectionFailedListener connectionFailedListener) {
        super(context, looper, 1, connectedListener, connectionFailedListener, clientSettings);
        this.zzaoR = clientSettings.zzny();
        this.zzaoW = new Binder();
        this.zzaoU = PopupManager.zza(this, clientSettings.zznu());
        this.zzn(clientSettings.zznA());
        this.zzaoX = ((Object)((Object)this)).hashCode();
        this.zzaoY = options;
    }

    public boolean requiresSignIn() {
        return true;
    }

    public void zznG() {
        super.zznG();
        if (this.zzaoV) {
            this.zzaoU.zztd();
            this.zzaoV = false;
        }
        if (!this.zzaoY.zzanC) {
            this.zzsu();
        }
    }

    public void onConnectionFailed(ConnectionResult result) {
        super.onConnectionFailed(result);
        this.zzaoV = false;
    }

    public void zzfC(int n) {
        this.zzaoU.setGravity(n);
    }

    public void zzn(View view) {
        this.zzaoU.zzo(view);
    }

    protected Set<Scope> zza(Set<Scope> set) {
        boolean bl = false;
        boolean bl2 = false;
        Scope scope = new Scope("https://www.googleapis.com/auth/games");
        Scope scope2 = new Scope("https://www.googleapis.com/auth/games.firstparty");
        for (Scope scope3 : set) {
            if (scope3.equals((Object)scope)) {
                bl = true;
                continue;
            }
            if (!scope3.equals((Object)scope2)) continue;
            bl2 = true;
        }
        if (bl2) {
            zzu.zza((!bl ? 1 : 0) != 0, (String)"Cannot have both %s and %s!", (Object[])new Object[]{"https://www.googleapis.com/auth/games", "https://www.googleapis.com/auth/games.firstparty"});
        } else {
            zzu.zza((boolean)bl, (String)"Games APIs requires %s to function.", (Object[])new Object[]{"https://www.googleapis.com/auth/games"});
        }
        return set;
    }

    public void connect(GoogleApiClient.ConnectionProgressReportCallbacks callbacks) {
        this.zzst();
        super.connect(callbacks);
    }

    public void disconnect() {
        this.zzaoV = false;
        if (this.isConnected()) {
            try {
                IGamesService iGamesService = (IGamesService)this.zznM();
                iGamesService.zzsR();
                this.zzaoQ.flush();
                iGamesService.zzE(this.zzaoX);
            }
            catch (RemoteException remoteException) {
                GamesLog.zzu("GamesClientImpl", "Failed to notify client disconnect.");
            }
        }
        super.disconnect();
    }

    protected String getStartServiceAction() {
        return "com.google.android.gms.games.service.START";
    }

    protected String getServiceDescriptor() {
        return "com.google.android.gms.games.internal.IGamesService";
    }

    protected IGamesService zzbJ(IBinder iBinder) {
        return IGamesService.Stub.zzbM(iBinder);
    }

    public Bundle zzlM() {
        try {
            Bundle bundle = ((IGamesService)this.zznM()).zzlM();
            if (bundle != null) {
                bundle.setClassLoader(GamesClientImpl.class.getClassLoader());
            }
            return bundle;
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return null;
        }
    }

    private void zzst() {
        this.zzaoS = null;
        this.zzaoT = null;
    }

    protected Bundle zzkR() {
        String string = this.getContext().getResources().getConfiguration().locale.toString();
        Bundle bundle = this.zzaoY.zzrI();
        bundle.putString("com.google.android.gms.games.key.gamePackageName", this.zzaoR);
        bundle.putString("com.google.android.gms.games.key.desiredLocale", string);
        bundle.putParcelable("com.google.android.gms.games.key.popupWindowToken", (Parcelable)new BinderWrapper(this.zzaoU.zztf()));
        bundle.putInt("com.google.android.gms.games.key.API_VERSION", 0);
        zze zze2 = this.zznK();
        if (zze2.zznB() != null) {
            bundle.putBundle("com.google.android.gms.games.key.signInOptions", zzh.zza((zzpt)zze2.zznB(), (Integer)zze2.zznC(), (ExecutorService)Executors.newSingleThreadExecutor()));
        }
        return bundle;
    }

    public void zzsu() {
        try {
            PopupLocationInfoBinderCallbacks popupLocationInfoBinderCallbacks = new PopupLocationInfoBinderCallbacks(this.zzaoU);
            ((IGamesService)this.zznM()).zza(popupLocationInfoBinderCallbacks, this.zzaoX);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public String zzsv() {
        try {
            return ((IGamesService)this.zznM()).zzsv();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return null;
        }
    }

    public String zzsw() {
        if (this.zzaoS != null) {
            return this.zzaoS.getPlayerId();
        }
        try {
            return ((IGamesService)this.zznM()).zzsw();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Player zzsx() {
        this.zznL();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.zzaoS == null) {
                try {
                    PlayerBuffer playerBuffer = new PlayerBuffer(((IGamesService)this.zznM()).zzsT());
                    try {
                        if (playerBuffer.getCount() > 0) {
                            this.zzaoS = (PlayerEntity)playerBuffer.get(0).freeze();
                        }
                    }
                    finally {
                        playerBuffer.release();
                    }
                }
                catch (RemoteException remoteException) {
                    this.zzb(remoteException);
                }
            }
        }
        return this.zzaoS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Game zzsy() {
        this.zznL();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.zzaoT == null) {
                try {
                    GameBuffer gameBuffer = new GameBuffer(((IGamesService)this.zznM()).zzsV());
                    try {
                        if (gameBuffer.getCount() > 0) {
                            this.zzaoT = (GameEntity)gameBuffer.get(0).freeze();
                        }
                    }
                    finally {
                        gameBuffer.release();
                    }
                }
                catch (RemoteException remoteException) {
                    this.zzb(remoteException);
                }
            }
        }
        return this.zzaoT;
    }

    public void zza(zza.zzb<Players.LoadPlayersResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zznM()).zzf((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, bl);
    }

    public void zza(zza.zzb<Players.LoadPlayersResult> zzb2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zznM()).zzc((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), stringArray);
    }

    public void zza(zza.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zznM()).zza((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zza(zza.zzb<Players.LoadPlayersResult> zzb2, String string, int n, boolean bl, boolean bl2) throws RemoteException {
        switch (string) {
            case "played_with": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid player collection: " + string);
            }
        }
        ((IGamesService)this.zznM()).zzd(new PlayersLoadedBinderCallback(zzb2), string, n, bl, bl2);
    }

    public void zza(zza.zzb<Players.LoadPlayersResult> zzb2, String string, String string2, int n, boolean bl, boolean bl2) throws RemoteException {
        switch (string) {
            case "circled": 
            case "played_with": 
            case "nearby": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid player collection: " + string);
            }
        }
        ((IGamesService)this.zznM()).zza((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, string2, n, bl, bl2);
    }

    public void zza(zza.zzb<Players.LoadPlayersResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zznM()).zzc((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), bl);
    }

    public Intent zzsz() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zznM()).zzsz();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzo(String string, int n) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zznM()).zzv(string, n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzb(zza.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zznM()).zzb((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), bl);
    }

    public void zzb(zza.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zznM()).zzc((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), string, bl);
    }

    public void zza(zza.zzb<Leaderboards.LoadPlayerScoreResult> zzb2, String string, String string2, int n, int n2) throws RemoteException {
        ((IGamesService)this.zznM()).zza((IGamesCallbacks)new PlayerLeaderboardScoreLoadedBinderCallback(zzb2), string, string2, n, n2);
    }

    public void zza(zza.zzb<Leaderboards.LoadScoresResult> zzb2, String string, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zznM()).zza((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), string, n, n2, n3, bl);
    }

    public void zzb(zza.zzb<Leaderboards.LoadScoresResult> zzb2, String string, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zznM()).zzb((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), string, n, n2, n3, bl);
    }

    public void zza(zza.zzb<Leaderboards.LoadScoresResult> zzb2, LeaderboardScoreBuffer leaderboardScoreBuffer, int n, int n2) throws RemoteException {
        ((IGamesService)this.zznM()).zza((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), leaderboardScoreBuffer.zztF().asBundle(), n, n2);
    }

    public void zza(zza.zzb<Leaderboards.SubmitScoreResult> zzb2, String string, long l, String string2) throws RemoteException {
        SubmitScoreBinderCallbacks submitScoreBinderCallbacks = zzb2 == null ? null : new SubmitScoreBinderCallbacks(zzb2);
        ((IGamesService)this.zznM()).zza((IGamesCallbacks)submitScoreBinderCallbacks, string, l, string2);
    }

    public Intent zzsA() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zznM()).zzsA();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzc(zza.zzb<Achievements.LoadAchievementsResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zznM()).zza((IGamesCallbacks)new AchievementsLoadedBinderCallback(zzb2), bl);
    }

    public void zza(zza.zzb<Achievements.UpdateAchievementResult> zzb2, String string) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zznM()).zza((IGamesCallbacks)achievementUpdatedBinderCallback, string, this.zzaoU.zztf(), this.zzaoU.zzte());
    }

    public void zzb(zza.zzb<Achievements.UpdateAchievementResult> zzb2, String string) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zznM()).zzb((IGamesCallbacks)achievementUpdatedBinderCallback, string, this.zzaoU.zztf(), this.zzaoU.zzte());
    }

    public void zza(zza.zzb<Achievements.UpdateAchievementResult> zzb2, String string, int n) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zznM()).zza((IGamesCallbacks)achievementUpdatedBinderCallback, string, n, this.zzaoU.zztf(), this.zzaoU.zzte());
    }

    public void zzb(zza.zzb<Achievements.UpdateAchievementResult> zzb2, String string, int n) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zznM()).zzb((IGamesCallbacks)achievementUpdatedBinderCallback, string, n, this.zzaoU.zztf(), this.zzaoU.zzte());
    }

    public void zzd(zza.zzb<Events.LoadEventsResult> zzb2, boolean bl) throws RemoteException {
        this.zzaoQ.flush();
        ((IGamesService)this.zznM()).zzf((IGamesCallbacks)new EventsLoadedBinderCallback(zzb2), bl);
    }

    public void zza(zza.zzb<Events.LoadEventsResult> zzb2, boolean bl, String ... stringArray) throws RemoteException {
        this.zzaoQ.flush();
        ((IGamesService)this.zznM()).zza((IGamesCallbacks)new EventsLoadedBinderCallback(zzb2), bl, stringArray);
    }

    public void zzp(String string, int n) {
        this.zzaoQ.zzp(string, n);
    }

    public Intent zzsB() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zznM()).zzsB();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzsC() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zznM()).zzsC();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zza(zzi<OnInvitationReceivedListener> zzi2) {
        try {
            InvitationReceivedBinderCallback invitationReceivedBinderCallback = new InvitationReceivedBinderCallback(zzi2);
            ((IGamesService)this.zznM()).zza((IGamesCallbacks)invitationReceivedBinderCallback, this.zzaoX);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzsD() {
        try {
            ((IGamesService)this.zznM()).zzF(this.zzaoX);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzb(zzi<OnTurnBasedMatchUpdateReceivedListener> zzi2) {
        try {
            MatchUpdateReceivedBinderCallback matchUpdateReceivedBinderCallback = new MatchUpdateReceivedBinderCallback(zzi2);
            ((IGamesService)this.zznM()).zzb((IGamesCallbacks)matchUpdateReceivedBinderCallback, this.zzaoX);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzsE() {
        try {
            ((IGamesService)this.zznM()).zzG(this.zzaoX);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzc(zzi<QuestUpdateListener> zzi2) {
        try {
            QuestUpdateBinderCallback questUpdateBinderCallback = new QuestUpdateBinderCallback(zzi2);
            ((IGamesService)this.zznM()).zzd((IGamesCallbacks)questUpdateBinderCallback, this.zzaoX);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzsF() {
        try {
            ((IGamesService)this.zznM()).zzI(this.zzaoX);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzd(zzi<OnRequestReceivedListener> zzi2) {
        try {
            RequestReceivedBinderCallback requestReceivedBinderCallback = new RequestReceivedBinderCallback(zzi2);
            ((IGamesService)this.zznM()).zzc((IGamesCallbacks)requestReceivedBinderCallback, this.zzaoX);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzsG() {
        try {
            ((IGamesService)this.zznM()).zzH(this.zzaoX);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public Intent zza(PlayerEntity playerEntity) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zznM()).zza(playerEntity);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzsH() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zznM()).zzsH();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zza(Room room, int n) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zznM()).zza((RoomEntity)room.freeze(), n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzsI() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zznM()).zzsI();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzf(zza.zzb<GamesMetadata.LoadGamesResult> zzb2) throws RemoteException {
        ((IGamesService)this.zznM()).zzd(new GamesLoadedBinderCallback(zzb2));
    }

    public void zzb(zza.zzb<Status> zzb2) throws RemoteException {
        this.zzaoQ.flush();
        ((IGamesService)this.zznM()).zza(new SignOutCompleteBinderCallbacks(zzb2));
    }

    public int zzsJ() {
        int n = 4368;
        try {
            n = ((IGamesService)this.zznM()).zzsJ();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public String zzsK() {
        try {
            return ((IGamesService)this.zznM()).zzsK();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return null;
        }
    }

    public void zzc(zza.zzb<Invitations.LoadInvitationsResult> zzb2, int n) throws RemoteException {
        ((IGamesService)this.zznM()).zza((IGamesCallbacks)new InvitationsLoadedBinderCallback(zzb2), n);
    }

    public void zzq(String string, int n) {
        try {
            ((IGamesService)this.zznM()).zzq(string, n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzr(String string, int n) {
        try {
            ((IGamesService)this.zznM()).zzr(string, n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public Intent zzb(int n, int n2, boolean bl) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zznM()).zzb(n, n2, bl);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zza(zza.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, TurnBasedMatchConfig turnBasedMatchConfig) throws RemoteException {
        ((IGamesService)this.zznM()).zza((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), turnBasedMatchConfig.getVariant(), turnBasedMatchConfig.zztL(), turnBasedMatchConfig.getInvitedPlayerIds(), turnBasedMatchConfig.getAutoMatchCriteria());
    }

    public void zzc(zza.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zznM()).zzl(new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string);
    }

    public void zzd(zza.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zznM()).zzm(new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string);
    }

    public int zzsL() {
        int n = -1;
        try {
            n = ((IGamesService)this.zznM()).zzsL();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public void zza(zza.zzb<TurnBasedMultiplayer.UpdateMatchResult> zzb2, String string, byte[] byArray, String string2, ParticipantResult[] participantResultArray) throws RemoteException {
        ((IGamesService)this.zznM()).zza((IGamesCallbacks)new TurnBasedMatchUpdatedBinderCallbacks(zzb2), string, byArray, string2, participantResultArray);
    }

    public void zza(zza.zzb<TurnBasedMultiplayer.UpdateMatchResult> zzb2, String string, byte[] byArray, ParticipantResult[] participantResultArray) throws RemoteException {
        ((IGamesService)this.zznM()).zza((IGamesCallbacks)new TurnBasedMatchUpdatedBinderCallbacks(zzb2), string, byArray, participantResultArray);
    }

    public void zze(zza.zzb<TurnBasedMultiplayer.LeaveMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zznM()).zzo(new TurnBasedMatchLeftBinderCallbacks(zzb2), string);
    }

    public void zza(zza.zzb<TurnBasedMultiplayer.LeaveMatchResult> zzb2, String string, String string2) throws RemoteException {
        ((IGamesService)this.zznM()).zzc((IGamesCallbacks)new TurnBasedMatchLeftBinderCallbacks(zzb2), string, string2);
    }

    public void zzf(zza.zzb<TurnBasedMultiplayer.CancelMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zznM()).zzn(new TurnBasedMatchCanceledBinderCallbacks(zzb2), string);
    }

    public void zzcN(String string) {
        try {
            ((IGamesService)this.zznM()).zzcV(string);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zza(zza.zzb<TurnBasedMultiplayer.LoadMatchesResult> zzb2, int n, int[] nArray) throws RemoteException {
        ((IGamesService)this.zznM()).zza((IGamesCallbacks)new TurnBasedMatchesLoadedBinderCallbacks(zzb2), n, nArray);
    }

    public void zzg(zza.zzb<TurnBasedMultiplayer.LoadMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zznM()).zzp(new TurnBasedMatchLoadedBinderCallbacks(zzb2), string);
    }

    public Intent zzc(int n, int n2, boolean bl) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zznM()).zzc(n, n2, bl);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zza(zzi<RoomUpdateListener> zzi2, zzi<RoomStatusUpdateListener> zzi3, zzi<RealTimeMessageReceivedListener> zzi4, RoomConfig roomConfig) {
        try {
            RoomBinderCallbacks roomBinderCallbacks = new RoomBinderCallbacks(zzi2, zzi3, zzi4);
            ((IGamesService)this.zznM()).zza((IGamesCallbacks)roomBinderCallbacks, (IBinder)this.zzaoW, roomConfig.getVariant(), roomConfig.getInvitedPlayerIds(), roomConfig.getAutoMatchCriteria(), false, this.zzaoX);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzb(zzi<RoomUpdateListener> zzi2, zzi<RoomStatusUpdateListener> zzi3, zzi<RealTimeMessageReceivedListener> zzi4, RoomConfig roomConfig) {
        try {
            RoomBinderCallbacks roomBinderCallbacks = new RoomBinderCallbacks(zzi2, zzi3, zzi4);
            ((IGamesService)this.zznM()).zza((IGamesCallbacks)roomBinderCallbacks, (IBinder)this.zzaoW, roomConfig.getInvitationId(), false, this.zzaoX);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zza(zzi<RoomUpdateListener> zzi2, String string) {
        try {
            ((IGamesService)this.zznM()).zzc((IGamesCallbacks)new RoomBinderCallbacks(zzi2), string);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public int zza(zzi<RealTimeMultiplayer.ReliableMessageSentCallback> zzi2, byte[] byArray, String string, String string2) {
        try {
            return ((IGamesService)this.zznM()).zza((IGamesCallbacks)new RealTimeReliableMessageBinderCallbacks(zzi2), byArray, string, string2);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return -1;
        }
    }

    public int zza(byte[] byArray, String string, String[] stringArray) {
        zzu.zzb((Object)stringArray, (Object)"Participant IDs must not be null");
        try {
            return ((IGamesService)this.zznM()).zzb(byArray, string, stringArray);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return -1;
        }
    }

    public int zzd(byte[] byArray, String string) {
        try {
            return ((IGamesService)this.zznM()).zzb(byArray, string, null);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return -1;
        }
    }

    public void zzfD(int n) {
        try {
            ((IGamesService)this.zznM()).zzfD(n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public Intent zzsM() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zznM()).zzsM();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zza(int n, byte[] byArray, int n2, Bitmap bitmap, String string) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zznM()).zza(n, byArray, n2, string);
            zzu.zzb((Object)bitmap, (Object)"Must provide a non null icon");
            intent.putExtra("com.google.android.gms.games.REQUEST_ITEM_ICON", (Parcelable)bitmap);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public int zzsN() {
        int n = -1;
        try {
            n = ((IGamesService)this.zznM()).zzsN();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public int zzsO() {
        int n = -1;
        try {
            n = ((IGamesService)this.zznM()).zzsO();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public void zzb(zza.zzb<Requests.UpdateRequestsResult> zzb2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zznM()).zza((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(zzb2), stringArray);
    }

    public void zzc(zza.zzb<Requests.UpdateRequestsResult> zzb2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zznM()).zzb((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(zzb2), stringArray);
    }

    public void zza(zza.zzb<Requests.LoadRequestsResult> zzb2, int n, int n2, int n3) throws RemoteException {
        ((IGamesService)this.zznM()).zza((IGamesCallbacks)new RequestsLoadedBinderCallbacks(zzb2), n, n2, n3);
    }

    public void zza(zza.zzb<AppContents.LoadAppContentResult> zzb2, int n, String string, String[] stringArray, boolean bl) throws RemoteException {
        ((IGamesService)this.zznM()).zza((IGamesCallbacks)new AppContentLoadedBinderCallbacks(zzb2), n, string, stringArray, bl);
    }

    public Intent zzb(int[] nArray) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zznM()).zzb(nArray);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzcO(String string) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zznM()).zzcO(string);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzh(zza.zzb<Quests.AcceptQuestResult> zzb2, String string) throws RemoteException {
        this.zzaoQ.flush();
        ((IGamesService)this.zznM()).zzu(new QuestAcceptedBinderCallbacks(zzb2), string);
    }

    public void zzb(zza.zzb<Quests.ClaimMilestoneResult> zzb2, String string, String string2) throws RemoteException {
        this.zzaoQ.flush();
        ((IGamesService)this.zznM()).zzf((IGamesCallbacks)new QuestMilestoneClaimBinderCallbacks(zzb2, string2), string, string2);
    }

    public void zza(zza.zzb<Quests.LoadQuestsResult> zzb2, int[] nArray, int n, boolean bl) throws RemoteException {
        this.zzaoQ.flush();
        ((IGamesService)this.zznM()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), nArray, n, bl);
    }

    public void zzb(zza.zzb<Quests.LoadQuestsResult> zzb2, boolean bl, String[] stringArray) throws RemoteException {
        this.zzaoQ.flush();
        ((IGamesService)this.zznM()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), stringArray, bl);
    }

    public void zzcP(String string) {
        try {
            ((IGamesService)this.zznM()).zza(string, this.zzaoU.zztf(), this.zzaoU.zzte());
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zza(zza.zzb<Quests.LoadQuestsResult> zzb2, String string, String string2, int[] nArray, int n, boolean bl) throws RemoteException {
        this.zzaoQ.flush();
        ((IGamesService)this.zznM()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), string, string2, nArray, n, bl);
    }

    public void zza(zza.zzb<Quests.LoadQuestsResult> zzb2, String string, String string2, boolean bl, String[] stringArray) throws RemoteException {
        this.zzaoQ.flush();
        ((IGamesService)this.zznM()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), string, string2, stringArray, bl);
    }

    public int zzsP() {
        int n = -1;
        try {
            n = ((IGamesService)this.zznM()).zzsP();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public int zzsQ() {
        int n = -1;
        try {
            n = ((IGamesService)this.zznM()).zzsQ();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public Intent zza(String string, boolean bl, boolean bl2, int n) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zznM()).zza(string, bl, bl2, n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zze(zza.zzb<Snapshots.LoadSnapshotsResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zznM()).zzd((IGamesCallbacks)new SnapshotsLoadedBinderCallbacks(zzb2), bl);
    }

    public void zza(zza.zzb<Snapshots.OpenSnapshotResult> zzb2, String string, boolean bl, int n) throws RemoteException {
        ((IGamesService)this.zznM()).zza((IGamesCallbacks)new SnapshotOpenedBinderCallbacks(zzb2), string, bl, n);
    }

    public void zza(zza.zzb<Snapshots.CommitSnapshotResult> zzb2, Snapshot snapshot, SnapshotMetadataChange snapshotMetadataChange) throws RemoteException {
        SnapshotContents snapshotContents = snapshot.getSnapshotContents();
        zzu.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"Snapshot already closed");
        BitmapTeleporter bitmapTeleporter = snapshotMetadataChange.zztQ();
        if (bitmapTeleporter != null) {
            bitmapTeleporter.zzc(this.getContext().getCacheDir());
        }
        Contents contents = snapshotContents.zzpe();
        snapshotContents.close();
        ((IGamesService)this.zznM()).zza((IGamesCallbacks)new SnapshotCommittedBinderCallbacks(zzb2), snapshot.getMetadata().getSnapshotId(), (SnapshotMetadataChangeEntity)snapshotMetadataChange, contents);
    }

    public void zza(Snapshot snapshot) {
        SnapshotContents snapshotContents = snapshot.getSnapshotContents();
        zzu.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"Snapshot already closed");
        Contents contents = snapshotContents.zzpe();
        snapshotContents.close();
        try {
            ((IGamesService)this.zznM()).zza(contents);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzi(zza.zzb<Snapshots.DeleteSnapshotResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zznM()).zzr(new SnapshotDeletedBinderCallbacks(zzb2), string);
    }

    public void zza(zza.zzb<Snapshots.OpenSnapshotResult> zzb2, String string, String string2, SnapshotMetadataChange snapshotMetadataChange, SnapshotContents snapshotContents) throws RemoteException {
        zzu.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"SnapshotContents already closed");
        BitmapTeleporter bitmapTeleporter = snapshotMetadataChange.zztQ();
        if (bitmapTeleporter != null) {
            bitmapTeleporter.zzc(this.getContext().getCacheDir());
        }
        Contents contents = snapshotContents.zzpe();
        snapshotContents.close();
        ((IGamesService)this.zznM()).zza((IGamesCallbacks)new SnapshotOpenedBinderCallbacks(zzb2), string, string2, (SnapshotMetadataChangeEntity)snapshotMetadataChange, contents);
    }

    public void zzj(zza.zzb<GamesMetadata.LoadGameInstancesResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zznM()).zzf((IGamesCallbacks)new GameInstancesLoadedBinderCallback(zzb2), string);
    }

    public void zzk(zza.zzb<GamesMetadata.LoadGameSearchSuggestionsResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zznM()).zzq(new GameSearchSuggestionsLoadedBinderCallback(zzb2), string);
    }

    public void zzc(zza.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zznM()).zzd((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), string, bl);
    }

    public void zza(zza.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, String string, String string2, boolean bl) throws RemoteException {
        ((IGamesService)this.zznM()).zzb((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), string, string2, bl);
    }

    public void zza(zza.zzb<Leaderboards.LoadScoresResult> zzb2, String string, String string2, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zznM()).zza((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), string, string2, n, n2, n3, bl);
    }

    public void zzb(zza.zzb<Leaderboards.LoadScoresResult> zzb2, String string, String string2, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zznM()).zzb(new LeaderboardScoresLoadedBinderCallback(zzb2), string, string2, n, n2, n3, bl);
    }

    public void zzb(zza.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zznM()).zzb((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zzc(zza.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zznM()).zzc((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zzd(zza.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zznM()).zze(new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zzb(zza.zzb<Players.LoadPlayersResult> zzb2, String string, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zznM()).zzb((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, n, bl, bl2);
    }

    public void zzb(zza.zzb<Players.LoadPlayersResult> zzb2, String string, String string2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zznM()).zzb((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, string2, n, bl, bl2);
    }

    public void zzl(zza.zzb<Players.LoadXpForGameCategoriesResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zznM()).zzs(new PlayerXpForGameCategoriesLoadedBinderCallback(zzb2), string);
    }

    public void zzc(zza.zzb<Players.LoadXpStreamResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zznM()).zzb((IGamesCallbacks)new PlayerXpStreamLoadedBinderCallback(zzb2), string, n);
    }

    public void zzd(zza.zzb<Players.LoadXpStreamResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zznM()).zzc((IGamesCallbacks)new PlayerXpStreamLoadedBinderCallback(zzb2), string, n);
    }

    public void zzf(zza.zzb<Players.LoadProfileSettingsResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zznM()).zzg((IGamesCallbacks)new ProfileSettingsLoadedBinderCallback(zzb2), bl);
    }

    public void zzg(zza.zzb<Status> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zznM()).zzh((IGamesCallbacks)new ProfileSettingsUpdatedBinderCallback(zzb2), bl);
    }

    public void zzb(zza.zzb<Achievements.LoadAchievementsResult> zzb2, String string, String string2, boolean bl) throws RemoteException {
        ((IGamesService)this.zznM()).zza((IGamesCallbacks)new AchievementsLoadedBinderCallback(zzb2), string, string2, bl);
    }

    public void zzc(zza.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string, String string2) throws RemoteException {
        ((IGamesService)this.zznM()).zzd((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string, string2);
    }

    public void zzd(zza.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string, String string2) throws RemoteException {
        ((IGamesService)this.zznM()).zze((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string, string2);
    }

    public void zze(zza.zzb<Invitations.LoadInvitationsResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zznM()).zzb((IGamesCallbacks)new InvitationsLoadedBinderCallback(zzb2), string, n, false);
    }

    public void zzm(zza.zzb<Invitations.LoadInvitationsResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zznM()).zzk(new InvitationsLoadedBinderCallback(zzb2), string);
    }

    public void zza(zza.zzb<TurnBasedMultiplayer.LoadMatchesResult> zzb2, String string, int n, int[] nArray) throws RemoteException {
        ((IGamesService)this.zznM()).zza((IGamesCallbacks)new TurnBasedMatchesLoadedBinderCallbacks(zzb2), string, n, nArray);
    }

    public void zzg(zza.zzb<Acls.LoadAclResult> zzb2) throws RemoteException {
        ((IGamesService)this.zznM()).zzh(new NotifyAclLoadedBinderCallback(zzb2));
    }

    public void zzn(zza.zzb<Status> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zznM()).zzj(new NotifyAclUpdatedBinderCallback(zzb2), string);
    }

    public void zzd(zza.zzb<Notifications.GameMuteStatusChangeResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zznM()).zza((IGamesCallbacks)new GameMuteStatusChangedBinderCallback(zzb2), string, bl);
    }

    public void zzo(zza.zzb<Notifications.GameMuteStatusLoadResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zznM()).zzi(new GameMuteStatusLoadedBinderCallback(zzb2), string);
    }

    public void zzh(zza.zzb<Notifications.ContactSettingLoadResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zznM()).zze((IGamesCallbacks)new ContactSettingsLoadedBinderCallback(zzb2), bl);
    }

    public void zza(zza.zzb<Status> zzb2, boolean bl, Bundle bundle) throws RemoteException {
        ((IGamesService)this.zznM()).zza((IGamesCallbacks)new ContactSettingsUpdatedBinderCallback(zzb2), bl, bundle);
    }

    public void zzh(zza.zzb<Notifications.InboxCountResult> zzb2) throws RemoteException {
        ((IGamesService)this.zznM()).zzt(new InboxCountsLoadedBinderCallback(zzb2), null);
    }

    public void zza(zza.zzb<Requests.SendRequestResult> zzb2, String string, String[] stringArray, int n, byte[] byArray, int n2) throws RemoteException {
        ((IGamesService)this.zznM()).zza((IGamesCallbacks)new RequestSentBinderCallbacks(zzb2), string, stringArray, n, byArray, n2);
    }

    public void zza(zza.zzb<Requests.UpdateRequestsResult> zzb2, String string, String string2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zznM()).zza((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(zzb2), string, string2, stringArray);
    }

    public void zza(zza.zzb<Requests.LoadRequestsResult> zzb2, String string, String string2, int n, int n2, int n3) throws RemoteException {
        ((IGamesService)this.zznM()).zza((IGamesCallbacks)new RequestsLoadedBinderCallbacks(zzb2), string, string2, n, n2, n3);
    }

    public void zzf(zza.zzb<Requests.LoadRequestSummariesResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zznM()).zza((IGamesCallbacks)new RequestSummariesLoadedBinderCallbacks(zzb2), string, n);
    }

    public void zzc(zza.zzb<Snapshots.LoadSnapshotsResult> zzb2, String string, String string2, boolean bl) throws RemoteException {
        ((IGamesService)this.zznM()).zzc((IGamesCallbacks)new SnapshotsLoadedBinderCallbacks(zzb2), string, string2, bl);
    }

    public void zza(IBinder iBinder, Bundle bundle) {
        if (this.isConnected()) {
            try {
                ((IGamesService)this.zznM()).zza(iBinder, bundle);
            }
            catch (RemoteException remoteException) {
                this.zzb(remoteException);
            }
        }
    }

    public void zzsR() {
        if (this.isConnected()) {
            try {
                ((IGamesService)this.zznM()).zzsR();
            }
            catch (RemoteException remoteException) {
                this.zzb(remoteException);
            }
        }
    }

    private void zzb(RemoteException remoteException) {
        GamesLog.zzb("GamesClientImpl", "service died", remoteException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Room zzU(DataHolder dataHolder) {
        RoomBuffer roomBuffer = new RoomBuffer(dataHolder);
        Room room = null;
        try {
            if (roomBuffer.getCount() > 0) {
                room = (Room)((Room)roomBuffer.get(0)).freeze();
            }
        }
        finally {
            roomBuffer.release();
        }
        return room;
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (n == 0 && bundle != null) {
            bundle.setClassLoader(GamesClientImpl.class.getClassLoader());
            this.zzaoV = bundle.getBoolean("show_welcome_popup");
            this.zzaoS = (PlayerEntity)bundle.getParcelable("com.google.android.gms.games.current_player");
            this.zzaoT = (GameEntity)bundle.getParcelable("com.google.android.gms.games.current_game");
        }
        super.zza(n, iBinder, bundle, n2);
    }

    protected /* synthetic */ IInterface zzT(IBinder iBinder) {
        return this.zzbJ(iBinder);
    }

    private static final class DeleteSnapshotResultImpl
    implements Snapshots.DeleteSnapshotResult {
        private final Status zzOt;
        private final String zzapg;

        DeleteSnapshotResultImpl(int statusCode, String snapshotId) {
            this.zzOt = GamesStatusCodes.zzfn(statusCode);
            this.zzapg = snapshotId;
        }

        public Status getStatus() {
            return this.zzOt;
        }

        @Override
        public String getSnapshotId() {
            return this.zzapg;
        }
    }

    private static final class CommitSnapshotResultImpl
    extends GamesDataHolderResult
    implements Snapshots.CommitSnapshotResult {
        private final SnapshotMetadata zzapf;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        CommitSnapshotResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(dataHolder);
            try {
                this.zzapf = snapshotMetadataBuffer.getCount() > 0 ? new SnapshotMetadataEntity(snapshotMetadataBuffer.get(0)) : null;
            }
            finally {
                snapshotMetadataBuffer.release();
            }
        }

        @Override
        public SnapshotMetadata getSnapshotMetadata() {
            return this.zzapf;
        }
    }

    private static final class OpenSnapshotResultImpl
    extends GamesDataHolderResult
    implements Snapshots.OpenSnapshotResult {
        private final Snapshot zzapJ;
        private final String zzapK;
        private final Snapshot zzapL;
        private final Contents zzapM;
        private final SnapshotContents zzapN;

        OpenSnapshotResultImpl(DataHolder dataHolder, Contents currentContents) {
            this(dataHolder, null, currentContents, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        OpenSnapshotResultImpl(DataHolder metadataHolder, String conflictId, Contents currentContents, Contents conflictContents, Contents resolutionContents) {
            super(metadataHolder);
            SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(metadataHolder);
            try {
                if (snapshotMetadataBuffer.getCount() == 0) {
                    this.zzapJ = null;
                    this.zzapL = null;
                } else if (snapshotMetadataBuffer.getCount() == 1) {
                    com.google.android.gms.common.internal.zzb.zzU((metadataHolder.getStatusCode() != 4004 ? 1 : 0) != 0);
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity(snapshotMetadataBuffer.get(0));
                    this.zzapJ = new SnapshotEntity(snapshotMetadataEntity, new SnapshotContentsEntity(currentContents));
                    this.zzapL = null;
                } else {
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity(snapshotMetadataBuffer.get(0));
                    this.zzapJ = new SnapshotEntity(snapshotMetadataEntity, new SnapshotContentsEntity(currentContents));
                    SnapshotMetadataEntity snapshotMetadataEntity2 = new SnapshotMetadataEntity(snapshotMetadataBuffer.get(1));
                    this.zzapL = new SnapshotEntity(snapshotMetadataEntity2, new SnapshotContentsEntity(conflictContents));
                }
            }
            finally {
                snapshotMetadataBuffer.release();
            }
            this.zzapK = conflictId;
            this.zzapM = resolutionContents;
            this.zzapN = new SnapshotContentsEntity(resolutionContents);
        }

        @Override
        public Snapshot getSnapshot() {
            return this.zzapJ;
        }

        @Override
        public String getConflictId() {
            return this.zzapK;
        }

        @Override
        public Snapshot getConflictingSnapshot() {
            return this.zzapL;
        }

        @Override
        public SnapshotContents getResolutionSnapshotContents() {
            return this.zzapN;
        }
    }

    private static final class LoadSnapshotsResultImpl
    extends GamesDataHolderResult
    implements Snapshots.LoadSnapshotsResult {
        LoadSnapshotsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public SnapshotMetadataBuffer getSnapshots() {
            return new SnapshotMetadataBuffer(this.zzWu);
        }
    }

    private static final class LoadAppContentsResultImpl
    extends GamesDataHolderResult
    implements AppContents.LoadAppContentResult {
        private final ArrayList<DataHolder> zzapp;

        LoadAppContentsResultImpl(DataHolder[] appContentData) {
            super(appContentData[0]);
            this.zzapp = new ArrayList<DataHolder>(Arrays.asList(appContentData));
        }
    }

    private static final class ClaimMilestoneResultImpl
    extends GamesDataHolderResult
    implements Quests.ClaimMilestoneResult {
        private final Milestone zzape;
        private final Quest zzapb;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ClaimMilestoneResultImpl(DataHolder dataHolder, String milestoneId) {
            super(dataHolder);
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            try {
                if (questBuffer.getCount() > 0) {
                    this.zzapb = new QuestEntity((Quest)questBuffer.get(0));
                    List<Milestone> list = this.zzapb.zztN();
                    int n = list.size();
                    for (int i = 0; i < n; ++i) {
                        if (!list.get(i).getMilestoneId().equals(milestoneId)) continue;
                        this.zzape = list.get(i);
                        return;
                    }
                    this.zzape = null;
                } else {
                    this.zzape = null;
                    this.zzapb = null;
                }
            }
            finally {
                questBuffer.release();
            }
        }

        @Override
        public Milestone getMilestone() {
            return this.zzape;
        }

        @Override
        public Quest getQuest() {
            return this.zzapb;
        }
    }

    private static final class AcceptQuestResultImpl
    extends GamesDataHolderResult
    implements Quests.AcceptQuestResult {
        private final Quest zzapb;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        AcceptQuestResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            try {
                this.zzapb = questBuffer.getCount() > 0 ? new QuestEntity((Quest)questBuffer.get(0)) : null;
            }
            finally {
                questBuffer.release();
            }
        }

        @Override
        public Quest getQuest() {
            return this.zzapb;
        }
    }

    private static final class LoadQuestsResultImpl
    extends GamesDataHolderResult
    implements Quests.LoadQuestsResult {
        private final DataHolder zzWu;

        LoadQuestsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzWu = dataHolder;
        }

        @Override
        public QuestBuffer getQuests() {
            return new QuestBuffer(this.zzWu);
        }
    }

    private static final class LoadRequestSummariesResultImpl
    extends GamesDataHolderResult
    implements Requests.LoadRequestSummariesResult {
        LoadRequestSummariesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class LoadRequestsResultImpl
    implements Requests.LoadRequestsResult {
        private final Status zzOt;
        private final Bundle zzapz;

        LoadRequestsResultImpl(Status status, Bundle requestData) {
            this.zzOt = status;
            this.zzapz = requestData;
        }

        public Status getStatus() {
            return this.zzOt;
        }

        @Override
        public GameRequestBuffer getRequests(int requestType) {
            String string = RequestType.zzfG(requestType);
            if (!this.zzapz.containsKey(string)) {
                return null;
            }
            DataHolder dataHolder = (DataHolder)this.zzapz.get(string);
            return new GameRequestBuffer(dataHolder);
        }

        public void release() {
            for (String string : this.zzapz.keySet()) {
                DataHolder dataHolder = (DataHolder)this.zzapz.getParcelable(string);
                if (dataHolder == null) continue;
                dataHolder.close();
            }
        }
    }

    private static final class UpdateRequestsResultImpl
    extends GamesDataHolderResult
    implements Requests.UpdateRequestsResult {
        private final RequestUpdateOutcomes zzaqo;

        UpdateRequestsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaqo = RequestUpdateOutcomes.zzX(dataHolder);
        }

        @Override
        public int getRequestOutcome(String requestId) {
            return this.zzaqo.getRequestOutcome(requestId);
        }

        @Override
        public Set<String> getRequestIds() {
            return this.zzaqo.getRequestIds();
        }
    }

    private static final class SendRequestResultImpl
    extends GamesDataHolderResult
    implements Requests.SendRequestResult {
        private final GameRequest zzapW;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SendRequestResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            GameRequestBuffer gameRequestBuffer = new GameRequestBuffer(dataHolder);
            try {
                this.zzapW = gameRequestBuffer.getCount() > 0 ? (GameRequest)((GameRequest)gameRequestBuffer.get(0)).freeze() : null;
            }
            finally {
                gameRequestBuffer.release();
            }
        }
    }

    private static final class InboxCountResultImpl
    implements Notifications.InboxCountResult {
        private final Status zzOt;
        private final Bundle zzapj;

        InboxCountResultImpl(Status status, Bundle inboxCounts) {
            this.zzOt = status;
            this.zzapj = inboxCounts;
        }

        public Status getStatus() {
            return this.zzOt;
        }
    }

    private static final class ContactSettingLoadResultImpl
    extends GamesDataHolderResult
    implements Notifications.ContactSettingLoadResult {
        ContactSettingLoadResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class GameMuteStatusLoadResultImpl
    implements Notifications.GameMuteStatusLoadResult {
        private final Status zzOt;
        private final String zzaph;
        private final boolean zzapi;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GameMuteStatusLoadResultImpl(DataHolder dataHolder) {
            try {
                this.zzOt = GamesStatusCodes.zzfn(dataHolder.getStatusCode());
                if (dataHolder.getCount() > 0) {
                    this.zzaph = dataHolder.zzd("external_game_id", 0, 0);
                    this.zzapi = dataHolder.zze("muted", 0, 0);
                } else {
                    this.zzaph = null;
                    this.zzapi = false;
                }
            }
            finally {
                dataHolder.close();
            }
        }

        public Status getStatus() {
            return this.zzOt;
        }
    }

    private static final class GameMuteStatusChangeResultImpl
    implements Notifications.GameMuteStatusChangeResult {
        private final Status zzOt;
        private final String zzaph;
        private final boolean zzapi;

        public GameMuteStatusChangeResultImpl(int statusCode, String externalGameId, boolean isMuted) {
            this.zzOt = GamesStatusCodes.zzfn(statusCode);
            this.zzaph = externalGameId;
            this.zzapi = isMuted;
        }

        public Status getStatus() {
            return this.zzOt;
        }
    }

    private static final class LoadAclResultImpl
    extends GamesDataHolderResult
    implements Acls.LoadAclResult {
        LoadAclResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class CancelMatchResultImpl
    implements TurnBasedMultiplayer.CancelMatchResult {
        private final Status zzOt;
        private final String zzapd;

        CancelMatchResultImpl(Status status, String externalMatchId) {
            this.zzOt = status;
            this.zzapd = externalMatchId;
        }

        public Status getStatus() {
            return this.zzOt;
        }

        @Override
        public String getMatchId() {
            return this.zzapd;
        }
    }

    private static final class LeaveMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.LeaveMatchResult {
        LeaveMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class UpdateMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.UpdateMatchResult {
        UpdateMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class InitiateMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.InitiateMatchResult {
        InitiateMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class LoadMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.LoadMatchResult {
        LoadMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static abstract class TurnBasedMatchResult
    extends GamesDataHolderResult {
        final TurnBasedMatch zzapG;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TurnBasedMatchResult(DataHolder dataHolder) {
            super(dataHolder);
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            try {
                this.zzapG = turnBasedMatchBuffer.getCount() > 0 ? (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze() : null;
            }
            finally {
                turnBasedMatchBuffer.release();
            }
        }

        public TurnBasedMatch getMatch() {
            return this.zzapG;
        }
    }

    private static final class SubmitScoreResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.SubmitScoreResult {
        private final ScoreSubmissionData zzaqh;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SubmitScoreResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            try {
                this.zzaqh = new ScoreSubmissionData(dataHolder);
            }
            finally {
                dataHolder.close();
            }
        }

        @Override
        public ScoreSubmissionData getScoreData() {
            return this.zzaqh;
        }
    }

    private static final class LoadProfileSettingsResultImpl
    extends GamesDataHolderResult
    implements Players.LoadProfileSettingsResult {
        private final boolean zzaoN;
        private final boolean zzapy;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LoadProfileSettingsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            try {
                if (dataHolder.getCount() > 0) {
                    int n = dataHolder.zzbh(0);
                    this.zzaoN = dataHolder.zze("profile_visible", 0, n);
                    this.zzapy = dataHolder.zze("profile_visibility_explicitly_set", 0, n);
                } else {
                    this.zzaoN = true;
                    this.zzapy = false;
                }
            }
            finally {
                dataHolder.close();
            }
        }

        public Status getStatus() {
            return this.zzOt;
        }

        @Override
        public boolean isProfileVisible() {
            return this.zzaoN;
        }

        @Override
        public boolean isVisibilityExplicitlySet() {
            return this.zzapy;
        }
    }

    private static final class LoadXpStreamResultImpl
    extends GamesDataHolderResult
    implements Players.LoadXpStreamResult {
        private final ExperienceEventBuffer zzapE;

        LoadXpStreamResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzapE = new ExperienceEventBuffer(dataHolder);
        }
    }

    private static final class LoadXpForGameCategoriesResultImpl
    implements Players.LoadXpForGameCategoriesResult {
        private final Status zzOt;
        private final List<String> zzapC;
        private final Bundle zzapD;

        LoadXpForGameCategoriesResultImpl(Status status, Bundle xpData) {
            this.zzOt = status;
            this.zzapC = xpData.getStringArrayList("game_category_list");
            this.zzapD = xpData;
        }

        public Status getStatus() {
            return this.zzOt;
        }
    }

    private static final class LoadPlayersResultImpl
    extends GamesDataHolderResult
    implements Players.LoadPlayersResult {
        private final PlayerBuffer zzapx;

        LoadPlayersResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzapx = new PlayerBuffer(dataHolder);
        }

        @Override
        public PlayerBuffer getPlayers() {
            return this.zzapx;
        }
    }

    private static final class LoadMatchesResultImpl
    implements TurnBasedMultiplayer.LoadMatchesResult {
        private final Status zzOt;
        private final LoadMatchesResponse zzapv;

        LoadMatchesResultImpl(Status status, Bundle matchData) {
            this.zzOt = status;
            this.zzapv = new LoadMatchesResponse(matchData);
        }

        public Status getStatus() {
            return this.zzOt;
        }

        @Override
        public LoadMatchesResponse getMatches() {
            return this.zzapv;
        }

        public void release() {
            this.zzapv.release();
        }
    }

    private static final class LoadInvitationsResultImpl
    extends GamesDataHolderResult
    implements Invitations.LoadInvitationsResult {
        private final InvitationBuffer zzapu;

        LoadInvitationsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzapu = new InvitationBuffer(dataHolder);
        }

        @Override
        public InvitationBuffer getInvitations() {
            return this.zzapu;
        }
    }

    private static final class LoadPlayerScoreResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.LoadPlayerScoreResult {
        private final LeaderboardScoreEntity zzapw;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LoadPlayerScoreResultImpl(DataHolder scoreHolder) {
            super(scoreHolder);
            LeaderboardScoreBuffer leaderboardScoreBuffer = new LeaderboardScoreBuffer(scoreHolder);
            try {
                this.zzapw = leaderboardScoreBuffer.getCount() > 0 ? (LeaderboardScoreEntity)leaderboardScoreBuffer.get(0).freeze() : null;
            }
            finally {
                leaderboardScoreBuffer.release();
            }
        }

        @Override
        public LeaderboardScore getScore() {
            return this.zzapw;
        }
    }

    private static final class LoadScoresResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.LoadScoresResult {
        private final LeaderboardEntity zzapA;
        private final LeaderboardScoreBuffer zzapB;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LoadScoresResultImpl(DataHolder leaderboard, DataHolder scores) {
            super(scores);
            LeaderboardBuffer leaderboardBuffer = new LeaderboardBuffer(leaderboard);
            try {
                this.zzapA = leaderboardBuffer.getCount() > 0 ? (LeaderboardEntity)((Leaderboard)leaderboardBuffer.get(0)).freeze() : null;
            }
            finally {
                leaderboardBuffer.release();
            }
            this.zzapB = new LeaderboardScoreBuffer(scores);
        }

        @Override
        public Leaderboard getLeaderboard() {
            return this.zzapA;
        }

        @Override
        public LeaderboardScoreBuffer getScores() {
            return this.zzapB;
        }
    }

    private static final class LeaderboardMetadataResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.LeaderboardMetadataResult {
        private final LeaderboardBuffer zzapm;

        LeaderboardMetadataResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzapm = new LeaderboardBuffer(dataHolder);
        }

        @Override
        public LeaderboardBuffer getLeaderboards() {
            return this.zzapm;
        }
    }

    private static final class LoadGameSearchSuggestionsResultImpl
    extends GamesDataHolderResult
    implements GamesMetadata.LoadGameSearchSuggestionsResult {
        private final GameSearchSuggestionBuffer zzaps;

        LoadGameSearchSuggestionsResultImpl(DataHolder data) {
            super(data);
            this.zzaps = new GameSearchSuggestionBuffer(data);
        }
    }

    private static final class LoadGameInstancesResultImpl
    extends GamesDataHolderResult
    implements GamesMetadata.LoadGameInstancesResult {
        private final GameInstanceBuffer zzapr;

        LoadGameInstancesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzapr = new GameInstanceBuffer(dataHolder);
        }
    }

    private static final class LoadGamesResultImpl
    extends GamesDataHolderResult
    implements GamesMetadata.LoadGamesResult {
        private final GameBuffer zzapt;

        LoadGamesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzapt = new GameBuffer(dataHolder);
        }

        @Override
        public GameBuffer getGames() {
            return this.zzapt;
        }
    }

    private static final class LoadEventResultImpl
    extends GamesDataHolderResult
    implements Events.LoadEventsResult {
        private final EventBuffer zzapq;

        LoadEventResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzapq = new EventBuffer(dataHolder);
        }

        @Override
        public EventBuffer getEvents() {
            return this.zzapq;
        }
    }

    private static final class UpdateAchievementResultImpl
    implements Achievements.UpdateAchievementResult {
        private final Status zzOt;
        private final String zzanZ;

        UpdateAchievementResultImpl(int statusCode, String achievementId) {
            this.zzOt = GamesStatusCodes.zzfn(statusCode);
            this.zzanZ = achievementId;
        }

        public Status getStatus() {
            return this.zzOt;
        }

        @Override
        public String getAchievementId() {
            return this.zzanZ;
        }
    }

    private static final class LoadAchievementsResultImpl
    extends GamesDataHolderResult
    implements Achievements.LoadAchievementsResult {
        private final AchievementBuffer zzapo;

        LoadAchievementsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzapo = new AchievementBuffer(dataHolder);
        }

        @Override
        public AchievementBuffer getAchievements() {
            return this.zzapo;
        }
    }

    private static abstract class GamesDataHolderResult
    extends zzc {
        protected GamesDataHolderResult(DataHolder dataHolder) {
            super(dataHolder, GamesStatusCodes.zzfn(dataHolder.getStatusCode()));
        }
    }

    private static final class RealTimeMessageSentNotifier
    implements zzi.zzb<RealTimeMultiplayer.ReliableMessageSentCallback> {
        private final int zzTS;
        private final String zzapT;
        private final int zzapU;

        RealTimeMessageSentNotifier(int statusCode, int token, String recipientParticipantId) {
            this.zzTS = statusCode;
            this.zzapU = token;
            this.zzapT = recipientParticipantId;
        }

        public void zza(RealTimeMultiplayer.ReliableMessageSentCallback reliableMessageSentCallback) {
            if (reliableMessageSentCallback != null) {
                reliableMessageSentCallback.onRealTimeMessageSent(this.zzTS, this.zzapU, this.zzapT);
            }
        }

        public void zzmw() {
        }

        public /* synthetic */ void zzn(Object object) {
            this.zza((RealTimeMultiplayer.ReliableMessageSentCallback)object);
        }
    }

    private static final class MessageReceivedNotifier
    implements zzi.zzb<RealTimeMessageReceivedListener> {
        private final RealTimeMessage zzapH;

        MessageReceivedNotifier(RealTimeMessage message) {
            this.zzapH = message;
        }

        public void zza(RealTimeMessageReceivedListener realTimeMessageReceivedListener) {
            realTimeMessageReceivedListener.onRealTimeMessageReceived(this.zzapH);
        }

        public void zzmw() {
        }

        public /* synthetic */ void zzn(Object object) {
            this.zza((RealTimeMessageReceivedListener)object);
        }
    }

    private static final class P2PDisconnectedNotifier
    implements zzi.zzb<RoomStatusUpdateListener> {
        private final String zzapO;

        P2PDisconnectedNotifier(String participantId) {
            this.zzapO = participantId;
        }

        public void zza(RoomStatusUpdateListener roomStatusUpdateListener) {
            roomStatusUpdateListener.onP2PDisconnected(this.zzapO);
        }

        public void zzmw() {
        }

        public /* synthetic */ void zzn(Object object) {
            this.zza((RoomStatusUpdateListener)object);
        }
    }

    private static final class P2PConnectedNotifier
    implements zzi.zzb<RoomStatusUpdateListener> {
        private final String zzapO;

        P2PConnectedNotifier(String participantId) {
            this.zzapO = participantId;
        }

        public void zza(RoomStatusUpdateListener roomStatusUpdateListener) {
            roomStatusUpdateListener.onP2PConnected(this.zzapO);
        }

        public void zzmw() {
        }

        public /* synthetic */ void zzn(Object object) {
            this.zza((RoomStatusUpdateListener)object);
        }
    }

    private static final class PeerDisconnectedNotifier
    extends AbstractPeerStatusNotifier {
        PeerDisconnectedNotifier(DataHolder dataHolder, String[] participantIds) {
            super(dataHolder, participantIds);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersDisconnected(room, arrayList);
        }
    }

    private static final class PeerConnectedNotifier
    extends AbstractPeerStatusNotifier {
        PeerConnectedNotifier(DataHolder dataHolder, String[] participantIds) {
            super(dataHolder, participantIds);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersConnected(room, arrayList);
        }
    }

    private static final class PeerDeclinedNotifier
    extends AbstractPeerStatusNotifier {
        PeerDeclinedNotifier(DataHolder dataHolder, String[] participantIds) {
            super(dataHolder, participantIds);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerDeclined(room, arrayList);
        }
    }

    private static final class PeerLeftRoomNotifier
    extends AbstractPeerStatusNotifier {
        PeerLeftRoomNotifier(DataHolder dataHolder, String[] participantIds) {
            super(dataHolder, participantIds);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerLeft(room, arrayList);
        }
    }

    private static final class PeerJoinedRoomNotifier
    extends AbstractPeerStatusNotifier {
        PeerJoinedRoomNotifier(DataHolder dataHolder, String[] participantIds) {
            super(dataHolder, participantIds);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerJoined(room, arrayList);
        }
    }

    private static final class PeerInvitedToRoomNotifier
    extends AbstractPeerStatusNotifier {
        PeerInvitedToRoomNotifier(DataHolder dataHolder, String[] participantIds) {
            super(dataHolder, participantIds);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerInvitedToRoom(room, arrayList);
        }
    }

    private static final class DisconnectedFromRoomNotifier
    extends AbstractRoomStatusNotifier {
        DisconnectedFromRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onDisconnectedFromRoom(room);
        }
    }

    private static final class ConnectedToRoomNotifier
    extends AbstractRoomStatusNotifier {
        ConnectedToRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onConnectedToRoom(room);
        }
    }

    private static final class RoomAutoMatchingNotifier
    extends AbstractRoomStatusNotifier {
        RoomAutoMatchingNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomAutoMatching(room);
        }
    }

    private static final class RoomConnectingNotifier
    extends AbstractRoomStatusNotifier {
        RoomConnectingNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomConnecting(room);
        }
    }

    private static final class RoomConnectedNotifier
    extends AbstractRoomNotifier {
        RoomConnectedNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onRoomConnected(n, room);
        }
    }

    private static final class LeftRoomNotifier
    implements zzi.zzb<RoomUpdateListener> {
        private final int zzTS;
        private final String zzapn;

        LeftRoomNotifier(int statusCode, String roomId) {
            this.zzTS = statusCode;
            this.zzapn = roomId;
        }

        public void zza(RoomUpdateListener roomUpdateListener) {
            roomUpdateListener.onLeftRoom(this.zzTS, this.zzapn);
        }

        public void zzmw() {
        }

        public /* synthetic */ void zzn(Object object) {
            this.zza((RoomUpdateListener)object);
        }
    }

    private static final class JoinedRoomNotifier
    extends AbstractRoomNotifier {
        public JoinedRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onJoinedRoom(n, room);
        }
    }

    private static final class RoomCreatedNotifier
    extends AbstractRoomNotifier {
        public RoomCreatedNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onRoomCreated(n, room);
        }
    }

    private static abstract class AbstractPeerStatusNotifier
    extends AbstractRoomStatusNotifier {
        private final ArrayList<String> zzapa = new ArrayList();

        AbstractPeerStatusNotifier(DataHolder dataHolder, String[] participantIds) {
            super(dataHolder);
            int n = participantIds.length;
            for (int i = 0; i < n; ++i) {
                this.zzapa.add(participantIds[i]);
            }
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            this.zza(roomStatusUpdateListener, room, this.zzapa);
        }

        protected abstract void zza(RoomStatusUpdateListener var1, Room var2, ArrayList<String> var3);
    }

    private static abstract class AbstractRoomStatusNotifier
    extends zzb<RoomStatusUpdateListener> {
        AbstractRoomStatusNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder) {
            this.zza(roomStatusUpdateListener, GamesClientImpl.zzU(dataHolder));
        }

        protected abstract void zza(RoomStatusUpdateListener var1, Room var2);
    }

    private static abstract class AbstractRoomNotifier
    extends zzb<RoomUpdateListener> {
        AbstractRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        protected void zza(RoomUpdateListener roomUpdateListener, DataHolder dataHolder) {
            this.zza(roomUpdateListener, GamesClientImpl.zzU(dataHolder), dataHolder.getStatusCode());
        }

        protected abstract void zza(RoomUpdateListener var1, Room var2, int var3);
    }

    private static final class NearbyPlayerDetectedNotifier
    implements zzi.zzb<OnNearbyPlayerDetectedListener> {
        private final Player zzapI;

        public void zza(OnNearbyPlayerDetectedListener onNearbyPlayerDetectedListener) {
            onNearbyPlayerDetectedListener.zza(this.zzapI);
        }

        public void zzmw() {
        }

        public /* synthetic */ void zzn(Object object) {
            this.zza((OnNearbyPlayerDetectedListener)object);
        }
    }

    private static final class RequestRemovedNotifier
    implements zzi.zzb<OnRequestReceivedListener> {
        private final String zzDK;

        RequestRemovedNotifier(String requestId) {
            this.zzDK = requestId;
        }

        public void zza(OnRequestReceivedListener onRequestReceivedListener) {
            onRequestReceivedListener.onRequestRemoved(this.zzDK);
        }

        public void zzmw() {
        }

        public /* synthetic */ void zzn(Object object) {
            this.zza((OnRequestReceivedListener)object);
        }
    }

    private static final class RequestReceivedNotifier
    implements zzi.zzb<OnRequestReceivedListener> {
        private final GameRequest zzapW;

        RequestReceivedNotifier(GameRequest request) {
            this.zzapW = request;
        }

        public void zza(OnRequestReceivedListener onRequestReceivedListener) {
            onRequestReceivedListener.onRequestReceived(this.zzapW);
        }

        public void zzmw() {
        }

        public /* synthetic */ void zzn(Object object) {
            this.zza((OnRequestReceivedListener)object);
        }
    }

    private static final class QuestCompletedNotifier
    implements zzi.zzb<QuestUpdateListener> {
        private final Quest zzapb;

        QuestCompletedNotifier(Quest quest) {
            this.zzapb = quest;
        }

        public void zza(QuestUpdateListener questUpdateListener) {
            questUpdateListener.onQuestCompleted(this.zzapb);
        }

        public void zzmw() {
        }

        public /* synthetic */ void zzn(Object object) {
            this.zza((QuestUpdateListener)object);
        }
    }

    private static final class MatchRemovedNotifier
    implements zzi.zzb<OnTurnBasedMatchUpdateReceivedListener> {
        private final String zzapF;

        MatchRemovedNotifier(String matchId) {
            this.zzapF = matchId;
        }

        public void zza(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchRemoved(this.zzapF);
        }

        public void zzmw() {
        }

        public /* synthetic */ void zzn(Object object) {
            this.zza((OnTurnBasedMatchUpdateReceivedListener)object);
        }
    }

    private static final class MatchUpdateReceivedNotifier
    implements zzi.zzb<OnTurnBasedMatchUpdateReceivedListener> {
        private final TurnBasedMatch zzapG;

        MatchUpdateReceivedNotifier(TurnBasedMatch match) {
            this.zzapG = match;
        }

        public void zza(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchReceived(this.zzapG);
        }

        public void zzmw() {
        }

        public /* synthetic */ void zzn(Object object) {
            this.zza((OnTurnBasedMatchUpdateReceivedListener)object);
        }
    }

    private static final class InvitationRemovedNotifier
    implements zzi.zzb<OnInvitationReceivedListener> {
        private final String zzapl;

        InvitationRemovedNotifier(String invitationId) {
            this.zzapl = invitationId;
        }

        public void zza(OnInvitationReceivedListener onInvitationReceivedListener) {
            onInvitationReceivedListener.onInvitationRemoved(this.zzapl);
        }

        public void zzmw() {
        }

        public /* synthetic */ void zzn(Object object) {
            this.zza((OnInvitationReceivedListener)object);
        }
    }

    private static final class InvitationReceivedNotifier
    implements zzi.zzb<OnInvitationReceivedListener> {
        private final Invitation zzapk;

        InvitationReceivedNotifier(Invitation invitation) {
            this.zzapk = invitation;
        }

        public void zza(OnInvitationReceivedListener onInvitationReceivedListener) {
            onInvitationReceivedListener.onInvitationReceived(this.zzapk);
        }

        public void zzmw() {
        }

        public /* synthetic */ void zzn(Object object) {
            this.zza((OnInvitationReceivedListener)object);
        }
    }

    static final class SnapshotDeletedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<Snapshots.DeleteSnapshotResult> zzOs;

        public SnapshotDeletedBinderCallbacks(zza.zzb<Snapshots.DeleteSnapshotResult> resultHolder) {
            this.zzOs = (zza.zzb)zzu.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzh(int n, String string) {
            this.zzOs.zzm((Object)new DeleteSnapshotResultImpl(n, string));
        }
    }

    private static final class SnapshotCommittedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<Snapshots.CommitSnapshotResult> zzaqe;

        public SnapshotCommittedBinderCallbacks(zza.zzb<Snapshots.CommitSnapshotResult> resultHolder) {
            this.zzaqe = (zza.zzb)zzu.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzM(DataHolder dataHolder) {
            this.zzaqe.zzm((Object)new CommitSnapshotResultImpl(dataHolder));
        }
    }

    private static final class SnapshotOpenedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<Snapshots.OpenSnapshotResult> zzaqf;

        public SnapshotOpenedBinderCallbacks(zza.zzb<Snapshots.OpenSnapshotResult> resultHolder) {
            this.zzaqf = (zza.zzb)zzu.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zza(DataHolder dataHolder, Contents contents) {
            this.zzaqf.zzm((Object)new OpenSnapshotResultImpl(dataHolder, contents));
        }

        @Override
        public void zza(DataHolder dataHolder, String string, Contents contents, Contents contents2, Contents contents3) {
            this.zzaqf.zzm((Object)new OpenSnapshotResultImpl(dataHolder, string, contents, contents2, contents3));
        }
    }

    private static final class SnapshotsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<Snapshots.LoadSnapshotsResult> zzaqg;

        public SnapshotsLoadedBinderCallbacks(zza.zzb<Snapshots.LoadSnapshotsResult> resultHolder) {
            this.zzaqg = (zza.zzb)zzu.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzL(DataHolder dataHolder) {
            this.zzaqg.zzm((Object)new LoadSnapshotsResultImpl(dataHolder));
        }
    }

    private static final class AppContentLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<AppContents.LoadAppContentResult> zzapc;

        public AppContentLoadedBinderCallbacks(zza.zzb<AppContents.LoadAppContentResult> resultHolder) {
            this.zzapc = (zza.zzb)zzu.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zza(DataHolder[] dataHolderArray) {
            this.zzapc.zzm((Object)new LoadAppContentsResultImpl(dataHolderArray));
        }
    }

    private static final class QuestsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<Quests.LoadQuestsResult> zzapS;

        public QuestsLoadedBinderCallbacks(zza.zzb<Quests.LoadQuestsResult> resultHolder) {
            this.zzapS = (zza.zzb)zzu.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzR(DataHolder dataHolder) {
            this.zzapS.zzm((Object)new LoadQuestsResultImpl(dataHolder));
        }
    }

    private static final class QuestMilestoneClaimBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<Quests.ClaimMilestoneResult> zzapQ;
        private final String zzapR;

        public QuestMilestoneClaimBinderCallbacks(zza.zzb<Quests.ClaimMilestoneResult> resultHolder, String milestoneId) {
            this.zzapQ = (zza.zzb)zzu.zzb(resultHolder, (Object)"Holder must not be null");
            this.zzapR = (String)zzu.zzb((Object)milestoneId, (Object)"MilestoneId must not be null");
        }

        @Override
        public void zzN(DataHolder dataHolder) {
            this.zzapQ.zzm((Object)new ClaimMilestoneResultImpl(dataHolder, this.zzapR));
        }
    }

    private static final class QuestAcceptedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<Quests.AcceptQuestResult> zzapP;

        public QuestAcceptedBinderCallbacks(zza.zzb<Quests.AcceptQuestResult> resultHolder) {
            this.zzapP = (zza.zzb)zzu.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzO(DataHolder dataHolder) {
            this.zzapP.zzm((Object)new AcceptQuestResultImpl(dataHolder));
        }
    }

    private static final class RequestSummariesLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<Requests.LoadRequestSummariesResult> zzapY;

        public RequestSummariesLoadedBinderCallbacks(zza.zzb<Requests.LoadRequestSummariesResult> resultHolder) {
            this.zzapY = (zza.zzb)zzu.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzK(DataHolder dataHolder) {
            this.zzapY.zzm((Object)new LoadRequestSummariesResultImpl(dataHolder));
        }
    }

    private static final class RequestsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<Requests.LoadRequestsResult> zzapZ;

        public RequestsLoadedBinderCallbacks(zza.zzb<Requests.LoadRequestsResult> resultHolder) {
            this.zzapZ = (zza.zzb)zzu.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzd(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzfn(n);
            this.zzapZ.zzm((Object)new LoadRequestsResultImpl(status, bundle));
        }
    }

    private static final class RequestSentBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<Requests.SendRequestResult> zzapX;

        public RequestSentBinderCallbacks(zza.zzb<Requests.SendRequestResult> resultHolder) {
            this.zzapX = (zza.zzb)zzu.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzJ(DataHolder dataHolder) {
            this.zzapX.zzm((Object)new SendRequestResultImpl(dataHolder));
        }
    }

    private static final class RequestsUpdatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<Requests.UpdateRequestsResult> zzaqa;

        public RequestsUpdatedBinderCallbacks(zza.zzb<Requests.UpdateRequestsResult> resultHolder) {
            this.zzaqa = (zza.zzb)zzu.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzI(DataHolder dataHolder) {
            this.zzaqa.zzm((Object)new UpdateRequestsResultImpl(dataHolder));
        }
    }

    private static final class PopupLocationInfoBinderCallbacks
    extends AbstractGamesClient {
        private final PopupManager zzaoU;

        public PopupLocationInfoBinderCallbacks(PopupManager popupManager) {
            this.zzaoU = popupManager;
        }

        @Override
        public PopupLocationInfoParcelable zzsq() {
            return new PopupLocationInfoParcelable(this.zzaoU.zztg());
        }
    }

    private static final class SignOutCompleteBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<Status> zzOs;

        public SignOutCompleteBinderCallbacks(zza.zzb<Status> resultHolder) {
            this.zzOs = (zza.zzb)zzu.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzkU() {
            Status status = GamesStatusCodes.zzfn(0);
            this.zzOs.zzm((Object)status);
        }
    }

    private static final class InboxCountsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Notifications.InboxCountResult> zzOs;

        InboxCountsLoadedBinderCallback(zza.zzb<Notifications.InboxCountResult> holder) {
            this.zzOs = (zza.zzb)zzu.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzg(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzfn(n);
            this.zzOs.zzm((Object)new InboxCountResultImpl(status, bundle));
        }
    }

    private static final class ContactSettingsUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Status> zzOs;

        ContactSettingsUpdatedBinderCallback(zza.zzb<Status> holder) {
            this.zzOs = (zza.zzb)zzu.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzfz(int n) {
            this.zzOs.zzm((Object)GamesStatusCodes.zzfn(n));
        }
    }

    private static final class ContactSettingsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Notifications.ContactSettingLoadResult> zzOs;

        ContactSettingsLoadedBinderCallback(zza.zzb<Notifications.ContactSettingLoadResult> holder) {
            this.zzOs = (zza.zzb)zzu.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzG(DataHolder dataHolder) {
            this.zzOs.zzm((Object)new ContactSettingLoadResultImpl(dataHolder));
        }
    }

    private static final class GameMuteStatusLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Notifications.GameMuteStatusLoadResult> zzOs;

        GameMuteStatusLoadedBinderCallback(zza.zzb<Notifications.GameMuteStatusLoadResult> holder) {
            this.zzOs = (zza.zzb)zzu.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzE(DataHolder dataHolder) {
            this.zzOs.zzm((Object)new GameMuteStatusLoadResultImpl(dataHolder));
        }
    }

    private static final class GameMuteStatusChangedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Notifications.GameMuteStatusChangeResult> zzOs;

        GameMuteStatusChangedBinderCallback(zza.zzb<Notifications.GameMuteStatusChangeResult> holder) {
            this.zzOs = (zza.zzb)zzu.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zza(int n, String string, boolean bl) {
            this.zzOs.zzm((Object)new GameMuteStatusChangeResultImpl(n, string, bl));
        }
    }

    private static final class NotifyAclUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Status> zzOs;

        NotifyAclUpdatedBinderCallback(zza.zzb<Status> resultHolder) {
            this.zzOs = (zza.zzb)zzu.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzfy(int n) {
            this.zzOs.zzm((Object)GamesStatusCodes.zzfn(n));
        }
    }

    private static final class NotifyAclLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Acls.LoadAclResult> zzOs;

        NotifyAclLoadedBinderCallback(zza.zzb<Acls.LoadAclResult> resultHolder) {
            this.zzOs = (zza.zzb)zzu.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzF(DataHolder dataHolder) {
            this.zzOs.zzm((Object)new LoadAclResultImpl(dataHolder));
        }
    }

    private static final class RealTimeReliableMessageBinderCallbacks
    extends AbstractGamesCallbacks {
        final zzi<RealTimeMultiplayer.ReliableMessageSentCallback> zzapV;

        public RealTimeReliableMessageBinderCallbacks(zzi<RealTimeMultiplayer.ReliableMessageSentCallback> messageSentCallbacks) {
            this.zzapV = messageSentCallbacks;
        }

        @Override
        public void zzb(int n, int n2, String string) {
            if (this.zzapV != null) {
                this.zzapV.zza((zzi.zzb)new RealTimeMessageSentNotifier(n, n2, string));
            }
        }
    }

    private static final class RoomBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzi<? extends RoomUpdateListener> zzaqb;
        private final zzi<? extends RoomStatusUpdateListener> zzaqc;
        private final zzi<RealTimeMessageReceivedListener> zzaqd;

        public RoomBinderCallbacks(zzi<RoomUpdateListener> roomCallbacks) {
            this.zzaqb = (zzi)zzu.zzb(roomCallbacks, (Object)"Callbacks must not be null");
            this.zzaqc = null;
            this.zzaqd = null;
        }

        public RoomBinderCallbacks(zzi<? extends RoomUpdateListener> roomCallbacks, zzi<? extends RoomStatusUpdateListener> roomStatusCallbacks, zzi<RealTimeMessageReceivedListener> realTimeMessageReceivedCallbacks) {
            this.zzaqb = (zzi)zzu.zzb(roomCallbacks, (Object)"Callbacks must not be null");
            this.zzaqc = roomStatusCallbacks;
            this.zzaqd = realTimeMessageReceivedCallbacks;
        }

        @Override
        public void zzx(DataHolder dataHolder) {
            this.zzaqb.zza((zzi.zzb)new RoomCreatedNotifier(dataHolder));
        }

        @Override
        public void zzy(DataHolder dataHolder) {
            this.zzaqb.zza((zzi.zzb)new JoinedRoomNotifier(dataHolder));
        }

        @Override
        public void onLeftRoom(int statusCode, String externalRoomId) {
            this.zzaqb.zza((zzi.zzb)new LeftRoomNotifier(statusCode, externalRoomId));
        }

        @Override
        public void zzB(DataHolder dataHolder) {
            this.zzaqb.zza((zzi.zzb)new RoomConnectedNotifier(dataHolder));
        }

        @Override
        public void zzz(DataHolder dataHolder) {
            if (this.zzaqc != null) {
                this.zzaqc.zza((zzi.zzb)new RoomConnectingNotifier(dataHolder));
            }
        }

        @Override
        public void zzA(DataHolder dataHolder) {
            if (this.zzaqc != null) {
                this.zzaqc.zza((zzi.zzb)new RoomAutoMatchingNotifier(dataHolder));
            }
        }

        @Override
        public void zzC(DataHolder dataHolder) {
            if (this.zzaqc != null) {
                this.zzaqc.zza((zzi.zzb)new ConnectedToRoomNotifier(dataHolder));
            }
        }

        @Override
        public void zzD(DataHolder dataHolder) {
            if (this.zzaqc != null) {
                this.zzaqc.zza((zzi.zzb)new DisconnectedFromRoomNotifier(dataHolder));
            }
        }

        @Override
        public void zze(DataHolder dataHolder, String[] stringArray) {
            if (this.zzaqc != null) {
                this.zzaqc.zza((zzi.zzb)new PeerConnectedNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzf(DataHolder dataHolder, String[] stringArray) {
            if (this.zzaqc != null) {
                this.zzaqc.zza((zzi.zzb)new PeerDisconnectedNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zza(DataHolder dataHolder, String[] stringArray) {
            if (this.zzaqc != null) {
                this.zzaqc.zza((zzi.zzb)new PeerInvitedToRoomNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzb(DataHolder dataHolder, String[] stringArray) {
            if (this.zzaqc != null) {
                this.zzaqc.zza((zzi.zzb)new PeerJoinedRoomNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzc(DataHolder dataHolder, String[] stringArray) {
            if (this.zzaqc != null) {
                this.zzaqc.zza((zzi.zzb)new PeerLeftRoomNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzd(DataHolder dataHolder, String[] stringArray) {
            if (this.zzaqc != null) {
                this.zzaqc.zza((zzi.zzb)new PeerDeclinedNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void onP2PConnected(String participantId) {
            if (this.zzaqc != null) {
                this.zzaqc.zza((zzi.zzb)new P2PConnectedNotifier(participantId));
            }
        }

        @Override
        public void onP2PDisconnected(String participantId) {
            if (this.zzaqc != null) {
                this.zzaqc.zza((zzi.zzb)new P2PDisconnectedNotifier(participantId));
            }
        }

        @Override
        public void onRealTimeMessageReceived(RealTimeMessage message) {
            if (this.zzaqd != null) {
                this.zzaqd.zza((zzi.zzb)new MessageReceivedNotifier(message));
            }
        }
    }

    private static final class TurnBasedMatchCanceledBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<TurnBasedMultiplayer.CancelMatchResult> zzaqi;

        public TurnBasedMatchCanceledBinderCallbacks(zza.zzb<TurnBasedMultiplayer.CancelMatchResult> resultHolder) {
            this.zzaqi = (zza.zzb)zzu.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzg(int n, String string) {
            Status status = GamesStatusCodes.zzfn(n);
            this.zzaqi.zzm((Object)new CancelMatchResultImpl(status, string));
        }
    }

    private static final class TurnBasedMatchLeftBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<TurnBasedMultiplayer.LeaveMatchResult> zzaqk;

        public TurnBasedMatchLeftBinderCallbacks(zza.zzb<TurnBasedMultiplayer.LeaveMatchResult> resultHolder) {
            this.zzaqk = (zza.zzb)zzu.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzv(DataHolder dataHolder) {
            this.zzaqk.zzm((Object)new LeaveMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchUpdatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<TurnBasedMultiplayer.UpdateMatchResult> zzaqm;

        public TurnBasedMatchUpdatedBinderCallbacks(zza.zzb<TurnBasedMultiplayer.UpdateMatchResult> resultHolder) {
            this.zzaqm = (zza.zzb)zzu.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzu(DataHolder dataHolder) {
            this.zzaqm.zzm((Object)new UpdateMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchInitiatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzaqj;

        public TurnBasedMatchInitiatedBinderCallbacks(zza.zzb<TurnBasedMultiplayer.InitiateMatchResult> resultHolder) {
            this.zzaqj = (zza.zzb)zzu.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzt(DataHolder dataHolder) {
            this.zzaqj.zzm((Object)new InitiateMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<TurnBasedMultiplayer.LoadMatchResult> zzaql;

        public TurnBasedMatchLoadedBinderCallbacks(zza.zzb<TurnBasedMultiplayer.LoadMatchResult> resultHolder) {
            this.zzaql = (zza.zzb)zzu.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzs(DataHolder dataHolder) {
            this.zzaql.zzm((Object)new LoadMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchesLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<TurnBasedMultiplayer.LoadMatchesResult> zzaqn;

        public TurnBasedMatchesLoadedBinderCallbacks(zza.zzb<TurnBasedMultiplayer.LoadMatchesResult> resultHolder) {
            this.zzaqn = (zza.zzb)zzu.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzc(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzfn(n);
            this.zzaqn.zzm((Object)new LoadMatchesResultImpl(status, bundle));
        }
    }

    private static final class SubmitScoreBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<Leaderboards.SubmitScoreResult> zzOs;

        public SubmitScoreBinderCallbacks(zza.zzb<Leaderboards.SubmitScoreResult> resultHolder) {
            this.zzOs = (zza.zzb)zzu.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzi(DataHolder dataHolder) {
            this.zzOs.zzm((Object)new SubmitScoreResultImpl(dataHolder));
        }
    }

    private static final class ProfileSettingsUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Status> zzOs;

        ProfileSettingsUpdatedBinderCallback(zza.zzb<Status> holder) {
            this.zzOs = (zza.zzb)zzu.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzfA(int n) {
            this.zzOs.zzm((Object)GamesStatusCodes.zzfn(n));
        }
    }

    static final class ProfileSettingsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Players.LoadProfileSettingsResult> zzOs;

        ProfileSettingsLoadedBinderCallback(zza.zzb<Players.LoadProfileSettingsResult> holder) {
            this.zzOs = (zza.zzb)zzu.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzT(DataHolder dataHolder) {
            this.zzOs.zzm((Object)new LoadProfileSettingsResultImpl(dataHolder));
        }
    }

    static final class PlayerXpStreamLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Players.LoadXpStreamResult> zzOs;

        PlayerXpStreamLoadedBinderCallback(zza.zzb<Players.LoadXpStreamResult> holder) {
            this.zzOs = (zza.zzb)zzu.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzS(DataHolder dataHolder) {
            this.zzOs.zzm((Object)new LoadXpStreamResultImpl(dataHolder));
        }
    }

    private static final class PlayerXpForGameCategoriesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Players.LoadXpForGameCategoriesResult> zzOs;

        PlayerXpForGameCategoriesLoadedBinderCallback(zza.zzb<Players.LoadXpForGameCategoriesResult> holder) {
            this.zzOs = (zza.zzb)zzu.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzf(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzfn(n);
            this.zzOs.zzm((Object)new LoadXpForGameCategoriesResultImpl(status, bundle));
        }
    }

    private static final class PlayersLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Players.LoadPlayersResult> zzOs;

        PlayersLoadedBinderCallback(zza.zzb<Players.LoadPlayersResult> holder) {
            this.zzOs = (zza.zzb)zzu.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzj(DataHolder dataHolder) {
            this.zzOs.zzm((Object)new LoadPlayersResultImpl(dataHolder));
        }

        @Override
        public void zzk(DataHolder dataHolder) {
            this.zzOs.zzm((Object)new LoadPlayersResultImpl(dataHolder));
        }
    }

    private static final class RequestReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzi<OnRequestReceivedListener> zzafi;

        RequestReceivedBinderCallback(zzi<OnRequestReceivedListener> listener) {
            this.zzafi = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzr(DataHolder dataHolder) {
            GameRequestBuffer gameRequestBuffer = new GameRequestBuffer(dataHolder);
            GameRequest gameRequest = null;
            try {
                if (gameRequestBuffer.getCount() > 0) {
                    gameRequest = (GameRequest)((GameRequest)gameRequestBuffer.get(0)).freeze();
                }
            }
            finally {
                gameRequestBuffer.release();
            }
            if (gameRequest != null) {
                this.zzafi.zza((zzi.zzb)new RequestReceivedNotifier(gameRequest));
            }
        }

        @Override
        public void onRequestRemoved(String requestId) {
            this.zzafi.zza((zzi.zzb)new RequestRemovedNotifier(requestId));
        }
    }

    private static final class QuestUpdateBinderCallback
    extends AbstractGamesCallbacks {
        private final zzi<QuestUpdateListener> zzafi;

        QuestUpdateBinderCallback(zzi<QuestUpdateListener> listener) {
            this.zzafi = listener;
        }

        @Override
        public void zzP(DataHolder dataHolder) {
            Quest quest = this.zzW(dataHolder);
            if (quest != null) {
                this.zzafi.zza((zzi.zzb)new QuestCompletedNotifier(quest));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Quest zzW(DataHolder dataHolder) {
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            Quest quest = null;
            try {
                if (questBuffer.getCount() > 0) {
                    quest = (Quest)((Quest)questBuffer.get(0)).freeze();
                }
            }
            finally {
                questBuffer.release();
            }
            return quest;
        }
    }

    private static final class MatchUpdateReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzi<OnTurnBasedMatchUpdateReceivedListener> zzafi;

        MatchUpdateReceivedBinderCallback(zzi<OnTurnBasedMatchUpdateReceivedListener> listener) {
            this.zzafi = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzw(DataHolder dataHolder) {
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            TurnBasedMatch turnBasedMatch = null;
            try {
                if (turnBasedMatchBuffer.getCount() > 0) {
                    turnBasedMatch = (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze();
                }
            }
            finally {
                turnBasedMatchBuffer.release();
            }
            if (turnBasedMatch != null) {
                this.zzafi.zza((zzi.zzb)new MatchUpdateReceivedNotifier(turnBasedMatch));
            }
        }

        @Override
        public void onTurnBasedMatchRemoved(String matchId) {
            this.zzafi.zza((zzi.zzb)new MatchRemovedNotifier(matchId));
        }
    }

    private static final class InvitationReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzi<OnInvitationReceivedListener> zzafi;

        InvitationReceivedBinderCallback(zzi<OnInvitationReceivedListener> listener) {
            this.zzafi = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzq(DataHolder dataHolder) {
            InvitationBuffer invitationBuffer = new InvitationBuffer(dataHolder);
            Invitation invitation = null;
            try {
                if (invitationBuffer.getCount() > 0) {
                    invitation = (Invitation)((Invitation)invitationBuffer.get(0)).freeze();
                }
            }
            finally {
                invitationBuffer.release();
            }
            if (invitation != null) {
                this.zzafi.zza((zzi.zzb)new InvitationReceivedNotifier(invitation));
            }
        }

        @Override
        public void onInvitationRemoved(String invitationId) {
            this.zzafi.zza((zzi.zzb)new InvitationRemovedNotifier(invitationId));
        }
    }

    private static final class InvitationsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Invitations.LoadInvitationsResult> zzOs;

        InvitationsLoadedBinderCallback(zza.zzb<Invitations.LoadInvitationsResult> resultHolder) {
            this.zzOs = (zza.zzb)zzu.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzp(DataHolder dataHolder) {
            this.zzOs.zzm((Object)new LoadInvitationsResultImpl(dataHolder));
        }
    }

    private static final class PlayerLeaderboardScoreLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Leaderboards.LoadPlayerScoreResult> zzOs;

        PlayerLeaderboardScoreLoadedBinderCallback(zza.zzb<Leaderboards.LoadPlayerScoreResult> resultHolder) {
            this.zzOs = (zza.zzb)zzu.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzH(DataHolder dataHolder) {
            this.zzOs.zzm((Object)new LoadPlayerScoreResultImpl(dataHolder));
        }
    }

    private static final class LeaderboardScoresLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Leaderboards.LoadScoresResult> zzOs;

        LeaderboardScoresLoadedBinderCallback(zza.zzb<Leaderboards.LoadScoresResult> resultHolder) {
            this.zzOs = (zza.zzb)zzu.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zza(DataHolder dataHolder, DataHolder dataHolder2) {
            this.zzOs.zzm((Object)new LoadScoresResultImpl(dataHolder, dataHolder2));
        }
    }

    private static final class LeaderboardsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Leaderboards.LeaderboardMetadataResult> zzOs;

        LeaderboardsLoadedBinderCallback(zza.zzb<Leaderboards.LeaderboardMetadataResult> resultHolder) {
            this.zzOs = (zza.zzb)zzu.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzh(DataHolder dataHolder) {
            this.zzOs.zzm((Object)new LeaderboardMetadataResultImpl(dataHolder));
        }
    }

    private static final class GameSearchSuggestionsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<GamesMetadata.LoadGameSearchSuggestionsResult> zzOs;

        GameSearchSuggestionsLoadedBinderCallback(zza.zzb<GamesMetadata.LoadGameSearchSuggestionsResult> holder) {
            this.zzOs = (zza.zzb)zzu.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzo(DataHolder dataHolder) {
            this.zzOs.zzm((Object)new LoadGameSearchSuggestionsResultImpl(dataHolder));
        }
    }

    private static final class GameInstancesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<GamesMetadata.LoadGameInstancesResult> zzOs;

        GameInstancesLoadedBinderCallback(zza.zzb<GamesMetadata.LoadGameInstancesResult> holder) {
            this.zzOs = (zza.zzb)zzu.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzn(DataHolder dataHolder) {
            this.zzOs.zzm((Object)new LoadGameInstancesResultImpl(dataHolder));
        }
    }

    private static final class EventsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Events.LoadEventsResult> zzOs;

        EventsLoadedBinderCallback(zza.zzb<Events.LoadEventsResult> resultHolder) {
            this.zzOs = (zza.zzb)zzu.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzg(DataHolder dataHolder) {
            this.zzOs.zzm((Object)new LoadEventResultImpl(dataHolder));
        }
    }

    private static final class GamesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<GamesMetadata.LoadGamesResult> zzOs;

        GamesLoadedBinderCallback(zza.zzb<GamesMetadata.LoadGamesResult> holder) {
            this.zzOs = (zza.zzb)zzu.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzl(DataHolder dataHolder) {
            this.zzOs.zzm((Object)new LoadGamesResultImpl(dataHolder));
        }
    }

    private static final class AchievementUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Achievements.UpdateAchievementResult> zzOs;

        AchievementUpdatedBinderCallback(zza.zzb<Achievements.UpdateAchievementResult> resultHolder) {
            this.zzOs = (zza.zzb)zzu.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzf(int n, String string) {
            this.zzOs.zzm((Object)new UpdateAchievementResultImpl(n, string));
        }
    }

    private static final class AchievementsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Achievements.LoadAchievementsResult> zzOs;

        AchievementsLoadedBinderCallback(zza.zzb<Achievements.LoadAchievementsResult> resultHolder) {
            this.zzOs = (zza.zzb)zzu.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzf(DataHolder dataHolder) {
            this.zzOs.zzm((Object)new LoadAchievementsResultImpl(dataHolder));
        }
    }

    private class GameClientEventIncrementCache
    extends EventIncrementCache {
        public GameClientEventIncrementCache() {
            super(GamesClientImpl.this.getContext().getMainLooper(), 1000);
        }

        @Override
        protected void zzs(String string, int n) {
            try {
                if (GamesClientImpl.this.isConnected()) {
                    ((IGamesService)GamesClientImpl.this.zznM()).zzp(string, n);
                } else {
                    GamesLog.zzv("GamesClientImpl", "Unable to increment event " + string + " by " + n + " because the games client is no longer connected");
                }
            }
            catch (RemoteException remoteException) {
                GamesClientImpl.this.zzb(remoteException);
            }
        }
    }
}

