/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.view.Display;
import android.view.View;
import android.view.ViewTreeObserver;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.games.internal.GamesLog;
import com.google.android.gms.internal.zzlv;
import java.lang.ref.WeakReference;

public class PopupManager {
    protected GamesClientImpl zzauo;
    protected PopupLocationInfo zzaup;

    public static PopupManager zza(GamesClientImpl gamesClientImpl, int n) {
        if (zzlv.zzpP()) {
            return new PopupManagerHCMR1(gamesClientImpl, n);
        }
        return new PopupManager(gamesClientImpl, n);
    }

    private PopupManager(GamesClientImpl gamesClientImpl, int gravity) {
        this.zzauo = gamesClientImpl;
        this.zzfP(gravity);
    }

    protected void zzfP(int n) {
        this.zzaup = new PopupLocationInfo(n, (IBinder)new Binder());
    }

    public void setGravity(int gravity) {
        this.zzaup.gravity = gravity;
    }

    public void zzn(View view) {
    }

    public void zzup() {
        this.zzauo.zza(this.zzaup.zzauq, this.zzaup.zzuo());
    }

    public Bundle zzuq() {
        return this.zzaup.zzuo();
    }

    public IBinder zzur() {
        return this.zzaup.zzauq;
    }

    public PopupLocationInfo zzus() {
        return this.zzaup;
    }

    public static final class PopupLocationInfo {
        public IBinder zzauq;
        public int gravity;
        public int zzaur = -1;
        public int left = 0;
        public int top = 0;
        public int right = 0;
        public int bottom = 0;

        private PopupLocationInfo(int gravity, IBinder windowToken) {
            this.gravity = gravity;
            this.zzauq = windowToken;
        }

        public Bundle zzuo() {
            Bundle bundle = new Bundle();
            bundle.putInt("popupLocationInfo.gravity", this.gravity);
            bundle.putInt("popupLocationInfo.displayId", this.zzaur);
            bundle.putInt("popupLocationInfo.left", this.left);
            bundle.putInt("popupLocationInfo.top", this.top);
            bundle.putInt("popupLocationInfo.right", this.right);
            bundle.putInt("popupLocationInfo.bottom", this.bottom);
            return bundle;
        }
    }

    private static final class PopupManagerHCMR1
    extends PopupManager
    implements View.OnAttachStateChangeListener,
    ViewTreeObserver.OnGlobalLayoutListener {
        private WeakReference<View> zzaus;
        private boolean zzasO = false;

        protected PopupManagerHCMR1(GamesClientImpl gamesClientImpl, int gravity) {
            super(gamesClientImpl, gravity);
        }

        @Override
        protected void zzfP(int n) {
            this.zzaup = new PopupLocationInfo(n, null);
        }

        @Override
        public void zzn(View view) {
            Context context;
            View view2;
            this.zzauo.zzud();
            if (this.zzaus != null) {
                view2 = (View)this.zzaus.get();
                context = this.zzauo.getContext();
                if (view2 == null && context instanceof Activity) {
                    view2 = ((Activity)context).getWindow().getDecorView();
                }
                if (view2 != null) {
                    view2.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                    ViewTreeObserver viewTreeObserver = view2.getViewTreeObserver();
                    if (zzlv.zzpS()) {
                        viewTreeObserver.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    } else {
                        viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                }
            }
            this.zzaus = null;
            view2 = this.zzauo.getContext();
            if (view == null && view2 instanceof Activity) {
                context = (Activity)view2;
                view = context.findViewById(0x1020002);
                if (view == null) {
                    view = ((Activity)view2).getWindow().getDecorView();
                }
                GamesLog.zzw("PopupManager", "You have not specified a View to use as content view for popups. Falling back to the Activity content view. Note that this may not work as expected in multi-screen environments");
            }
            if (view != null) {
                this.zzo(view);
                this.zzaus = new WeakReference<View>(view);
                view.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                context = view.getViewTreeObserver();
                context.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            } else {
                GamesLog.zzx("PopupManager", "No content view usable to display popups. Popups will not be displayed in response to this client's calls. Use setViewForPopups() to set your content view.");
            }
        }

        @Override
        public void zzup() {
            if (this.zzaup.zzauq != null) {
                super.zzup();
                return;
            }
            this.zzasO = this.zzaus != null;
        }

        public void onViewAttachedToWindow(View v) {
            this.zzo(v);
        }

        public void onViewDetachedFromWindow(View v) {
            this.zzauo.zzud();
            v.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
        }

        public void onGlobalLayout() {
            if (this.zzaus == null) {
                return;
            }
            View view = (View)this.zzaus.get();
            if (view == null) {
                return;
            }
            this.zzo(view);
        }

        private void zzo(View view) {
            Display display;
            int n = -1;
            if (zzlv.zzpT()) {
                display = view.getDisplay();
                n = display != null ? display.getDisplayId() : -1;
            }
            display = view.getWindowToken();
            int[] nArray = new int[2];
            view.getLocationInWindow(nArray);
            int n2 = view.getWidth();
            int n3 = view.getHeight();
            this.zzaup.zzaur = n;
            this.zzaup.zzauq = display;
            this.zzaup.left = nArray[0];
            this.zzaup.top = nArray[1];
            this.zzaup.right = nArray[0] + n2;
            this.zzaup.bottom = nArray[1] + n3;
            if (this.zzasO) {
                this.zzup();
                this.zzasO = false;
            }
        }
    }
}

