/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.games.internal.constants.TimeSpan;
import java.util.HashMap;

public final class ScoreSubmissionData {
    private static final String[] zzaxr = new String[]{"leaderboardId", "playerId", "timeSpan", "hasResult", "rawScore", "formattedScore", "newBest", "scoreTag"};
    private String zzaxt;
    private String zzWn;
    private int zzWu;
    private HashMap<Integer, Result> zzaxX;

    public ScoreSubmissionData(DataHolder dataHolder) {
        this.zzWu = dataHolder.getStatusCode();
        this.zzaxX = new HashMap();
        int n = dataHolder.getCount();
        zzx.zzZ((n == 3 ? 1 : 0) != 0);
        for (int i = 0; i < n; ++i) {
            boolean bl;
            int n2 = dataHolder.zzbo(i);
            if (i == 0) {
                this.zzaxt = dataHolder.zzd("leaderboardId", i, n2);
                this.zzWn = dataHolder.zzd("playerId", i, n2);
            }
            if (!(bl = dataHolder.zze("hasResult", i, n2))) continue;
            Result result = new Result(dataHolder.zzb("rawScore", i, n2), dataHolder.zzd("formattedScore", i, n2), dataHolder.zzd("scoreTag", i, n2), dataHolder.zze("newBest", i, n2));
            this.zza(result, dataHolder.zzc("timeSpan", i, n2));
        }
    }

    public String getLeaderboardId() {
        return this.zzaxt;
    }

    public String getPlayerId() {
        return this.zzWn;
    }

    public Result getScoreResult(int timeSpan) {
        return this.zzaxX.get(timeSpan);
    }

    private void zza(Result result, int n) {
        this.zzaxX.put(n, result);
    }

    public String toString() {
        zzw.zza zza2 = zzw.zzu((Object)this).zzg("PlayerId", (Object)this.zzWn).zzg("StatusCode", (Object)this.zzWu);
        for (int i = 0; i < 3; ++i) {
            Result result = this.zzaxX.get(i);
            zza2.zzg("TimesSpan", (Object)TimeSpan.zzfQ(i));
            zza2.zzg("Result", (Object)(result == null ? "null" : result.toString()));
        }
        return zza2.toString();
    }

    public static final class Result {
        public final long rawScore;
        public final String formattedScore;
        public final String scoreTag;
        public final boolean newBest;

        public Result(long rawScore, String formattedScore, String scoreTag, boolean newBest) {
            this.rawScore = rawScore;
            this.formattedScore = formattedScore;
            this.scoreTag = scoreTag;
            this.newBest = newBest;
        }

        public String toString() {
            return zzw.zzu((Object)this).zzg("RawScore", (Object)this.rawScore).zzg("FormattedScore", (Object)this.formattedScore).zzg("ScoreTag", (Object)this.scoreTag).zzg("NewBest", (Object)this.newBest).toString();
        }
    }
}

