/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.event;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.event.Event;
import com.google.android.gms.games.event.EventEntityCreator;
import com.google.android.gms.internal.zzmo;

public final class EventEntity
implements SafeParcelable,
Event {
    public static final EventEntityCreator CREATOR = new EventEntityCreator();
    private final int mVersionCode;
    private final String zzavb;
    private final String mName;
    private final String zzaqZ;
    private final Uri zzatu;
    private final String zzatF;
    private final PlayerEntity zzaux;
    private final long zzavc;
    private final String zzavd;
    private final boolean zzave;

    public EventEntity(Event event) {
        this.mVersionCode = 1;
        this.zzavb = event.getEventId();
        this.mName = event.getName();
        this.zzaqZ = event.getDescription();
        this.zzatu = event.getIconImageUri();
        this.zzatF = event.getIconImageUrl();
        this.zzaux = (PlayerEntity)event.getPlayer().freeze();
        this.zzavc = event.getValue();
        this.zzavd = event.getFormattedValue();
        this.zzave = event.isVisible();
    }

    EventEntity(int versionCode, String eventId, String name, String description, Uri iconImageUri, String iconImageUrl, Player player, long value, String formattedValue, boolean isVisible) {
        this.mVersionCode = versionCode;
        this.zzavb = eventId;
        this.mName = name;
        this.zzaqZ = description;
        this.zzatu = iconImageUri;
        this.zzatF = iconImageUrl;
        this.zzaux = new PlayerEntity(player);
        this.zzavc = value;
        this.zzavd = formattedValue;
        this.zzave = isVisible;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getEventId() {
        return this.zzavb;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer dataOut) {
        zzmo.zzb((String)this.mName, (CharArrayBuffer)dataOut);
    }

    @Override
    public String getDescription() {
        return this.zzaqZ;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zzmo.zzb((String)this.zzaqZ, (CharArrayBuffer)dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzatu;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzatF;
    }

    @Override
    public Player getPlayer() {
        return this.zzaux;
    }

    @Override
    public long getValue() {
        return this.zzavc;
    }

    @Override
    public String getFormattedValue() {
        return this.zzavd;
    }

    @Override
    public void getFormattedValue(CharArrayBuffer dataOut) {
        zzmo.zzb((String)this.zzavd, (CharArrayBuffer)dataOut);
    }

    @Override
    public boolean isVisible() {
        return this.zzave;
    }

    public Event freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return EventEntity.zza(this);
    }

    static int zza(Event event) {
        return zzw.hashCode((Object[])new Object[]{event.getEventId(), event.getName(), event.getDescription(), event.getIconImageUri(), event.getIconImageUrl(), event.getPlayer(), event.getValue(), event.getFormattedValue(), event.isVisible()});
    }

    public boolean equals(Object obj) {
        return EventEntity.zza(this, obj);
    }

    static boolean zza(Event event, Object object) {
        if (!(object instanceof Event)) {
            return false;
        }
        if (event == object) {
            return true;
        }
        Event event2 = (Event)object;
        return zzw.equal((Object)event2.getEventId(), (Object)event.getEventId()) && zzw.equal((Object)event2.getName(), (Object)event.getName()) && zzw.equal((Object)event2.getDescription(), (Object)event.getDescription()) && zzw.equal((Object)event2.getIconImageUri(), (Object)event.getIconImageUri()) && zzw.equal((Object)event2.getIconImageUrl(), (Object)event.getIconImageUrl()) && zzw.equal((Object)event2.getPlayer(), (Object)event.getPlayer()) && zzw.equal((Object)event2.getValue(), (Object)event.getValue()) && zzw.equal((Object)event2.getFormattedValue(), (Object)event.getFormattedValue()) && zzw.equal((Object)event2.isVisible(), (Object)event.isVisible());
    }

    public String toString() {
        return EventEntity.zzb(this);
    }

    static String zzb(Event event) {
        return zzw.zzv((Object)event).zzg("Id", (Object)event.getEventId()).zzg("Name", (Object)event.getName()).zzg("Description", (Object)event.getDescription()).zzg("IconImageUri", (Object)event.getIconImageUri()).zzg("IconImageUrl", (Object)event.getIconImageUrl()).zzg("Player", (Object)event.getPlayer()).zzg("Value", (Object)event.getValue()).zzg("FormattedValue", (Object)event.getFormattedValue()).zzg("isVisible", (Object)event.isVisible()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        EventEntityCreator.zza(this, out, flags);
    }
}

