/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntityCreator;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.internal.zznn;

public final class GameEntity
extends GamesDowngradeableSafeParcel
implements Game {
    public static final Parcelable.Creator<GameEntity> CREATOR = new GameEntityCreatorCompat();
    private final int mVersionCode;
    private final String zzXW;
    private final String zzVu;
    private final String zzazz;
    private final String zzazA;
    private final String zzavc;
    private final String zzazB;
    private final Uri zzazC;
    private final Uri zzazD;
    private final Uri zzazE;
    private final boolean zzazF;
    private final boolean zzazG;
    private final String zzazH;
    private final int zzazI;
    private final int zzazJ;
    private final int zzazK;
    private final boolean zzazL;
    private final boolean zzazM;
    private final String zzazN;
    private final String zzazO;
    private final String zzazP;
    private final boolean zzCZ;
    private final boolean zzazQ;
    private final boolean zzazR;
    private final String zzazS;
    private final boolean zzazT;

    public GameEntity(Game game) {
        this.mVersionCode = 7;
        this.zzXW = game.getApplicationId();
        this.zzazz = game.getPrimaryCategory();
        this.zzazA = game.getSecondaryCategory();
        this.zzavc = game.getDescription();
        this.zzazB = game.getDeveloperName();
        this.zzVu = game.getDisplayName();
        this.zzazC = game.getIconImageUri();
        this.zzazN = game.getIconImageUrl();
        this.zzazD = game.getHiResImageUri();
        this.zzazO = game.getHiResImageUrl();
        this.zzazE = game.getFeaturedImageUri();
        this.zzazP = game.getFeaturedImageUrl();
        this.zzazF = game.zzuR();
        this.zzazG = game.zzuT();
        this.zzazH = game.zzuU();
        this.zzazI = game.zzuV();
        this.zzazJ = game.getAchievementTotalCount();
        this.zzazK = game.getLeaderboardCount();
        this.zzazL = game.isRealTimeMultiplayerEnabled();
        this.zzazM = game.isTurnBasedMultiplayerEnabled();
        this.zzCZ = game.isMuted();
        this.zzazQ = game.zzuS();
        this.zzazR = game.areSnapshotsEnabled();
        this.zzazS = game.getThemeColor();
        this.zzazT = game.hasGamepadSupport();
    }

    GameEntity(int versionCode, String applicationId, String displayName, String primaryCategory, String secondaryCategory, String description, String developerName, Uri iconImageUri, Uri hiResImageUri, Uri featuredImageUri, boolean playEnabledGame, boolean instanceInstalled, String instancePackageName, int gameplayAclStatus, int achievementTotalCount, int leaderboardCount, boolean realTimeEnabled, boolean turnBasedEnabled, String iconImageUrl, String hiResImageUrl, String featuredImageUrl, boolean muted, boolean identitySharingConfirmed, boolean snapshotsEnabled, String themeColor, boolean hasGamepadSupport) {
        this.mVersionCode = versionCode;
        this.zzXW = applicationId;
        this.zzVu = displayName;
        this.zzazz = primaryCategory;
        this.zzazA = secondaryCategory;
        this.zzavc = description;
        this.zzazB = developerName;
        this.zzazC = iconImageUri;
        this.zzazN = iconImageUrl;
        this.zzazD = hiResImageUri;
        this.zzazO = hiResImageUrl;
        this.zzazE = featuredImageUri;
        this.zzazP = featuredImageUrl;
        this.zzazF = playEnabledGame;
        this.zzazG = instanceInstalled;
        this.zzazH = instancePackageName;
        this.zzazI = gameplayAclStatus;
        this.zzazJ = achievementTotalCount;
        this.zzazK = leaderboardCount;
        this.zzazL = realTimeEnabled;
        this.zzazM = turnBasedEnabled;
        this.zzCZ = muted;
        this.zzazQ = identitySharingConfirmed;
        this.zzazR = snapshotsEnabled;
        this.zzazS = themeColor;
        this.zzazT = hasGamepadSupport;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getApplicationId() {
        return this.zzXW;
    }

    @Override
    public String getDisplayName() {
        return this.zzVu;
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        zznn.zzb((String)this.zzVu, (CharArrayBuffer)dataOut);
    }

    @Override
    public String getPrimaryCategory() {
        return this.zzazz;
    }

    @Override
    public String getSecondaryCategory() {
        return this.zzazA;
    }

    @Override
    public String getDescription() {
        return this.zzavc;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zznn.zzb((String)this.zzavc, (CharArrayBuffer)dataOut);
    }

    @Override
    public String getDeveloperName() {
        return this.zzazB;
    }

    @Override
    public void getDeveloperName(CharArrayBuffer dataOut) {
        zznn.zzb((String)this.zzazB, (CharArrayBuffer)dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzazC;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzazN;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.zzazD;
    }

    @Override
    public String getHiResImageUrl() {
        return this.zzazO;
    }

    @Override
    public Uri getFeaturedImageUri() {
        return this.zzazE;
    }

    @Override
    public String getFeaturedImageUrl() {
        return this.zzazP;
    }

    @Override
    public boolean isMuted() {
        return this.zzCZ;
    }

    @Override
    public boolean zzuS() {
        return this.zzazQ;
    }

    @Override
    public boolean zzuR() {
        return this.zzazF;
    }

    @Override
    public boolean zzuT() {
        return this.zzazG;
    }

    @Override
    public String zzuU() {
        return this.zzazH;
    }

    @Override
    public int zzuV() {
        return this.zzazI;
    }

    @Override
    public int getAchievementTotalCount() {
        return this.zzazJ;
    }

    @Override
    public int getLeaderboardCount() {
        return this.zzazK;
    }

    @Override
    public boolean isRealTimeMultiplayerEnabled() {
        return this.zzazL;
    }

    @Override
    public boolean isTurnBasedMultiplayerEnabled() {
        return this.zzazM;
    }

    @Override
    public boolean areSnapshotsEnabled() {
        return this.zzazR;
    }

    @Override
    public String getThemeColor() {
        return this.zzazS;
    }

    @Override
    public boolean hasGamepadSupport() {
        return this.zzazT;
    }

    public Game freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameEntity.zza(this);
    }

    static int zza(Game game) {
        return zzw.hashCode((Object[])new Object[]{game.getApplicationId(), game.getDisplayName(), game.getPrimaryCategory(), game.getSecondaryCategory(), game.getDescription(), game.getDeveloperName(), game.getIconImageUri(), game.getHiResImageUri(), game.getFeaturedImageUri(), game.zzuR(), game.zzuT(), game.zzuU(), game.zzuV(), game.getAchievementTotalCount(), game.getLeaderboardCount(), game.isRealTimeMultiplayerEnabled(), game.isTurnBasedMultiplayerEnabled(), game.isMuted(), game.zzuS(), game.areSnapshotsEnabled(), game.getThemeColor(), game.hasGamepadSupport()});
    }

    public boolean equals(Object obj) {
        return GameEntity.zza(this, obj);
    }

    static boolean zza(Game game, Object object) {
        if (!(object instanceof Game)) {
            return false;
        }
        if (game == object) {
            return true;
        }
        Game game2 = (Game)object;
        return zzw.equal((Object)game2.getApplicationId(), (Object)game.getApplicationId()) && zzw.equal((Object)game2.getDisplayName(), (Object)game.getDisplayName()) && zzw.equal((Object)game2.getPrimaryCategory(), (Object)game.getPrimaryCategory()) && zzw.equal((Object)game2.getSecondaryCategory(), (Object)game.getSecondaryCategory()) && zzw.equal((Object)game2.getDescription(), (Object)game.getDescription()) && zzw.equal((Object)game2.getDeveloperName(), (Object)game.getDeveloperName()) && zzw.equal((Object)game2.getIconImageUri(), (Object)game.getIconImageUri()) && zzw.equal((Object)game2.getHiResImageUri(), (Object)game.getHiResImageUri()) && zzw.equal((Object)game2.getFeaturedImageUri(), (Object)game.getFeaturedImageUri()) && zzw.equal((Object)game2.zzuR(), (Object)game.zzuR()) && zzw.equal((Object)game2.zzuT(), (Object)game.zzuT()) && zzw.equal((Object)game2.zzuU(), (Object)game.zzuU()) && zzw.equal((Object)game2.zzuV(), (Object)game.zzuV()) && zzw.equal((Object)game2.getAchievementTotalCount(), (Object)game.getAchievementTotalCount()) && zzw.equal((Object)game2.getLeaderboardCount(), (Object)game.getLeaderboardCount()) && zzw.equal((Object)game2.isRealTimeMultiplayerEnabled(), (Object)game.isRealTimeMultiplayerEnabled()) && zzw.equal((Object)game2.isTurnBasedMultiplayerEnabled(), (Object)(game.isTurnBasedMultiplayerEnabled() && zzw.equal((Object)game2.isMuted(), (Object)game.isMuted()) && zzw.equal((Object)game2.zzuS(), (Object)game.zzuS()) ? 1 : 0)) && zzw.equal((Object)game2.areSnapshotsEnabled(), (Object)game.areSnapshotsEnabled()) && zzw.equal((Object)game2.getThemeColor(), (Object)game.getThemeColor()) && zzw.equal((Object)game2.hasGamepadSupport(), (Object)game.hasGamepadSupport());
    }

    public String toString() {
        return GameEntity.zzb(this);
    }

    static String zzb(Game game) {
        return zzw.zzx((Object)game).zzg("ApplicationId", (Object)game.getApplicationId()).zzg("DisplayName", (Object)game.getDisplayName()).zzg("PrimaryCategory", (Object)game.getPrimaryCategory()).zzg("SecondaryCategory", (Object)game.getSecondaryCategory()).zzg("Description", (Object)game.getDescription()).zzg("DeveloperName", (Object)game.getDeveloperName()).zzg("IconImageUri", (Object)game.getIconImageUri()).zzg("IconImageUrl", (Object)game.getIconImageUrl()).zzg("HiResImageUri", (Object)game.getHiResImageUri()).zzg("HiResImageUrl", (Object)game.getHiResImageUrl()).zzg("FeaturedImageUri", (Object)game.getFeaturedImageUri()).zzg("FeaturedImageUrl", (Object)game.getFeaturedImageUrl()).zzg("PlayEnabledGame", (Object)game.zzuR()).zzg("InstanceInstalled", (Object)game.zzuT()).zzg("InstancePackageName", (Object)game.zzuU()).zzg("AchievementTotalCount", (Object)game.getAchievementTotalCount()).zzg("LeaderboardCount", (Object)game.getLeaderboardCount()).zzg("RealTimeMultiplayerEnabled", (Object)game.isRealTimeMultiplayerEnabled()).zzg("TurnBasedMultiplayerEnabled", (Object)game.isTurnBasedMultiplayerEnabled()).zzg("AreSnapshotsEnabled", (Object)game.areSnapshotsEnabled()).zzg("ThemeColor", (Object)game.getThemeColor()).zzg("HasGamepadSupport", (Object)game.hasGamepadSupport()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.zzqk()) {
            GameEntityCreator.zza(this, dest, flags);
        } else {
            dest.writeString(this.zzXW);
            dest.writeString(this.zzVu);
            dest.writeString(this.zzazz);
            dest.writeString(this.zzazA);
            dest.writeString(this.zzavc);
            dest.writeString(this.zzazB);
            dest.writeString(this.zzazC == null ? null : this.zzazC.toString());
            dest.writeString(this.zzazD == null ? null : this.zzazD.toString());
            dest.writeString(this.zzazE == null ? null : this.zzazE.toString());
            dest.writeInt(this.zzazF ? 1 : 0);
            dest.writeInt(this.zzazG ? 1 : 0);
            dest.writeString(this.zzazH);
            dest.writeInt(this.zzazI);
            dest.writeInt(this.zzazJ);
            dest.writeInt(this.zzazK);
        }
    }

    static final class GameEntityCreatorCompat
    extends GameEntityCreator {
        GameEntityCreatorCompat() {
        }

        @Override
        public GameEntity zzdS(Parcel parcel) {
            boolean bl = GameEntity.zzd(GameEntity.zzqj());
            if (bl || GameEntity.zzcz((String)GameEntity.class.getCanonicalName())) {
                return super.zzdS(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            String string7 = parcel.readString();
            Uri uri = string7 == null ? null : Uri.parse((String)string7);
            String string8 = parcel.readString();
            Uri uri2 = string8 == null ? null : Uri.parse((String)string8);
            String string9 = parcel.readString();
            Uri uri3 = string9 == null ? null : Uri.parse((String)string9);
            boolean bl2 = parcel.readInt() > 0;
            boolean bl3 = parcel.readInt() > 0;
            String string10 = parcel.readString();
            int n = parcel.readInt();
            int n2 = parcel.readInt();
            int n3 = parcel.readInt();
            boolean bl4 = false;
            boolean bl5 = false;
            String string11 = null;
            String string12 = null;
            String string13 = null;
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = false;
            String string14 = null;
            boolean bl9 = false;
            return new GameEntity(7, string, string2, string3, string4, string5, string6, uri, uri2, uri3, bl2, bl3, string10, n, n2, n3, bl4, bl5, string11, string12, string13, bl6, bl7, bl8, string14, bl9);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.zzdS(x0);
        }
    }
}

