/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.PlayerLevel;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfoRef;
import com.google.android.gms.games.internal.player.PlayerColumnNames;

public final class PlayerRef
extends zzc
implements Player {
    private final PlayerColumnNames zzaAC;
    private final PlayerLevelInfo zzaAn;
    private final MostRecentGameInfoRef zzaAD;

    public PlayerRef(DataHolder holder, int dataRow) {
        this(holder, dataRow, null);
    }

    public PlayerRef(DataHolder holder, int dataRow, String prefix) {
        super(holder, dataRow);
        this.zzaAC = new PlayerColumnNames(prefix);
        this.zzaAD = new MostRecentGameInfoRef(holder, dataRow, this.zzaAC);
        if (this.zzvd()) {
            PlayerLevel playerLevel;
            int n = this.getInteger(this.zzaAC.zzaFS);
            int n2 = this.getInteger(this.zzaAC.zzaFV);
            PlayerLevel playerLevel2 = playerLevel = new PlayerLevel(n, this.getLong(this.zzaAC.zzaFT), this.getLong(this.zzaAC.zzaFU));
            if (n != n2) {
                playerLevel2 = new PlayerLevel(n2, this.getLong(this.zzaAC.zzaFU), this.getLong(this.zzaAC.zzaFW));
            }
            this.zzaAn = new PlayerLevelInfo(this.getLong(this.zzaAC.zzaFR), this.getLong(this.zzaAC.zzaFX), playerLevel, playerLevel2);
        } else {
            this.zzaAn = null;
        }
    }

    @Override
    public String getPlayerId() {
        return this.getString(this.zzaAC.zzaFI);
    }

    @Override
    public String getDisplayName() {
        return this.getString(this.zzaAC.zzaFJ);
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        this.zza(this.zzaAC.zzaFJ, dataOut);
    }

    @Override
    public String zzuY() {
        return this.getString(this.zzaAC.zzaGh);
    }

    @Override
    public String getName() {
        return this.getString(this.zzaAC.name);
    }

    @Override
    public boolean zzuZ() {
        return this.getBoolean(this.zzaAC.zzaGg);
    }

    @Override
    public boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzcu(this.zzaAC.zzaFK);
    }

    @Override
    public String getIconImageUrl() {
        return this.getString(this.zzaAC.zzaFL);
    }

    @Override
    public boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.zzcu(this.zzaAC.zzaFM);
    }

    @Override
    public String getHiResImageUrl() {
        return this.getString(this.zzaAC.zzaFN);
    }

    @Override
    public long getRetrievedTimestamp() {
        return this.getLong(this.zzaAC.zzaFO);
    }

    @Override
    public long getLastPlayedWithTimestamp() {
        if (!this.zzct(this.zzaAC.zzaFQ) || this.zzcv(this.zzaAC.zzaFQ)) {
            return -1L;
        }
        return this.getLong(this.zzaAC.zzaFQ);
    }

    @Override
    public int zzva() {
        return this.getInteger(this.zzaAC.zzaFP);
    }

    @Override
    public boolean zzvb() {
        return this.getBoolean(this.zzaAC.zzaFZ);
    }

    @Override
    public String getTitle() {
        return this.getString(this.zzaAC.title);
    }

    @Override
    public void getTitle(CharArrayBuffer dataOut) {
        this.zza(this.zzaAC.title, dataOut);
    }

    @Override
    public PlayerLevelInfo getLevelInfo() {
        return this.zzaAn;
    }

    @Override
    public MostRecentGameInfo zzvc() {
        if (this.zzcv(this.zzaAC.zzaGa)) {
            return null;
        }
        return this.zzaAD;
    }

    @Override
    public Uri getBannerImageLandscapeUri() {
        return this.zzcu(this.zzaAC.zzaGi);
    }

    @Override
    public String getBannerImageLandscapeUrl() {
        return this.getString(this.zzaAC.zzaGj);
    }

    @Override
    public Uri getBannerImagePortraitUri() {
        return this.zzcu(this.zzaAC.zzaGk);
    }

    @Override
    public String getBannerImagePortraitUrl() {
        return this.getString(this.zzaAC.zzaGl);
    }

    public Player freeze() {
        return new PlayerEntity(this);
    }

    public int hashCode() {
        return PlayerEntity.zzb(this);
    }

    public boolean equals(Object obj) {
        return PlayerEntity.zza(this, obj);
    }

    public String toString() {
        return PlayerEntity.zzc(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        PlayerEntity playerEntity = (PlayerEntity)this.freeze();
        playerEntity.writeToParcel(dest, flags);
    }

    private boolean zzvd() {
        if (this.zzcv(this.zzaAC.zzaFR)) {
            return false;
        }
        return this.getLong(this.zzaAC.zzaFR) != -1L;
    }
}

