/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.appcontent;

import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.appcontent.AppContentAction;
import com.google.android.gms.games.appcontent.AppContentActionEntity;
import com.google.android.gms.games.appcontent.AppContentAnnotation;
import com.google.android.gms.games.appcontent.AppContentAnnotationEntity;
import com.google.android.gms.games.appcontent.AppContentCard;
import com.google.android.gms.games.appcontent.AppContentCardEntityCreator;
import com.google.android.gms.games.appcontent.AppContentCondition;
import com.google.android.gms.games.appcontent.AppContentConditionEntity;
import java.util.ArrayList;
import java.util.List;

public final class AppContentCardEntity
implements SafeParcelable,
AppContentCard {
    public static final AppContentCardEntityCreator CREATOR = new AppContentCardEntityCreator();
    private final int mVersionCode;
    private final ArrayList<AppContentActionEntity> mActions;
    private final ArrayList<AppContentAnnotationEntity> zzaBa;
    private final ArrayList<AppContentConditionEntity> zzaAQ;
    private final String zzaAR;
    private final int zzaBb;
    private final String zzavc;
    private final Bundle mExtras;
    private final String zzaBc;
    private final String zzank;
    private final int zzaBd;
    private final String zzIx;
    private final String zzxX;

    public AppContentCardEntity(AppContentCard card) {
        this.mVersionCode = 4;
        this.zzaAR = card.zzvk();
        this.zzaBb = card.zzvv();
        this.zzavc = card.getDescription();
        this.mExtras = card.getExtras();
        this.zzxX = card.getId();
        this.zzank = card.getTitle();
        this.zzaBc = card.zzvw();
        this.zzaBd = card.zzvx();
        this.zzIx = card.getType();
        List<AppContentAction> list = card.getActions();
        int n = list.size();
        this.mActions = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.mActions.add((AppContentActionEntity)list.get(i).freeze());
        }
        List<AppContentAnnotation> list2 = card.zzvu();
        int n2 = list2.size();
        this.zzaBa = new ArrayList(n2);
        for (int i = 0; i < n2; ++i) {
            this.zzaBa.add((AppContentAnnotationEntity)list2.get(i).freeze());
        }
        List<AppContentCondition> list3 = card.zzvj();
        int n3 = list3.size();
        this.zzaAQ = new ArrayList(n3);
        for (int i = 0; i < n3; ++i) {
            this.zzaAQ.add((AppContentConditionEntity)list3.get(i).freeze());
        }
    }

    AppContentCardEntity(int versionCode, ArrayList<AppContentActionEntity> actions, ArrayList<AppContentAnnotationEntity> annotations, ArrayList<AppContentConditionEntity> conditions, String contentDescription, int currentProgress, String description, Bundle extras, String subtitle, String title, int totalProgress, String type, String id) {
        this.mVersionCode = versionCode;
        this.mActions = actions;
        this.zzaBa = annotations;
        this.zzaAQ = conditions;
        this.zzaAR = contentDescription;
        this.zzaBb = currentProgress;
        this.zzavc = description;
        this.mExtras = extras;
        this.zzxX = id;
        this.zzaBc = subtitle;
        this.zzank = title;
        this.zzaBd = totalProgress;
        this.zzIx = type;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public List<AppContentAction> getActions() {
        return new ArrayList<AppContentAction>(this.mActions);
    }

    @Override
    public List<AppContentAnnotation> zzvu() {
        return new ArrayList<AppContentAnnotation>(this.zzaBa);
    }

    @Override
    public List<AppContentCondition> zzvj() {
        return new ArrayList<AppContentCondition>(this.zzaAQ);
    }

    @Override
    public String zzvk() {
        return this.zzaAR;
    }

    @Override
    public int zzvv() {
        return this.zzaBb;
    }

    @Override
    public String getDescription() {
        return this.zzavc;
    }

    @Override
    public Bundle getExtras() {
        return this.mExtras;
    }

    @Override
    public String getId() {
        return this.zzxX;
    }

    @Override
    public String zzvw() {
        return this.zzaBc;
    }

    @Override
    public String getTitle() {
        return this.zzank;
    }

    @Override
    public int zzvx() {
        return this.zzaBd;
    }

    @Override
    public String getType() {
        return this.zzIx;
    }

    public AppContentCard zzvy() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return AppContentCardEntity.zza(this);
    }

    static int zza(AppContentCard appContentCard) {
        return zzw.hashCode((Object[])new Object[]{appContentCard.getActions(), appContentCard.zzvu(), appContentCard.zzvj(), appContentCard.zzvk(), appContentCard.zzvv(), appContentCard.getDescription(), appContentCard.getExtras(), appContentCard.getId(), appContentCard.zzvw(), appContentCard.getTitle(), appContentCard.zzvx(), appContentCard.getType()});
    }

    public boolean equals(Object obj) {
        return AppContentCardEntity.zza(this, obj);
    }

    static boolean zza(AppContentCard appContentCard, Object object) {
        if (!(object instanceof AppContentCard)) {
            return false;
        }
        if (appContentCard == object) {
            return true;
        }
        AppContentCard appContentCard2 = (AppContentCard)object;
        return zzw.equal(appContentCard2.getActions(), appContentCard.getActions()) && zzw.equal(appContentCard2.zzvu(), appContentCard.zzvu()) && zzw.equal(appContentCard2.zzvj(), appContentCard.zzvj()) && zzw.equal((Object)appContentCard2.zzvk(), (Object)appContentCard.zzvk()) && zzw.equal((Object)appContentCard2.zzvv(), (Object)appContentCard.zzvv()) && zzw.equal((Object)appContentCard2.getDescription(), (Object)appContentCard.getDescription()) && zzw.equal((Object)appContentCard2.getExtras(), (Object)appContentCard.getExtras()) && zzw.equal((Object)appContentCard2.getId(), (Object)appContentCard.getId()) && zzw.equal((Object)appContentCard2.zzvw(), (Object)appContentCard.zzvw()) && zzw.equal((Object)appContentCard2.getTitle(), (Object)appContentCard.getTitle()) && zzw.equal((Object)appContentCard2.zzvx(), (Object)appContentCard.zzvx()) && zzw.equal((Object)appContentCard2.getType(), (Object)appContentCard.getType());
    }

    public String toString() {
        return AppContentCardEntity.zzb(this);
    }

    static String zzb(AppContentCard appContentCard) {
        return zzw.zzx((Object)appContentCard).zzg("Actions", appContentCard.getActions()).zzg("Annotations", appContentCard.zzvu()).zzg("Conditions", appContentCard.zzvj()).zzg("ContentDescription", (Object)appContentCard.zzvk()).zzg("CurrentSteps", (Object)appContentCard.zzvv()).zzg("Description", (Object)appContentCard.getDescription()).zzg("Extras", (Object)appContentCard.getExtras()).zzg("Id", (Object)appContentCard.getId()).zzg("Subtitle", (Object)appContentCard.zzvw()).zzg("Title", (Object)appContentCard.getTitle()).zzg("TotalSteps", (Object)appContentCard.zzvx()).zzg("Type", (Object)appContentCard.getType()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        AppContentCardEntityCreator.zza(this, out, flags);
    }

    public /* synthetic */ Object freeze() {
        return this.zzvy();
    }
}

