/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.BinderWrapper;
import com.google.android.gms.common.internal.zzb;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.drive.Contents;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameBuffer;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.GamesMetadata;
import com.google.android.gms.games.GamesStatusCodes;
import com.google.android.gms.games.Notifications;
import com.google.android.gms.games.OnNearbyPlayerDetectedListener;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerBuffer;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.achievement.AchievementBuffer;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.appcontent.AppContents;
import com.google.android.gms.games.event.EventBuffer;
import com.google.android.gms.games.event.Events;
import com.google.android.gms.games.internal.AbstractGamesCallbacks;
import com.google.android.gms.games.internal.AbstractGamesClient;
import com.google.android.gms.games.internal.GamesLog;
import com.google.android.gms.games.internal.IGamesCallbacks;
import com.google.android.gms.games.internal.IGamesService;
import com.google.android.gms.games.internal.PopupLocationInfoParcelable;
import com.google.android.gms.games.internal.PopupManager;
import com.google.android.gms.games.internal.constants.RequestType;
import com.google.android.gms.games.internal.events.EventIncrementCache;
import com.google.android.gms.games.internal.events.EventIncrementManager;
import com.google.android.gms.games.internal.experience.ExperienceEventBuffer;
import com.google.android.gms.games.internal.game.Acls;
import com.google.android.gms.games.internal.game.GameInstanceBuffer;
import com.google.android.gms.games.internal.game.GameSearchSuggestionBuffer;
import com.google.android.gms.games.internal.request.RequestUpdateOutcomes;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.games.leaderboard.LeaderboardScoreBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardScoreEntity;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.leaderboard.ScoreSubmissionData;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.Invitations;
import com.google.android.gms.games.multiplayer.OnInvitationReceivedListener;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessage;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomBuffer;
import com.google.android.gms.games.multiplayer.realtime.RoomConfig;
import com.google.android.gms.games.multiplayer.realtime.RoomEntity;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.games.multiplayer.turnbased.LoadMatchesResponse;
import com.google.android.gms.games.multiplayer.turnbased.OnTurnBasedMatchUpdateReceivedListener;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchConfig;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestBuffer;
import com.google.android.gms.games.quest.QuestEntity;
import com.google.android.gms.games.quest.QuestUpdateListener;
import com.google.android.gms.games.quest.Quests;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestBuffer;
import com.google.android.gms.games.request.OnRequestReceivedListener;
import com.google.android.gms.games.request.Requests;
import com.google.android.gms.games.snapshot.Snapshot;
import com.google.android.gms.games.snapshot.SnapshotContents;
import com.google.android.gms.games.snapshot.SnapshotContentsEntity;
import com.google.android.gms.games.snapshot.SnapshotEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataBuffer;
import com.google.android.gms.games.snapshot.SnapshotMetadataChange;
import com.google.android.gms.games.snapshot.SnapshotMetadataChangeEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntity;
import com.google.android.gms.games.snapshot.Snapshots;
import com.google.android.gms.games.stats.PlayerStats;
import com.google.android.gms.games.stats.PlayerStatsBuffer;
import com.google.android.gms.games.stats.PlayerStatsEntity;
import com.google.android.gms.games.stats.Stats;
import com.google.android.gms.games.video.VideoBuffer;
import com.google.android.gms.games.video.VideoConfiguration;
import com.google.android.gms.games.video.Videos;
import com.google.android.gms.internal.zzlx;
import com.google.android.gms.internal.zzmb;
import com.google.android.gms.internal.zzmc;
import com.google.android.gms.internal.zzmn;
import com.google.android.gms.internal.zzsd;
import com.google.android.gms.signin.internal.zzi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class GamesClientImpl
extends zzj<IGamesService> {
    EventIncrementManager zzaBv = new EventIncrementManager(){

        @Override
        public EventIncrementCache zzwo() {
            return new GameClientEventIncrementCache();
        }
    };
    private final String zzaBw;
    private PlayerEntity zzaBx;
    private GameEntity zzaBy;
    private final PopupManager zzaBz;
    private boolean zzaBA = false;
    private final Binder zzaBB;
    private final long zzaBC;
    private final Games.GamesOptions zzaBD;

    public GamesClientImpl(Context context, Looper looper, zzf clientSettings, Games.GamesOptions options, GoogleApiClient.ConnectionCallbacks connectedListener, GoogleApiClient.OnConnectionFailedListener connectionFailedListener) {
        super(context, looper, 1, clientSettings, connectedListener, connectionFailedListener);
        this.zzaBw = clientSettings.zzqd();
        this.zzaBB = new Binder();
        this.zzaBz = PopupManager.zza(this, clientSettings.zzpZ());
        this.zzo(clientSettings.zzqf());
        this.zzaBC = ((Object)((Object)this)).hashCode();
        this.zzaBD = options;
    }

    public boolean zzmn() {
        return true;
    }

    public void zzqm() {
        super.zzqm();
        if (this.zzaBA) {
            this.zzaBz.zzwA();
            this.zzaBA = false;
        }
        if (!this.zzaBD.zzaAb) {
            this.zzvQ();
        }
    }

    public void onConnectionFailed(ConnectionResult result) {
        super.onConnectionFailed(result);
        this.zzaBA = false;
    }

    public void zzgk(int n) {
        this.zzaBz.setGravity(n);
    }

    public void zzo(View view) {
        this.zzaBz.zzp(view);
    }

    protected Set<Scope> zzb(Set<Scope> set) {
        boolean bl = false;
        boolean bl2 = false;
        Scope scope = new Scope("https://www.googleapis.com/auth/games");
        Scope scope2 = new Scope("https://www.googleapis.com/auth/games.firstparty");
        for (Scope scope3 : set) {
            if (scope3.equals((Object)scope)) {
                bl = true;
                continue;
            }
            if (!scope3.equals((Object)scope2)) continue;
            bl2 = true;
        }
        if (bl2) {
            zzx.zza((!bl ? 1 : 0) != 0, (String)"Cannot have both %s and %s!", (Object[])new Object[]{"https://www.googleapis.com/auth/games", "https://www.googleapis.com/auth/games.firstparty"});
        } else {
            zzx.zza((boolean)bl, (String)"Games APIs requires %s to function.", (Object[])new Object[]{"https://www.googleapis.com/auth/games"});
        }
        return set;
    }

    public void zza(GoogleApiClient.zza zza2) {
        this.zzvP();
        super.zza(zza2);
    }

    public void disconnect() {
        this.zzaBA = false;
        if (this.isConnected()) {
            try {
                IGamesService iGamesService = (IGamesService)this.zzqs();
                iGamesService.zzwn();
                this.zzaBv.flush();
                iGamesService.zzF(this.zzaBC);
            }
            catch (RemoteException remoteException) {
                GamesLog.zzA("GamesClientImpl", "Failed to notify client disconnect.");
            }
        }
        super.disconnect();
    }

    protected String zzgh() {
        return "com.google.android.gms.games.service.START";
    }

    protected String zzgi() {
        return "com.google.android.gms.games.internal.IGamesService";
    }

    protected IGamesService zzbV(IBinder iBinder) {
        return IGamesService.Stub.zzbY(iBinder);
    }

    public Bundle zznQ() {
        try {
            Bundle bundle = ((IGamesService)this.zzqs()).zznQ();
            if (bundle != null) {
                bundle.setClassLoader(GamesClientImpl.class.getClassLoader());
            }
            return bundle;
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return null;
        }
    }

    private void zzvP() {
        this.zzaBx = null;
        this.zzaBy = null;
    }

    protected Bundle zzlU() {
        String string = this.getContext().getResources().getConfiguration().locale.toString();
        Bundle bundle = this.zzaBD.zzuX();
        bundle.putString("com.google.android.gms.games.key.gamePackageName", this.zzaBw);
        bundle.putString("com.google.android.gms.games.key.desiredLocale", string);
        bundle.putParcelable("com.google.android.gms.games.key.popupWindowToken", (Parcelable)new BinderWrapper(this.zzaBz.zzwC()));
        bundle.putInt("com.google.android.gms.games.key.API_VERSION", 2);
        zzf zzf2 = this.zzqq();
        if (zzf2.zzqg() != null) {
            bundle.putBundle("com.google.android.gms.games.key.signInOptions", zzi.zza((zzsd)zzf2.zzqg(), (Integer)zzf2.zzqh(), (ExecutorService)Executors.newSingleThreadExecutor()));
        }
        return bundle;
    }

    public void zzvQ() {
        try {
            PopupLocationInfoBinderCallbacks popupLocationInfoBinderCallbacks = new PopupLocationInfoBinderCallbacks(this.zzaBz);
            ((IGamesService)this.zzqs()).zza(popupLocationInfoBinderCallbacks, this.zzaBC);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public String zzvR() {
        try {
            return ((IGamesService)this.zzqs()).zzvR();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return null;
        }
    }

    public void zzd(zzlx.zzb<Games.GetTokenResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzqs()).zzk(new GetAuthTokenBinderCallbacks(zzb2));
    }

    public String zzvS() {
        if (this.zzaBx != null) {
            return this.zzaBx.getPlayerId();
        }
        try {
            return ((IGamesService)this.zzqs()).zzvS();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Player zzvT() {
        this.zzqr();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.zzaBx == null) {
                try {
                    PlayerBuffer playerBuffer = new PlayerBuffer(((IGamesService)this.zzqs()).zzwp());
                    try {
                        if (playerBuffer.getCount() > 0) {
                            this.zzaBx = (PlayerEntity)playerBuffer.get(0).freeze();
                        }
                    }
                    finally {
                        playerBuffer.release();
                    }
                }
                catch (RemoteException remoteException) {
                    this.zzb(remoteException);
                }
            }
        }
        return this.zzaBx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Game zzvU() {
        this.zzqr();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.zzaBy == null) {
                try {
                    GameBuffer gameBuffer = new GameBuffer(((IGamesService)this.zzqs()).zzwr());
                    try {
                        if (gameBuffer.getCount() > 0) {
                            this.zzaBy = (GameEntity)gameBuffer.get(0).freeze();
                        }
                    }
                    finally {
                        gameBuffer.release();
                    }
                }
                catch (RemoteException remoteException) {
                    this.zzb(remoteException);
                }
            }
        }
        return this.zzaBy;
    }

    public void zza(zzlx.zzb<Players.LoadPlayersResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzqs()).zzf((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, bl);
    }

    public void zza(zzlx.zzb<Players.LoadPlayersResult> zzb2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zzqs()).zzc((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), stringArray);
    }

    public void zza(zzlx.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzqs()).zza((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zza(zzlx.zzb<Players.LoadPlayersResult> zzb2, String string, int n, boolean bl, boolean bl2) throws RemoteException {
        switch (string) {
            case "played_with": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid player collection: " + string);
            }
        }
        ((IGamesService)this.zzqs()).zzd(new PlayersLoadedBinderCallback(zzb2), string, n, bl, bl2);
    }

    public void zza(zzlx.zzb<Players.LoadPlayersResult> zzb2, String string, String string2, int n, boolean bl, boolean bl2) throws RemoteException {
        switch (string) {
            case "circled": 
            case "played_with": 
            case "nearby": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid player collection: " + string);
            }
        }
        ((IGamesService)this.zzqs()).zza((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, string2, n, bl, bl2);
    }

    public void zza(zzlx.zzb<Players.LoadPlayersResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzqs()).zzc((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), bl);
    }

    public Intent zzvV() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzqs()).zzvV();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzl(String string, int n, int n2) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzqs()).zzm(string, n, n2);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzb(zzlx.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzqs()).zzb((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), bl);
    }

    public void zzb(zzlx.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzqs()).zzc((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), string, bl);
    }

    public void zza(zzlx.zzb<Leaderboards.LoadPlayerScoreResult> zzb2, String string, String string2, int n, int n2) throws RemoteException {
        ((IGamesService)this.zzqs()).zza((IGamesCallbacks)new PlayerLeaderboardScoreLoadedBinderCallback(zzb2), string, string2, n, n2);
    }

    public void zza(zzlx.zzb<Leaderboards.LoadScoresResult> zzb2, String string, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zzqs()).zza((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), string, n, n2, n3, bl);
    }

    public void zzb(zzlx.zzb<Leaderboards.LoadScoresResult> zzb2, String string, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zzqs()).zzb((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), string, n, n2, n3, bl);
    }

    public void zza(zzlx.zzb<Leaderboards.LoadScoresResult> zzb2, LeaderboardScoreBuffer leaderboardScoreBuffer, int n, int n2) throws RemoteException {
        ((IGamesService)this.zzqs()).zza((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), leaderboardScoreBuffer.zzxc().asBundle(), n, n2);
    }

    public void zza(zzlx.zzb<Leaderboards.SubmitScoreResult> zzb2, String string, long l, String string2) throws RemoteException {
        SubmitScoreBinderCallbacks submitScoreBinderCallbacks = zzb2 == null ? null : new SubmitScoreBinderCallbacks(zzb2);
        ((IGamesService)this.zzqs()).zza((IGamesCallbacks)submitScoreBinderCallbacks, string, l, string2);
    }

    public Intent zzvW() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzqs()).zzvW();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzc(zzlx.zzb<Achievements.LoadAchievementsResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzqs()).zza((IGamesCallbacks)new AchievementsLoadedBinderCallback(zzb2), bl);
    }

    public void zza(zzlx.zzb<Achievements.UpdateAchievementResult> zzb2, String string) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zzqs()).zza((IGamesCallbacks)achievementUpdatedBinderCallback, string, this.zzaBz.zzwC(), this.zzaBz.zzwB());
    }

    public void zzb(zzlx.zzb<Achievements.UpdateAchievementResult> zzb2, String string) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zzqs()).zzb((IGamesCallbacks)achievementUpdatedBinderCallback, string, this.zzaBz.zzwC(), this.zzaBz.zzwB());
    }

    public void zza(zzlx.zzb<Achievements.UpdateAchievementResult> zzb2, String string, int n) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zzqs()).zza((IGamesCallbacks)achievementUpdatedBinderCallback, string, n, this.zzaBz.zzwC(), this.zzaBz.zzwB());
    }

    public void zzb(zzlx.zzb<Achievements.UpdateAchievementResult> zzb2, String string, int n) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zzqs()).zzb((IGamesCallbacks)achievementUpdatedBinderCallback, string, n, this.zzaBz.zzwC(), this.zzaBz.zzwB());
    }

    public void zzd(zzlx.zzb<Events.LoadEventsResult> zzb2, boolean bl) throws RemoteException {
        this.zzaBv.flush();
        ((IGamesService)this.zzqs()).zzf((IGamesCallbacks)new EventsLoadedBinderCallback(zzb2), bl);
    }

    public void zza(zzlx.zzb<Events.LoadEventsResult> zzb2, boolean bl, String ... stringArray) throws RemoteException {
        this.zzaBv.flush();
        ((IGamesService)this.zzqs()).zza((IGamesCallbacks)new EventsLoadedBinderCallback(zzb2), bl, stringArray);
    }

    public void zzp(String string, int n) {
        this.zzaBv.zzp(string, n);
    }

    public Intent zzvX() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzqs()).zzvX();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzvY() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzqs()).zzvY();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zza(zzmn<OnInvitationReceivedListener> zzmn2) {
        try {
            InvitationReceivedBinderCallback invitationReceivedBinderCallback = new InvitationReceivedBinderCallback(zzmn2);
            ((IGamesService)this.zzqs()).zza((IGamesCallbacks)invitationReceivedBinderCallback, this.zzaBC);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzvZ() {
        try {
            ((IGamesService)this.zzqs()).zzG(this.zzaBC);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzb(zzmn<OnTurnBasedMatchUpdateReceivedListener> zzmn2) {
        try {
            MatchUpdateReceivedBinderCallback matchUpdateReceivedBinderCallback = new MatchUpdateReceivedBinderCallback(zzmn2);
            ((IGamesService)this.zzqs()).zzb((IGamesCallbacks)matchUpdateReceivedBinderCallback, this.zzaBC);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzwa() {
        try {
            ((IGamesService)this.zzqs()).zzH(this.zzaBC);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzc(zzmn<QuestUpdateListener> zzmn2) {
        try {
            QuestUpdateBinderCallback questUpdateBinderCallback = new QuestUpdateBinderCallback(zzmn2);
            ((IGamesService)this.zzqs()).zzd((IGamesCallbacks)questUpdateBinderCallback, this.zzaBC);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzwb() {
        try {
            ((IGamesService)this.zzqs()).zzJ(this.zzaBC);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzd(zzmn<OnRequestReceivedListener> zzmn2) {
        try {
            RequestReceivedBinderCallback requestReceivedBinderCallback = new RequestReceivedBinderCallback(zzmn2);
            ((IGamesService)this.zzqs()).zzc((IGamesCallbacks)requestReceivedBinderCallback, this.zzaBC);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzwc() {
        try {
            ((IGamesService)this.zzqs()).zzI(this.zzaBC);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public Intent zza(PlayerEntity playerEntity) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzqs()).zza(playerEntity);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzwd() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzqs()).zzwd();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zza(Room room, int n) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzqs()).zza((RoomEntity)room.freeze(), n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzwe() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzqs()).zzwe();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zze(zzlx.zzb<GamesMetadata.LoadGamesResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzqs()).zzd(new GamesLoadedBinderCallback(zzb2));
    }

    public void zzf(zzlx.zzb<Status> zzb2) throws RemoteException {
        this.zzaBv.flush();
        ((IGamesService)this.zzqs()).zza(new SignOutCompleteBinderCallbacks(zzb2));
    }

    public int zzwf() {
        int n = 4368;
        try {
            n = ((IGamesService)this.zzqs()).zzwf();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public String zzwg() {
        try {
            return ((IGamesService)this.zzqs()).zzwg();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return null;
        }
    }

    public void zza(zzlx.zzb<Invitations.LoadInvitationsResult> zzb2, int n) throws RemoteException {
        ((IGamesService)this.zzqs()).zza((IGamesCallbacks)new InvitationsLoadedBinderCallback(zzb2), n);
    }

    public void zzq(String string, int n) {
        try {
            ((IGamesService)this.zzqs()).zzq(string, n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzr(String string, int n) {
        try {
            ((IGamesService)this.zzqs()).zzr(string, n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public Intent zzb(int n, int n2, boolean bl) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzqs()).zzb(n, n2, bl);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zza(zzlx.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, TurnBasedMatchConfig turnBasedMatchConfig) throws RemoteException {
        ((IGamesService)this.zzqs()).zza((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), turnBasedMatchConfig.getVariant(), turnBasedMatchConfig.zzxi(), turnBasedMatchConfig.getInvitedPlayerIds(), turnBasedMatchConfig.getAutoMatchCriteria());
    }

    public void zzc(zzlx.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzqs()).zzl(new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string);
    }

    public void zzd(zzlx.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzqs()).zzm(new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string);
    }

    public int zzwh() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzqs()).zzwh();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public void zza(zzlx.zzb<TurnBasedMultiplayer.UpdateMatchResult> zzb2, String string, byte[] byArray, String string2, ParticipantResult[] participantResultArray) throws RemoteException {
        ((IGamesService)this.zzqs()).zza((IGamesCallbacks)new TurnBasedMatchUpdatedBinderCallbacks(zzb2), string, byArray, string2, participantResultArray);
    }

    public void zza(zzlx.zzb<TurnBasedMultiplayer.UpdateMatchResult> zzb2, String string, byte[] byArray, ParticipantResult[] participantResultArray) throws RemoteException {
        ((IGamesService)this.zzqs()).zza((IGamesCallbacks)new TurnBasedMatchUpdatedBinderCallbacks(zzb2), string, byArray, participantResultArray);
    }

    public void zze(zzlx.zzb<TurnBasedMultiplayer.LeaveMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzqs()).zzo(new TurnBasedMatchLeftBinderCallbacks(zzb2), string);
    }

    public void zza(zzlx.zzb<TurnBasedMultiplayer.LeaveMatchResult> zzb2, String string, String string2) throws RemoteException {
        ((IGamesService)this.zzqs()).zzc((IGamesCallbacks)new TurnBasedMatchLeftBinderCallbacks(zzb2), string, string2);
    }

    public void zzf(zzlx.zzb<TurnBasedMultiplayer.CancelMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzqs()).zzn(new TurnBasedMatchCanceledBinderCallbacks(zzb2), string);
    }

    public void zzdt(String string) {
        try {
            ((IGamesService)this.zzqs()).zzdB(string);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zza(zzlx.zzb<TurnBasedMultiplayer.LoadMatchesResult> zzb2, int n, int[] nArray) throws RemoteException {
        ((IGamesService)this.zzqs()).zza((IGamesCallbacks)new TurnBasedMatchesLoadedBinderCallbacks(zzb2), n, nArray);
    }

    public void zzg(zzlx.zzb<TurnBasedMultiplayer.LoadMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzqs()).zzp(new TurnBasedMatchLoadedBinderCallbacks(zzb2), string);
    }

    public Intent zzc(int n, int n2, boolean bl) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzqs()).zzc(n, n2, bl);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zza(zzmn<RoomUpdateListener> zzmn2, zzmn<RoomStatusUpdateListener> zzmn3, zzmn<RealTimeMessageReceivedListener> zzmn4, RoomConfig roomConfig) {
        try {
            RoomBinderCallbacks roomBinderCallbacks = new RoomBinderCallbacks(zzmn2, zzmn3, zzmn4);
            ((IGamesService)this.zzqs()).zza((IGamesCallbacks)roomBinderCallbacks, (IBinder)this.zzaBB, roomConfig.getVariant(), roomConfig.getInvitedPlayerIds(), roomConfig.getAutoMatchCriteria(), false, this.zzaBC);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzb(zzmn<RoomUpdateListener> zzmn2, zzmn<RoomStatusUpdateListener> zzmn3, zzmn<RealTimeMessageReceivedListener> zzmn4, RoomConfig roomConfig) {
        try {
            RoomBinderCallbacks roomBinderCallbacks = new RoomBinderCallbacks(zzmn2, zzmn3, zzmn4);
            ((IGamesService)this.zzqs()).zza((IGamesCallbacks)roomBinderCallbacks, (IBinder)this.zzaBB, roomConfig.getInvitationId(), false, this.zzaBC);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zza(zzmn<RoomUpdateListener> zzmn2, String string) {
        try {
            ((IGamesService)this.zzqs()).zzc((IGamesCallbacks)new RoomBinderCallbacks(zzmn2), string);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public int zza(zzmn<RealTimeMultiplayer.ReliableMessageSentCallback> zzmn2, byte[] byArray, String string, String string2) {
        try {
            return ((IGamesService)this.zzqs()).zza((IGamesCallbacks)new RealTimeReliableMessageBinderCallbacks(zzmn2), byArray, string, string2);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return -1;
        }
    }

    public int zza(byte[] byArray, String string, String[] stringArray) {
        zzx.zzb((Object)stringArray, (Object)"Participant IDs must not be null");
        try {
            return ((IGamesService)this.zzqs()).zzb(byArray, string, stringArray);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return -1;
        }
    }

    public int zzd(byte[] byArray, String string) {
        try {
            return ((IGamesService)this.zzqs()).zzb(byArray, string, null);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return -1;
        }
    }

    public void zzgl(int n) {
        try {
            ((IGamesService)this.zzqs()).zzgl(n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public Intent zzwi() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzqs()).zzwi();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zza(int n, byte[] byArray, int n2, Bitmap bitmap, String string) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzqs()).zza(n, byArray, n2, string);
            zzx.zzb((Object)bitmap, (Object)"Must provide a non null icon");
            intent.putExtra("com.google.android.gms.games.REQUEST_ITEM_ICON", (Parcelable)bitmap);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public int zzwj() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzqs()).zzwj();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public int zzwk() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzqs()).zzwk();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public void zzb(zzlx.zzb<Requests.UpdateRequestsResult> zzb2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zzqs()).zza((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(zzb2), stringArray);
    }

    public void zzc(zzlx.zzb<Requests.UpdateRequestsResult> zzb2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zzqs()).zzb((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(zzb2), stringArray);
    }

    public void zza(zzlx.zzb<Requests.LoadRequestsResult> zzb2, int n, int n2, int n3) throws RemoteException {
        ((IGamesService)this.zzqs()).zza((IGamesCallbacks)new RequestsLoadedBinderCallbacks(zzb2), n, n2, n3);
    }

    public void zza(zzlx.zzb<AppContents.LoadAppContentResult> zzb2, int n, String string, String[] stringArray, boolean bl) throws RemoteException {
        ((IGamesService)this.zzqs()).zza((IGamesCallbacks)new AppContentLoadedBinderCallbacks(zzb2), n, string, stringArray, bl);
    }

    public void zze(zzlx.zzb<Stats.LoadPlayerStatsResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzqs()).zzi((IGamesCallbacks)new PlayerStatsLoadedBinderCallbacks(zzb2), bl);
    }

    public Intent zzb(int[] nArray) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzqs()).zzb(nArray);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzdu(String string) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzqs()).zzdu(string);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzh(zzlx.zzb<Quests.AcceptQuestResult> zzb2, String string) throws RemoteException {
        this.zzaBv.flush();
        ((IGamesService)this.zzqs()).zzu(new QuestAcceptedBinderCallbacks(zzb2), string);
    }

    public void zzb(zzlx.zzb<Quests.ClaimMilestoneResult> zzb2, String string, String string2) throws RemoteException {
        this.zzaBv.flush();
        ((IGamesService)this.zzqs()).zzf((IGamesCallbacks)new QuestMilestoneClaimBinderCallbacks(zzb2, string2), string, string2);
    }

    public void zza(zzlx.zzb<Quests.LoadQuestsResult> zzb2, int[] nArray, int n, boolean bl) throws RemoteException {
        this.zzaBv.flush();
        ((IGamesService)this.zzqs()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), nArray, n, bl);
    }

    public void zzb(zzlx.zzb<Quests.LoadQuestsResult> zzb2, boolean bl, String[] stringArray) throws RemoteException {
        this.zzaBv.flush();
        ((IGamesService)this.zzqs()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), stringArray, bl);
    }

    public void zzdv(String string) {
        try {
            ((IGamesService)this.zzqs()).zza(string, this.zzaBz.zzwC(), this.zzaBz.zzwB());
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zza(zzlx.zzb<Quests.LoadQuestsResult> zzb2, String string, String string2, int[] nArray, int n, boolean bl) throws RemoteException {
        this.zzaBv.flush();
        ((IGamesService)this.zzqs()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), string, string2, nArray, n, bl);
    }

    public void zza(zzlx.zzb<Quests.LoadQuestsResult> zzb2, String string, String string2, boolean bl, String[] stringArray) throws RemoteException {
        this.zzaBv.flush();
        ((IGamesService)this.zzqs()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), string, string2, stringArray, bl);
    }

    public int zzwl() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzqs()).zzwl();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public int zzwm() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzqs()).zzwm();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public Intent zza(String string, boolean bl, boolean bl2, int n) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzqs()).zza(string, bl, bl2, n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzf(zzlx.zzb<Snapshots.LoadSnapshotsResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzqs()).zzd((IGamesCallbacks)new SnapshotsLoadedBinderCallbacks(zzb2), bl);
    }

    public void zza(zzlx.zzb<Snapshots.OpenSnapshotResult> zzb2, String string, boolean bl, int n) throws RemoteException {
        ((IGamesService)this.zzqs()).zza((IGamesCallbacks)new SnapshotOpenedBinderCallbacks(zzb2), string, bl, n);
    }

    public void zza(zzlx.zzb<Snapshots.CommitSnapshotResult> zzb2, Snapshot snapshot, SnapshotMetadataChange snapshotMetadataChange) throws RemoteException {
        SnapshotContents snapshotContents = snapshot.getSnapshotContents();
        zzx.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"Snapshot already closed");
        BitmapTeleporter bitmapTeleporter = snapshotMetadataChange.zzxn();
        if (bitmapTeleporter != null) {
            bitmapTeleporter.zzc(this.getContext().getCacheDir());
        }
        Contents contents = snapshotContents.zzsh();
        snapshotContents.close();
        ((IGamesService)this.zzqs()).zza((IGamesCallbacks)new SnapshotCommittedBinderCallbacks(zzb2), snapshot.getMetadata().getSnapshotId(), (SnapshotMetadataChangeEntity)snapshotMetadataChange, contents);
    }

    public void zza(Snapshot snapshot) {
        SnapshotContents snapshotContents = snapshot.getSnapshotContents();
        zzx.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"Snapshot already closed");
        Contents contents = snapshotContents.zzsh();
        snapshotContents.close();
        try {
            ((IGamesService)this.zzqs()).zza(contents);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzi(zzlx.zzb<Snapshots.DeleteSnapshotResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzqs()).zzr(new SnapshotDeletedBinderCallbacks(zzb2), string);
    }

    public void zza(zzlx.zzb<Snapshots.OpenSnapshotResult> zzb2, String string, String string2, SnapshotMetadataChange snapshotMetadataChange, SnapshotContents snapshotContents) throws RemoteException {
        zzx.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"SnapshotContents already closed");
        BitmapTeleporter bitmapTeleporter = snapshotMetadataChange.zzxn();
        if (bitmapTeleporter != null) {
            bitmapTeleporter.zzc(this.getContext().getCacheDir());
        }
        Contents contents = snapshotContents.zzsh();
        snapshotContents.close();
        ((IGamesService)this.zzqs()).zza((IGamesCallbacks)new SnapshotOpenedBinderCallbacks(zzb2), string, string2, (SnapshotMetadataChangeEntity)snapshotMetadataChange, contents);
    }

    public void zza(Games.BaseGamesApiMethodImpl<Status> baseGamesApiMethodImpl, String string, String string2, VideoConfiguration videoConfiguration) throws RemoteException {
        ((IGamesService)this.zzqs()).zza((IGamesCallbacks)new StartRecordingBinderCallback(baseGamesApiMethodImpl), string, string2, videoConfiguration);
    }

    public void zzg(zzlx.zzb<Videos.ListVideosResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzqs()).zzl(new ListVideosBinderCallback(zzb2));
    }

    public void zzj(zzlx.zzb<GamesMetadata.LoadGameInstancesResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzqs()).zzf((IGamesCallbacks)new GameInstancesLoadedBinderCallback(zzb2), string);
    }

    public void zzk(zzlx.zzb<GamesMetadata.LoadGameSearchSuggestionsResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzqs()).zzq(new GameSearchSuggestionsLoadedBinderCallback(zzb2), string);
    }

    public void zzc(zzlx.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzqs()).zzd((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), string, bl);
    }

    public void zza(zzlx.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, String string, String string2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzqs()).zzb((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), string, string2, bl);
    }

    public void zza(zzlx.zzb<Leaderboards.LoadScoresResult> zzb2, String string, String string2, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zzqs()).zza((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), string, string2, n, n2, n3, bl);
    }

    public void zzb(zzlx.zzb<Leaderboards.LoadScoresResult> zzb2, String string, String string2, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zzqs()).zzb(new LeaderboardScoresLoadedBinderCallback(zzb2), string, string2, n, n2, n3, bl);
    }

    public void zzb(zzlx.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzqs()).zzb((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zzc(zzlx.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzqs()).zzc((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zzd(zzlx.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzqs()).zze(new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zzb(zzlx.zzb<Players.LoadPlayersResult> zzb2, String string, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzqs()).zzb((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, n, bl, bl2);
    }

    public void zzb(zzlx.zzb<Players.LoadPlayersResult> zzb2, String string, String string2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzqs()).zzb((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, string2, n, bl, bl2);
    }

    public void zzl(zzlx.zzb<Players.LoadXpForGameCategoriesResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzqs()).zzs(new PlayerXpForGameCategoriesLoadedBinderCallback(zzb2), string);
    }

    public void zzc(zzlx.zzb<Players.LoadXpStreamResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zzqs()).zzb((IGamesCallbacks)new PlayerXpStreamLoadedBinderCallback(zzb2), string, n);
    }

    public void zzd(zzlx.zzb<Players.LoadXpStreamResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zzqs()).zzc((IGamesCallbacks)new PlayerXpStreamLoadedBinderCallback(zzb2), string, n);
    }

    public void zzg(zzlx.zzb<Players.LoadProfileSettingsResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzqs()).zzg((IGamesCallbacks)new ProfileSettingsLoadedBinderCallback(zzb2), bl);
    }

    public void zzh(zzlx.zzb<Status> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzqs()).zzh((IGamesCallbacks)new ProfileSettingsUpdatedBinderCallback(zzb2), bl);
    }

    public void zzb(zzlx.zzb<Achievements.LoadAchievementsResult> zzb2, String string, String string2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzqs()).zza((IGamesCallbacks)new AchievementsLoadedBinderCallback(zzb2), string, string2, bl);
    }

    public void zzc(zzlx.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string, String string2) throws RemoteException {
        ((IGamesService)this.zzqs()).zzd((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string, string2);
    }

    public void zzd(zzlx.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string, String string2) throws RemoteException {
        ((IGamesService)this.zzqs()).zze((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string, string2);
    }

    public void zze(zzlx.zzb<Invitations.LoadInvitationsResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zzqs()).zzb((IGamesCallbacks)new InvitationsLoadedBinderCallback(zzb2), string, n, false);
    }

    public void zzm(zzlx.zzb<Invitations.LoadInvitationsResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzqs()).zzk(new InvitationsLoadedBinderCallback(zzb2), string);
    }

    public void zza(zzlx.zzb<TurnBasedMultiplayer.LoadMatchesResult> zzb2, String string, int n, int[] nArray) throws RemoteException {
        ((IGamesService)this.zzqs()).zza((IGamesCallbacks)new TurnBasedMatchesLoadedBinderCallbacks(zzb2), string, n, nArray);
    }

    public void zzh(zzlx.zzb<Acls.LoadAclResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzqs()).zzh(new NotifyAclLoadedBinderCallback(zzb2));
    }

    public void zzn(zzlx.zzb<Status> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzqs()).zzj(new NotifyAclUpdatedBinderCallback(zzb2), string);
    }

    public void zzd(zzlx.zzb<Notifications.GameMuteStatusChangeResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzqs()).zza((IGamesCallbacks)new GameMuteStatusChangedBinderCallback(zzb2), string, bl);
    }

    public void zzo(zzlx.zzb<Notifications.GameMuteStatusLoadResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzqs()).zzi((IGamesCallbacks)new GameMuteStatusLoadedBinderCallback(zzb2), string);
    }

    public void zzi(zzlx.zzb<Notifications.ContactSettingLoadResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzqs()).zze((IGamesCallbacks)new ContactSettingsLoadedBinderCallback(zzb2), bl);
    }

    public void zza(zzlx.zzb<Status> zzb2, boolean bl, Bundle bundle) throws RemoteException {
        ((IGamesService)this.zzqs()).zza((IGamesCallbacks)new ContactSettingsUpdatedBinderCallback(zzb2), bl, bundle);
    }

    public void zzi(zzlx.zzb<Notifications.InboxCountResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzqs()).zzt(new InboxCountsLoadedBinderCallback(zzb2), null);
    }

    public void zza(zzlx.zzb<Requests.SendRequestResult> zzb2, String string, String[] stringArray, int n, byte[] byArray, int n2) throws RemoteException {
        ((IGamesService)this.zzqs()).zza((IGamesCallbacks)new RequestSentBinderCallbacks(zzb2), string, stringArray, n, byArray, n2);
    }

    public void zza(zzlx.zzb<Requests.UpdateRequestsResult> zzb2, String string, String string2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zzqs()).zza((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(zzb2), string, string2, stringArray);
    }

    public void zza(zzlx.zzb<Requests.LoadRequestsResult> zzb2, String string, String string2, int n, int n2, int n3) throws RemoteException {
        ((IGamesService)this.zzqs()).zza((IGamesCallbacks)new RequestsLoadedBinderCallbacks(zzb2), string, string2, n, n2, n3);
    }

    public void zzf(zzlx.zzb<Requests.LoadRequestSummariesResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zzqs()).zza((IGamesCallbacks)new RequestSummariesLoadedBinderCallbacks(zzb2), string, n);
    }

    public void zzc(zzlx.zzb<Snapshots.LoadSnapshotsResult> zzb2, String string, String string2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzqs()).zzc((IGamesCallbacks)new SnapshotsLoadedBinderCallbacks(zzb2), string, string2, bl);
    }

    public void zza(IBinder iBinder, Bundle bundle) {
        if (this.isConnected()) {
            try {
                ((IGamesService)this.zzqs()).zza(iBinder, bundle);
            }
            catch (RemoteException remoteException) {
                this.zzb(remoteException);
            }
        }
    }

    public void zzwn() {
        if (this.isConnected()) {
            try {
                ((IGamesService)this.zzqs()).zzwn();
            }
            catch (RemoteException remoteException) {
                this.zzb(remoteException);
            }
        }
    }

    private void zzb(RemoteException remoteException) {
        GamesLog.zzb("GamesClientImpl", "service died", remoteException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Room zzY(DataHolder dataHolder) {
        RoomBuffer roomBuffer = new RoomBuffer(dataHolder);
        Room room = null;
        try {
            if (roomBuffer.getCount() > 0) {
                room = (Room)((Room)roomBuffer.get(0)).freeze();
            }
        }
        finally {
            roomBuffer.release();
        }
        return room;
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (n == 0 && bundle != null) {
            bundle.setClassLoader(GamesClientImpl.class.getClassLoader());
            this.zzaBA = bundle.getBoolean("show_welcome_popup");
            this.zzaBx = (PlayerEntity)bundle.getParcelable("com.google.android.gms.games.current_player");
            this.zzaBy = (GameEntity)bundle.getParcelable("com.google.android.gms.games.current_game");
        }
        super.zza(n, iBinder, bundle, n2);
    }

    protected /* synthetic */ IInterface zzW(IBinder iBinder) {
        return this.zzbV(iBinder);
    }

    public static final class ListVideosResultImpl
    extends GamesDataHolderResult
    implements Videos.ListVideosResult {
        private final VideoBuffer zzaBS;

        public ListVideosResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaBS = new VideoBuffer(dataHolder);
        }
    }

    private static final class DeleteSnapshotResultImpl
    implements Snapshots.DeleteSnapshotResult {
        private final Status zzTA;
        private final String zzaBL;

        DeleteSnapshotResultImpl(int statusCode, String snapshotId) {
            this.zzTA = GamesStatusCodes.zzfU(statusCode);
            this.zzaBL = snapshotId;
        }

        public Status getStatus() {
            return this.zzTA;
        }

        @Override
        public String getSnapshotId() {
            return this.zzaBL;
        }
    }

    private static final class CommitSnapshotResultImpl
    extends GamesDataHolderResult
    implements Snapshots.CommitSnapshotResult {
        private final SnapshotMetadata zzaBK;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        CommitSnapshotResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(dataHolder);
            try {
                this.zzaBK = snapshotMetadataBuffer.getCount() > 0 ? new SnapshotMetadataEntity(snapshotMetadataBuffer.get(0)) : null;
            }
            finally {
                snapshotMetadataBuffer.release();
            }
        }

        @Override
        public SnapshotMetadata getSnapshotMetadata() {
            return this.zzaBK;
        }
    }

    private static final class OpenSnapshotResultImpl
    extends GamesDataHolderResult
    implements Snapshots.OpenSnapshotResult {
        private final Snapshot zzaCp;
        private final String zzaCq;
        private final Snapshot zzaCr;
        private final Contents zzaCs;
        private final SnapshotContents zzaCt;

        OpenSnapshotResultImpl(DataHolder dataHolder, Contents currentContents) {
            this(dataHolder, null, currentContents, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        OpenSnapshotResultImpl(DataHolder metadataHolder, String conflictId, Contents currentContents, Contents conflictContents, Contents resolutionContents) {
            super(metadataHolder);
            SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(metadataHolder);
            try {
                if (snapshotMetadataBuffer.getCount() == 0) {
                    this.zzaCp = null;
                    this.zzaCr = null;
                } else if (snapshotMetadataBuffer.getCount() == 1) {
                    zzb.zzaa((metadataHolder.getStatusCode() != 4004 ? 1 : 0) != 0);
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity(snapshotMetadataBuffer.get(0));
                    this.zzaCp = new SnapshotEntity(snapshotMetadataEntity, new SnapshotContentsEntity(currentContents));
                    this.zzaCr = null;
                } else {
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity(snapshotMetadataBuffer.get(0));
                    this.zzaCp = new SnapshotEntity(snapshotMetadataEntity, new SnapshotContentsEntity(currentContents));
                    SnapshotMetadataEntity snapshotMetadataEntity2 = new SnapshotMetadataEntity(snapshotMetadataBuffer.get(1));
                    this.zzaCr = new SnapshotEntity(snapshotMetadataEntity2, new SnapshotContentsEntity(conflictContents));
                }
            }
            finally {
                snapshotMetadataBuffer.release();
            }
            this.zzaCq = conflictId;
            this.zzaCs = resolutionContents;
            this.zzaCt = new SnapshotContentsEntity(resolutionContents);
        }

        @Override
        public Snapshot getSnapshot() {
            return this.zzaCp;
        }

        @Override
        public String getConflictId() {
            return this.zzaCq;
        }

        @Override
        public Snapshot getConflictingSnapshot() {
            return this.zzaCr;
        }

        @Override
        public SnapshotContents getResolutionSnapshotContents() {
            return this.zzaCt;
        }
    }

    private static final class LoadSnapshotsResultImpl
    extends GamesDataHolderResult
    implements Snapshots.LoadSnapshotsResult {
        LoadSnapshotsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public SnapshotMetadataBuffer getSnapshots() {
            return new SnapshotMetadataBuffer(this.zzafC);
        }
    }

    private static final class LoadPlayerStatsResultImpl
    extends GamesDataHolderResult
    implements Stats.LoadPlayerStatsResult {
        private final PlayerStats zzaCc;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LoadPlayerStatsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            PlayerStatsBuffer playerStatsBuffer = new PlayerStatsBuffer(dataHolder);
            try {
                this.zzaCc = playerStatsBuffer.getCount() > 0 ? new PlayerStatsEntity(playerStatsBuffer.zzgN(0)) : null;
            }
            finally {
                playerStatsBuffer.release();
            }
        }

        @Override
        public PlayerStats getPlayerStats() {
            return this.zzaCc;
        }
    }

    private static final class LoadAppContentsResultImpl
    extends GamesDataHolderResult
    implements AppContents.LoadAppContentResult {
        private final ArrayList<DataHolder> zzaBU;

        LoadAppContentsResultImpl(DataHolder[] appContentData) {
            super(appContentData[0]);
            this.zzaBU = new ArrayList<DataHolder>(Arrays.asList(appContentData));
        }
    }

    private static final class ClaimMilestoneResultImpl
    extends GamesDataHolderResult
    implements Quests.ClaimMilestoneResult {
        private final Milestone zzaBJ;
        private final Quest zzaBG;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ClaimMilestoneResultImpl(DataHolder dataHolder, String milestoneId) {
            super(dataHolder);
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            try {
                if (questBuffer.getCount() > 0) {
                    this.zzaBG = new QuestEntity((Quest)questBuffer.get(0));
                    List<Milestone> list = this.zzaBG.zzxk();
                    int n = list.size();
                    for (int i = 0; i < n; ++i) {
                        if (!list.get(i).getMilestoneId().equals(milestoneId)) continue;
                        this.zzaBJ = list.get(i);
                        return;
                    }
                    this.zzaBJ = null;
                } else {
                    this.zzaBJ = null;
                    this.zzaBG = null;
                }
            }
            finally {
                questBuffer.release();
            }
        }

        @Override
        public Milestone getMilestone() {
            return this.zzaBJ;
        }

        @Override
        public Quest getQuest() {
            return this.zzaBG;
        }
    }

    private static final class AcceptQuestResultImpl
    extends GamesDataHolderResult
    implements Quests.AcceptQuestResult {
        private final Quest zzaBG;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        AcceptQuestResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            try {
                this.zzaBG = questBuffer.getCount() > 0 ? new QuestEntity((Quest)questBuffer.get(0)) : null;
            }
            finally {
                questBuffer.release();
            }
        }

        @Override
        public Quest getQuest() {
            return this.zzaBG;
        }
    }

    private static final class LoadQuestsResultImpl
    extends GamesDataHolderResult
    implements Quests.LoadQuestsResult {
        private final DataHolder zzafC;

        LoadQuestsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzafC = dataHolder;
        }

        @Override
        public QuestBuffer getQuests() {
            return new QuestBuffer(this.zzafC);
        }
    }

    private static final class LoadRequestSummariesResultImpl
    extends GamesDataHolderResult
    implements Requests.LoadRequestSummariesResult {
        LoadRequestSummariesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class LoadRequestsResultImpl
    implements Requests.LoadRequestsResult {
        private final Status zzTA;
        private final Bundle zzaCf;

        LoadRequestsResultImpl(Status status, Bundle requestData) {
            this.zzTA = status;
            this.zzaCf = requestData;
        }

        public Status getStatus() {
            return this.zzTA;
        }

        @Override
        public GameRequestBuffer getRequests(int requestType) {
            String string = RequestType.zzgo(requestType);
            if (!this.zzaCf.containsKey(string)) {
                return null;
            }
            DataHolder dataHolder = (DataHolder)this.zzaCf.get(string);
            return new GameRequestBuffer(dataHolder);
        }

        public void release() {
            for (String string : this.zzaCf.keySet()) {
                DataHolder dataHolder = (DataHolder)this.zzaCf.getParcelable(string);
                if (dataHolder == null) continue;
                dataHolder.close();
            }
        }
    }

    private static final class UpdateRequestsResultImpl
    extends GamesDataHolderResult
    implements Requests.UpdateRequestsResult {
        private final RequestUpdateOutcomes zzaCV;

        UpdateRequestsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaCV = RequestUpdateOutcomes.zzab(dataHolder);
        }

        @Override
        public int getRequestOutcome(String requestId) {
            return this.zzaCV.getRequestOutcome(requestId);
        }

        @Override
        public Set<String> getRequestIds() {
            return this.zzaCV.getRequestIds();
        }
    }

    private static final class SendRequestResultImpl
    extends GamesDataHolderResult
    implements Requests.SendRequestResult {
        private final GameRequest zzaCC;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SendRequestResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            GameRequestBuffer gameRequestBuffer = new GameRequestBuffer(dataHolder);
            try {
                this.zzaCC = gameRequestBuffer.getCount() > 0 ? (GameRequest)((GameRequest)gameRequestBuffer.get(0)).freeze() : null;
            }
            finally {
                gameRequestBuffer.release();
            }
        }
    }

    private static final class InboxCountResultImpl
    implements Notifications.InboxCountResult {
        private final Status zzTA;
        private final Bundle zzaBO;

        InboxCountResultImpl(Status status, Bundle inboxCounts) {
            this.zzTA = status;
            this.zzaBO = inboxCounts;
        }

        public Status getStatus() {
            return this.zzTA;
        }
    }

    private static final class GetTokenResultImpl
    implements Games.GetTokenResult {
        private final Status zzTA;
        private final String zzTR;

        GetTokenResultImpl(Status status, String token) {
            this.zzTA = status;
            this.zzTR = token;
        }

        public Status getStatus() {
            return this.zzTA;
        }
    }

    private static final class ContactSettingLoadResultImpl
    extends GamesDataHolderResult
    implements Notifications.ContactSettingLoadResult {
        ContactSettingLoadResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class GameMuteStatusLoadResultImpl
    implements Notifications.GameMuteStatusLoadResult {
        private final Status zzTA;
        private final String zzaBM;
        private final boolean zzaBN;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GameMuteStatusLoadResultImpl(DataHolder dataHolder) {
            try {
                this.zzTA = GamesStatusCodes.zzfU(dataHolder.getStatusCode());
                if (dataHolder.getCount() > 0) {
                    this.zzaBM = dataHolder.zzd("external_game_id", 0, 0);
                    this.zzaBN = dataHolder.zze("muted", 0, 0);
                } else {
                    this.zzaBM = null;
                    this.zzaBN = false;
                }
            }
            finally {
                dataHolder.close();
            }
        }

        public Status getStatus() {
            return this.zzTA;
        }
    }

    private static final class GameMuteStatusChangeResultImpl
    implements Notifications.GameMuteStatusChangeResult {
        private final Status zzTA;
        private final String zzaBM;
        private final boolean zzaBN;

        public GameMuteStatusChangeResultImpl(int statusCode, String externalGameId, boolean isMuted) {
            this.zzTA = GamesStatusCodes.zzfU(statusCode);
            this.zzaBM = externalGameId;
            this.zzaBN = isMuted;
        }

        public Status getStatus() {
            return this.zzTA;
        }
    }

    private static final class LoadAclResultImpl
    extends GamesDataHolderResult
    implements Acls.LoadAclResult {
        LoadAclResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class CancelMatchResultImpl
    implements TurnBasedMultiplayer.CancelMatchResult {
        private final Status zzTA;
        private final String zzaBI;

        CancelMatchResultImpl(Status status, String externalMatchId) {
            this.zzTA = status;
            this.zzaBI = externalMatchId;
        }

        public Status getStatus() {
            return this.zzTA;
        }

        @Override
        public String getMatchId() {
            return this.zzaBI;
        }
    }

    private static final class LeaveMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.LeaveMatchResult {
        LeaveMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class UpdateMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.UpdateMatchResult {
        UpdateMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class InitiateMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.InitiateMatchResult {
        InitiateMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class LoadMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.LoadMatchResult {
        LoadMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static abstract class TurnBasedMatchResult
    extends GamesDataHolderResult {
        final TurnBasedMatch zzaCm;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TurnBasedMatchResult(DataHolder dataHolder) {
            super(dataHolder);
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            try {
                this.zzaCm = turnBasedMatchBuffer.getCount() > 0 ? (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze() : null;
            }
            finally {
                turnBasedMatchBuffer.release();
            }
        }

        public TurnBasedMatch getMatch() {
            return this.zzaCm;
        }
    }

    private static final class SubmitScoreResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.SubmitScoreResult {
        private final ScoreSubmissionData zzaCO;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SubmitScoreResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            try {
                this.zzaCO = new ScoreSubmissionData(dataHolder);
            }
            finally {
                dataHolder.close();
            }
        }

        @Override
        public ScoreSubmissionData getScoreData() {
            return this.zzaCO;
        }
    }

    private static final class LoadProfileSettingsResultImpl
    extends GamesDataHolderResult
    implements Players.LoadProfileSettingsResult {
        private final boolean zzaBs;
        private final boolean zzaCe;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LoadProfileSettingsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            try {
                if (dataHolder.getCount() > 0) {
                    int n = dataHolder.zzbI(0);
                    this.zzaBs = dataHolder.zze("profile_visible", 0, n);
                    this.zzaCe = dataHolder.zze("profile_visibility_explicitly_set", 0, n);
                } else {
                    this.zzaBs = true;
                    this.zzaCe = false;
                }
            }
            finally {
                dataHolder.close();
            }
        }

        public Status getStatus() {
            return this.zzTA;
        }
    }

    private static final class LoadXpStreamResultImpl
    extends GamesDataHolderResult
    implements Players.LoadXpStreamResult {
        private final ExperienceEventBuffer zzaCk;

        LoadXpStreamResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaCk = new ExperienceEventBuffer(dataHolder);
        }
    }

    private static final class LoadXpForGameCategoriesResultImpl
    implements Players.LoadXpForGameCategoriesResult {
        private final Status zzTA;
        private final List<String> zzaCi;
        private final Bundle zzaCj;

        LoadXpForGameCategoriesResultImpl(Status status, Bundle xpData) {
            this.zzTA = status;
            this.zzaCi = xpData.getStringArrayList("game_category_list");
            this.zzaCj = xpData;
        }

        public Status getStatus() {
            return this.zzTA;
        }
    }

    private static final class LoadPlayersResultImpl
    extends GamesDataHolderResult
    implements Players.LoadPlayersResult {
        private final PlayerBuffer zzaCd;

        LoadPlayersResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaCd = new PlayerBuffer(dataHolder);
        }

        @Override
        public PlayerBuffer getPlayers() {
            return this.zzaCd;
        }
    }

    private static final class LoadMatchesResultImpl
    implements TurnBasedMultiplayer.LoadMatchesResult {
        private final Status zzTA;
        private final LoadMatchesResponse zzaCa;

        LoadMatchesResultImpl(Status status, Bundle matchData) {
            this.zzTA = status;
            this.zzaCa = new LoadMatchesResponse(matchData);
        }

        public Status getStatus() {
            return this.zzTA;
        }

        @Override
        public LoadMatchesResponse getMatches() {
            return this.zzaCa;
        }

        public void release() {
            this.zzaCa.release();
        }
    }

    private static final class LoadInvitationsResultImpl
    extends GamesDataHolderResult
    implements Invitations.LoadInvitationsResult {
        private final InvitationBuffer zzaBZ;

        LoadInvitationsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaBZ = new InvitationBuffer(dataHolder);
        }

        @Override
        public InvitationBuffer getInvitations() {
            return this.zzaBZ;
        }
    }

    private static final class LoadPlayerScoreResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.LoadPlayerScoreResult {
        private final LeaderboardScoreEntity zzaCb;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LoadPlayerScoreResultImpl(DataHolder scoreHolder) {
            super(scoreHolder);
            LeaderboardScoreBuffer leaderboardScoreBuffer = new LeaderboardScoreBuffer(scoreHolder);
            try {
                this.zzaCb = leaderboardScoreBuffer.getCount() > 0 ? (LeaderboardScoreEntity)leaderboardScoreBuffer.get(0).freeze() : null;
            }
            finally {
                leaderboardScoreBuffer.release();
            }
        }

        @Override
        public LeaderboardScore getScore() {
            return this.zzaCb;
        }
    }

    private static final class LoadScoresResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.LoadScoresResult {
        private final LeaderboardEntity zzaCg;
        private final LeaderboardScoreBuffer zzaCh;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LoadScoresResultImpl(DataHolder leaderboard, DataHolder scores) {
            super(scores);
            LeaderboardBuffer leaderboardBuffer = new LeaderboardBuffer(leaderboard);
            try {
                this.zzaCg = leaderboardBuffer.getCount() > 0 ? (LeaderboardEntity)((Leaderboard)leaderboardBuffer.get(0)).freeze() : null;
            }
            finally {
                leaderboardBuffer.release();
            }
            this.zzaCh = new LeaderboardScoreBuffer(scores);
        }

        @Override
        public Leaderboard getLeaderboard() {
            return this.zzaCg;
        }

        @Override
        public LeaderboardScoreBuffer getScores() {
            return this.zzaCh;
        }
    }

    private static final class LeaderboardMetadataResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.LeaderboardMetadataResult {
        private final LeaderboardBuffer zzaBQ;

        LeaderboardMetadataResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaBQ = new LeaderboardBuffer(dataHolder);
        }

        @Override
        public LeaderboardBuffer getLeaderboards() {
            return this.zzaBQ;
        }
    }

    private static final class LoadGameSearchSuggestionsResultImpl
    extends GamesDataHolderResult
    implements GamesMetadata.LoadGameSearchSuggestionsResult {
        private final GameSearchSuggestionBuffer zzaBX;

        LoadGameSearchSuggestionsResultImpl(DataHolder data) {
            super(data);
            this.zzaBX = new GameSearchSuggestionBuffer(data);
        }
    }

    private static final class LoadGameInstancesResultImpl
    extends GamesDataHolderResult
    implements GamesMetadata.LoadGameInstancesResult {
        private final GameInstanceBuffer zzaBW;

        LoadGameInstancesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaBW = new GameInstanceBuffer(dataHolder);
        }
    }

    private static final class LoadGamesResultImpl
    extends GamesDataHolderResult
    implements GamesMetadata.LoadGamesResult {
        private final GameBuffer zzaBY;

        LoadGamesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaBY = new GameBuffer(dataHolder);
        }

        @Override
        public GameBuffer getGames() {
            return this.zzaBY;
        }
    }

    private static final class LoadEventResultImpl
    extends GamesDataHolderResult
    implements Events.LoadEventsResult {
        private final EventBuffer zzaBV;

        LoadEventResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaBV = new EventBuffer(dataHolder);
        }

        @Override
        public EventBuffer getEvents() {
            return this.zzaBV;
        }
    }

    private static final class UpdateAchievementResultImpl
    implements Achievements.UpdateAchievementResult {
        private final Status zzTA;
        private final String zzaAE;

        UpdateAchievementResultImpl(int statusCode, String achievementId) {
            this.zzTA = GamesStatusCodes.zzfU(statusCode);
            this.zzaAE = achievementId;
        }

        public Status getStatus() {
            return this.zzTA;
        }

        @Override
        public String getAchievementId() {
            return this.zzaAE;
        }
    }

    private static final class LoadAchievementsResultImpl
    extends GamesDataHolderResult
    implements Achievements.LoadAchievementsResult {
        private final AchievementBuffer zzaBT;

        LoadAchievementsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaBT = new AchievementBuffer(dataHolder);
        }

        @Override
        public AchievementBuffer getAchievements() {
            return this.zzaBT;
        }
    }

    private static abstract class GamesDataHolderResult
    extends zzmc {
        protected GamesDataHolderResult(DataHolder dataHolder) {
            super(dataHolder, GamesStatusCodes.zzfU(dataHolder.getStatusCode()));
        }
    }

    private static final class RealTimeMessageSentNotifier
    implements zzmn.zzb<RealTimeMultiplayer.ReliableMessageSentCallback> {
        private final int zzabx;
        private final String zzaCz;
        private final int zzaCA;

        RealTimeMessageSentNotifier(int statusCode, int token, String recipientParticipantId) {
            this.zzabx = statusCode;
            this.zzaCA = token;
            this.zzaCz = recipientParticipantId;
        }

        public void zza(RealTimeMultiplayer.ReliableMessageSentCallback reliableMessageSentCallback) {
            if (reliableMessageSentCallback != null) {
                reliableMessageSentCallback.onRealTimeMessageSent(this.zzabx, this.zzaCA, this.zzaCz);
            }
        }

        public void zzpb() {
        }

        public /* synthetic */ void zzs(Object object) {
            this.zza((RealTimeMultiplayer.ReliableMessageSentCallback)object);
        }
    }

    private static final class MessageReceivedNotifier
    implements zzmn.zzb<RealTimeMessageReceivedListener> {
        private final RealTimeMessage zzaCn;

        MessageReceivedNotifier(RealTimeMessage message) {
            this.zzaCn = message;
        }

        public void zza(RealTimeMessageReceivedListener realTimeMessageReceivedListener) {
            realTimeMessageReceivedListener.onRealTimeMessageReceived(this.zzaCn);
        }

        public void zzpb() {
        }

        public /* synthetic */ void zzs(Object object) {
            this.zza((RealTimeMessageReceivedListener)object);
        }
    }

    private static final class P2PDisconnectedNotifier
    implements zzmn.zzb<RoomStatusUpdateListener> {
        private final String zzaCu;

        P2PDisconnectedNotifier(String participantId) {
            this.zzaCu = participantId;
        }

        public void zza(RoomStatusUpdateListener roomStatusUpdateListener) {
            roomStatusUpdateListener.onP2PDisconnected(this.zzaCu);
        }

        public void zzpb() {
        }

        public /* synthetic */ void zzs(Object object) {
            this.zza((RoomStatusUpdateListener)object);
        }
    }

    private static final class P2PConnectedNotifier
    implements zzmn.zzb<RoomStatusUpdateListener> {
        private final String zzaCu;

        P2PConnectedNotifier(String participantId) {
            this.zzaCu = participantId;
        }

        public void zza(RoomStatusUpdateListener roomStatusUpdateListener) {
            roomStatusUpdateListener.onP2PConnected(this.zzaCu);
        }

        public void zzpb() {
        }

        public /* synthetic */ void zzs(Object object) {
            this.zza((RoomStatusUpdateListener)object);
        }
    }

    private static final class PeerDisconnectedNotifier
    extends AbstractPeerStatusNotifier {
        PeerDisconnectedNotifier(DataHolder dataHolder, String[] participantIds) {
            super(dataHolder, participantIds);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersDisconnected(room, arrayList);
        }
    }

    private static final class PeerConnectedNotifier
    extends AbstractPeerStatusNotifier {
        PeerConnectedNotifier(DataHolder dataHolder, String[] participantIds) {
            super(dataHolder, participantIds);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersConnected(room, arrayList);
        }
    }

    private static final class PeerDeclinedNotifier
    extends AbstractPeerStatusNotifier {
        PeerDeclinedNotifier(DataHolder dataHolder, String[] participantIds) {
            super(dataHolder, participantIds);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerDeclined(room, arrayList);
        }
    }

    private static final class PeerLeftRoomNotifier
    extends AbstractPeerStatusNotifier {
        PeerLeftRoomNotifier(DataHolder dataHolder, String[] participantIds) {
            super(dataHolder, participantIds);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerLeft(room, arrayList);
        }
    }

    private static final class PeerJoinedRoomNotifier
    extends AbstractPeerStatusNotifier {
        PeerJoinedRoomNotifier(DataHolder dataHolder, String[] participantIds) {
            super(dataHolder, participantIds);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerJoined(room, arrayList);
        }
    }

    private static final class PeerInvitedToRoomNotifier
    extends AbstractPeerStatusNotifier {
        PeerInvitedToRoomNotifier(DataHolder dataHolder, String[] participantIds) {
            super(dataHolder, participantIds);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerInvitedToRoom(room, arrayList);
        }
    }

    private static final class DisconnectedFromRoomNotifier
    extends AbstractRoomStatusNotifier {
        DisconnectedFromRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onDisconnectedFromRoom(room);
        }
    }

    private static final class ConnectedToRoomNotifier
    extends AbstractRoomStatusNotifier {
        ConnectedToRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onConnectedToRoom(room);
        }
    }

    private static final class RoomAutoMatchingNotifier
    extends AbstractRoomStatusNotifier {
        RoomAutoMatchingNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomAutoMatching(room);
        }
    }

    private static final class RoomConnectingNotifier
    extends AbstractRoomStatusNotifier {
        RoomConnectingNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomConnecting(room);
        }
    }

    private static final class RoomConnectedNotifier
    extends AbstractRoomNotifier {
        RoomConnectedNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onRoomConnected(n, room);
        }
    }

    private static final class LeftRoomNotifier
    implements zzmn.zzb<RoomUpdateListener> {
        private final int zzabx;
        private final String zzaBR;

        LeftRoomNotifier(int statusCode, String roomId) {
            this.zzabx = statusCode;
            this.zzaBR = roomId;
        }

        public void zza(RoomUpdateListener roomUpdateListener) {
            roomUpdateListener.onLeftRoom(this.zzabx, this.zzaBR);
        }

        public void zzpb() {
        }

        public /* synthetic */ void zzs(Object object) {
            this.zza((RoomUpdateListener)object);
        }
    }

    private static final class JoinedRoomNotifier
    extends AbstractRoomNotifier {
        public JoinedRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onJoinedRoom(n, room);
        }
    }

    private static final class RoomCreatedNotifier
    extends AbstractRoomNotifier {
        public RoomCreatedNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onRoomCreated(n, room);
        }
    }

    private static abstract class AbstractPeerStatusNotifier
    extends AbstractRoomStatusNotifier {
        private final ArrayList<String> zzaBF = new ArrayList();

        AbstractPeerStatusNotifier(DataHolder dataHolder, String[] participantIds) {
            super(dataHolder);
            int n = participantIds.length;
            for (int i = 0; i < n; ++i) {
                this.zzaBF.add(participantIds[i]);
            }
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            this.zza(roomStatusUpdateListener, room, this.zzaBF);
        }

        protected abstract void zza(RoomStatusUpdateListener var1, Room var2, ArrayList<String> var3);
    }

    private static abstract class AbstractRoomStatusNotifier
    extends zzmb<RoomStatusUpdateListener> {
        AbstractRoomStatusNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder) {
            this.zza(roomStatusUpdateListener, GamesClientImpl.zzY(dataHolder));
        }

        protected abstract void zza(RoomStatusUpdateListener var1, Room var2);
    }

    private static abstract class AbstractRoomNotifier
    extends zzmb<RoomUpdateListener> {
        AbstractRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        protected void zza(RoomUpdateListener roomUpdateListener, DataHolder dataHolder) {
            this.zza(roomUpdateListener, GamesClientImpl.zzY(dataHolder), dataHolder.getStatusCode());
        }

        protected abstract void zza(RoomUpdateListener var1, Room var2, int var3);
    }

    private static final class NearbyPlayerDetectedNotifier
    implements zzmn.zzb<OnNearbyPlayerDetectedListener> {
        private final Player zzaCo;

        public void zza(OnNearbyPlayerDetectedListener onNearbyPlayerDetectedListener) {
            onNearbyPlayerDetectedListener.zza(this.zzaCo);
        }

        public void zzpb() {
        }

        public /* synthetic */ void zzs(Object object) {
            this.zza((OnNearbyPlayerDetectedListener)object);
        }
    }

    private static final class RequestRemovedNotifier
    implements zzmn.zzb<OnRequestReceivedListener> {
        private final String zzDX;

        RequestRemovedNotifier(String requestId) {
            this.zzDX = requestId;
        }

        public void zza(OnRequestReceivedListener onRequestReceivedListener) {
            onRequestReceivedListener.onRequestRemoved(this.zzDX);
        }

        public void zzpb() {
        }

        public /* synthetic */ void zzs(Object object) {
            this.zza((OnRequestReceivedListener)object);
        }
    }

    private static final class RequestReceivedNotifier
    implements zzmn.zzb<OnRequestReceivedListener> {
        private final GameRequest zzaCC;

        RequestReceivedNotifier(GameRequest request) {
            this.zzaCC = request;
        }

        public void zza(OnRequestReceivedListener onRequestReceivedListener) {
            onRequestReceivedListener.onRequestReceived(this.zzaCC);
        }

        public void zzpb() {
        }

        public /* synthetic */ void zzs(Object object) {
            this.zza((OnRequestReceivedListener)object);
        }
    }

    private static final class QuestCompletedNotifier
    implements zzmn.zzb<QuestUpdateListener> {
        private final Quest zzaBG;

        QuestCompletedNotifier(Quest quest) {
            this.zzaBG = quest;
        }

        public void zza(QuestUpdateListener questUpdateListener) {
            questUpdateListener.onQuestCompleted(this.zzaBG);
        }

        public void zzpb() {
        }

        public /* synthetic */ void zzs(Object object) {
            this.zza((QuestUpdateListener)object);
        }
    }

    private static final class MatchRemovedNotifier
    implements zzmn.zzb<OnTurnBasedMatchUpdateReceivedListener> {
        private final String zzaCl;

        MatchRemovedNotifier(String matchId) {
            this.zzaCl = matchId;
        }

        public void zza(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchRemoved(this.zzaCl);
        }

        public void zzpb() {
        }

        public /* synthetic */ void zzs(Object object) {
            this.zza((OnTurnBasedMatchUpdateReceivedListener)object);
        }
    }

    private static final class MatchUpdateReceivedNotifier
    implements zzmn.zzb<OnTurnBasedMatchUpdateReceivedListener> {
        private final TurnBasedMatch zzaCm;

        MatchUpdateReceivedNotifier(TurnBasedMatch match) {
            this.zzaCm = match;
        }

        public void zza(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchReceived(this.zzaCm);
        }

        public void zzpb() {
        }

        public /* synthetic */ void zzs(Object object) {
            this.zza((OnTurnBasedMatchUpdateReceivedListener)object);
        }
    }

    private static final class InvitationRemovedNotifier
    implements zzmn.zzb<OnInvitationReceivedListener> {
        private final String zzTr;

        InvitationRemovedNotifier(String invitationId) {
            this.zzTr = invitationId;
        }

        public void zza(OnInvitationReceivedListener onInvitationReceivedListener) {
            onInvitationReceivedListener.onInvitationRemoved(this.zzTr);
        }

        public void zzpb() {
        }

        public /* synthetic */ void zzs(Object object) {
            this.zza((OnInvitationReceivedListener)object);
        }
    }

    private static final class InvitationReceivedNotifier
    implements zzmn.zzb<OnInvitationReceivedListener> {
        private final Invitation zzaBP;

        InvitationReceivedNotifier(Invitation invitation) {
            this.zzaBP = invitation;
        }

        public void zza(OnInvitationReceivedListener onInvitationReceivedListener) {
            onInvitationReceivedListener.onInvitationReceived(this.zzaBP);
        }

        public void zzpb() {
        }

        public /* synthetic */ void zzs(Object object) {
            this.zza((OnInvitationReceivedListener)object);
        }
    }

    private static final class ListVideosBinderCallback
    extends AbstractGamesCallbacks {
        private final zzlx.zzb<Videos.ListVideosResult> zzakL;

        ListVideosBinderCallback(zzlx.zzb<Videos.ListVideosResult> holder) {
            this.zzakL = (zzlx.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzX(DataHolder dataHolder) {
            this.zzakL.zzr((Object)new ListVideosResultImpl(dataHolder));
        }
    }

    private static final class StartRecordingBinderCallback
    extends AbstractGamesCallbacks {
        private final Games.BaseGamesApiMethodImpl<Status> zzaCN;

        StartRecordingBinderCallback(Games.BaseGamesApiMethodImpl<Status> holder) {
            this.zzaCN = (Games.BaseGamesApiMethodImpl)((Object)zzx.zzb(holder, (Object)"Holder must not be null"));
        }

        @Override
        public void zzgi(int n) {
            this.zzaCN.zzb((Result)new Status(n));
        }
    }

    static final class SnapshotDeletedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzlx.zzb<Snapshots.DeleteSnapshotResult> zzakL;

        public SnapshotDeletedBinderCallbacks(zzlx.zzb<Snapshots.DeleteSnapshotResult> resultHolder) {
            this.zzakL = (zzlx.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzl(int n, String string) {
            this.zzakL.zzr((Object)new DeleteSnapshotResultImpl(n, string));
        }
    }

    private static final class SnapshotCommittedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzlx.zzb<Snapshots.CommitSnapshotResult> zzaCK;

        public SnapshotCommittedBinderCallbacks(zzlx.zzb<Snapshots.CommitSnapshotResult> resultHolder) {
            this.zzaCK = (zzlx.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzO(DataHolder dataHolder) {
            this.zzaCK.zzr((Object)new CommitSnapshotResultImpl(dataHolder));
        }
    }

    private static final class SnapshotOpenedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzlx.zzb<Snapshots.OpenSnapshotResult> zzaCL;

        public SnapshotOpenedBinderCallbacks(zzlx.zzb<Snapshots.OpenSnapshotResult> resultHolder) {
            this.zzaCL = (zzlx.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zza(DataHolder dataHolder, Contents contents) {
            this.zzaCL.zzr((Object)new OpenSnapshotResultImpl(dataHolder, contents));
        }

        @Override
        public void zza(DataHolder dataHolder, String string, Contents contents, Contents contents2, Contents contents3) {
            this.zzaCL.zzr((Object)new OpenSnapshotResultImpl(dataHolder, string, contents, contents2, contents3));
        }
    }

    private static final class SnapshotsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzlx.zzb<Snapshots.LoadSnapshotsResult> zzaCM;

        public SnapshotsLoadedBinderCallbacks(zzlx.zzb<Snapshots.LoadSnapshotsResult> resultHolder) {
            this.zzaCM = (zzlx.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzN(DataHolder dataHolder) {
            this.zzaCM.zzr((Object)new LoadSnapshotsResultImpl(dataHolder));
        }
    }

    private static final class PlayerStatsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzlx.zzb<Stats.LoadPlayerStatsResult> zzakL;

        public PlayerStatsLoadedBinderCallbacks(zzlx.zzb<Stats.LoadPlayerStatsResult> resultHolder) {
            this.zzakL = (zzlx.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzW(DataHolder dataHolder) {
            this.zzakL.zzr((Object)new LoadPlayerStatsResultImpl(dataHolder));
        }
    }

    private static final class AppContentLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzlx.zzb<AppContents.LoadAppContentResult> zzaBH;

        public AppContentLoadedBinderCallbacks(zzlx.zzb<AppContents.LoadAppContentResult> resultHolder) {
            this.zzaBH = (zzlx.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zza(DataHolder[] dataHolderArray) {
            this.zzaBH.zzr((Object)new LoadAppContentsResultImpl(dataHolderArray));
        }
    }

    private static final class QuestsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzlx.zzb<Quests.LoadQuestsResult> zzaCy;

        public QuestsLoadedBinderCallbacks(zzlx.zzb<Quests.LoadQuestsResult> resultHolder) {
            this.zzaCy = (zzlx.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzT(DataHolder dataHolder) {
            this.zzaCy.zzr((Object)new LoadQuestsResultImpl(dataHolder));
        }
    }

    private static final class QuestMilestoneClaimBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzlx.zzb<Quests.ClaimMilestoneResult> zzaCw;
        private final String zzaCx;

        public QuestMilestoneClaimBinderCallbacks(zzlx.zzb<Quests.ClaimMilestoneResult> resultHolder, String milestoneId) {
            this.zzaCw = (zzlx.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
            this.zzaCx = (String)zzx.zzb((Object)milestoneId, (Object)"MilestoneId must not be null");
        }

        @Override
        public void zzP(DataHolder dataHolder) {
            this.zzaCw.zzr((Object)new ClaimMilestoneResultImpl(dataHolder, this.zzaCx));
        }
    }

    private static final class QuestAcceptedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzlx.zzb<Quests.AcceptQuestResult> zzaCv;

        public QuestAcceptedBinderCallbacks(zzlx.zzb<Quests.AcceptQuestResult> resultHolder) {
            this.zzaCv = (zzlx.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzQ(DataHolder dataHolder) {
            this.zzaCv.zzr((Object)new AcceptQuestResultImpl(dataHolder));
        }
    }

    private static final class RequestSummariesLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzlx.zzb<Requests.LoadRequestSummariesResult> zzaCE;

        public RequestSummariesLoadedBinderCallbacks(zzlx.zzb<Requests.LoadRequestSummariesResult> resultHolder) {
            this.zzaCE = (zzlx.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzM(DataHolder dataHolder) {
            this.zzaCE.zzr((Object)new LoadRequestSummariesResultImpl(dataHolder));
        }
    }

    private static final class RequestsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzlx.zzb<Requests.LoadRequestsResult> zzaCF;

        public RequestsLoadedBinderCallbacks(zzlx.zzb<Requests.LoadRequestsResult> resultHolder) {
            this.zzaCF = (zzlx.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzd(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzfU(n);
            this.zzaCF.zzr((Object)new LoadRequestsResultImpl(status, bundle));
        }
    }

    private static final class RequestSentBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzlx.zzb<Requests.SendRequestResult> zzaCD;

        public RequestSentBinderCallbacks(zzlx.zzb<Requests.SendRequestResult> resultHolder) {
            this.zzaCD = (zzlx.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzL(DataHolder dataHolder) {
            this.zzaCD.zzr((Object)new SendRequestResultImpl(dataHolder));
        }
    }

    private static final class RequestsUpdatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzlx.zzb<Requests.UpdateRequestsResult> zzaCG;

        public RequestsUpdatedBinderCallbacks(zzlx.zzb<Requests.UpdateRequestsResult> resultHolder) {
            this.zzaCG = (zzlx.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzK(DataHolder dataHolder) {
            this.zzaCG.zzr((Object)new UpdateRequestsResultImpl(dataHolder));
        }
    }

    private static final class PopupLocationInfoBinderCallbacks
    extends AbstractGamesClient {
        private final PopupManager zzaBz;

        public PopupLocationInfoBinderCallbacks(PopupManager popupManager) {
            this.zzaBz = popupManager;
        }

        @Override
        public PopupLocationInfoParcelable zzvM() {
            return new PopupLocationInfoParcelable(this.zzaBz.zzwD());
        }
    }

    private static final class GetAuthTokenBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzlx.zzb<Games.GetTokenResult> zzakL;

        public GetAuthTokenBinderCallbacks(zzlx.zzb<Games.GetTokenResult> resultHolder) {
            this.zzakL = (zzlx.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzi(int n, String string) {
            Status status = GamesStatusCodes.zzfU(n);
            this.zzakL.zzr((Object)new GetTokenResultImpl(status, string));
        }
    }

    private static final class SignOutCompleteBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzlx.zzb<Status> zzakL;

        public SignOutCompleteBinderCallbacks(zzlx.zzb<Status> resultHolder) {
            this.zzakL = (zzlx.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzvL() {
            Status status = GamesStatusCodes.zzfU(0);
            this.zzakL.zzr((Object)status);
        }
    }

    private static final class InboxCountsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzlx.zzb<Notifications.InboxCountResult> zzakL;

        InboxCountsLoadedBinderCallback(zzlx.zzb<Notifications.InboxCountResult> holder) {
            this.zzakL = (zzlx.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzg(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzfU(n);
            this.zzakL.zzr((Object)new InboxCountResultImpl(status, bundle));
        }
    }

    private static final class ContactSettingsUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzlx.zzb<Status> zzakL;

        ContactSettingsUpdatedBinderCallback(zzlx.zzb<Status> holder) {
            this.zzakL = (zzlx.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzgg(int n) {
            this.zzakL.zzr((Object)GamesStatusCodes.zzfU(n));
        }
    }

    private static final class ContactSettingsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzlx.zzb<Notifications.ContactSettingLoadResult> zzakL;

        ContactSettingsLoadedBinderCallback(zzlx.zzb<Notifications.ContactSettingLoadResult> holder) {
            this.zzakL = (zzlx.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzI(DataHolder dataHolder) {
            this.zzakL.zzr((Object)new ContactSettingLoadResultImpl(dataHolder));
        }
    }

    private static final class GameMuteStatusLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzlx.zzb<Notifications.GameMuteStatusLoadResult> zzakL;

        GameMuteStatusLoadedBinderCallback(zzlx.zzb<Notifications.GameMuteStatusLoadResult> holder) {
            this.zzakL = (zzlx.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzG(DataHolder dataHolder) {
            this.zzakL.zzr((Object)new GameMuteStatusLoadResultImpl(dataHolder));
        }
    }

    private static final class GameMuteStatusChangedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzlx.zzb<Notifications.GameMuteStatusChangeResult> zzakL;

        GameMuteStatusChangedBinderCallback(zzlx.zzb<Notifications.GameMuteStatusChangeResult> holder) {
            this.zzakL = (zzlx.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zza(int n, String string, boolean bl) {
            this.zzakL.zzr((Object)new GameMuteStatusChangeResultImpl(n, string, bl));
        }
    }

    private static final class NotifyAclUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzlx.zzb<Status> zzakL;

        NotifyAclUpdatedBinderCallback(zzlx.zzb<Status> resultHolder) {
            this.zzakL = (zzlx.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzgf(int n) {
            this.zzakL.zzr((Object)GamesStatusCodes.zzfU(n));
        }
    }

    private static final class NotifyAclLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzlx.zzb<Acls.LoadAclResult> zzakL;

        NotifyAclLoadedBinderCallback(zzlx.zzb<Acls.LoadAclResult> resultHolder) {
            this.zzakL = (zzlx.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzH(DataHolder dataHolder) {
            this.zzakL.zzr((Object)new LoadAclResultImpl(dataHolder));
        }
    }

    private static final class RealTimeReliableMessageBinderCallbacks
    extends AbstractGamesCallbacks {
        final zzmn<RealTimeMultiplayer.ReliableMessageSentCallback> zzaCB;

        public RealTimeReliableMessageBinderCallbacks(zzmn<RealTimeMultiplayer.ReliableMessageSentCallback> messageSentCallbacks) {
            this.zzaCB = messageSentCallbacks;
        }

        @Override
        public void zzb(int n, int n2, String string) {
            if (this.zzaCB != null) {
                this.zzaCB.zza((zzmn.zzb)new RealTimeMessageSentNotifier(n, n2, string));
            }
        }
    }

    private static final class RoomBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzmn<? extends RoomUpdateListener> zzaCH;
        private final zzmn<? extends RoomStatusUpdateListener> zzaCI;
        private final zzmn<RealTimeMessageReceivedListener> zzaCJ;

        public RoomBinderCallbacks(zzmn<RoomUpdateListener> roomCallbacks) {
            this.zzaCH = (zzmn)zzx.zzb(roomCallbacks, (Object)"Callbacks must not be null");
            this.zzaCI = null;
            this.zzaCJ = null;
        }

        public RoomBinderCallbacks(zzmn<? extends RoomUpdateListener> roomCallbacks, zzmn<? extends RoomStatusUpdateListener> roomStatusCallbacks, zzmn<RealTimeMessageReceivedListener> realTimeMessageReceivedCallbacks) {
            this.zzaCH = (zzmn)zzx.zzb(roomCallbacks, (Object)"Callbacks must not be null");
            this.zzaCI = roomStatusCallbacks;
            this.zzaCJ = realTimeMessageReceivedCallbacks;
        }

        @Override
        public void zzz(DataHolder dataHolder) {
            this.zzaCH.zza((zzmn.zzb)new RoomCreatedNotifier(dataHolder));
        }

        @Override
        public void zzA(DataHolder dataHolder) {
            this.zzaCH.zza((zzmn.zzb)new JoinedRoomNotifier(dataHolder));
        }

        @Override
        public void onLeftRoom(int statusCode, String externalRoomId) {
            this.zzaCH.zza((zzmn.zzb)new LeftRoomNotifier(statusCode, externalRoomId));
        }

        @Override
        public void zzD(DataHolder dataHolder) {
            this.zzaCH.zza((zzmn.zzb)new RoomConnectedNotifier(dataHolder));
        }

        @Override
        public void zzB(DataHolder dataHolder) {
            if (this.zzaCI != null) {
                this.zzaCI.zza((zzmn.zzb)new RoomConnectingNotifier(dataHolder));
            }
        }

        @Override
        public void zzC(DataHolder dataHolder) {
            if (this.zzaCI != null) {
                this.zzaCI.zza((zzmn.zzb)new RoomAutoMatchingNotifier(dataHolder));
            }
        }

        @Override
        public void zzE(DataHolder dataHolder) {
            if (this.zzaCI != null) {
                this.zzaCI.zza((zzmn.zzb)new ConnectedToRoomNotifier(dataHolder));
            }
        }

        @Override
        public void zzF(DataHolder dataHolder) {
            if (this.zzaCI != null) {
                this.zzaCI.zza((zzmn.zzb)new DisconnectedFromRoomNotifier(dataHolder));
            }
        }

        @Override
        public void zze(DataHolder dataHolder, String[] stringArray) {
            if (this.zzaCI != null) {
                this.zzaCI.zza((zzmn.zzb)new PeerConnectedNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzf(DataHolder dataHolder, String[] stringArray) {
            if (this.zzaCI != null) {
                this.zzaCI.zza((zzmn.zzb)new PeerDisconnectedNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zza(DataHolder dataHolder, String[] stringArray) {
            if (this.zzaCI != null) {
                this.zzaCI.zza((zzmn.zzb)new PeerInvitedToRoomNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzb(DataHolder dataHolder, String[] stringArray) {
            if (this.zzaCI != null) {
                this.zzaCI.zza((zzmn.zzb)new PeerJoinedRoomNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzc(DataHolder dataHolder, String[] stringArray) {
            if (this.zzaCI != null) {
                this.zzaCI.zza((zzmn.zzb)new PeerLeftRoomNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzd(DataHolder dataHolder, String[] stringArray) {
            if (this.zzaCI != null) {
                this.zzaCI.zza((zzmn.zzb)new PeerDeclinedNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void onP2PConnected(String participantId) {
            if (this.zzaCI != null) {
                this.zzaCI.zza((zzmn.zzb)new P2PConnectedNotifier(participantId));
            }
        }

        @Override
        public void onP2PDisconnected(String participantId) {
            if (this.zzaCI != null) {
                this.zzaCI.zza((zzmn.zzb)new P2PDisconnectedNotifier(participantId));
            }
        }

        @Override
        public void onRealTimeMessageReceived(RealTimeMessage message) {
            if (this.zzaCJ != null) {
                this.zzaCJ.zza((zzmn.zzb)new MessageReceivedNotifier(message));
            }
        }
    }

    private static final class TurnBasedMatchCanceledBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzlx.zzb<TurnBasedMultiplayer.CancelMatchResult> zzaCP;

        public TurnBasedMatchCanceledBinderCallbacks(zzlx.zzb<TurnBasedMultiplayer.CancelMatchResult> resultHolder) {
            this.zzaCP = (zzlx.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzk(int n, String string) {
            Status status = GamesStatusCodes.zzfU(n);
            this.zzaCP.zzr((Object)new CancelMatchResultImpl(status, string));
        }
    }

    private static final class TurnBasedMatchLeftBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzlx.zzb<TurnBasedMultiplayer.LeaveMatchResult> zzaCR;

        public TurnBasedMatchLeftBinderCallbacks(zzlx.zzb<TurnBasedMultiplayer.LeaveMatchResult> resultHolder) {
            this.zzaCR = (zzlx.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzx(DataHolder dataHolder) {
            this.zzaCR.zzr((Object)new LeaveMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchUpdatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzlx.zzb<TurnBasedMultiplayer.UpdateMatchResult> zzaCT;

        public TurnBasedMatchUpdatedBinderCallbacks(zzlx.zzb<TurnBasedMultiplayer.UpdateMatchResult> resultHolder) {
            this.zzaCT = (zzlx.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzw(DataHolder dataHolder) {
            this.zzaCT.zzr((Object)new UpdateMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchInitiatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzlx.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzaCQ;

        public TurnBasedMatchInitiatedBinderCallbacks(zzlx.zzb<TurnBasedMultiplayer.InitiateMatchResult> resultHolder) {
            this.zzaCQ = (zzlx.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzv(DataHolder dataHolder) {
            this.zzaCQ.zzr((Object)new InitiateMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzlx.zzb<TurnBasedMultiplayer.LoadMatchResult> zzaCS;

        public TurnBasedMatchLoadedBinderCallbacks(zzlx.zzb<TurnBasedMultiplayer.LoadMatchResult> resultHolder) {
            this.zzaCS = (zzlx.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzu(DataHolder dataHolder) {
            this.zzaCS.zzr((Object)new LoadMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchesLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzlx.zzb<TurnBasedMultiplayer.LoadMatchesResult> zzaCU;

        public TurnBasedMatchesLoadedBinderCallbacks(zzlx.zzb<TurnBasedMultiplayer.LoadMatchesResult> resultHolder) {
            this.zzaCU = (zzlx.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzc(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzfU(n);
            this.zzaCU.zzr((Object)new LoadMatchesResultImpl(status, bundle));
        }
    }

    private static final class SubmitScoreBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzlx.zzb<Leaderboards.SubmitScoreResult> zzakL;

        public SubmitScoreBinderCallbacks(zzlx.zzb<Leaderboards.SubmitScoreResult> resultHolder) {
            this.zzakL = (zzlx.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzk(DataHolder dataHolder) {
            this.zzakL.zzr((Object)new SubmitScoreResultImpl(dataHolder));
        }
    }

    private static final class ProfileSettingsUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzlx.zzb<Status> zzakL;

        ProfileSettingsUpdatedBinderCallback(zzlx.zzb<Status> holder) {
            this.zzakL = (zzlx.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzgh(int n) {
            this.zzakL.zzr((Object)GamesStatusCodes.zzfU(n));
        }
    }

    static final class ProfileSettingsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzlx.zzb<Players.LoadProfileSettingsResult> zzakL;

        ProfileSettingsLoadedBinderCallback(zzlx.zzb<Players.LoadProfileSettingsResult> holder) {
            this.zzakL = (zzlx.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzV(DataHolder dataHolder) {
            this.zzakL.zzr((Object)new LoadProfileSettingsResultImpl(dataHolder));
        }
    }

    static final class PlayerXpStreamLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzlx.zzb<Players.LoadXpStreamResult> zzakL;

        PlayerXpStreamLoadedBinderCallback(zzlx.zzb<Players.LoadXpStreamResult> holder) {
            this.zzakL = (zzlx.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzU(DataHolder dataHolder) {
            this.zzakL.zzr((Object)new LoadXpStreamResultImpl(dataHolder));
        }
    }

    private static final class PlayerXpForGameCategoriesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzlx.zzb<Players.LoadXpForGameCategoriesResult> zzakL;

        PlayerXpForGameCategoriesLoadedBinderCallback(zzlx.zzb<Players.LoadXpForGameCategoriesResult> holder) {
            this.zzakL = (zzlx.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzf(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzfU(n);
            this.zzakL.zzr((Object)new LoadXpForGameCategoriesResultImpl(status, bundle));
        }
    }

    private static final class PlayersLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzlx.zzb<Players.LoadPlayersResult> zzakL;

        PlayersLoadedBinderCallback(zzlx.zzb<Players.LoadPlayersResult> holder) {
            this.zzakL = (zzlx.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzl(DataHolder dataHolder) {
            this.zzakL.zzr((Object)new LoadPlayersResultImpl(dataHolder));
        }

        @Override
        public void zzm(DataHolder dataHolder) {
            this.zzakL.zzr((Object)new LoadPlayersResultImpl(dataHolder));
        }
    }

    private static final class RequestReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzmn<OnRequestReceivedListener> zzape;

        RequestReceivedBinderCallback(zzmn<OnRequestReceivedListener> listener) {
            this.zzape = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzt(DataHolder dataHolder) {
            GameRequestBuffer gameRequestBuffer = new GameRequestBuffer(dataHolder);
            GameRequest gameRequest = null;
            try {
                if (gameRequestBuffer.getCount() > 0) {
                    gameRequest = (GameRequest)((GameRequest)gameRequestBuffer.get(0)).freeze();
                }
            }
            finally {
                gameRequestBuffer.release();
            }
            if (gameRequest != null) {
                this.zzape.zza((zzmn.zzb)new RequestReceivedNotifier(gameRequest));
            }
        }

        @Override
        public void onRequestRemoved(String requestId) {
            this.zzape.zza((zzmn.zzb)new RequestRemovedNotifier(requestId));
        }
    }

    private static final class QuestUpdateBinderCallback
    extends AbstractGamesCallbacks {
        private final zzmn<QuestUpdateListener> zzape;

        QuestUpdateBinderCallback(zzmn<QuestUpdateListener> listener) {
            this.zzape = listener;
        }

        @Override
        public void zzR(DataHolder dataHolder) {
            Quest quest = this.zzaa(dataHolder);
            if (quest != null) {
                this.zzape.zza((zzmn.zzb)new QuestCompletedNotifier(quest));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Quest zzaa(DataHolder dataHolder) {
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            Quest quest = null;
            try {
                if (questBuffer.getCount() > 0) {
                    quest = (Quest)((Quest)questBuffer.get(0)).freeze();
                }
            }
            finally {
                questBuffer.release();
            }
            return quest;
        }
    }

    private static final class MatchUpdateReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzmn<OnTurnBasedMatchUpdateReceivedListener> zzape;

        MatchUpdateReceivedBinderCallback(zzmn<OnTurnBasedMatchUpdateReceivedListener> listener) {
            this.zzape = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzy(DataHolder dataHolder) {
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            TurnBasedMatch turnBasedMatch = null;
            try {
                if (turnBasedMatchBuffer.getCount() > 0) {
                    turnBasedMatch = (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze();
                }
            }
            finally {
                turnBasedMatchBuffer.release();
            }
            if (turnBasedMatch != null) {
                this.zzape.zza((zzmn.zzb)new MatchUpdateReceivedNotifier(turnBasedMatch));
            }
        }

        @Override
        public void onTurnBasedMatchRemoved(String matchId) {
            this.zzape.zza((zzmn.zzb)new MatchRemovedNotifier(matchId));
        }
    }

    private static final class InvitationReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzmn<OnInvitationReceivedListener> zzape;

        InvitationReceivedBinderCallback(zzmn<OnInvitationReceivedListener> listener) {
            this.zzape = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzs(DataHolder dataHolder) {
            InvitationBuffer invitationBuffer = new InvitationBuffer(dataHolder);
            Invitation invitation = null;
            try {
                if (invitationBuffer.getCount() > 0) {
                    invitation = (Invitation)((Invitation)invitationBuffer.get(0)).freeze();
                }
            }
            finally {
                invitationBuffer.release();
            }
            if (invitation != null) {
                this.zzape.zza((zzmn.zzb)new InvitationReceivedNotifier(invitation));
            }
        }

        @Override
        public void onInvitationRemoved(String invitationId) {
            this.zzape.zza((zzmn.zzb)new InvitationRemovedNotifier(invitationId));
        }
    }

    private static final class InvitationsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzlx.zzb<Invitations.LoadInvitationsResult> zzakL;

        InvitationsLoadedBinderCallback(zzlx.zzb<Invitations.LoadInvitationsResult> resultHolder) {
            this.zzakL = (zzlx.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzr(DataHolder dataHolder) {
            this.zzakL.zzr((Object)new LoadInvitationsResultImpl(dataHolder));
        }
    }

    private static final class PlayerLeaderboardScoreLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzlx.zzb<Leaderboards.LoadPlayerScoreResult> zzakL;

        PlayerLeaderboardScoreLoadedBinderCallback(zzlx.zzb<Leaderboards.LoadPlayerScoreResult> resultHolder) {
            this.zzakL = (zzlx.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzJ(DataHolder dataHolder) {
            this.zzakL.zzr((Object)new LoadPlayerScoreResultImpl(dataHolder));
        }
    }

    private static final class LeaderboardScoresLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzlx.zzb<Leaderboards.LoadScoresResult> zzakL;

        LeaderboardScoresLoadedBinderCallback(zzlx.zzb<Leaderboards.LoadScoresResult> resultHolder) {
            this.zzakL = (zzlx.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zza(DataHolder dataHolder, DataHolder dataHolder2) {
            this.zzakL.zzr((Object)new LoadScoresResultImpl(dataHolder, dataHolder2));
        }
    }

    private static final class LeaderboardsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzlx.zzb<Leaderboards.LeaderboardMetadataResult> zzakL;

        LeaderboardsLoadedBinderCallback(zzlx.zzb<Leaderboards.LeaderboardMetadataResult> resultHolder) {
            this.zzakL = (zzlx.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzj(DataHolder dataHolder) {
            this.zzakL.zzr((Object)new LeaderboardMetadataResultImpl(dataHolder));
        }
    }

    private static final class GameSearchSuggestionsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzlx.zzb<GamesMetadata.LoadGameSearchSuggestionsResult> zzakL;

        GameSearchSuggestionsLoadedBinderCallback(zzlx.zzb<GamesMetadata.LoadGameSearchSuggestionsResult> holder) {
            this.zzakL = (zzlx.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzq(DataHolder dataHolder) {
            this.zzakL.zzr((Object)new LoadGameSearchSuggestionsResultImpl(dataHolder));
        }
    }

    private static final class GameInstancesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzlx.zzb<GamesMetadata.LoadGameInstancesResult> zzakL;

        GameInstancesLoadedBinderCallback(zzlx.zzb<GamesMetadata.LoadGameInstancesResult> holder) {
            this.zzakL = (zzlx.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzp(DataHolder dataHolder) {
            this.zzakL.zzr((Object)new LoadGameInstancesResultImpl(dataHolder));
        }
    }

    private static final class EventsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzlx.zzb<Events.LoadEventsResult> zzakL;

        EventsLoadedBinderCallback(zzlx.zzb<Events.LoadEventsResult> resultHolder) {
            this.zzakL = (zzlx.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzi(DataHolder dataHolder) {
            this.zzakL.zzr((Object)new LoadEventResultImpl(dataHolder));
        }
    }

    private static final class GamesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzlx.zzb<GamesMetadata.LoadGamesResult> zzakL;

        GamesLoadedBinderCallback(zzlx.zzb<GamesMetadata.LoadGamesResult> holder) {
            this.zzakL = (zzlx.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzn(DataHolder dataHolder) {
            this.zzakL.zzr((Object)new LoadGamesResultImpl(dataHolder));
        }
    }

    private static final class AchievementUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzlx.zzb<Achievements.UpdateAchievementResult> zzakL;

        AchievementUpdatedBinderCallback(zzlx.zzb<Achievements.UpdateAchievementResult> resultHolder) {
            this.zzakL = (zzlx.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzj(int n, String string) {
            this.zzakL.zzr((Object)new UpdateAchievementResultImpl(n, string));
        }
    }

    private static final class AchievementsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzlx.zzb<Achievements.LoadAchievementsResult> zzakL;

        AchievementsLoadedBinderCallback(zzlx.zzb<Achievements.LoadAchievementsResult> resultHolder) {
            this.zzakL = (zzlx.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzh(DataHolder dataHolder) {
            this.zzakL.zzr((Object)new LoadAchievementsResultImpl(dataHolder));
        }
    }

    private class GameClientEventIncrementCache
    extends EventIncrementCache {
        public GameClientEventIncrementCache() {
            super(GamesClientImpl.this.getContext().getMainLooper(), 1000);
        }

        @Override
        protected void zzs(String string, int n) {
            try {
                if (GamesClientImpl.this.isConnected()) {
                    ((IGamesService)GamesClientImpl.this.zzqs()).zzp(string, n);
                } else {
                    GamesLog.zzB("GamesClientImpl", "Unable to increment event " + string + " by " + n + " because the games client is no longer connected");
                }
            }
            catch (RemoteException remoteException) {
                GamesClientImpl.this.zzb(remoteException);
            }
        }
    }
}

