/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.api;

import android.content.Intent;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.achievement.AchievementBuffer;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.internal.zzlx;

public final class AchievementsImpl
implements Achievements {
    @Override
    public Intent getAchievementsIntent(GoogleApiClient apiClient) {
        return Games.zzf(apiClient).zzvW();
    }

    @Override
    public PendingResult<Achievements.LoadAchievementsResult> load(GoogleApiClient apiClient, final boolean forceReload) {
        return apiClient.zza((zzlx.zza)new LoadImpl(apiClient){

            public void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzc((zzlx.zzb<Achievements.LoadAchievementsResult>)this, forceReload);
            }
        });
    }

    @Override
    public void reveal(GoogleApiClient apiClient, final String id) {
        apiClient.zzb((zzlx.zza)new UpdateImpl(id, apiClient){

            public void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza((zzlx.zzb<Achievements.UpdateAchievementResult>)null, id);
            }
        });
    }

    @Override
    public PendingResult<Achievements.UpdateAchievementResult> revealImmediate(GoogleApiClient apiClient, final String id) {
        return apiClient.zzb((zzlx.zza)new UpdateImpl(id, apiClient){

            public void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza((zzlx.zzb<Achievements.UpdateAchievementResult>)this, id);
            }
        });
    }

    @Override
    public void unlock(GoogleApiClient apiClient, final String id) {
        apiClient.zzb((zzlx.zza)new UpdateImpl(id, apiClient){

            public void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzb(null, id);
            }
        });
    }

    @Override
    public PendingResult<Achievements.UpdateAchievementResult> unlockImmediate(GoogleApiClient apiClient, final String id) {
        return apiClient.zzb((zzlx.zza)new UpdateImpl(id, apiClient){

            public void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzb((zzlx.zzb<Achievements.UpdateAchievementResult>)this, id);
            }
        });
    }

    @Override
    public void increment(GoogleApiClient apiClient, final String id, final int numSteps) {
        apiClient.zzb((zzlx.zza)new UpdateImpl(id, apiClient){

            public void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza(null, id, numSteps);
            }
        });
    }

    @Override
    public PendingResult<Achievements.UpdateAchievementResult> incrementImmediate(GoogleApiClient apiClient, final String id, final int numSteps) {
        return apiClient.zzb((zzlx.zza)new UpdateImpl(id, apiClient){

            public void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza((zzlx.zzb<Achievements.UpdateAchievementResult>)this, id, numSteps);
            }
        });
    }

    @Override
    public void setSteps(GoogleApiClient apiClient, final String id, final int numSteps) {
        apiClient.zzb((zzlx.zza)new UpdateImpl(id, apiClient){

            public void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzb(null, id, numSteps);
            }
        });
    }

    @Override
    public PendingResult<Achievements.UpdateAchievementResult> setStepsImmediate(GoogleApiClient apiClient, final String id, final int numSteps) {
        return apiClient.zzb((zzlx.zza)new UpdateImpl(id, apiClient){

            public void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzb((zzlx.zzb<Achievements.UpdateAchievementResult>)this, id, numSteps);
            }
        });
    }

    private static abstract class UpdateImpl
    extends Games.BaseGamesApiMethodImpl<Achievements.UpdateAchievementResult> {
        private final String zzxX;

        public UpdateImpl(String id, GoogleApiClient googleApiClient) {
            super(googleApiClient);
            this.zzxX = id;
        }

        public Achievements.UpdateAchievementResult zzZ(final Status status) {
            return new Achievements.UpdateAchievementResult(){

                public Status getStatus() {
                    return status;
                }

                @Override
                public String getAchievementId() {
                    return UpdateImpl.this.zzxX;
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzZ(status);
        }
    }

    private static abstract class LoadImpl
    extends Games.BaseGamesApiMethodImpl<Achievements.LoadAchievementsResult> {
        private LoadImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Achievements.LoadAchievementsResult zzY(final Status status) {
            return new Achievements.LoadAchievementsResult(){

                public Status getStatus() {
                    return status;
                }

                public void release() {
                }

                @Override
                public AchievementBuffer getAchievements() {
                    return new AchievementBuffer(DataHolder.zzbJ((int)14));
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzY(status);
        }
    }
}

