/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.api;

import android.content.Intent;
import android.os.Bundle;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.games.snapshot.Snapshot;
import com.google.android.gms.games.snapshot.SnapshotContents;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataBuffer;
import com.google.android.gms.games.snapshot.SnapshotMetadataChange;
import com.google.android.gms.games.snapshot.Snapshots;
import com.google.android.gms.internal.zzlx;

public final class SnapshotsImpl
implements Snapshots {
    @Override
    public int getMaxDataSize(GoogleApiClient apiClient) {
        return Games.zzf(apiClient).zzwl();
    }

    @Override
    public int getMaxCoverImageSize(GoogleApiClient apiClient) {
        return Games.zzf(apiClient).zzwm();
    }

    @Override
    public Intent getSelectSnapshotIntent(GoogleApiClient apiClient, String title, boolean allowAddButton, boolean allowDelete, int maxSnapshots) {
        return Games.zzf(apiClient).zza(title, allowAddButton, allowDelete, maxSnapshots);
    }

    @Override
    public PendingResult<Snapshots.LoadSnapshotsResult> load(GoogleApiClient apiClient, final boolean forceReload) {
        return apiClient.zza((zzlx.zza)new LoadImpl(apiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzf((zzlx.zzb<Snapshots.LoadSnapshotsResult>)this, forceReload);
            }
        });
    }

    @Override
    public PendingResult<Snapshots.OpenSnapshotResult> open(GoogleApiClient apiClient, SnapshotMetadata metadata) {
        return this.open(apiClient, metadata.getUniqueName(), false);
    }

    @Override
    public PendingResult<Snapshots.OpenSnapshotResult> open(GoogleApiClient apiClient, SnapshotMetadata metadata, int conflictPolicy) {
        return this.open(apiClient, metadata.getUniqueName(), false, conflictPolicy);
    }

    @Override
    public PendingResult<Snapshots.OpenSnapshotResult> open(GoogleApiClient apiClient, String fileName, boolean createIfNotFound) {
        return this.open(apiClient, fileName, createIfNotFound, -1);
    }

    @Override
    public PendingResult<Snapshots.OpenSnapshotResult> open(GoogleApiClient apiClient, final String fileName, final boolean createIfNotFound, final int conflictPolicy) {
        return apiClient.zzb((zzlx.zza)new OpenImpl(apiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza((zzlx.zzb<Snapshots.OpenSnapshotResult>)this, fileName, createIfNotFound, conflictPolicy);
            }
        });
    }

    @Override
    public PendingResult<Snapshots.CommitSnapshotResult> commitAndClose(GoogleApiClient apiClient, final Snapshot snapshot, final SnapshotMetadataChange metadataChange) {
        return apiClient.zzb((zzlx.zza)new CommitImpl(apiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza((zzlx.zzb<Snapshots.CommitSnapshotResult>)this, snapshot, metadataChange);
            }
        });
    }

    @Override
    public void discardAndClose(GoogleApiClient apiClient, Snapshot snapshot) {
        Games.zzf(apiClient).zza(snapshot);
    }

    @Override
    public PendingResult<Snapshots.DeleteSnapshotResult> delete(GoogleApiClient apiClient, final SnapshotMetadata metadata) {
        return apiClient.zzb((zzlx.zza)new DeleteImpl(apiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzi((zzlx.zzb<Snapshots.DeleteSnapshotResult>)this, metadata.getSnapshotId());
            }
        });
    }

    @Override
    public PendingResult<Snapshots.OpenSnapshotResult> resolveConflict(GoogleApiClient apiClient, String conflictId, Snapshot snapshot) {
        SnapshotMetadata snapshotMetadata = snapshot.getMetadata();
        SnapshotMetadataChange snapshotMetadataChange = new SnapshotMetadataChange.Builder().fromMetadata(snapshotMetadata).build();
        return this.resolveConflict(apiClient, conflictId, snapshotMetadata.getSnapshotId(), snapshotMetadataChange, snapshot.getSnapshotContents());
    }

    @Override
    public PendingResult<Snapshots.OpenSnapshotResult> resolveConflict(GoogleApiClient apiClient, final String conflictId, final String snapshotId, final SnapshotMetadataChange metadataChange, final SnapshotContents snapshotContents) {
        return apiClient.zzb((zzlx.zza)new OpenImpl(apiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza((zzlx.zzb<Snapshots.OpenSnapshotResult>)this, conflictId, snapshotId, metadataChange, snapshotContents);
            }
        });
    }

    @Override
    public SnapshotMetadata getSnapshotFromBundle(Bundle extras) {
        if (extras == null || !extras.containsKey("com.google.android.gms.games.SNAPSHOT_METADATA")) {
            return null;
        }
        SnapshotMetadata snapshotMetadata = (SnapshotMetadata)extras.getParcelable("com.google.android.gms.games.SNAPSHOT_METADATA");
        return snapshotMetadata;
    }

    private static abstract class DeleteImpl
    extends Games.BaseGamesApiMethodImpl<Snapshots.DeleteSnapshotResult> {
        private DeleteImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Snapshots.DeleteSnapshotResult zzaD(final Status status) {
            return new Snapshots.DeleteSnapshotResult(){

                public Status getStatus() {
                    return status;
                }

                @Override
                public String getSnapshotId() {
                    return null;
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzaD(status);
        }
    }

    private static abstract class CommitImpl
    extends Games.BaseGamesApiMethodImpl<Snapshots.CommitSnapshotResult> {
        private CommitImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Snapshots.CommitSnapshotResult zzaC(final Status status) {
            return new Snapshots.CommitSnapshotResult(){

                public Status getStatus() {
                    return status;
                }

                @Override
                public SnapshotMetadata getSnapshotMetadata() {
                    return null;
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzaC(status);
        }
    }

    private static abstract class OpenImpl
    extends Games.BaseGamesApiMethodImpl<Snapshots.OpenSnapshotResult> {
        private OpenImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Snapshots.OpenSnapshotResult zzaF(final Status status) {
            return new Snapshots.OpenSnapshotResult(){

                public Status getStatus() {
                    return status;
                }

                @Override
                public Snapshot getSnapshot() {
                    return null;
                }

                @Override
                public String getConflictId() {
                    return null;
                }

                @Override
                public Snapshot getConflictingSnapshot() {
                    return null;
                }

                @Override
                public SnapshotContents getResolutionSnapshotContents() {
                    return null;
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzaF(status);
        }
    }

    private static abstract class LoadImpl
    extends Games.BaseGamesApiMethodImpl<Snapshots.LoadSnapshotsResult> {
        private LoadImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Snapshots.LoadSnapshotsResult zzaE(final Status status) {
            return new Snapshots.LoadSnapshotsResult(){

                public Status getStatus() {
                    return status;
                }

                public void release() {
                }

                @Override
                public SnapshotMetadataBuffer getSnapshots() {
                    return new SnapshotMetadataBuffer(DataHolder.zzbJ((int)14));
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzaE(status);
        }
    }
}

