/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.request;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzb;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.internal.request.GameRequestClusterCreator;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestEntity;
import java.util.ArrayList;
import java.util.List;

public final class GameRequestCluster
implements SafeParcelable,
GameRequest {
    public static final GameRequestClusterCreator CREATOR = new GameRequestClusterCreator();
    private final int mVersionCode;
    private final ArrayList<GameRequestEntity> zzaGm;

    GameRequestCluster(int versionCode, ArrayList<GameRequestEntity> requestList) {
        this.mVersionCode = versionCode;
        this.zzaGm = requestList;
        this.zzwK();
    }

    private void zzwK() {
        zzb.zzaa((!this.zzaGm.isEmpty() ? 1 : 0) != 0);
        GameRequest gameRequest = this.zzaGm.get(0);
        int n = this.zzaGm.size();
        for (int i = 1; i < n; ++i) {
            GameRequest gameRequest2 = this.zzaGm.get(i);
            zzb.zza((gameRequest.getType() == gameRequest2.getType() ? 1 : 0) != 0, (Object)"All the requests must be of the same type");
            zzb.zza((boolean)gameRequest.getSender().equals(gameRequest2.getSender()), (Object)"All the requests must be from the same sender");
        }
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public ArrayList<GameRequest> zzwY() {
        return new ArrayList<GameRequest>(this.zzaGm);
    }

    @Override
    public String getRequestId() {
        return this.zzaGm.get(0).getRequestId();
    }

    @Override
    public Game getGame() {
        throw new UnsupportedOperationException("Method not supported on a cluster");
    }

    @Override
    public Player getSender() {
        return this.zzaGm.get(0).getSender();
    }

    public ArrayList<Player> zzwZ() {
        throw new UnsupportedOperationException("Method not supported on a cluster");
    }

    @Override
    public boolean isConsumed(String playerId) {
        throw new UnsupportedOperationException("Method not supported on a cluster");
    }

    @Override
    public byte[] getData() {
        throw new UnsupportedOperationException("Method not supported on a cluster");
    }

    @Override
    public int getType() {
        return this.zzaGm.get(0).getType();
    }

    @Override
    public long getCreationTimestamp() {
        throw new UnsupportedOperationException("Method not supported on a cluster");
    }

    @Override
    public long getExpirationTimestamp() {
        throw new UnsupportedOperationException("Method not supported on a cluster");
    }

    @Override
    public int getRecipientStatus(String playerId) {
        throw new UnsupportedOperationException("Method not supported on a cluster");
    }

    @Override
    public int getStatus() {
        throw new UnsupportedOperationException("Method not supported on a cluster");
    }

    public GameRequest freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GameRequestCluster)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        GameRequestCluster gameRequestCluster = (GameRequestCluster)obj;
        if (gameRequestCluster.zzaGm.size() != this.zzaGm.size()) {
            return false;
        }
        int n = this.zzaGm.size();
        for (int i = 0; i < n; ++i) {
            GameRequest gameRequest;
            GameRequest gameRequest2 = this.zzaGm.get(i);
            if (gameRequest2.equals(gameRequest = (GameRequest)gameRequestCluster.zzaGm.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])this.zzaGm.toArray());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        GameRequestClusterCreator.zza(this, dest, flags);
    }

    public /* synthetic */ List getRecipients() {
        return this.zzwZ();
    }
}

