/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.internal.zznn;

public final class LeaderboardScoreEntity
implements LeaderboardScore {
    private final long zzaGu;
    private final String zzaGv;
    private final String zzaGw;
    private final long zzaGx;
    private final long zzaGy;
    private final String zzaGz;
    private final Uri zzaGA;
    private final Uri zzaGB;
    private final PlayerEntity zzaGC;
    private final String zzaGD;
    private final String zzaGE;
    private final String zzaGF;

    public LeaderboardScoreEntity(LeaderboardScore score) {
        this.zzaGu = score.getRank();
        this.zzaGv = (String)zzx.zzy((Object)score.getDisplayRank());
        this.zzaGw = (String)zzx.zzy((Object)score.getDisplayScore());
        this.zzaGx = score.getRawScore();
        this.zzaGy = score.getTimestampMillis();
        this.zzaGz = score.getScoreHolderDisplayName();
        this.zzaGA = score.getScoreHolderIconImageUri();
        this.zzaGB = score.getScoreHolderHiResImageUri();
        Player player = score.getScoreHolder();
        this.zzaGC = player == null ? null : (PlayerEntity)player.freeze();
        this.zzaGD = score.getScoreTag();
        this.zzaGE = score.getScoreHolderIconImageUrl();
        this.zzaGF = score.getScoreHolderHiResImageUrl();
    }

    @Override
    public long getRank() {
        return this.zzaGu;
    }

    @Override
    public String getDisplayRank() {
        return this.zzaGv;
    }

    @Override
    public void getDisplayRank(CharArrayBuffer dataOut) {
        zznn.zzb((String)this.zzaGv, (CharArrayBuffer)dataOut);
    }

    @Override
    public String getDisplayScore() {
        return this.zzaGw;
    }

    @Override
    public void getDisplayScore(CharArrayBuffer dataOut) {
        zznn.zzb((String)this.zzaGw, (CharArrayBuffer)dataOut);
    }

    @Override
    public long getRawScore() {
        return this.zzaGx;
    }

    @Override
    public long getTimestampMillis() {
        return this.zzaGy;
    }

    @Override
    public String getScoreHolderDisplayName() {
        if (this.zzaGC == null) {
            return this.zzaGz;
        }
        return this.zzaGC.getDisplayName();
    }

    @Override
    public void getScoreHolderDisplayName(CharArrayBuffer dataOut) {
        if (this.zzaGC == null) {
            zznn.zzb((String)this.zzaGz, (CharArrayBuffer)dataOut);
            return;
        }
        this.zzaGC.getDisplayName(dataOut);
    }

    @Override
    public Uri getScoreHolderIconImageUri() {
        if (this.zzaGC == null) {
            return this.zzaGA;
        }
        return this.zzaGC.getIconImageUri();
    }

    @Override
    public String getScoreHolderIconImageUrl() {
        if (this.zzaGC == null) {
            return this.zzaGE;
        }
        return this.zzaGC.getIconImageUrl();
    }

    @Override
    public Uri getScoreHolderHiResImageUri() {
        if (this.zzaGC == null) {
            return this.zzaGB;
        }
        return this.zzaGC.getHiResImageUri();
    }

    @Override
    public String getScoreHolderHiResImageUrl() {
        if (this.zzaGC == null) {
            return this.zzaGF;
        }
        return this.zzaGC.getHiResImageUrl();
    }

    @Override
    public Player getScoreHolder() {
        return this.zzaGC;
    }

    @Override
    public String getScoreTag() {
        return this.zzaGD;
    }

    public LeaderboardScore zzxd() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return LeaderboardScoreEntity.zza(this);
    }

    static int zza(LeaderboardScore leaderboardScore) {
        return zzw.hashCode((Object[])new Object[]{leaderboardScore.getRank(), leaderboardScore.getDisplayRank(), leaderboardScore.getRawScore(), leaderboardScore.getDisplayScore(), leaderboardScore.getTimestampMillis(), leaderboardScore.getScoreHolderDisplayName(), leaderboardScore.getScoreHolderIconImageUri(), leaderboardScore.getScoreHolderHiResImageUri(), leaderboardScore.getScoreHolder()});
    }

    public boolean equals(Object obj) {
        return LeaderboardScoreEntity.zza(this, obj);
    }

    static boolean zza(LeaderboardScore leaderboardScore, Object object) {
        if (!(object instanceof LeaderboardScore)) {
            return false;
        }
        if (leaderboardScore == object) {
            return true;
        }
        LeaderboardScore leaderboardScore2 = (LeaderboardScore)object;
        return zzw.equal((Object)leaderboardScore2.getRank(), (Object)leaderboardScore.getRank()) && zzw.equal((Object)leaderboardScore2.getDisplayRank(), (Object)leaderboardScore.getDisplayRank()) && zzw.equal((Object)leaderboardScore2.getRawScore(), (Object)leaderboardScore.getRawScore()) && zzw.equal((Object)leaderboardScore2.getDisplayScore(), (Object)leaderboardScore.getDisplayScore()) && zzw.equal((Object)leaderboardScore2.getTimestampMillis(), (Object)leaderboardScore.getTimestampMillis()) && zzw.equal((Object)leaderboardScore2.getScoreHolderDisplayName(), (Object)leaderboardScore.getScoreHolderDisplayName()) && zzw.equal((Object)leaderboardScore2.getScoreHolderIconImageUri(), (Object)leaderboardScore.getScoreHolderIconImageUri()) && zzw.equal((Object)leaderboardScore2.getScoreHolderHiResImageUri(), (Object)leaderboardScore.getScoreHolderHiResImageUri()) && zzw.equal((Object)leaderboardScore2.getScoreHolder(), (Object)leaderboardScore.getScoreHolder()) && zzw.equal((Object)leaderboardScore2.getScoreTag(), (Object)leaderboardScore.getScoreTag());
    }

    public String toString() {
        return LeaderboardScoreEntity.zzb(this);
    }

    static String zzb(LeaderboardScore leaderboardScore) {
        return zzw.zzx((Object)leaderboardScore).zzg("Rank", (Object)leaderboardScore.getRank()).zzg("DisplayRank", (Object)leaderboardScore.getDisplayRank()).zzg("Score", (Object)leaderboardScore.getRawScore()).zzg("DisplayScore", (Object)leaderboardScore.getDisplayScore()).zzg("Timestamp", (Object)leaderboardScore.getTimestampMillis()).zzg("DisplayName", (Object)leaderboardScore.getScoreHolderDisplayName()).zzg("IconImageUri", (Object)leaderboardScore.getScoreHolderIconImageUri()).zzg("IconImageUrl", (Object)leaderboardScore.getScoreHolderIconImageUrl()).zzg("HiResImageUri", (Object)leaderboardScore.getScoreHolderHiResImageUri()).zzg("HiResImageUrl", (Object)leaderboardScore.getScoreHolderHiResImageUrl()).zzg("Player", (Object)(leaderboardScore.getScoreHolder() == null ? null : leaderboardScore.getScoreHolder())).zzg("ScoreTag", (Object)leaderboardScore.getScoreTag()).toString();
    }

    public /* synthetic */ Object freeze() {
        return this.zzxd();
    }
}

