/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.games.internal.constants.TimeSpan;
import java.util.HashMap;

public final class ScoreSubmissionData {
    private static final String[] zzaGn = new String[]{"leaderboardId", "playerId", "timeSpan", "hasResult", "rawScore", "formattedScore", "newBest", "scoreTag"};
    private String zzaGp;
    private String zzabq;
    private int zzabx;
    private HashMap<Integer, Result> zzaGT;

    public ScoreSubmissionData(DataHolder dataHolder) {
        this.zzabx = dataHolder.getStatusCode();
        this.zzaGT = new HashMap();
        int n = dataHolder.getCount();
        zzx.zzab((n == 3 ? 1 : 0) != 0);
        for (int i = 0; i < n; ++i) {
            boolean bl;
            int n2 = dataHolder.zzbI(i);
            if (i == 0) {
                this.zzaGp = dataHolder.zzd("leaderboardId", i, n2);
                this.zzabq = dataHolder.zzd("playerId", i, n2);
            }
            if (!(bl = dataHolder.zze("hasResult", i, n2))) continue;
            Result result = new Result(dataHolder.zzb("rawScore", i, n2), dataHolder.zzd("formattedScore", i, n2), dataHolder.zzd("scoreTag", i, n2), dataHolder.zze("newBest", i, n2));
            this.zza(result, dataHolder.zzc("timeSpan", i, n2));
        }
    }

    public String getLeaderboardId() {
        return this.zzaGp;
    }

    public String getPlayerId() {
        return this.zzabq;
    }

    public Result getScoreResult(int timeSpan) {
        return this.zzaGT.get(timeSpan);
    }

    private void zza(Result result, int n) {
        this.zzaGT.put(n, result);
    }

    public String toString() {
        zzw.zza zza2 = zzw.zzx((Object)this).zzg("PlayerId", (Object)this.zzabq).zzg("StatusCode", (Object)this.zzabx);
        for (int i = 0; i < 3; ++i) {
            Result result = this.zzaGT.get(i);
            zza2.zzg("TimesSpan", (Object)TimeSpan.zzgo(i));
            zza2.zzg("Result", (Object)(result == null ? "null" : result.toString()));
        }
        return zza2.toString();
    }

    public static final class Result {
        public final long rawScore;
        public final String formattedScore;
        public final String scoreTag;
        public final boolean newBest;

        public Result(long rawScore, String formattedScore, String scoreTag, boolean newBest) {
            this.rawScore = rawScore;
            this.formattedScore = formattedScore;
            this.scoreTag = scoreTag;
            this.newBest = newBest;
        }

        public String toString() {
            return zzw.zzx((Object)this).zzg("RawScore", (Object)this.rawScore).zzg("FormattedScore", (Object)this.formattedScore).zzg("ScoreTag", (Object)this.scoreTag).zzg("NewBest", (Object)this.newBest).toString();
        }
    }
}

