/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationEntityCreator;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import java.util.ArrayList;

public final class InvitationEntity
extends GamesDowngradeableSafeParcel
implements Invitation {
    public static final Parcelable.Creator<InvitationEntity> CREATOR = new InvitationEntityCreatorCompat();
    private final int mVersionCode;
    private final GameEntity zzaGU;
    private final String zzTr;
    private final long zzaGV;
    private final int zzaGW;
    private final ParticipantEntity zzaGX;
    private final ArrayList<ParticipantEntity> zzaGY;
    private final int zzaGZ;
    private final int zzaHa;

    InvitationEntity(Invitation invitation) {
        this.mVersionCode = 2;
        this.zzaGU = new GameEntity(invitation.getGame());
        this.zzTr = invitation.getInvitationId();
        this.zzaGV = invitation.getCreationTimestamp();
        this.zzaGW = invitation.getInvitationType();
        this.zzaGZ = invitation.getVariant();
        this.zzaHa = invitation.getAvailableAutoMatchSlots();
        String string = invitation.getInviter().getParticipantId();
        Participant participant = null;
        ArrayList arrayList = invitation.getParticipants();
        int n = arrayList.size();
        this.zzaGY = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            Participant participant2 = (Participant)arrayList.get(i);
            if (participant2.getParticipantId().equals(string)) {
                participant = participant2;
            }
            this.zzaGY.add((ParticipantEntity)participant2.freeze());
        }
        zzx.zzb(participant, (Object)"Must have a valid inviter!");
        this.zzaGX = (ParticipantEntity)participant.freeze();
    }

    InvitationEntity(int versionCode, GameEntity game, String invitationId, long creationTimestamp, int invitationType, ParticipantEntity inviter, ArrayList<ParticipantEntity> participants, int variant, int availableAutoMatchSlots) {
        this.mVersionCode = versionCode;
        this.zzaGU = game;
        this.zzTr = invitationId;
        this.zzaGV = creationTimestamp;
        this.zzaGW = invitationType;
        this.zzaGX = inviter;
        this.zzaGY = participants;
        this.zzaGZ = variant;
        this.zzaHa = availableAutoMatchSlots;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public Game getGame() {
        return this.zzaGU;
    }

    @Override
    public String getInvitationId() {
        return this.zzTr;
    }

    @Override
    public Participant getInviter() {
        return this.zzaGX;
    }

    @Override
    public long getCreationTimestamp() {
        return this.zzaGV;
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.zzaGY);
    }

    @Override
    public int getInvitationType() {
        return this.zzaGW;
    }

    @Override
    public int getVariant() {
        return this.zzaGZ;
    }

    @Override
    public int getAvailableAutoMatchSlots() {
        return this.zzaHa;
    }

    public Invitation freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return InvitationEntity.zza(this);
    }

    static int zza(Invitation invitation) {
        return zzw.hashCode((Object[])new Object[]{invitation.getGame(), invitation.getInvitationId(), invitation.getCreationTimestamp(), invitation.getInvitationType(), invitation.getInviter(), invitation.getParticipants(), invitation.getVariant(), invitation.getAvailableAutoMatchSlots()});
    }

    public boolean equals(Object obj) {
        return InvitationEntity.zza(this, obj);
    }

    static boolean zza(Invitation invitation, Object object) {
        if (!(object instanceof Invitation)) {
            return false;
        }
        if (invitation == object) {
            return true;
        }
        Invitation invitation2 = (Invitation)object;
        return zzw.equal((Object)invitation2.getGame(), (Object)invitation.getGame()) && zzw.equal((Object)invitation2.getInvitationId(), (Object)invitation.getInvitationId()) && zzw.equal((Object)invitation2.getCreationTimestamp(), (Object)invitation.getCreationTimestamp()) && zzw.equal((Object)invitation2.getInvitationType(), (Object)invitation.getInvitationType()) && zzw.equal((Object)invitation2.getInviter(), (Object)invitation.getInviter()) && zzw.equal((Object)invitation2.getParticipants(), (Object)invitation.getParticipants()) && zzw.equal((Object)invitation2.getVariant(), (Object)invitation.getVariant()) && zzw.equal((Object)invitation2.getAvailableAutoMatchSlots(), (Object)invitation.getAvailableAutoMatchSlots());
    }

    public String toString() {
        return InvitationEntity.zzb(this);
    }

    static String zzb(Invitation invitation) {
        return zzw.zzx((Object)invitation).zzg("Game", (Object)invitation.getGame()).zzg("InvitationId", (Object)invitation.getInvitationId()).zzg("CreationTimestamp", (Object)invitation.getCreationTimestamp()).zzg("InvitationType", (Object)invitation.getInvitationType()).zzg("Inviter", (Object)invitation.getInviter()).zzg("Participants", (Object)invitation.getParticipants()).zzg("Variant", (Object)invitation.getVariant()).zzg("AvailableAutoMatchSlots", (Object)invitation.getAvailableAutoMatchSlots()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.zzqk()) {
            InvitationEntityCreator.zza(this, dest, flags);
        } else {
            this.zzaGU.writeToParcel(dest, flags);
            dest.writeString(this.zzTr);
            dest.writeLong(this.zzaGV);
            dest.writeInt(this.zzaGW);
            this.zzaGX.writeToParcel(dest, flags);
            int n = this.zzaGY.size();
            dest.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.zzaGY.get(i).writeToParcel(dest, flags);
            }
        }
    }

    static final class InvitationEntityCreatorCompat
    extends InvitationEntityCreator {
        InvitationEntityCreatorCompat() {
        }

        @Override
        public InvitationEntity zzej(Parcel parcel) {
            int n;
            boolean bl = InvitationEntity.zzd(InvitationEntity.zzqj());
            if (bl || InvitationEntity.zzcz((String)InvitationEntity.class.getCanonicalName())) {
                return super.zzej(parcel);
            }
            GameEntity gameEntity = (GameEntity)GameEntity.CREATOR.createFromParcel(parcel);
            String string = parcel.readString();
            long l = parcel.readLong();
            int n2 = parcel.readInt();
            ParticipantEntity participantEntity = (ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel);
            int n3 = parcel.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n3);
            for (n = 0; n < n3; ++n) {
                arrayList.add((ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            n = -1;
            int n4 = 0;
            return new InvitationEntity(2, gameEntity, string, l, n2, participantEntity, arrayList, n, n4);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.zzej(x0);
        }
    }
}

