/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomEntityCreator;
import com.google.android.gms.internal.zznn;
import java.util.ArrayList;

public final class RoomEntity
extends GamesDowngradeableSafeParcel
implements Room {
    public static final Parcelable.Creator<RoomEntity> CREATOR = new RoomEntityCreatorCompat();
    private final int mVersionCode;
    private final String zzaBR;
    private final String zzaHr;
    private final long zzaGV;
    private final int zzaHs;
    private final String zzavc;
    private final int zzaGZ;
    private final Bundle zzaHp;
    private final ArrayList<ParticipantEntity> zzaGY;
    private final int zzaHt;

    public RoomEntity(Room room) {
        this.mVersionCode = 2;
        this.zzaBR = room.getRoomId();
        this.zzaHr = room.getCreatorId();
        this.zzaGV = room.getCreationTimestamp();
        this.zzaHs = room.getStatus();
        this.zzavc = room.getDescription();
        this.zzaGZ = room.getVariant();
        this.zzaHp = room.getAutoMatchCriteria();
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        this.zzaGY = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzaGY.add((ParticipantEntity)((Participant)arrayList.get(i)).freeze());
        }
        this.zzaHt = room.getAutoMatchWaitEstimateSeconds();
    }

    RoomEntity(int versionCode, String roomId, String creatorId, long creationTimestamp, int roomStatus, String description, int variant, Bundle autoMatchCriteria, ArrayList<ParticipantEntity> participants, int autoMatchWaitEstimateSeconds) {
        this.mVersionCode = versionCode;
        this.zzaBR = roomId;
        this.zzaHr = creatorId;
        this.zzaGV = creationTimestamp;
        this.zzaHs = roomStatus;
        this.zzavc = description;
        this.zzaGZ = variant;
        this.zzaHp = autoMatchCriteria;
        this.zzaGY = participants;
        this.zzaHt = autoMatchWaitEstimateSeconds;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getRoomId() {
        return this.zzaBR;
    }

    @Override
    public String getCreatorId() {
        return this.zzaHr;
    }

    @Override
    public long getCreationTimestamp() {
        return this.zzaGV;
    }

    @Override
    public int getStatus() {
        return this.zzaHs;
    }

    @Override
    public String getDescription() {
        return this.zzavc;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zznn.zzb((String)this.zzavc, (CharArrayBuffer)dataOut);
    }

    @Override
    public int getVariant() {
        return this.zzaGZ;
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        return this.zzaHp;
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.zzaGY);
    }

    @Override
    public int getAutoMatchWaitEstimateSeconds() {
        return this.zzaHt;
    }

    @Override
    public int getParticipantStatus(String participantId) {
        return RoomEntity.zza((Room)this, participantId);
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        return RoomEntity.zzc(this);
    }

    @Override
    public String getParticipantId(String playerId) {
        return RoomEntity.zzb(this, playerId);
    }

    @Override
    public Participant getParticipant(String participantId) {
        return RoomEntity.zzc(this, participantId);
    }

    public Room freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return RoomEntity.zza(this);
    }

    static int zza(Room room) {
        return zzw.hashCode((Object[])new Object[]{room.getRoomId(), room.getCreatorId(), room.getCreationTimestamp(), room.getStatus(), room.getDescription(), room.getVariant(), room.getAutoMatchCriteria(), room.getParticipants(), room.getAutoMatchWaitEstimateSeconds()});
    }

    public boolean equals(Object obj) {
        return RoomEntity.zza((Room)this, obj);
    }

    static boolean zza(Room room, Object object) {
        if (!(object instanceof Room)) {
            return false;
        }
        if (room == object) {
            return true;
        }
        Room room2 = (Room)object;
        return zzw.equal((Object)room2.getRoomId(), (Object)room.getRoomId()) && zzw.equal((Object)room2.getCreatorId(), (Object)room.getCreatorId()) && zzw.equal((Object)room2.getCreationTimestamp(), (Object)room.getCreationTimestamp()) && zzw.equal((Object)room2.getStatus(), (Object)room.getStatus()) && zzw.equal((Object)room2.getDescription(), (Object)room.getDescription()) && zzw.equal((Object)room2.getVariant(), (Object)room.getVariant()) && zzw.equal((Object)room2.getAutoMatchCriteria(), (Object)room.getAutoMatchCriteria()) && zzw.equal((Object)room2.getParticipants(), (Object)room.getParticipants()) && zzw.equal((Object)room2.getAutoMatchWaitEstimateSeconds(), (Object)room.getAutoMatchWaitEstimateSeconds());
    }

    public String toString() {
        return RoomEntity.zzb(this);
    }

    static String zzb(Room room) {
        return zzw.zzx((Object)room).zzg("RoomId", (Object)room.getRoomId()).zzg("CreatorId", (Object)room.getCreatorId()).zzg("CreationTimestamp", (Object)room.getCreationTimestamp()).zzg("RoomStatus", (Object)room.getStatus()).zzg("Description", (Object)room.getDescription()).zzg("Variant", (Object)room.getVariant()).zzg("AutoMatchCriteria", (Object)room.getAutoMatchCriteria()).zzg("Participants", (Object)room.getParticipants()).zzg("AutoMatchWaitEstimateSeconds", (Object)room.getAutoMatchWaitEstimateSeconds()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.zzqk()) {
            RoomEntityCreator.zza(this, dest, flags);
        } else {
            dest.writeString(this.zzaBR);
            dest.writeString(this.zzaHr);
            dest.writeLong(this.zzaGV);
            dest.writeInt(this.zzaHs);
            dest.writeString(this.zzavc);
            dest.writeInt(this.zzaGZ);
            dest.writeBundle(this.zzaHp);
            int n = this.zzaGY.size();
            dest.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.zzaGY.get(i).writeToParcel(dest, flags);
            }
        }
    }

    static int zza(Room room, String string) {
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant.getStatus();
        }
        throw new IllegalStateException("Participant " + string + " is not in room " + room.getRoomId());
    }

    static ArrayList<String> zzc(Room room) {
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            arrayList2.add(participant.getParticipantId());
        }
        return arrayList2;
    }

    static String zzb(Room room, String string) {
        String string2 = null;
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(string)) continue;
            string2 = participant.getParticipantId();
            break;
        }
        return string2;
    }

    static Participant zzc(Room room, String string) {
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant;
        }
        throw new IllegalStateException("Participant " + string + " is not in match " + room.getRoomId());
    }

    static final class RoomEntityCreatorCompat
    extends RoomEntityCreator {
        RoomEntityCreatorCompat() {
        }

        @Override
        public RoomEntity zzen(Parcel parcel) {
            int n;
            boolean bl = RoomEntity.zzd(RoomEntity.zzqj());
            if (bl || RoomEntity.zzcz((String)RoomEntity.class.getCanonicalName())) {
                return super.zzen(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            long l = parcel.readLong();
            int n2 = parcel.readInt();
            String string3 = parcel.readString();
            int n3 = parcel.readInt();
            Bundle bundle = parcel.readBundle();
            int n4 = parcel.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n4);
            for (n = 0; n < n4; ++n) {
                arrayList.add((ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            n = -1;
            return new RoomEntity(2, string, string2, l, n2, string3, n3, bundle, arrayList, n);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.zzen(x0);
        }
    }
}

