/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.os.Bundle;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.internal.constants.TurnBasedMatchTurnStatus;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;

public final class LoadMatchesResponse {
    private final InvitationBuffer zzaHu;
    private final TurnBasedMatchBuffer zzaHv;
    private final TurnBasedMatchBuffer zzaHw;
    private final TurnBasedMatchBuffer zzaHx;

    public LoadMatchesResponse(Bundle matchData) {
        DataHolder dataHolder = LoadMatchesResponse.zza(matchData, 0);
        this.zzaHu = dataHolder != null ? new InvitationBuffer(dataHolder) : null;
        DataHolder dataHolder2 = LoadMatchesResponse.zza(matchData, 1);
        this.zzaHv = dataHolder2 != null ? new TurnBasedMatchBuffer(dataHolder2) : null;
        DataHolder dataHolder3 = LoadMatchesResponse.zza(matchData, 2);
        this.zzaHw = dataHolder3 != null ? new TurnBasedMatchBuffer(dataHolder3) : null;
        DataHolder dataHolder4 = LoadMatchesResponse.zza(matchData, 3);
        this.zzaHx = dataHolder4 != null ? new TurnBasedMatchBuffer(dataHolder4) : null;
    }

    private static DataHolder zza(Bundle bundle, int n) {
        String string = TurnBasedMatchTurnStatus.zzgo(n);
        if (!bundle.containsKey(string)) {
            return null;
        }
        return (DataHolder)bundle.getParcelable(string);
    }

    public InvitationBuffer getInvitations() {
        return this.zzaHu;
    }

    public TurnBasedMatchBuffer getMyTurnMatches() {
        return this.zzaHv;
    }

    public TurnBasedMatchBuffer getTheirTurnMatches() {
        return this.zzaHw;
    }

    public TurnBasedMatchBuffer getCompletedMatches() {
        return this.zzaHx;
    }

    @Deprecated
    public void close() {
        this.release();
    }

    public void release() {
        if (this.zzaHu != null) {
            this.zzaHu.release();
        }
        if (this.zzaHv != null) {
            this.zzaHv.release();
        }
        if (this.zzaHw != null) {
            this.zzaHw.release();
        }
        if (this.zzaHx != null) {
            this.zzaHx.release();
        }
    }

    public boolean hasData() {
        if (this.zzaHu != null && this.zzaHu.getCount() > 0) {
            return true;
        }
        if (this.zzaHv != null && this.zzaHv.getCount() > 0) {
            return true;
        }
        if (this.zzaHw != null && this.zzaHw.getCount() > 0) {
            return true;
        }
        return this.zzaHx != null && this.zzaHx.getCount() > 0;
    }
}

