/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.request;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestEntityCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class GameRequestEntity
implements SafeParcelable,
GameRequest {
    public static final Parcelable.Creator<GameRequestEntity> CREATOR = new GameRequestEntityCreator();
    private final int mVersionCode;
    private final GameEntity zzaGU;
    private final PlayerEntity zzaHW;
    private final byte[] zzaHC;
    private final String zzDX;
    private final ArrayList<PlayerEntity> zzaHX;
    private final int zzZU;
    private final long zzaGV;
    private final long zzaHY;
    private final Bundle zzaHZ;
    private final int zzAk;

    public GameRequestEntity(GameRequest request) {
        this.mVersionCode = 2;
        this.zzaGU = new GameEntity(request.getGame());
        this.zzaHW = new PlayerEntity(request.getSender());
        this.zzDX = request.getRequestId();
        this.zzZU = request.getType();
        this.zzaGV = request.getCreationTimestamp();
        this.zzaHY = request.getExpirationTimestamp();
        this.zzAk = request.getStatus();
        byte[] byArray = request.getData();
        if (byArray == null) {
            this.zzaHC = null;
        } else {
            this.zzaHC = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.zzaHC, 0, byArray.length);
        }
        List<Player> list = request.getRecipients();
        int n = list.size();
        this.zzaHX = new ArrayList(n);
        this.zzaHZ = new Bundle();
        for (int i = 0; i < n; ++i) {
            Player player = (Player)list.get(i).freeze();
            String string = player.getPlayerId();
            this.zzaHX.add((PlayerEntity)player);
            this.zzaHZ.putInt(string, request.getRecipientStatus(string));
        }
    }

    GameRequestEntity(int versionCode, GameEntity game, PlayerEntity sender, byte[] data, String requestId, ArrayList<PlayerEntity> recipients, int type, long creationTimestamp, long expirationTimestamp, Bundle recipientStatuses, int status) {
        this.mVersionCode = versionCode;
        this.zzaGU = game;
        this.zzaHW = sender;
        this.zzaHC = data;
        this.zzDX = requestId;
        this.zzaHX = recipients;
        this.zzZU = type;
        this.zzaGV = creationTimestamp;
        this.zzaHY = expirationTimestamp;
        this.zzaHZ = recipientStatuses;
        this.zzAk = status;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getRequestId() {
        return this.zzDX;
    }

    @Override
    public Game getGame() {
        return this.zzaGU;
    }

    @Override
    public Player getSender() {
        return this.zzaHW;
    }

    @Override
    public List<Player> getRecipients() {
        return new ArrayList<Player>(this.zzaHX);
    }

    @Override
    public boolean isConsumed(String playerId) {
        return this.getRecipientStatus(playerId) == 1;
    }

    @Override
    public byte[] getData() {
        return this.zzaHC;
    }

    @Override
    public int getType() {
        return this.zzZU;
    }

    @Override
    public long getCreationTimestamp() {
        return this.zzaGV;
    }

    @Override
    public long getExpirationTimestamp() {
        return this.zzaHY;
    }

    @Override
    public int getRecipientStatus(String playerId) {
        return this.zzaHZ.getInt(playerId, 0);
    }

    @Override
    public int getStatus() {
        return this.zzAk;
    }

    public Bundle zzxm() {
        return this.zzaHZ;
    }

    public GameRequest freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameRequestEntity.zza(this);
    }

    static int zza(GameRequest gameRequest) {
        return zzw.hashCode((Object[])new Object[]{gameRequest.getGame(), gameRequest.getRecipients(), gameRequest.getRequestId(), gameRequest.getSender(), GameRequestEntity.zzb(gameRequest), gameRequest.getType(), gameRequest.getCreationTimestamp(), gameRequest.getExpirationTimestamp()});
    }

    public boolean equals(Object obj) {
        return GameRequestEntity.zza(this, obj);
    }

    static boolean zza(GameRequest gameRequest, Object object) {
        if (!(object instanceof GameRequest)) {
            return false;
        }
        if (gameRequest == object) {
            return true;
        }
        GameRequest gameRequest2 = (GameRequest)object;
        return zzw.equal((Object)gameRequest2.getGame(), (Object)gameRequest.getGame()) && zzw.equal(gameRequest2.getRecipients(), gameRequest.getRecipients()) && zzw.equal((Object)gameRequest2.getRequestId(), (Object)gameRequest.getRequestId()) && zzw.equal((Object)gameRequest2.getSender(), (Object)gameRequest.getSender()) && Arrays.equals(GameRequestEntity.zzb(gameRequest2), GameRequestEntity.zzb(gameRequest)) && zzw.equal((Object)gameRequest2.getType(), (Object)gameRequest.getType()) && zzw.equal((Object)gameRequest2.getCreationTimestamp(), (Object)gameRequest.getCreationTimestamp()) && zzw.equal((Object)gameRequest2.getExpirationTimestamp(), (Object)gameRequest.getExpirationTimestamp());
    }

    private static int[] zzb(GameRequest gameRequest) {
        List<Player> list = gameRequest.getRecipients();
        int n = list.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = gameRequest.getRecipientStatus(list.get(i).getPlayerId());
        }
        return nArray;
    }

    public String toString() {
        return GameRequestEntity.zzc(this);
    }

    static String zzc(GameRequest gameRequest) {
        return zzw.zzx((Object)gameRequest).zzg("Game", (Object)gameRequest.getGame()).zzg("Sender", (Object)gameRequest.getSender()).zzg("Recipients", gameRequest.getRecipients()).zzg("Data", (Object)gameRequest.getData()).zzg("RequestId", (Object)gameRequest.getRequestId()).zzg("Type", (Object)gameRequest.getType()).zzg("CreationTimestamp", (Object)gameRequest.getCreationTimestamp()).zzg("ExpirationTimestamp", (Object)gameRequest.getExpirationTimestamp()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        GameRequestEntityCreator.zza(this, dest, flags);
    }
}

