/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.request;

import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameRef;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerRef;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestEntity;
import java.util.ArrayList;
import java.util.List;

public final class GameRequestRef
extends zzc
implements GameRequest {
    private final int zzaBl;

    public GameRequestRef(DataHolder holder, int dataRow, int numChildren) {
        super(holder, dataRow);
        this.zzaBl = numChildren;
    }

    @Override
    public String getRequestId() {
        return this.getString("external_request_id");
    }

    @Override
    public Game getGame() {
        return new GameRef(this.zzafC, this.zzahw);
    }

    @Override
    public Player getSender() {
        return new PlayerRef(this.zzafC, this.zzpK(), "sender_");
    }

    @Override
    public List<Player> getRecipients() {
        ArrayList<Player> arrayList = new ArrayList<Player>(this.zzaBl);
        for (int i = 0; i < this.zzaBl; ++i) {
            arrayList.add(new PlayerRef(this.zzafC, this.zzahw + i, "recipient_"));
        }
        return arrayList;
    }

    @Override
    public boolean isConsumed(String playerId) {
        return this.getRecipientStatus(playerId) == 1;
    }

    @Override
    public byte[] getData() {
        return this.getByteArray("data");
    }

    @Override
    public int getType() {
        return this.getInteger("type");
    }

    @Override
    public long getCreationTimestamp() {
        return this.getLong("creation_timestamp");
    }

    @Override
    public long getExpirationTimestamp() {
        return this.getLong("expiration_timestamp");
    }

    @Override
    public int getRecipientStatus(String playerId) {
        for (int i = this.zzahw; i < this.zzahw + this.zzaBl; ++i) {
            int n = this.zzafC.zzbI(i);
            String string = this.zzafC.zzd("recipient_external_player_id", i, n);
            if (!string.equals(playerId)) continue;
            return this.zzafC.zzc("recipient_status", i, n);
        }
        return -1;
    }

    @Override
    public int getStatus() {
        return this.getInteger("status");
    }

    public GameRequest freeze() {
        return new GameRequestEntity(this);
    }

    public int hashCode() {
        return GameRequestEntity.zza(this);
    }

    public boolean equals(Object obj) {
        return GameRequestEntity.zza(this, obj);
    }

    public String toString() {
        return GameRequestEntity.zzc(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        GameRequestEntity gameRequestEntity = (GameRequestEntity)this.freeze();
        gameRequestEntity.writeToParcel(dest, flags);
    }
}

