/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntityCreator;
import com.google.android.gms.internal.zznn;

public final class SnapshotMetadataEntity
implements SafeParcelable,
SnapshotMetadata {
    public static final Parcelable.Creator<SnapshotMetadataEntity> CREATOR = new SnapshotMetadataEntityCreator();
    private final int mVersionCode;
    private final GameEntity zzaGU;
    private final PlayerEntity zzaIj;
    private final String zzaBL;
    private final Uri zzaIg;
    private final String zzaIk;
    private final String zzank;
    private final String zzavc;
    private final long zzaIl;
    private final long zzaIm;
    private final float zzaIn;
    private final String zzaIo;
    private final boolean zzaIp;
    private final long zzaIq;
    private final String zzaIr;

    public SnapshotMetadataEntity(SnapshotMetadata snapshotMetadata) {
        this.mVersionCode = 6;
        this.zzaGU = new GameEntity(snapshotMetadata.getGame());
        this.zzaIj = new PlayerEntity(snapshotMetadata.getOwner());
        this.zzaBL = snapshotMetadata.getSnapshotId();
        this.zzaIg = snapshotMetadata.getCoverImageUri();
        this.zzaIk = snapshotMetadata.getCoverImageUrl();
        this.zzaIn = snapshotMetadata.getCoverImageAspectRatio();
        this.zzank = snapshotMetadata.getTitle();
        this.zzavc = snapshotMetadata.getDescription();
        this.zzaIl = snapshotMetadata.getLastModifiedTimestamp();
        this.zzaIm = snapshotMetadata.getPlayedTime();
        this.zzaIo = snapshotMetadata.getUniqueName();
        this.zzaIp = snapshotMetadata.hasChangePending();
        this.zzaIq = snapshotMetadata.getProgressValue();
        this.zzaIr = snapshotMetadata.getDeviceName();
    }

    SnapshotMetadataEntity(int versionCode, GameEntity game, PlayerEntity owner, String snapshotId, Uri coverImageUri, String coverImageUrl, String title, String description, long lastModifiedTimestamp, long playedTime, float coverImageAspectRatio, String uniqueName, boolean changePending, long progressValue, String deviceName) {
        this.mVersionCode = versionCode;
        this.zzaGU = game;
        this.zzaIj = owner;
        this.zzaBL = snapshotId;
        this.zzaIg = coverImageUri;
        this.zzaIk = coverImageUrl;
        this.zzaIn = coverImageAspectRatio;
        this.zzank = title;
        this.zzavc = description;
        this.zzaIl = lastModifiedTimestamp;
        this.zzaIm = playedTime;
        this.zzaIo = uniqueName;
        this.zzaIp = changePending;
        this.zzaIq = progressValue;
        this.zzaIr = deviceName;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public Game getGame() {
        return this.zzaGU;
    }

    @Override
    public Player getOwner() {
        return this.zzaIj;
    }

    @Override
    public String getSnapshotId() {
        return this.zzaBL;
    }

    @Override
    public Uri getCoverImageUri() {
        return this.zzaIg;
    }

    @Override
    public String getCoverImageUrl() {
        return this.zzaIk;
    }

    @Override
    public float getCoverImageAspectRatio() {
        return this.zzaIn;
    }

    @Override
    public String getUniqueName() {
        return this.zzaIo;
    }

    @Override
    public String getTitle() {
        return this.zzank;
    }

    @Override
    public String getDescription() {
        return this.zzavc;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zznn.zzb((String)this.zzavc, (CharArrayBuffer)dataOut);
    }

    @Override
    public long getLastModifiedTimestamp() {
        return this.zzaIl;
    }

    @Override
    public long getPlayedTime() {
        return this.zzaIm;
    }

    @Override
    public boolean hasChangePending() {
        return this.zzaIp;
    }

    @Override
    public long getProgressValue() {
        return this.zzaIq;
    }

    @Override
    public String getDeviceName() {
        return this.zzaIr;
    }

    public SnapshotMetadata freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return SnapshotMetadataEntity.zza(this);
    }

    static int zza(SnapshotMetadata snapshotMetadata) {
        return zzw.hashCode((Object[])new Object[]{snapshotMetadata.getGame(), snapshotMetadata.getOwner(), snapshotMetadata.getSnapshotId(), snapshotMetadata.getCoverImageUri(), Float.valueOf(snapshotMetadata.getCoverImageAspectRatio()), snapshotMetadata.getTitle(), snapshotMetadata.getDescription(), snapshotMetadata.getLastModifiedTimestamp(), snapshotMetadata.getPlayedTime(), snapshotMetadata.getUniqueName(), snapshotMetadata.hasChangePending(), snapshotMetadata.getProgressValue(), snapshotMetadata.getDeviceName()});
    }

    public boolean equals(Object obj) {
        return SnapshotMetadataEntity.zza(this, obj);
    }

    static boolean zza(SnapshotMetadata snapshotMetadata, Object object) {
        if (!(object instanceof SnapshotMetadata)) {
            return false;
        }
        if (snapshotMetadata == object) {
            return true;
        }
        SnapshotMetadata snapshotMetadata2 = (SnapshotMetadata)object;
        return zzw.equal((Object)snapshotMetadata2.getGame(), (Object)snapshotMetadata.getGame()) && zzw.equal((Object)snapshotMetadata2.getOwner(), (Object)snapshotMetadata.getOwner()) && zzw.equal((Object)snapshotMetadata2.getSnapshotId(), (Object)snapshotMetadata.getSnapshotId()) && zzw.equal((Object)snapshotMetadata2.getCoverImageUri(), (Object)snapshotMetadata.getCoverImageUri()) && zzw.equal((Object)Float.valueOf(snapshotMetadata2.getCoverImageAspectRatio()), (Object)Float.valueOf(snapshotMetadata.getCoverImageAspectRatio())) && zzw.equal((Object)snapshotMetadata2.getTitle(), (Object)snapshotMetadata.getTitle()) && zzw.equal((Object)snapshotMetadata2.getDescription(), (Object)snapshotMetadata.getDescription()) && zzw.equal((Object)snapshotMetadata2.getLastModifiedTimestamp(), (Object)snapshotMetadata.getLastModifiedTimestamp()) && zzw.equal((Object)snapshotMetadata2.getPlayedTime(), (Object)snapshotMetadata.getPlayedTime()) && zzw.equal((Object)snapshotMetadata2.getUniqueName(), (Object)snapshotMetadata.getUniqueName()) && zzw.equal((Object)snapshotMetadata2.hasChangePending(), (Object)snapshotMetadata.hasChangePending()) && zzw.equal((Object)snapshotMetadata2.getProgressValue(), (Object)snapshotMetadata.getProgressValue()) && zzw.equal((Object)snapshotMetadata2.getDeviceName(), (Object)snapshotMetadata.getDeviceName());
    }

    public String toString() {
        return SnapshotMetadataEntity.zzb(this);
    }

    static String zzb(SnapshotMetadata snapshotMetadata) {
        return zzw.zzx((Object)snapshotMetadata).zzg("Game", (Object)snapshotMetadata.getGame()).zzg("Owner", (Object)snapshotMetadata.getOwner()).zzg("SnapshotId", (Object)snapshotMetadata.getSnapshotId()).zzg("CoverImageUri", (Object)snapshotMetadata.getCoverImageUri()).zzg("CoverImageUrl", (Object)snapshotMetadata.getCoverImageUrl()).zzg("CoverImageAspectRatio", (Object)Float.valueOf(snapshotMetadata.getCoverImageAspectRatio())).zzg("Description", (Object)snapshotMetadata.getDescription()).zzg("LastModifiedTimestamp", (Object)snapshotMetadata.getLastModifiedTimestamp()).zzg("PlayedTime", (Object)snapshotMetadata.getPlayedTime()).zzg("UniqueName", (Object)snapshotMetadata.getUniqueName()).zzg("ChangePending", (Object)snapshotMetadata.hasChangePending()).zzg("ProgressValue", (Object)snapshotMetadata.getProgressValue()).zzg("DeviceName", (Object)snapshotMetadata.getDeviceName()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        SnapshotMetadataEntityCreator.zza(this, out, flags);
    }
}

