/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzb;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntityCreator;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.player.MostRecentGameInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfoEntity;
import com.google.android.gms.internal.zzms;

public final class PlayerEntity
extends GamesDowngradeableSafeParcel
implements Player {
    public static final Parcelable.Creator<PlayerEntity> CREATOR = new PlayerEntityCreatorCompat();
    private final int mVersionCode;
    private String zzacX;
    private String zzWQ;
    private final Uri zzaCd;
    private final Uri zzaCe;
    private final long zzaCO;
    private final int zzaCP;
    private final long zzaCQ;
    private final String zzaCo;
    private final String zzaCp;
    private final String zzapg;
    private final MostRecentGameInfoEntity zzaCR;
    private final PlayerLevelInfo zzaCS;
    private final boolean zzaCT;
    private final boolean zzaCU;
    private final String zzaCV;
    private final String mName;
    private final Uri zzaCW;
    private final String zzaCX;
    private final Uri zzaCY;
    private final String zzaCZ;

    public PlayerEntity(Player player) {
        this(player, true);
    }

    public PlayerEntity(Player player, boolean isPlusEnabled) {
        this.mVersionCode = 13;
        this.zzacX = isPlusEnabled ? player.getPlayerId() : null;
        this.zzWQ = player.getDisplayName();
        this.zzaCd = player.getIconImageUri();
        this.zzaCo = player.getIconImageUrl();
        this.zzaCe = player.getHiResImageUri();
        this.zzaCp = player.getHiResImageUrl();
        this.zzaCO = player.getRetrievedTimestamp();
        this.zzaCP = player.zzvG();
        this.zzaCQ = player.getLastPlayedWithTimestamp();
        this.zzapg = player.getTitle();
        this.zzaCT = player.zzvH();
        MostRecentGameInfo mostRecentGameInfo = player.zzvI();
        this.zzaCR = mostRecentGameInfo == null ? null : new MostRecentGameInfoEntity(mostRecentGameInfo);
        this.zzaCS = player.getLevelInfo();
        this.zzaCU = player.zzvF();
        this.zzaCV = player.zzvE();
        this.mName = player.getName();
        this.zzaCW = player.getBannerImageLandscapeUri();
        this.zzaCX = player.getBannerImageLandscapeUrl();
        this.zzaCY = player.getBannerImagePortraitUri();
        this.zzaCZ = player.getBannerImagePortraitUrl();
        if (isPlusEnabled) {
            zzb.zzv((Object)this.zzacX);
        }
        zzb.zzv((Object)this.zzWQ);
        zzb.zzab((this.zzaCO > 0L ? 1 : 0) != 0);
    }

    PlayerEntity(int versionCode, String playerId, String displayName, Uri iconImageUri, Uri hiResImageUri, long retrievedTimestamp, int isInCircles, long lastPlayedWithTimestamp, String iconImageUrl, String hiResImageUrl, String title, MostRecentGameInfoEntity mostRecentGameInfo, PlayerLevelInfo playerLevelInfo, boolean isProfileVisible, boolean hasDebugAccess, String gamerTag, String name, Uri bannerImageLandscapeUri, String bannerImageLandscapeUrl, Uri bannerImagePortraitUri, String bannerImagePortraitUrl) {
        this.mVersionCode = versionCode;
        this.zzacX = playerId;
        this.zzWQ = displayName;
        this.zzaCd = iconImageUri;
        this.zzaCo = iconImageUrl;
        this.zzaCe = hiResImageUri;
        this.zzaCp = hiResImageUrl;
        this.zzaCO = retrievedTimestamp;
        this.zzaCP = isInCircles;
        this.zzaCQ = lastPlayedWithTimestamp;
        this.zzapg = title;
        this.zzaCT = isProfileVisible;
        this.zzaCR = mostRecentGameInfo;
        this.zzaCS = playerLevelInfo;
        this.zzaCU = hasDebugAccess;
        this.zzaCV = gamerTag;
        this.mName = name;
        this.zzaCW = bannerImageLandscapeUri;
        this.zzaCX = bannerImageLandscapeUrl;
        this.zzaCY = bannerImagePortraitUri;
        this.zzaCZ = bannerImagePortraitUrl;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getPlayerId() {
        return this.zzacX;
    }

    @Override
    public String getDisplayName() {
        return this.zzWQ;
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        zzms.zzb((String)this.zzWQ, (CharArrayBuffer)dataOut);
    }

    @Override
    public String zzvE() {
        return this.zzaCV;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public boolean zzvF() {
        return this.zzaCU;
    }

    @Override
    public boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzaCd;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzaCo;
    }

    @Override
    public boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.zzaCe;
    }

    @Override
    public String getHiResImageUrl() {
        return this.zzaCp;
    }

    @Override
    public long getRetrievedTimestamp() {
        return this.zzaCO;
    }

    @Override
    public long getLastPlayedWithTimestamp() {
        return this.zzaCQ;
    }

    @Override
    public int zzvG() {
        return this.zzaCP;
    }

    @Override
    public boolean zzvH() {
        return this.zzaCT;
    }

    @Override
    public String getTitle() {
        return this.zzapg;
    }

    @Override
    public void getTitle(CharArrayBuffer dataOut) {
        zzms.zzb((String)this.zzapg, (CharArrayBuffer)dataOut);
    }

    @Override
    public PlayerLevelInfo getLevelInfo() {
        return this.zzaCS;
    }

    @Override
    public MostRecentGameInfo zzvI() {
        return this.zzaCR;
    }

    @Override
    public Uri getBannerImageLandscapeUri() {
        return this.zzaCW;
    }

    @Override
    public String getBannerImageLandscapeUrl() {
        return this.zzaCX;
    }

    @Override
    public Uri getBannerImagePortraitUri() {
        return this.zzaCY;
    }

    @Override
    public String getBannerImagePortraitUrl() {
        return this.zzaCZ;
    }

    public Player freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return PlayerEntity.zzb(this);
    }

    static int zzb(Player player) {
        return zzw.hashCode((Object[])new Object[]{player.getPlayerId(), player.getDisplayName(), player.zzvF(), player.getIconImageUri(), player.getHiResImageUri(), player.getRetrievedTimestamp(), player.getTitle(), player.getLevelInfo(), player.zzvE(), player.getName(), player.getBannerImageLandscapeUri(), player.getBannerImagePortraitUri()});
    }

    public boolean equals(Object obj) {
        return PlayerEntity.zza(this, obj);
    }

    static boolean zza(Player player, Object object) {
        if (!(object instanceof Player)) {
            return false;
        }
        if (player == object) {
            return true;
        }
        Player player2 = (Player)object;
        return zzw.equal((Object)player2.getPlayerId(), (Object)player.getPlayerId()) && zzw.equal((Object)player2.getDisplayName(), (Object)player.getDisplayName()) && zzw.equal((Object)player2.zzvF(), (Object)player.zzvF()) && zzw.equal((Object)player2.getIconImageUri(), (Object)player.getIconImageUri()) && zzw.equal((Object)player2.getHiResImageUri(), (Object)player.getHiResImageUri()) && zzw.equal((Object)player2.getRetrievedTimestamp(), (Object)player.getRetrievedTimestamp()) && zzw.equal((Object)player2.getTitle(), (Object)player.getTitle()) && zzw.equal((Object)player2.getLevelInfo(), (Object)player.getLevelInfo()) && zzw.equal((Object)player2.zzvE(), (Object)player.zzvE()) && zzw.equal((Object)player2.getName(), (Object)player.getName()) && zzw.equal((Object)player2.getBannerImageLandscapeUri(), (Object)player.getBannerImageLandscapeUri()) && zzw.equal((Object)player2.getBannerImagePortraitUri(), (Object)player.getBannerImagePortraitUri());
    }

    public String toString() {
        return PlayerEntity.zzc(this);
    }

    static String zzc(Player player) {
        return zzw.zzy((Object)player).zzg("PlayerId", (Object)player.getPlayerId()).zzg("DisplayName", (Object)player.getDisplayName()).zzg("HasDebugAccess", (Object)player.zzvF()).zzg("IconImageUri", (Object)player.getIconImageUri()).zzg("IconImageUrl", (Object)player.getIconImageUrl()).zzg("HiResImageUri", (Object)player.getHiResImageUri()).zzg("HiResImageUrl", (Object)player.getHiResImageUrl()).zzg("RetrievedTimestamp", (Object)player.getRetrievedTimestamp()).zzg("Title", (Object)player.getTitle()).zzg("LevelInfo", (Object)player.getLevelInfo()).zzg("GamerTag", (Object)player.zzvE()).zzg("Name", (Object)player.getName()).zzg("BannerImageLandscapeUri", (Object)player.getBannerImageLandscapeUri()).zzg("BannerImageLandscapeUrl", (Object)player.getBannerImageLandscapeUrl()).zzg("BannerImagePortraitUri", (Object)player.getBannerImagePortraitUri()).zzg("BannerImagePortraitUrl", (Object)player.getBannerImagePortraitUrl()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.zzqC()) {
            PlayerEntityCreator.zza(this, dest, flags);
        } else {
            dest.writeString(this.zzacX);
            dest.writeString(this.zzWQ);
            dest.writeString(this.zzaCd == null ? null : this.zzaCd.toString());
            dest.writeString(this.zzaCe == null ? null : this.zzaCe.toString());
            dest.writeLong(this.zzaCO);
        }
    }

    static final class PlayerEntityCreatorCompat
    extends PlayerEntityCreator {
        PlayerEntityCreatorCompat() {
        }

        @Override
        public PlayerEntity zzeb(Parcel parcel) {
            boolean bl = PlayerEntity.zzd(PlayerEntity.zzqB());
            if (bl || PlayerEntity.zzcF((String)PlayerEntity.class.getCanonicalName())) {
                return super.zzeb(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            long l = parcel.readLong();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            int n = -1;
            long l2 = -1L;
            String string7 = null;
            String string8 = null;
            String string9 = null;
            PlayerLevelInfo playerLevelInfo = null;
            MostRecentGameInfoEntity mostRecentGameInfoEntity = null;
            boolean bl2 = true;
            boolean bl3 = false;
            Uri uri3 = null;
            String string10 = null;
            Uri uri4 = null;
            String string11 = null;
            return new PlayerEntity(13, string, string2, uri, uri2, l, n, l2, string7, string8, string9, mostRecentGameInfoEntity, playerLevelInfo, bl2, bl3, string5, string6, uri3, string10, uri4, string11);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzeb(parcel);
        }
    }
}

