/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.PlayerLevel;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfoRef;
import com.google.android.gms.games.internal.player.PlayerColumnNames;

public final class PlayerRef
extends zzc
implements Player {
    private final PlayerColumnNames zzaDh;
    private final PlayerLevelInfo zzaCS;
    private final MostRecentGameInfoRef zzaDi;

    public PlayerRef(DataHolder holder, int dataRow) {
        this(holder, dataRow, null);
    }

    public PlayerRef(DataHolder holder, int dataRow, String prefix) {
        super(holder, dataRow);
        this.zzaDh = new PlayerColumnNames(prefix);
        this.zzaDi = new MostRecentGameInfoRef(holder, dataRow, this.zzaDh);
        if (this.zzvJ()) {
            PlayerLevel playerLevel;
            int n = this.getInteger(this.zzaDh.zzaIC);
            int n2 = this.getInteger(this.zzaDh.zzaIF);
            PlayerLevel playerLevel2 = playerLevel = new PlayerLevel(n, this.getLong(this.zzaDh.zzaID), this.getLong(this.zzaDh.zzaIE));
            if (n != n2) {
                playerLevel2 = new PlayerLevel(n2, this.getLong(this.zzaDh.zzaIE), this.getLong(this.zzaDh.zzaIG));
            }
            this.zzaCS = new PlayerLevelInfo(this.getLong(this.zzaDh.zzaIB), this.getLong(this.zzaDh.zzaIH), playerLevel, playerLevel2);
        } else {
            this.zzaCS = null;
        }
    }

    @Override
    public String getPlayerId() {
        return this.getString(this.zzaDh.zzaIs);
    }

    @Override
    public String getDisplayName() {
        return this.getString(this.zzaDh.zzaIt);
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        this.zza(this.zzaDh.zzaIt, dataOut);
    }

    @Override
    public String zzvE() {
        return this.getString(this.zzaDh.zzaIR);
    }

    @Override
    public String getName() {
        return this.getString(this.zzaDh.name);
    }

    @Override
    public boolean zzvF() {
        return this.getBoolean(this.zzaDh.zzaIQ);
    }

    @Override
    public boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzcA(this.zzaDh.zzaIu);
    }

    @Override
    public String getIconImageUrl() {
        return this.getString(this.zzaDh.zzaIv);
    }

    @Override
    public boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.zzcA(this.zzaDh.zzaIw);
    }

    @Override
    public String getHiResImageUrl() {
        return this.getString(this.zzaDh.zzaIx);
    }

    @Override
    public long getRetrievedTimestamp() {
        return this.getLong(this.zzaDh.zzaIy);
    }

    @Override
    public long getLastPlayedWithTimestamp() {
        if (!this.zzcz(this.zzaDh.zzaIA) || this.zzcB(this.zzaDh.zzaIA)) {
            return -1L;
        }
        return this.getLong(this.zzaDh.zzaIA);
    }

    @Override
    public int zzvG() {
        return this.getInteger(this.zzaDh.zzaIz);
    }

    @Override
    public boolean zzvH() {
        return this.getBoolean(this.zzaDh.zzaIJ);
    }

    @Override
    public String getTitle() {
        return this.getString(this.zzaDh.title);
    }

    @Override
    public void getTitle(CharArrayBuffer dataOut) {
        this.zza(this.zzaDh.title, dataOut);
    }

    @Override
    public PlayerLevelInfo getLevelInfo() {
        return this.zzaCS;
    }

    @Override
    public MostRecentGameInfo zzvI() {
        if (this.zzcB(this.zzaDh.zzaIK)) {
            return null;
        }
        return this.zzaDi;
    }

    @Override
    public Uri getBannerImageLandscapeUri() {
        return this.zzcA(this.zzaDh.zzaIS);
    }

    @Override
    public String getBannerImageLandscapeUrl() {
        return this.getString(this.zzaDh.zzaIT);
    }

    @Override
    public Uri getBannerImagePortraitUri() {
        return this.zzcA(this.zzaDh.zzaIU);
    }

    @Override
    public String getBannerImagePortraitUrl() {
        return this.getString(this.zzaDh.zzaIV);
    }

    public Player freeze() {
        return new PlayerEntity(this);
    }

    public int hashCode() {
        return PlayerEntity.zzb(this);
    }

    public boolean equals(Object obj) {
        return PlayerEntity.zza(this, obj);
    }

    public String toString() {
        return PlayerEntity.zzc(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        PlayerEntity playerEntity = (PlayerEntity)this.freeze();
        playerEntity.writeToParcel(dest, flags);
    }

    private boolean zzvJ() {
        if (this.zzcB(this.zzaDh.zzaIB)) {
            return false;
        }
        return this.getLong(this.zzaDh.zzaIB) != -1L;
    }
}

