/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.achievement;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzb;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.achievement.Achievement;
import com.google.android.gms.games.achievement.AchievementEntityCreator;
import com.google.android.gms.internal.zzms;

public final class AchievementEntity
implements SafeParcelable,
Achievement {
    public static final Parcelable.Creator<AchievementEntity> CREATOR = new AchievementEntityCreator();
    private final int mVersionCode;
    private final String zzaDj;
    private final int zzabB;
    private final String mName;
    private final String zzaxl;
    private final Uri zzaDk;
    private final String zzaDl;
    private final Uri zzaDm;
    private final String zzaDn;
    private final int zzaDo;
    private final String zzaDp;
    private final PlayerEntity zzaDq;
    private final int mState;
    private final int zzaDr;
    private final String zzaDs;
    private final long zzaDt;
    private final long zzaDu;

    public AchievementEntity(Achievement achievement) {
        this.mVersionCode = 1;
        this.zzaDj = achievement.getAchievementId();
        this.zzabB = achievement.getType();
        this.mName = achievement.getName();
        this.zzaxl = achievement.getDescription();
        this.zzaDk = achievement.getUnlockedImageUri();
        this.zzaDl = achievement.getUnlockedImageUrl();
        this.zzaDm = achievement.getRevealedImageUri();
        this.zzaDn = achievement.getRevealedImageUrl();
        this.zzaDq = (PlayerEntity)achievement.getPlayer().freeze();
        this.mState = achievement.getState();
        this.zzaDt = achievement.getLastUpdatedTimestamp();
        this.zzaDu = achievement.getXpValue();
        if (achievement.getType() == 1) {
            this.zzaDo = achievement.getTotalSteps();
            this.zzaDp = achievement.getFormattedTotalSteps();
            this.zzaDr = achievement.getCurrentSteps();
            this.zzaDs = achievement.getFormattedCurrentSteps();
        } else {
            this.zzaDo = 0;
            this.zzaDp = null;
            this.zzaDr = 0;
            this.zzaDs = null;
        }
        zzb.zzv((Object)this.zzaDj);
        zzb.zzv((Object)this.zzaxl);
    }

    AchievementEntity(int versionCode, String achievementId, int type, String name, String description, Uri unlockedImageUri, String unlockedImageUrl, Uri revealedImageUri, String revealedImageUrl, int totalSteps, String formattedTotalSteps, PlayerEntity player, int state, int currentSteps, String formattedCurrentSteps, long lastUpdatedTimestamp, long xpValue) {
        this.mVersionCode = versionCode;
        this.zzaDj = achievementId;
        this.zzabB = type;
        this.mName = name;
        this.zzaxl = description;
        this.zzaDk = unlockedImageUri;
        this.zzaDl = unlockedImageUrl;
        this.zzaDm = revealedImageUri;
        this.zzaDn = revealedImageUrl;
        this.zzaDo = totalSteps;
        this.zzaDp = formattedTotalSteps;
        this.zzaDq = player;
        this.mState = state;
        this.zzaDr = currentSteps;
        this.zzaDs = formattedCurrentSteps;
        this.zzaDt = lastUpdatedTimestamp;
        this.zzaDu = xpValue;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getAchievementId() {
        return this.zzaDj;
    }

    @Override
    public int getType() {
        return this.zzabB;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer dataOut) {
        zzms.zzb((String)this.mName, (CharArrayBuffer)dataOut);
    }

    @Override
    public String getDescription() {
        return this.zzaxl;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zzms.zzb((String)this.zzaxl, (CharArrayBuffer)dataOut);
    }

    @Override
    public Uri getUnlockedImageUri() {
        return this.zzaDk;
    }

    @Override
    public String getUnlockedImageUrl() {
        return this.zzaDl;
    }

    @Override
    public Uri getRevealedImageUri() {
        return this.zzaDm;
    }

    @Override
    public String getRevealedImageUrl() {
        return this.zzaDn;
    }

    public int zzvK() {
        return this.zzaDo;
    }

    @Override
    public int getTotalSteps() {
        zzb.zzab((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzvK();
    }

    @Override
    public String getFormattedTotalSteps() {
        zzb.zzab((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzvL();
    }

    public String zzvL() {
        return this.zzaDp;
    }

    @Override
    public void getFormattedTotalSteps(CharArrayBuffer dataOut) {
        zzb.zzab((this.getType() == 1 ? 1 : 0) != 0);
        zzms.zzb((String)this.zzaDp, (CharArrayBuffer)dataOut);
    }

    @Override
    public Player getPlayer() {
        return this.zzaDq;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public int getCurrentSteps() {
        zzb.zzab((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzvM();
    }

    public int zzvM() {
        return this.zzaDr;
    }

    @Override
    public String getFormattedCurrentSteps() {
        zzb.zzab((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzvN();
    }

    public String zzvN() {
        return this.zzaDs;
    }

    @Override
    public void getFormattedCurrentSteps(CharArrayBuffer dataOut) {
        zzb.zzab((this.getType() == 1 ? 1 : 0) != 0);
        zzms.zzb((String)this.zzaDs, (CharArrayBuffer)dataOut);
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.zzaDt;
    }

    @Override
    public long getXpValue() {
        return this.zzaDu;
    }

    public Achievement freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return AchievementEntity.zza(this);
    }

    static int zza(Achievement achievement) {
        int n = 0;
        int n2 = 0;
        if (achievement.getType() == 1) {
            n = achievement.getCurrentSteps();
            n2 = achievement.getTotalSteps();
        }
        return zzw.hashCode((Object[])new Object[]{achievement.getAchievementId(), achievement.getName(), achievement.getType(), achievement.getDescription(), achievement.getXpValue(), achievement.getState(), achievement.getLastUpdatedTimestamp(), achievement.getPlayer(), n, n2});
    }

    public boolean equals(Object obj) {
        return AchievementEntity.zza(this, obj);
    }

    static boolean zza(Achievement achievement, Object object) {
        if (!(object instanceof Achievement)) {
            return false;
        }
        if (achievement == object) {
            return true;
        }
        Achievement achievement2 = (Achievement)object;
        boolean bl = true;
        boolean bl2 = true;
        if (achievement.getType() == 1) {
            bl = zzw.equal((Object)achievement2.getCurrentSteps(), (Object)achievement.getCurrentSteps());
            bl2 = zzw.equal((Object)achievement2.getTotalSteps(), (Object)achievement.getTotalSteps());
        }
        return zzw.equal((Object)achievement2.getAchievementId(), (Object)achievement.getAchievementId()) && zzw.equal((Object)achievement2.getName(), (Object)achievement.getName()) && zzw.equal((Object)achievement2.getType(), (Object)achievement.getType()) && zzw.equal((Object)achievement2.getDescription(), (Object)achievement.getDescription()) && zzw.equal((Object)achievement2.getXpValue(), (Object)achievement.getXpValue()) && zzw.equal((Object)achievement2.getState(), (Object)achievement.getState()) && zzw.equal((Object)achievement2.getLastUpdatedTimestamp(), (Object)achievement.getLastUpdatedTimestamp()) && zzw.equal((Object)achievement2.getPlayer(), (Object)achievement.getPlayer()) && bl && bl2;
    }

    public String toString() {
        return AchievementEntity.zzb(this);
    }

    static String zzb(Achievement achievement) {
        zzw.zza zza2 = zzw.zzy((Object)achievement).zzg("Id", (Object)achievement.getAchievementId()).zzg("Type", (Object)achievement.getType()).zzg("Name", (Object)achievement.getName()).zzg("Description", (Object)achievement.getDescription()).zzg("Player", (Object)achievement.getPlayer()).zzg("State", (Object)achievement.getState());
        if (achievement.getType() == 1) {
            zza2.zzg("CurrentSteps", (Object)achievement.getCurrentSteps());
            zza2.zzg("TotalSteps", (Object)achievement.getTotalSteps());
        }
        return zza2.toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AchievementEntityCreator.zza(this, dest, flags);
    }
}

