/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.api;

import android.annotation.SuppressLint;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zza;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.event.EventBuffer;
import com.google.android.gms.games.event.Events;
import com.google.android.gms.games.internal.GamesClientImpl;

public final class EventsImpl
implements Events {
    @Override
    public PendingResult<Events.LoadEventsResult> loadByIds(GoogleApiClient apiClient, final boolean forceReload, final String ... eventIds) {
        return apiClient.zza((zza.zza)new LoadImpl(apiClient){

            public void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza((zza.zzb<Events.LoadEventsResult>)this, forceReload, eventIds);
            }
        });
    }

    @Override
    public PendingResult<Events.LoadEventsResult> load(GoogleApiClient apiClient, final boolean forceReload) {
        return apiClient.zza((zza.zza)new LoadImpl(apiClient){

            public void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzd((zza.zzb<Events.LoadEventsResult>)this, forceReload);
            }
        });
    }

    @Override
    @SuppressLint(value={"MissingRemoteException"})
    public void increment(GoogleApiClient apiClient, final String eventId, final int incrementAmount) {
        GamesClientImpl gamesClientImpl = Games.zzc(apiClient, false);
        if (gamesClientImpl == null) {
            return;
        }
        if (gamesClientImpl.isConnected()) {
            gamesClientImpl.zzp(eventId, incrementAmount);
        } else {
            apiClient.zzb((zza.zza)new UpdateImpl(apiClient){

                public void zza(GamesClientImpl gamesClientImpl) {
                    gamesClientImpl.zzp(eventId, incrementAmount);
                }
            });
        }
    }

    private static abstract class UpdateImpl
    extends Games.BaseGamesApiMethodImpl<Result> {
        private UpdateImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Result zzc(final Status status) {
            return new Result(){

                public Status getStatus() {
                    return status;
                }
            };
        }
    }

    private static abstract class LoadImpl
    extends Games.BaseGamesApiMethodImpl<Events.LoadEventsResult> {
        private LoadImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Events.LoadEventsResult zzaf(final Status status) {
            return new Events.LoadEventsResult(){

                public Status getStatus() {
                    return status;
                }

                public void release() {
                }

                @Override
                public EventBuffer getEvents() {
                    return new EventBuffer(DataHolder.zzbI((int)14));
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzaf(status);
        }
    }
}

