/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameRef;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardEntity;
import com.google.android.gms.games.leaderboard.LeaderboardVariant;
import com.google.android.gms.games.leaderboard.LeaderboardVariantRef;
import java.util.ArrayList;

public final class LeaderboardRef
extends zzc
implements Leaderboard {
    private final int zzaDQ;
    private final Game zzaJc;

    LeaderboardRef(DataHolder holder, int dataRow, int numChildren) {
        super(holder, dataRow);
        this.zzaDQ = numChildren;
        this.zzaJc = new GameRef(holder, dataRow);
    }

    @Override
    public String getLeaderboardId() {
        return this.getString("external_leaderboard_id");
    }

    @Override
    public String getDisplayName() {
        return this.getString("name");
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        this.zza("name", dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzcA("board_icon_image_uri");
    }

    @Override
    public String getIconImageUrl() {
        return this.getString("board_icon_image_url");
    }

    @Override
    public int getScoreOrder() {
        return this.getInteger("score_order");
    }

    @Override
    public ArrayList<LeaderboardVariant> getVariants() {
        ArrayList<LeaderboardVariant> arrayList = new ArrayList<LeaderboardVariant>(this.zzaDQ);
        for (int i = 0; i < this.zzaDQ; ++i) {
            arrayList.add(new LeaderboardVariantRef(this.zzahi, this.zzaje + i));
        }
        return arrayList;
    }

    @Override
    public Game getGame() {
        return this.zzaJc;
    }

    public Leaderboard zzxI() {
        return new LeaderboardEntity(this);
    }

    public int hashCode() {
        return LeaderboardEntity.zza(this);
    }

    public boolean equals(Object obj) {
        return LeaderboardEntity.zza(this, obj);
    }

    public String toString() {
        return LeaderboardEntity.zzb(this);
    }

    public /* synthetic */ Object freeze() {
        return this.zzxI();
    }
}

